/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Lcom.sun.jna.Structure;;
import [Lcom.sun.jna.WString;;
import [Ljava.lang.String;;
import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 32;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 1;
    private NativeLibrary library;
    private String functionName;
    private int callingConvention;

    public static Function getFunction(String libraryName, String functionName) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName);
    }

    public static Function getFunction(String libraryName, String functionName, int callConvention) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callConvention);
    }

    public Function(String libraryName, String functionName) {
        this(libraryName, functionName, 0);
    }

    public Function(String libraryName, String functionName, int callingConvention) {
        this(NativeLibrary.getInstance(libraryName), functionName, callingConvention);
    }

    Function(NativeLibrary library, String functionName, int callingConvention) {
        this.checkCallingConvention(callingConvention);
        this.library = library;
        this.functionName = functionName;
        this.callingConvention = callingConvention;
        this.peer = library.getFunctionAddress(functionName);
    }

    Function(Pointer functionAddress, int callingConvention) {
        this.checkCallingConvention(callingConvention);
        this.functionName = "<unknown>";
        this.callingConvention = callingConvention;
        this.peer = functionAddress.peer;
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        switch (convention) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized calling convention: " + convention);
            }
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callingConvention;
    }

    public Object invoke(Class returnType, Object[] inArgs) {
        return this.invoke(returnType, inArgs, Collections.EMPTY_MAP);
    }

    public Object invoke(Class returnType, Object[] inArgs, Map options) {
        Object[] args = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 32) {
                throw new UnsupportedOperationException("Maximum argument count is 32");
            }
            args = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args, 0, args.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        Method invokingMethod = (Method)options.get("invoking-method");
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.convertArgument(args, i, invokingMethod, mapper);
        }
        Class nativeType = returnType;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType)) {
            NativeMappedConverter tc = new NativeMappedConverter(returnType);
            resultConverter = tc;
            nativeType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeType = resultConverter.nativeType();
        }
        Object result = this.invoke(args, nativeType);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType, this, inArgs, invokingMethod) : new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object arg = inArgs[i];
                if (arg == null) continue;
                if (arg instanceof Structure) {
                    ((Structure)arg).read();
                    continue;
                }
                if (args[i] instanceof StringArray) {
                    ((StringArray)args[i]).read();
                    continue;
                }
                if (!(array$Lcom$sun$jna$Structure == null ? Function.class$("[Lcom.sun.jna.Structure;") : array$Lcom$sun$jna$Structure).isAssignableFrom(arg.getClass())) continue;
                Structure[] ss = (Structure[])arg;
                for (int si = 0; si < ss.length; ++si) {
                    ss[si].read();
                }
            }
        }
        return result;
    }

    Object invoke(Object[] args, Class returnType) {
        Object result = null;
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            this.invokeVoid(this.callingConvention, args);
            result = null;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = this.invokeInt(this.callingConvention, args) != 0;
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            result = new Byte((byte)this.invokeInt(this.callingConvention, args));
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            result = new Short((short)this.invokeInt(this.callingConvention, args));
        } else if (returnType == Character.TYPE || returnType == Character.class) {
            result = new Character((char)this.invokeInt(this.callingConvention, args));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = new Integer(this.invokeInt(this.callingConvention, args));
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = new Long(this.invokeLong(this.callingConvention, args));
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            result = new Float(this.invokeFloat(this.callingConvention, args));
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = new Double(this.invokeDouble(this.callingConvention, args));
        } else if (returnType == String.class) {
            result = this.invokeString(this.callingConvention, args, false);
        } else if (returnType == WString.class) {
            result = new WString(this.invokeString(this.callingConvention, args, true));
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            result = this.invokePointer(this.callingConvention, args);
        } else if (Structure.class.isAssignableFrom(returnType)) {
            result = this.invokePointer(this.callingConvention, args);
            if (result != null) {
                try {
                    Structure s = (Structure)returnType.newInstance();
                    s.useMemory((Pointer)result);
                    s.read();
                    result = s;
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Instantiation of " + returnType + " failed: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Not allowed to instantiate " + returnType + ": " + e);
                }
            }
        } else if (Callback.class.isAssignableFrom(returnType)) {
            result = this.invokePointer(this.callingConvention, args);
            if (result != null) {
                result = CallbackReference.getCallback(returnType, (Pointer)result);
            }
        } else {
            throw new IllegalArgumentException("Unsupported return type " + returnType);
        }
        return result;
    }

    private Object convertArgument(Object[] args, int index, Method invokingMethod, TypeMapper mapper) {
        Object arg = args[index];
        if (arg != null) {
            Class<?> type = arg.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type)) {
                converter = new NativeMappedConverter(type);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type);
            }
            if (converter != null) {
                FunctionParameterContext context = invokingMethod != null ? new MethodParameterContext(this, args, index, invokingMethod) : new FunctionParameterContext(this, args, index);
                arg = converter.toNative(arg, context);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.write();
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            return new Integer(Boolean.TRUE.equals(arg) ? -1 : 0);
        }
        if (String;.class == argClass) {
            return new StringArray((String[])arg);
        }
        if (WString;.class == argClass) {
            return new StringArray((WString[])arg);
        }
        if (Structure;.class.isAssignableFrom(argClass)) {
            Structure[] ss = (Structure[])arg;
            if (ss.length == 0) {
                return null;
            }
            if (ss[0] == null) {
                Class<?> type = argClass.getComponentType();
                try {
                    Structure struct = (Structure)type.newInstance();
                    int size = struct.size();
                    Memory m = new Memory(size * ss.length);
                    struct.useMemory(m);
                    Structure[] tmp = struct.toArray(ss.length);
                    for (int si = 0; si < ss.length; ++si) {
                        ss[si] = tmp[si];
                    }
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Instantiation of " + type + " failed: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Not allowed to instantiate " + type + ": " + e);
                }
                return ss[0].getPointer();
            }
            Pointer base = ss[0].getPointer();
            int size = ss[0].size();
            ss[0].write();
            for (int si = 1; si < ss.length; ++si) {
                Pointer p = base.share(size * si, size);
                if (ss[si].getPointer().peer != p.peer) {
                    String msg = "Structure array elements must use contiguous memory (at element index " + si + ")";
                    throw new IllegalArgumentException(msg);
                }
                ss[si].write();
            }
            return base;
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        return arg;
    }

    private boolean isPrimitiveArray(Class argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    private native int invokeInt(int var1, Object[] var2);

    private native long invokeLong(int var1, Object[] var2);

    public void invoke(Object[] args) {
        this.invoke(Void.class, args);
    }

    private native void invokeVoid(int var1, Object[] var2);

    private native float invokeFloat(int var1, Object[] var2);

    private native double invokeDouble(int var1, Object[] var2);

    private String invokeString(int callingConvention, Object[] args, boolean wide) {
        Pointer ptr = this.invokePointer(callingConvention, args);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getString(0, wide) : ptr.getString(0);
        }
        return s;
    }

    private native Pointer invokePointer(int var1, Object[] var2);

    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    public Pointer invokePointer(Object[] args) {
        return (Pointer)this.invoke(Pointer.class, args);
    }

    public String invokeString(Object[] args, boolean wide) {
        Class clazz = wide ? WString.class : String.class;
        Object o = this.invoke(clazz, args);
        return o != null ? o.toString() : null;
    }

    public int invokeInt(Object[] args) {
        return (Integer)this.invoke(Integer.class, args);
    }

    public long invokeLong(Object[] args) {
        return (Long)this.invoke(Long.class, args);
    }

    public float invokeFloat(Object[] args) {
        return ((Float)this.invoke(Float.class, args)).floatValue();
    }

    public double invokeDouble(Object[] args) {
        return (Double)this.invoke(Double.class, args);
    }

    public void invokeVoid(Object[] args) {
        this.invoke(Void.class, args);
    }

    public boolean equals(Object o) {
        if (o instanceof Function) {
            Function other = (Function)o;
            return other.callingConvention == this.callingConvention && other.peer == this.peer;
        }
        return false;
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    static boolean isVarArgs(Method m) {
        try {
            Method v = m.getClass().getMethod("isVarArgs", new Class[0]);
            return Boolean.TRUE.equals(v.invoke((Object)m, new Object[0]));
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }
}

