/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;

class PointerArray
extends Memory {
    private Object[] array;
    private TypeConverter tc;
    private Class type;

    public PointerArray(Pointer[] array) {
        super((array.length + 1) * Pointer.SIZE);
        this.array = array;
        this.write();
    }

    public PointerArray(NativeMapped[] array) {
        super((array.length + 1) * Pointer.SIZE);
        this.type = array.getClass().getComponentType();
        this.tc = new NativeMappedConverter(this.type);
        if (!Pointer.class.isAssignableFrom(this.tc.nativeType())) {
            throw new IllegalArgumentException("Arrays of " + this.tc.nativeType() + " not supported");
        }
        this.array = array;
        this.write();
    }

    private void write() {
        int offset = 0;
        for (int i = 0; i < this.array.length - 1; ++i) {
            Object o = this.array[i];
            Pointer p = this.tc == null ? (Pointer)o : (Pointer)this.tc.toNative(o, new ToNativeContext());
            this.setPointer(offset, p);
            offset += Pointer.SIZE;
        }
        this.setPointer(offset, null);
    }

    public void read() {
        int offset = 0;
        for (int i = 0; i < this.array.length; ++i) {
            Pointer p = this.getPointer(offset);
            this.array[i] = this.tc != null ? this.tc.fromNative(p, new FromNativeContext(this.type)) : p;
            offset += Pointer.SIZE;
        }
    }
}

