/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.util.Iterator;

public abstract class Union
extends Structure {
    private Structure.StructField writeField;

    protected Union() {
    }

    protected Union(int size) {
        super(size);
    }

    protected Union(int size, int alignType) {
        super(size, alignType);
    }

    public void setType(Class type) {
        Iterator i = this.fields().values().iterator();
        while (i.hasNext()) {
            Structure.StructField f = (Structure.StructField)i.next();
            if (f.type != type) continue;
            this.writeField = f;
            return;
        }
        throw new IllegalArgumentException("No field of type " + type + " in " + this);
    }

    void writeField(Structure.StructField field) {
        if (field == this.writeField) {
            super.writeField(field);
        }
    }

    void readField(Structure.StructField field) {
        if (field == this.writeField || !Structure.class.isAssignableFrom(field.type) && !String.class.isAssignableFrom(field.type) && !WString.class.isAssignableFrom(field.type)) {
            super.readField(field);
        }
    }

    int calculateSize(boolean force) {
        int size = super.calculateSize(force);
        if (size != -1) {
            int fsize = 0;
            Iterator i = this.fields().values().iterator();
            while (i.hasNext()) {
                Structure.StructField f = (Structure.StructField)i.next();
                f.offset = 0;
                fsize = Math.max(fsize, f.size);
            }
            size = this.calculateAlignedSize(fsize);
        }
        return size;
    }

    protected int getNativeAlignment(Class type, Object value, boolean firstElement) {
        return super.getNativeAlignment(type, value, true);
    }
}

