/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.io.Serializable;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DataConstraint;

public final class DCBetweenExpression
extends DCExpression
implements Serializable {
    private static final long serialVersionUID = 2784633710894608517L;
    public static final int BETWEEN_EXPRESSION = 1;
    public static final int NOT_BETWEEN_EXPRESSION = 2;
    private DataConstraint _checkConstraint;
    private DataConstraint _firstConstraint;
    private DataConstraint _secondConstraint;

    public DCBetweenExpression(DataConstraint dataConstraint, DataConstraint dataConstraint2, DataConstraint dataConstraint3, int n) {
        super(n);
        this._checkConstraint = dataConstraint;
        this._firstConstraint = dataConstraint2;
        this._secondConstraint = dataConstraint3;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("operand is invalid " + n);
        }
    }

    public int getConstraintCount() {
        return 3;
    }

    public DataConstraint getConstraint(int n) {
        switch (n) {
            case 0: {
                return this._checkConstraint;
            }
            case 1: {
                return this._firstConstraint;
            }
        }
        return this._secondConstraint;
    }

    public DataConstraint getCheckConstraint() {
        return this.getConstraint(0);
    }

    public DataConstraint getFirstConstraint() {
        return this.getConstraint(1);
    }

    public DataConstraint getSecondConstraint() {
        return this.getConstraint(2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DCBetweenExpression) {
            bl = super.equals(object);
        }
        return bl;
    }
}

