/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Vector;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;

public class DataConstraintUtils {
    private static DataConstraintUtils _sInstance;

    public static DataConstraintUtils getDataConstraintUtils() {
        if (_sInstance == null) {
            _sInstance = new DataConstraintUtils();
        }
        return _sInstance;
    }

    public DataConstraint simplifyConstraint(DataConstraint dataConstraint) {
        DataConstraint dataConstraint2;
        if (dataConstraint == null) {
            return dataConstraint;
        }
        if (!(dataConstraint instanceof DCExpression)) {
            return dataConstraint;
        }
        DCExpression dCExpression = (DCExpression)dataConstraint;
        int n = dCExpression.getConstraintCount();
        if (n == 0) {
            return dataConstraint;
        }
        DataConstraint[] dataConstraintArray = new DataConstraint[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            dataConstraint2 = this.simplifyConstraint(dCExpression.getConstraint(n3));
            if (dataConstraint2 != null) {
                dataConstraintArray[n2] = dataConstraint2;
                ++n2;
            }
            ++n3;
        }
        if (dCExpression instanceof DCUnaryExpression) {
            DCUnaryExpression dCUnaryExpression = (DCUnaryExpression)dCExpression;
            switch (n2) {
                case 0: {
                    dataConstraint = null;
                    break;
                }
                case 1: {
                    dataConstraint2 = dataConstraintArray[0];
                    if (!(dataConstraint2 instanceof DCUnaryExpression)) break;
                    DCUnaryExpression dCUnaryExpression2 = (DCUnaryExpression)dataConstraint2;
                    dataConstraint = dCUnaryExpression2.getConstraint(0);
                }
            }
        } else if (dCExpression instanceof DCBooleanExpression) {
            DCBooleanExpression dCBooleanExpression = (DCBooleanExpression)dCExpression;
            switch (n2) {
                case 0: {
                    dataConstraint = null;
                    break;
                }
                case 1: {
                    dataConstraint = dataConstraintArray[0];
                    break;
                }
                default: {
                    int n4 = dCBooleanExpression.getOperand();
                    Vector<DataConstraint> vector = new Vector<DataConstraint>(n2);
                    int n5 = 0;
                    while (n5 < n2) {
                        dataConstraint2 = dataConstraintArray[n5];
                        if (!(dataConstraint2 instanceof DCBooleanExpression)) {
                            vector.addElement(dataConstraint2);
                        } else {
                            DCBooleanExpression dCBooleanExpression2 = (DCBooleanExpression)dataConstraint2;
                            if (dCBooleanExpression2.getOperand() != n4) {
                                vector.addElement(dataConstraint2);
                            } else {
                                int n6 = dCBooleanExpression2.getConstraintCount();
                                int n7 = 0;
                                while (n7 < n6) {
                                    vector.addElement(dCBooleanExpression2.getConstraint(n7));
                                    ++n7;
                                }
                            }
                        }
                        ++n5;
                    }
                    Object[] objectArray = new DataConstraint[vector.size()];
                    vector.copyInto(objectArray);
                    dataConstraint = new DCBooleanExpression((DataConstraint[])objectArray, n4);
                }
            }
        }
        return dataConstraint;
    }

    public DataConstraint removeConstraint(DataConstraint dataConstraint, DataConstraint dataConstraint2) {
        if (dataConstraint == null || dataConstraint2 == null) {
            return dataConstraint;
        }
        if (!(dataConstraint instanceof DCExpression)) {
            if (dataConstraint.equals(dataConstraint2)) {
                dataConstraint = null;
            }
            return dataConstraint;
        }
        DCExpression dCExpression = (DCExpression)dataConstraint;
        if (dCExpression instanceof DCUnaryExpression) {
            DCUnaryExpression dCUnaryExpression = (DCUnaryExpression)dCExpression;
        } else if (dCExpression instanceof DCBooleanExpression) {
            DCBooleanExpression dCBooleanExpression = (DCBooleanExpression)dCExpression;
        }
        return dataConstraint;
    }

    protected DataConstraintUtils() {
    }
}

