/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.AndOrComponent;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.CBCompComparator;
import oracle.bali.dbUI.constraintBuilder.CBCompTransfer;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderCustomizer;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.RootComponent;
import oracle.bali.dbUI.constraintBuilder.TransparentGrayFilter;
import oracle.bali.dbUI.constraintBuilder.TruncateFilter;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class ConstraintBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTION_COUNT = "selectionCount";
    public static final String PROPERTY_GROUP_DEPTH = "groupDepth";
    public static final String PROPERTY_LEAF_COUNT = "leafCount";
    public static final int DROP_MODE_REPLACE = 1;
    public static final int DROP_MODE_SWAP = 2;
    public Color SELECTION_COLOR = UIManager.getColor("textHighlight");
    public Color DROP_FEEDBACK_COLOR = UIManager.getColor("normalIntensity");
    public final Color DROP_REPLACE_FEEDBACK_COLOR = Color.darkGray;
    protected static final int GROUP_LINE_OFFSET = -1;
    protected static final int GROUP_LINE_DASH_GAP = 1;
    private static final int _MIN_WIDTH = 100;
    private static final int _MIN_HEIGHT = 50;
    static final String _CREATE_AND_COMMAND = "CREATE_AND";
    static final String _CREATE_OR_COMMAND = "CREATE_OR";
    static final String _CREATE_NOT_COMMAND = "CREATE_NOT";
    static final String _CHANGE_TO_AND_COMMAND = "CHANGE_TO_AND";
    static final String _CHANGE_TO_OR_COMMAND = "CHANGE_TO_OR";
    static final String _DELETE_COMMAND = "DELETE";
    static final String _INSERT_COMMAND = "INSERT";
    static final String _ADD_COMMAND = "ADD";
    static final String _SIMPLIFY_COMMAND = "SIMPLIFY";
    static final String _EXPAND_COMMAND = "EXPAND";
    static final String _COLLAPSE_COMMAND = "COLLAPSE";
    static final String _REMOVE_AND_COMMAND = "REMOVE_AND";
    static final String _REMOVE_OR_COMMAND = "REMOVE_OR";
    static final String _REMOVE_NOT_COMMAND = "REMOVE_NOT";
    private static final String _CREATE_AND_KEY = "CREATE_AND";
    private static final String _CREATE_OR_KEY = "CREATE_OR";
    private static final String _CREATE_NOT_KEY = "CREATE_NOT";
    private static final String _CHANGE_TO_AND_KEY = "CHANGE_TO_AND";
    private static final String _CHANGE_TO_OR_KEY = "CHANGE_TO_OR";
    private static final String _SIMPLIFY_KEY = "SIMPLIFY";
    private static final String _ADD_CONSTRAINT_KEY = "ADD_CONSTRAINT";
    private static final String _EXPAND_KEY = "EXPAND";
    private static final String _COLLAPSE_KEY = "COLLAPSE";
    private static final String _DELETE_KEY = "DELETE";
    private static final String _REMOVE_AND_KEY = "REMOVE_AND";
    private static final String _REMOVE_OR_KEY = "REMOVE_OR";
    private static final int _MAX_IMAGE_WIDTH = 150;
    private static final int _VOFFSET = 5;
    private boolean _linesVisible;
    private boolean _alignLeaves;
    private boolean _collapseAllowed;
    private int _x1;
    private int _x2;
    private int _y1;
    private int _y2;
    private int _startCount;
    private int _anchorIndex;
    private DataConstraint _oldConstraint;
    private EWTScrollPane _scrollBox;
    private RootComponent _parent;
    private PropertyChangeListener _listener = new Listen();
    private boolean _autoSimplify;
    private boolean _isDragging;
    private DragComponent _draggingComponent;
    private Vector _selection;
    private ConstraintBuilderComp[] _orderedSelection;
    private boolean _orderedSelectionDirty;
    private ConstraintCompFactory _factory;
    private DataDescriptorProvider _provider;
    private JPopupMenu _menu;
    private ConstraintBuilderCustomizer _customizer;
    private ConstraintBuilderComp _menuComponent;
    private ActionListener _menuListener;
    private int _groupWidth;
    private boolean _groupWidthValid;
    private Vector _leaves;
    private boolean _leafWidthValid;
    private int _leafWidth;
    private int _groupDepth;
    private int _dropMode = 1;

    public ConstraintBuilder() {
        this(null);
    }

    public ConstraintBuilder(DataConstraint dataConstraint) {
        super.setLayout(new BorderLayout());
        ((JComponent)((Object)this)).setBackground(Color.white);
        ((JComponent)((Object)this)).setOpaque(false);
        this._autoSimplify = false;
        this._parent = this.createRootComponent();
        this._parent.setConstraintBuilder(this);
        this._scrollBox = new EWTScrollPane((Component)((Object)this._parent));
        ((Container)((Object)this)).add("Center", (Component)this._scrollBox);
        this._selection = new Vector();
        this._anchorIndex = -1;
        this._x1 = -1;
        this._linesVisible = true;
        this._alignLeaves = true;
        this._leaves = new Vector();
        this.setDataConstraint(dataConstraint);
        this.registerKeyboardActions();
    }

    public DataConstraint getDataConstraint() {
        return this._parent.getDataConstraint();
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        int n = this.getSelectionCount();
        this.clearSelection(false);
        this._oldConstraint = null;
        this.removeAllLeaves();
        this._parent.setDataConstraint(dataConstraint);
        this.tryInvalidateLeafLocation();
        this.trySimplify();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this._fireSelectionEvent(n, 0);
    }

    public void setConstraintCompFactory(ConstraintCompFactory constraintCompFactory) {
        this._factory = constraintCompFactory;
    }

    public ConstraintCompFactory getConstraintCompFactory() {
        if (this._factory == null) {
            this._factory = ConstraintCompFactory.getConstraintCompFactory();
        }
        return this._factory;
    }

    public void setDataDescriptorProvider(DataDescriptorProvider dataDescriptorProvider) {
        if (this._provider != dataDescriptorProvider) {
            this._provider = dataDescriptorProvider;
        }
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public ConstraintBuilderCustomizer getCustomizer() {
        return this._customizer;
    }

    public void setCustomizer(ConstraintBuilderCustomizer constraintBuilderCustomizer) {
        if (this._customizer != constraintBuilderCustomizer) {
            this._customizer = constraintBuilderCustomizer;
        }
    }

    public void addConstraintComponent(ConstraintComponent constraintComponent) {
        this.addLeaf(constraintComponent);
        DragComponent dragComponent = this.createDragComponent(constraintComponent);
        dragComponent.setConstraintBuilder(this);
        this._addConstraintBuilderComp(dragComponent, this._parent);
        this.setSelection(dragComponent);
        this.fireDataConstraintChanged();
    }

    public final int getSelectionCount() {
        return this._selection.size();
    }

    public void deleteSelectedComponents() {
        ConstraintBuilderComp[] constraintBuilderCompArray = this.getSelectedComponents();
        int n = constraintBuilderCompArray.length;
        this.freezeRepaints();
        int n2 = 0;
        while (n2 < n) {
            this.removeConstraintBuilderComp(constraintBuilderCompArray[n2]);
            ++n2;
        }
        this.trySimplify();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this.unfreezeRepaints();
        this.fireDataConstraintChanged();
    }

    public final void replaceSelectedComponent(ConstraintComponent constraintComponent) {
        if (this.getSelectionCount() != 0) {
            ConstraintBuilderComp constraintBuilderComp = (ConstraintBuilderComp)this._selection.elementAt(0);
            this.replaceConstraintBuilderComp(constraintComponent, constraintBuilderComp);
        }
    }

    public final void createAndOrOnSelection(boolean bl) {
        this.performCreateAndOr(bl, false);
    }

    public final void createNotOnSelection() {
        int n = this._selection.size();
        if (n == 0) {
            return;
        }
        Object[] objectArray = new ConstraintBuilderComp[n];
        this._selection.copyInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((ConstraintBuilderComp)object).performNot();
            ++n2;
        }
        this.trySimplify();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        ((ConstraintBuilderComp)objectArray[0]).requestDBUIFocus(false);
    }

    public boolean isAutoSimplifyEnabled() {
        return this._autoSimplify;
    }

    public void setAutoSimplifyEnabled(boolean bl) {
        if (this._autoSimplify != bl) {
            this._autoSimplify = bl;
            if (this._autoSimplify) {
                this.simplifyLayout();
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public void simplifyLayout() {
        Component component = SwingUtilities.findFocusOwner((Component)((Object)this));
        this._simplifyParent(this._parent);
        this._updateIndicies();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        if (component != null && component.getPeer() != null) {
            component.requestFocus();
        }
    }

    public void setGroupLinesVisible(boolean bl) {
        if (this._linesVisible != bl) {
            this._linesVisible = bl;
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean isGroupLinesVisible() {
        return this._linesVisible;
    }

    public boolean isAlignLeaves() {
        return this._alignLeaves;
    }

    public void setAlignLeaves(boolean bl) {
        if (this._alignLeaves != bl) {
            this._alignLeaves = bl;
            this._parent.setLeafLocationValid(false);
            this._layoutConstraintBuilder();
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean isCollapseAllowed() {
        return this._collapseAllowed;
    }

    public void setCollapseAllowed(boolean bl) {
        if (this._collapseAllowed != bl) {
            this._collapseAllowed = bl;
            if (!this._collapseAllowed) {
                this._setExpanded(this._parent, true);
                this._layoutConstraintBuilder();
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public int getDropMode() {
        return this._dropMode;
    }

    public void setDropMode(int n) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("Not a valid argument for drop mode");
        }
        this._dropMode = n;
    }

    public void replaceConstraintBuilderComp(ConstraintBuilderComp[] constraintBuilderCompArray, ConstraintBuilderComp constraintBuilderComp) {
        int n;
        ConstraintBuilderComp constraintBuilderComp2 = constraintBuilderCompArray[0];
        ParentComponent parentComponent = constraintBuilderComp.getParentComponent();
        ParentComponent parentComponent2 = constraintBuilderComp2.getParentComponent();
        this.freezeRepaints();
        int n2 = parentComponent.getIndex(constraintBuilderComp);
        ParentComponent parentComponent3 = parentComponent2;
        int n3 = parentComponent3.getIndex(constraintBuilderComp2);
        if (this.getDropMode() == 2) {
            n = 0;
            while (n < constraintBuilderCompArray.length) {
                if (constraintBuilderCompArray[n].getConstraintBuilder() != this) {
                    throw new IllegalArgumentException("Swap not possible: ConstraintBuilderComp does notbelong to this ConstraintBuilder");
                }
                ++n;
            }
        }
        n = this._selection.size();
        this.clearSelection(false);
        int n4 = 0;
        while (n4 < constraintBuilderCompArray.length) {
            constraintBuilderComp2 = constraintBuilderCompArray[n4];
            parentComponent2 = constraintBuilderComp2.getParentComponent();
            parentComponent2.removeChild(constraintBuilderComp2);
            parentComponent.addChild(constraintBuilderComp2, n2 + n4);
            this.addToSelection(constraintBuilderComp2, false);
            if (parentComponent2.getChildCount() == 0 && (this.getDropMode() == 1 || this.getDropMode() == 2 && parentComponent2 != parentComponent3)) {
                this.removeConstraintBuilderComp(parentComponent2);
            }
            ++n4;
        }
        parentComponent.removeChild(constraintBuilderComp);
        if (this.getDropMode() == 2) {
            parentComponent3.addChild(constraintBuilderComp, n3);
        } else {
            this.removeLeaf(((DragComponent)constraintBuilderComp).getConstraintComponent());
        }
        this.tryInvalidateLeafLocation();
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Component)((Object)this)).repaint();
        this._fireSelectionEvent(n, this._selection.size());
        this.fireDataConstraintChanged();
        constraintBuilderCompArray[0].requestDBUIFocus(false);
    }

    public void replaceConstraintBuilderComp(ConstraintComponent constraintComponent, ConstraintBuilderComp constraintBuilderComp) {
        ParentComponent parentComponent = constraintBuilderComp.getParentComponent();
        if (parentComponent == null) {
            return;
        }
        this.freezeRepaints();
        this.addLeaf(constraintComponent);
        DragComponent dragComponent = this.createDragComponent(constraintComponent);
        dragComponent.setConstraintBuilder(this);
        int n = parentComponent.getIndex(constraintBuilderComp);
        parentComponent.removeChild(constraintBuilderComp);
        parentComponent.addChild(dragComponent, n);
        this.removeLeaf(((DragComponent)constraintBuilderComp).getConstraintComponent());
        this.setSelection(dragComponent);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        dragComponent.requestDBUIFocus(false);
    }

    public void dropConstraintComponent(ConstraintComponent constraintComponent, ParentComponent parentComponent, int n) {
        this.freezeRepaints();
        this.addLeaf(constraintComponent);
        DragComponent dragComponent = this.createDragComponent(constraintComponent);
        dragComponent.setConstraintBuilder(this);
        parentComponent.addChild(dragComponent, n);
        this.setSelection(dragComponent);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        dragComponent.requestDBUIFocus(false);
    }

    public void dropConstraintBuilderComp(ConstraintBuilderComp[] constraintBuilderCompArray, ParentComponent parentComponent, int n) {
        ConstraintBuilderComp constraintBuilderComp = constraintBuilderCompArray[0];
        ParentComponent parentComponent2 = constraintBuilderComp.getParentComponent();
        this.freezeRepaints();
        int n2 = 0;
        while (n2 < constraintBuilderCompArray.length) {
            int n3 = n + n2;
            constraintBuilderComp = constraintBuilderCompArray[n2];
            parentComponent2 = constraintBuilderComp.getParentComponent();
            parentComponent2.removeChild(constraintBuilderComp);
            parentComponent.addChild(constraintBuilderComp, n3);
            if (parentComponent2.getChildCount() == 0) {
                this.removeConstraintBuilderComp(parentComponent2);
            }
            ++n2;
        }
        int n4 = this._selection.size();
        this.clearSelection(false);
        int n5 = 0;
        while (n5 < constraintBuilderCompArray.length) {
            this.addToSelection(constraintBuilderCompArray[n5], false);
            ++n5;
        }
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        this._fireSelectionEvent(n4, this._selection.size());
        constraintBuilderCompArray[0].requestDBUIFocus(false);
    }

    public void setSelection(ConstraintBuilderComp constraintBuilderComp) {
        this.setSelection(constraintBuilderComp, true);
        this._anchorIndex = constraintBuilderComp.getIndex();
    }

    public ConstraintBuilderComp parseConstraint(DataConstraint dataConstraint) {
        ConstraintBuilderComp constraintBuilderComp;
        if (dataConstraint instanceof DCBooleanExpression) {
            AndOrComponent andOrComponent = this.createAndOrComponent(true);
            andOrComponent.setConstraintBuilder(this);
            andOrComponent.setDataConstraint(dataConstraint);
            constraintBuilderComp = andOrComponent;
        } else if (dataConstraint instanceof DCUnaryExpression) {
            AndOrComponent andOrComponent = this.createAndOrComponent(true);
            andOrComponent.setConstraintBuilder(this);
            andOrComponent.setDataConstraint(dataConstraint);
            constraintBuilderComp = andOrComponent;
        } else {
            ConstraintComponent constraintComponent = this.createConstraintComponent(dataConstraint);
            this.addLeaf(constraintComponent);
            DragComponent dragComponent = this.createDragComponent(constraintComponent);
            dragComponent.setConstraintBuilder(this);
            constraintBuilderComp = dragComponent;
        }
        return constraintBuilderComp;
    }

    public int getGroupWidth() {
        if (!this._groupWidthValid) {
            this._groupWidth = this._computeGroupWidth();
            this._groupWidthValid = this._groupWidth != -1;
        }
        return this._groupWidth;
    }

    public void replaceConstraintComponent(ConstraintBuilderComp constraintBuilderComp, ConstraintComponent constraintComponent) {
        ConstraintBuilderComp constraintBuilderComp2 = null;
        Container container = constraintComponent.getComponent().getParent();
        if (container == null || !(container instanceof ConstraintBuilderComp)) {
            return;
        }
        constraintBuilderComp2 = (ConstraintBuilderComp)((Object)container);
        ParentComponent parentComponent = constraintBuilderComp2.getParentComponent();
        if (parentComponent == null) {
            return;
        }
        this.freezeRepaints();
        constraintBuilderComp.setConstraintBuilder(this);
        int n = parentComponent.getIndex(constraintBuilderComp2);
        parentComponent.removeChild(constraintBuilderComp2);
        parentComponent.addChild(constraintBuilderComp, n);
        this.removeLeaf(((DragComponent)constraintBuilderComp2).getConstraintComponent());
        this.setSelection(constraintBuilderComp);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        constraintBuilderComp.requestDBUIFocus(false);
    }

    public void selectAll() {
        this.freezeRepaints();
        ConstraintBuilderComp[] constraintBuilderCompArray = this._parent.getChildren();
        int n = 0;
        while (n < constraintBuilderCompArray.length) {
            this.setSelection(constraintBuilderCompArray[n], n == constraintBuilderCompArray.length - 1);
            ++n;
        }
        this.unfreezeRepaints();
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.SELECTION_COLOR = UIManager.getColor("textHighlight");
        Color color = UIManager.getColor("normalIntensity");
        if (color == null) {
            color = Color.lightGray;
        }
        this.DROP_FEEDBACK_COLOR = color;
    }

    public void removeAll() {
        this._parent.removeAll();
        this.fireDataConstraintChanged();
        ((Container)((Object)this)).invalidate();
    }

    public Dimension getMaximumSize() {
        return this._parent.getMaximumSize();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._parent.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._groupWidthValid = false;
    }

    protected void paintOverChildren(Graphics graphics) {
        this._paintSelection(graphics);
    }

    protected JPopupMenu getMenuForAndOrComponent(boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
        JPopupMenu jPopupMenu = this._getEmptyMenu();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_AND"));
        jMenuItem.setActionCommand("CREATE_AND");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_OR"));
        jMenuItem.setActionCommand("CREATE_OR");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_NOT"));
        jMenuItem.setActionCommand("CREATE_NOT");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        if (!bl2 || bl2 && n == 1) {
            if (bl) {
                jMenuItem = new JMenuItem(resourceBundle.getString("REMOVE_AND"));
                jMenuItem.setActionCommand("REMOVE_AND");
            } else {
                jMenuItem = new JMenuItem(resourceBundle.getString("REMOVE_OR"));
                jMenuItem.setActionCommand("REMOVE_OR");
            }
            jMenuItem.addActionListener(this._menuListener);
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(resourceBundle.getString("DELETE"));
        jMenuItem.setActionCommand("DELETE");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (bl) {
            jMenuItem = new JMenuItem(resourceBundle.getString("CHANGE_TO_OR"));
            jMenuItem.setActionCommand("CHANGE_TO_OR");
            jMenuItem.addActionListener(this._menuListener);
            jPopupMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem(resourceBundle.getString("CHANGE_TO_AND"));
            jMenuItem.setActionCommand("CHANGE_TO_AND");
            jMenuItem.addActionListener(this._menuListener);
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(resourceBundle.getString("SIMPLIFY"));
        jMenuItem.setActionCommand("SIMPLIFY");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString(_ADD_CONSTRAINT_KEY));
        jMenuItem.setActionCommand(_ADD_COMMAND);
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        if (this.isCollapseAllowed()) {
            if (bl4) {
                jMenuItem = new JMenuItem(resourceBundle.getString("COLLAPSE"));
                jMenuItem.setActionCommand("COLLAPSE");
                jMenuItem.addActionListener(this._menuListener);
                jPopupMenu.add(jMenuItem);
            } else {
                jMenuItem = new JMenuItem(resourceBundle.getString("EXPAND"));
                jMenuItem.setActionCommand("EXPAND");
                jMenuItem.addActionListener(this._menuListener);
                jPopupMenu.add(jMenuItem);
            }
        }
        return jPopupMenu;
    }

    protected JPopupMenu getMenuForSingleComponent(ConstraintComponent constraintComponent, boolean bl) {
        JPopupMenu jPopupMenu = this._getEmptyMenu();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_AND"));
        jMenuItem.setActionCommand("CREATE_AND");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_OR"));
        jMenuItem.setActionCommand("CREATE_OR");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_NOT"));
        jMenuItem.setActionCommand("CREATE_NOT");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("DELETE"));
        jMenuItem.setActionCommand("DELETE");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    protected JPopupMenu getMenuForMultipleSelection(int n) {
        JPopupMenu jPopupMenu = this._getEmptyMenu();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_AND"));
        jMenuItem.setActionCommand("CREATE_AND");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_OR"));
        jMenuItem.setActionCommand("CREATE_OR");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CREATE_NOT"));
        jMenuItem.setActionCommand("CREATE_NOT");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("DELETE"));
        jMenuItem.setActionCommand("DELETE");
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    protected JPopupMenu getMenuForConstraintBuilder() {
        JPopupMenu jPopupMenu = this._getEmptyMenu();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("SIMPLIFY"));
        jMenuItem.setActionCommand("SIMPLIFY");
        jMenuItem.addActionListener(this._menuListener);
        jMenuItem.setEnabled(this._parent.getChildCount() != 0);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString(_ADD_CONSTRAINT_KEY));
        jMenuItem.setActionCommand(_ADD_COMMAND);
        jMenuItem.addActionListener(this._menuListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    protected void layoutChildren() {
        this._parent.layoutChildren();
    }

    protected void paintGroupLines(Graphics graphics) {
        int n;
        if (this.isGroupLinesVisible() && (n = this.getGroupDepth()) != 0) {
            int n2 = 0;
            int n3 = this.getScrollPane().getViewport().getViewPosition().y;
            ImmInsets immInsets = this.getBorderInsets();
            int n4 = ((JComponent)((Object)this)).getHeight() + n3;
            graphics.setColor(Color.black);
            int n5 = 0;
            while (n5 < n) {
                int n6 = (n2 += this.getGroupWidth(n5)) + -1;
                int n7 = n3;
                while (n7 < n4) {
                    graphics.drawLine(n6, n7, n6, n7);
                    n7 += 2;
                }
                ++n5;
            }
        }
    }

    protected final int getGroupDepth() {
        return this._groupDepth;
    }

    public final int getLeafCount() {
        return this._leaves.size();
    }

    public final ConstraintComponent[] getLeaves() {
        Object[] objectArray = null;
        int n = this._leaves.size();
        if (n > 0) {
            objectArray = new ConstraintComponent[n];
            this._leaves.copyInto(objectArray);
        }
        return objectArray;
    }

    protected final int getGroupWidth(int n) {
        return this._parent.getGroupWidth(n);
    }

    protected final EWTScrollPane getScrollPane() {
        return this._scrollBox;
    }

    protected void leafChanged(ConstraintComponent constraintComponent) {
        if (!constraintComponent.getComponent().isValid()) {
            this._leafWidthValid = false;
            this._layoutConstraintBuilder();
        }
    }

    protected void removeConstraintBuilderComp(ConstraintBuilderComp constraintBuilderComp) {
        ParentComponent parentComponent = constraintBuilderComp.getParentComponent();
        if (parentComponent == null) {
            throw new IllegalArgumentException("toRemove not found");
        }
        Component component = SwingUtilities.findFocusOwner((Component)((Object)this));
        this.removeFromSelection(constraintBuilderComp);
        parentComponent.removeChild(constraintBuilderComp);
        constraintBuilderComp.setConstraintBuilder(null);
        if (constraintBuilderComp instanceof ParentComponent) {
            this._removeLeaves(((ParentComponent)constraintBuilderComp).getLeaves());
            ((Container)((Object)constraintBuilderComp)).removeAll();
            this.tryInvalidateLeafLocation();
        } else {
            this.removeLeaf(((DragComponent)constraintBuilderComp).getConstraintComponent());
        }
        if (parentComponent.getChildCount() == 0 && parentComponent != this._parent) {
            this.removeConstraintBuilderComp(parentComponent);
        }
        if (component != null && component.getPeer() != null) {
            component.requestFocus();
        }
    }

    protected void clearSelection() {
        this.clearSelection(true);
    }

    protected void fireDataConstraintChanged() {
        DataConstraint dataConstraint = this._parent.getDataConstraint();
        ((Component)((Object)this)).firePropertyChange("dataConstraint", this._oldConstraint, dataConstraint);
        this._oldConstraint = dataConstraint;
    }

    protected void performCreateAndOr(boolean bl, boolean bl2) {
        int n = this._selection.size();
        if (n > 1) {
            ConstraintBuilderComp constraintBuilderComp = bl2 ? this._menuComponent : (ConstraintBuilderComp)this._selection.lastElement();
            this._performAndOrOnSelection(constraintBuilderComp, bl);
        } else if (n == 1) {
            ConstraintBuilderComp constraintBuilderComp = (ConstraintBuilderComp)this._selection.firstElement();
            this._createConstraintGroup(constraintBuilderComp, bl);
        }
    }

    protected void performRemoveParent() {
        ParentComponent parentComponent = (ParentComponent)this._selection.firstElement();
        ParentComponent parentComponent2 = parentComponent.getParentComponent();
        int n = parentComponent2.getIndex(parentComponent);
        parentComponent2.removeChild(parentComponent);
        ConstraintBuilderComp[] constraintBuilderCompArray = parentComponent.getChildren();
        parentComponent.removeAll();
        int n2 = 0;
        while (n2 < constraintBuilderCompArray.length) {
            parentComponent2.addChild(constraintBuilderCompArray[n2], n + n2);
            ++n2;
        }
        this.clearSelection(false);
        int n3 = 0;
        while (n3 < constraintBuilderCompArray.length) {
            this.addToSelection(constraintBuilderCompArray[n3]);
            ++n3;
        }
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        constraintBuilderCompArray[0].requestDBUIFocus(false);
    }

    protected void performAdd() {
        DragComponent dragComponent = this.createNewComponent();
        ParentComponent parentComponent = this._selection.size() == 0 ? this._parent : (ParentComponent)this._selection.firstElement();
        this._addConstraintBuilderComp(dragComponent, parentComponent);
        this.fireDataConstraintChanged();
    }

    protected void addLeaf(ConstraintComponent constraintComponent) {
        int n = this._leaves.size();
        this._leaves.addElement(constraintComponent);
        constraintComponent.addPropertyChangeListener(this._listener);
        this._leafWidthValid = false;
        this._fireIntegerEvent(PROPERTY_LEAF_COUNT, n, this._leaves.size());
    }

    protected void removeLeaf(ConstraintComponent constraintComponent) {
        int n = this._leaves.size();
        this._leaves.removeElement(constraintComponent);
        constraintComponent.removePropertyChangeListener(this._listener);
        this._leafWidthValid = false;
        this._fireIntegerEvent(PROPERTY_LEAF_COUNT, n, this._leaves.size());
    }

    protected void removeAllLeaves() {
        int n = this._leaves.size();
        if (n > 0) {
            Object[] objectArray = new ConstraintComponent[n];
            this._leaves.copyInto(objectArray);
            this._removeLeaves((ConstraintComponent[])objectArray);
        }
    }

    protected void registerKeyboardActions() {
        Key key = new Key();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(8, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(key, "DELETE", keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(key, "DELETE", keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(155, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(key, _INSERT_COMMAND, keyStroke, 1);
    }

    protected DragComponent createDragComponent(ConstraintComponent constraintComponent) {
        return new DragComponent(constraintComponent);
    }

    protected AndOrComponent createAndOrComponent(boolean bl) {
        return new AndOrComponent(bl);
    }

    protected DragComponent createDragComponent(ParentComponent parentComponent, LWComponent lWComponent) {
        return new DragComponent(parentComponent, lWComponent);
    }

    protected RootComponent createRootComponent() {
        return new RootComponent();
    }

    protected final ConstraintBuilderComp[] getSelectedComponents() {
        int n = this._selection.size();
        Object[] objectArray = new ConstraintBuilderComp[n];
        this._selection.copyInto(objectArray);
        return objectArray;
    }

    protected final ParentComponent getRootComponent() {
        return this._parent;
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new AccessibleConstraintBuilder();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    ConstraintComponent createConstraintComponent(DataConstraint dataConstraint) {
        DataDescriptorProvider dataDescriptorProvider = this.getDataDescriptorProvider();
        ConstraintCompFactory constraintCompFactory = this.getConstraintCompFactory();
        return constraintCompFactory.createConstraintComponent(dataDescriptorProvider, null, dataConstraint);
    }

    ConstraintComponent createConstraintComponent(DataDescriptor dataDescriptor) {
        DataDescriptorProvider dataDescriptorProvider = this.getDataDescriptorProvider();
        ConstraintCompFactory constraintCompFactory = this.getConstraintCompFactory();
        return constraintCompFactory.createConstraintComponent(dataDescriptorProvider, dataDescriptor, null);
    }

    void tryRequestFocus() {
        if (!((Container)((Object)this)).isAncestorOf(SwingUtilities.findFocusOwner((Component)((Object)this)))) {
            this._parent.requestDBUIFocus(false);
        }
    }

    void startDragSelection(ParentComponent parentComponent, int n, int n2) {
        Point point = this._getOffset((Component)((Object)parentComponent));
        this._x1 = n + point.x;
        this._y1 = n2 + point.y;
        this._x2 = -1;
        this._y2 = -1;
        this._startCount = this._selection.size();
    }

    void continueDragSelection(ParentComponent parentComponent, int n, int n2) {
        Point point = this._getOffset((Component)((Object)parentComponent));
        this._x2 = n + point.x;
        this._y2 = n2 + point.y;
        this._parent.freezeRepaints();
        this._updateSelection();
        ((Component)((Object)this)).repaint();
        this._parent.unfreezeRepaints();
    }

    void finishDragSelection(ParentComponent parentComponent, int n, int n2) {
        this._parent.freezeRepaints();
        this._updateSelection();
        this._x1 = -1;
        ((Component)((Object)this)).repaint();
        this._parent.unfreezeRepaints();
        int n3 = this._selection.size();
        this._fireSelectionEvent(this._startCount, n3);
    }

    void addToSelection(ConstraintBuilderComp constraintBuilderComp) {
        if (this._anchorIndex == -1) {
            this._anchorIndex = constraintBuilderComp.getIndex();
            this.addToSelection(constraintBuilderComp, true);
        } else {
            this._setSelection(constraintBuilderComp.getIndex(), this._anchorIndex);
        }
    }

    void addToSelection(ConstraintBuilderComp constraintBuilderComp, boolean bl) {
        if (this._selection.indexOf(constraintBuilderComp) == -1 && ((Component)((Object)constraintBuilderComp)).isEnabled() && !constraintBuilderComp.isSelected()) {
            this._orderedSelectionDirty = true;
            int n = this._selection.size();
            this._selection.addElement(constraintBuilderComp);
            constraintBuilderComp.setSelected(true);
            int n2 = this._selection.size();
            if (bl) {
                this._fireSelectionEvent(n, n2);
            }
        }
    }

    void removeFromSelection(ConstraintBuilderComp constraintBuilderComp) {
        this.removeFromSelection(constraintBuilderComp, false);
    }

    void removeFromSelection(ConstraintBuilderComp constraintBuilderComp, boolean bl) {
        if (this._selection.indexOf(constraintBuilderComp) != -1) {
            this._orderedSelectionDirty = true;
            int n = this._selection.size();
            this._selection.removeElement(constraintBuilderComp);
            constraintBuilderComp.setSelected(false);
            int n2 = this._selection.size();
            if (bl) {
                this._fireSelectionEvent(n, n2);
            }
        }
    }

    void toggleSelection(ConstraintBuilderComp constraintBuilderComp) {
        if (!((Component)((Object)constraintBuilderComp)).isEnabled()) {
            return;
        }
        this._anchorIndex = constraintBuilderComp.getIndex();
        int n = this._selection.indexOf(constraintBuilderComp);
        boolean bl = constraintBuilderComp.isSelected();
        if (bl && n == -1) {
            return;
        }
        int n2 = this._selection.size();
        if (n == -1) {
            this._selection.addElement(constraintBuilderComp);
            bl = true;
        } else {
            this._selection.removeElementAt(n);
            bl = false;
        }
        this._orderedSelectionDirty = true;
        constraintBuilderComp.setSelected(bl);
        int n3 = this._selection.size();
        this._fireSelectionEvent(n2, n3);
    }

    boolean isSelected(ConstraintBuilderComp constraintBuilderComp) {
        int n = 0;
        while (n < this._selection.size()) {
            if (constraintBuilderComp == this._selection.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void clearSelection(boolean bl) {
        this.setSelection(null, bl);
        this._anchorIndex = -1;
    }

    void setSelection(ConstraintBuilderComp constraintBuilderComp, boolean bl) {
        int n = this._selection.size();
        int n2 = 0;
        while (n2 < this._selection.size()) {
            ConstraintBuilderComp constraintBuilderComp2 = (ConstraintBuilderComp)this._selection.elementAt(n2);
            if (constraintBuilderComp2 != constraintBuilderComp) {
                constraintBuilderComp2.setSelected(false);
            }
            ++n2;
        }
        this._selection.removeAllElements();
        if (constraintBuilderComp != null && ((Component)((Object)constraintBuilderComp)).isEnabled()) {
            this._selection.addElement(constraintBuilderComp);
            constraintBuilderComp.setSelected(true);
        }
        this._orderedSelectionDirty = true;
        int n3 = this._selection.size();
        if (bl) {
            this._fireSelectionEvent(n, n3);
        }
    }

    boolean canDrag(ConstraintBuilderComp constraintBuilderComp) {
        return this._parent.getChildCount() == 1 && this._parent.getChild(0) != constraintBuilderComp;
    }

    void showMenu(ParentComponent parentComponent, boolean bl, int n, int n2) {
        JPopupMenu jPopupMenu = null;
        if (!bl) {
            this._menuComponent = null;
            this.clearSelection();
            this.paintImmediateInterior();
            jPopupMenu = this._getMenuForConstraintBuilder();
        } else {
            int n3 = this.getSelectionCount();
            if (n3 > 1) {
                jPopupMenu = this._getMenuForMultipleSelection(n3);
                this._menuComponent = (ConstraintBuilderComp)this._selection.elementAt(0);
            } else if (n3 == 1) {
                ParentComponent parentComponent2;
                ConstraintBuilderComp constraintBuilderComp;
                this._menuComponent = constraintBuilderComp = (ConstraintBuilderComp)this._selection.elementAt(0);
                if (constraintBuilderComp instanceof DragComponent) {
                    DragComponent dragComponent = (DragComponent)constraintBuilderComp;
                    ConstraintComponent constraintComponent = dragComponent.getConstraintComponent();
                    jPopupMenu = this._getMenuForSingleComponent(constraintComponent, false);
                } else if (constraintBuilderComp instanceof ParentComponent && (parentComponent2 = (ParentComponent)constraintBuilderComp) instanceof AndOrComponent) {
                    AndOrComponent andOrComponent = (AndOrComponent)parentComponent2;
                    ParentComponent parentComponent3 = andOrComponent.getParentComponent();
                    boolean bl2 = parentComponent3 == this._parent;
                    boolean bl3 = andOrComponent.isNot();
                    jPopupMenu = this._getMenuForAndOrComponent(andOrComponent.isAnd(), andOrComponent.getChildCount(), bl2, bl3, andOrComponent.isExpanded());
                }
            }
        }
        if (jPopupMenu != null) {
            Point point = this._getOffset((Component)((Object)parentComponent));
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), jPopupMenu, n + point.x, n2 + point.y);
        }
    }

    void showMenu(ConstraintBuilderComp constraintBuilderComp, int n, int n2) {
        if (!this.isSelected(constraintBuilderComp) && !(constraintBuilderComp instanceof RootComponent)) {
            this.setSelection(constraintBuilderComp);
        }
        constraintBuilderComp.requestDBUIFocus(false);
        this._menuComponent = constraintBuilderComp;
        this.paintImmediateInterior();
        JPopupMenu jPopupMenu = this._getMenuForComponent(constraintBuilderComp);
        if (jPopupMenu != null) {
            Point point = this._getOffset((Component)((Object)constraintBuilderComp));
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), jPopupMenu, n + point.x, n2 + point.y);
        }
    }

    void performAndOr(boolean bl) {
        ConstraintBuilderComp constraintBuilderComp = (ConstraintBuilderComp)this._selection.firstElement();
        if (constraintBuilderComp instanceof AndOrComponent) {
            AndOrComponent andOrComponent;
            andOrComponent.setAnd(!(andOrComponent = (AndOrComponent)constraintBuilderComp).isAnd());
            this.paintImmediateInterior();
            this.trySimplify();
            this._layoutConstraintBuilder();
            ((Component)((Object)this)).repaint();
        }
        this.fireDataConstraintChanged();
    }

    void performSimplify() {
        int n = this._selection.size();
        Component component = SwingUtilities.findFocusOwner((Component)((Object)this));
        if (n == 0) {
            this._simplifyParent(this._parent);
        } else {
            ParentComponent parentComponent = (ParentComponent)this._selection.firstElement();
            this._simplifyParent(parentComponent);
        }
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        ((Component)((Object)this)).repaint();
        this.fireDataConstraintChanged();
        if (component != null && component.getPeer() != null) {
            component.requestFocus();
        }
    }

    void performExpand(boolean bl) {
        ParentComponent parentComponent = (ParentComponent)this._selection.firstElement();
        parentComponent.setExpanded(bl);
    }

    void trySimplify() {
        if (this.isAutoSimplifyEnabled()) {
            this.simplifyLayout();
        } else {
            this._updateIndicies();
        }
    }

    DragComponent createNewComponent() {
        ConstraintComponent constraintComponent = this.createConstraintComponent((DataConstraint)null);
        this.addLeaf(constraintComponent);
        DragComponent dragComponent = this.createDragComponent(constraintComponent);
        dragComponent.setConstraintBuilder(this);
        return dragComponent;
    }

    void setDragging(DragComponent dragComponent, boolean bl) {
        this._isDragging = bl;
        this._draggingComponent = dragComponent;
    }

    boolean isDragging() {
        return this._isDragging;
    }

    Image getDragImage() {
        Image image;
        int n = 0;
        int n2 = 0;
        Dimension dimension = null;
        if (this._orderedSelectionDirty) {
            this._orderSelection();
        }
        int n3 = this._orderedSelection.length;
        int n4 = 0;
        while (n4 < n3) {
            dimension = ((Component)((Object)this._orderedSelection[n4])).getSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            n2 += dimension.height + 5;
            ++n4;
        }
        n2 -= 5;
        if (n > 150) {
            n = 150;
        }
        if ((image = ((Component)((Object)this)).createImage(n, n2)) != null) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(((Component)((Object)this._parent)).getBackground());
            graphics.fillRect(0, 0, n, n2);
            int n5 = 0;
            while (n5 < n3) {
                ConstraintBuilderComp constraintBuilderComp = this._orderedSelection[n5];
                dimension = ((Component)((Object)constraintBuilderComp)).getSize();
                graphics.setClip(0, 0, n, dimension.height);
                graphics.setColor(((Component)((Object)constraintBuilderComp)).getBackground());
                graphics.fillRect(0, 0, n, dimension.height);
                graphics.setColor(((Component)((Object)constraintBuilderComp)).getForeground());
                graphics.setFont(((Component)((Object)constraintBuilderComp)).getFont());
                ((Component)((Object)constraintBuilderComp)).paint(graphics);
                graphics.translate(0, dimension.height + 5);
                ++n5;
            }
            TruncateFilter truncateFilter = new TruncateFilter(n, n2);
            image = DBUILookAndFeel.createFilteredImage(image, truncateFilter);
            TransparentGrayFilter transparentGrayFilter = new TransparentGrayFilter(((Component)((Object)this._parent)).getBackground(), true);
            image = DBUILookAndFeel.createFilteredImage(image, transparentGrayFilter);
        }
        return image;
    }

    Transferable getDragTransferable() {
        if (this._orderedSelectionDirty) {
            this._orderSelection();
        }
        int n = this._orderedSelection.length;
        ConstraintBuilderComp[] constraintBuilderCompArray = new ConstraintBuilderComp[n];
        int n2 = 0;
        while (n2 < n) {
            constraintBuilderCompArray[n2] = this._orderedSelection[n2];
            ++n2;
        }
        return new CBCompTransfer(new CBCompArray(constraintBuilderCompArray));
    }

    final int getLeafWidth() {
        if (!this._leafWidthValid) {
            this._leafWidth = this._computeLeafWidth();
            this._leafWidthValid = true;
        }
        return this._leafWidth;
    }

    private final int _computeGroupWidth() {
        return DragComponent.getGroupWidth(this.getPaintContext());
    }

    private final int _computeLeafWidth() {
        int n = 0;
        int n2 = this._leaves.size();
        int n3 = 0;
        while (n3 < n2) {
            ConstraintComponent constraintComponent = (ConstraintComponent)this._leaves.elementAt(n3);
            int n4 = constraintComponent.getComponent().getPreferredSize().width;
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    private void _removeLeaves(ConstraintComponent[] constraintComponentArray) {
        if (constraintComponentArray != null) {
            int n = 0;
            while (n < constraintComponentArray.length) {
                this.removeLeaf(constraintComponentArray[n]);
                ++n;
            }
        }
    }

    private JPopupMenu _getMenuForAndOrComponent(boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
        ConstraintBuilderCustomizer constraintBuilderCustomizer;
        JPopupMenu jPopupMenu = this.getMenuForAndOrComponent(bl, n, bl2, bl3, bl4);
        if (jPopupMenu != null && (constraintBuilderCustomizer = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            constraintBuilderCustomizer.customizeMenuForAndOrComponent(jPopupMenu, locale, bl, n, bl2, bl3, bl4);
            if (jPopupMenu.getComponentCount() == 0) {
                jPopupMenu = null;
            }
        }
        return jPopupMenu;
    }

    private JPopupMenu _getMenuForSingleComponent(ConstraintComponent constraintComponent, boolean bl) {
        ConstraintBuilderCustomizer constraintBuilderCustomizer;
        JPopupMenu jPopupMenu = this.getMenuForSingleComponent(constraintComponent, bl);
        if (jPopupMenu != null && (constraintBuilderCustomizer = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            constraintBuilderCustomizer.customizeMenuForSingleComponent(jPopupMenu, locale, constraintComponent, bl);
            if (jPopupMenu.getComponentCount() == 0) {
                jPopupMenu = null;
            }
        }
        return jPopupMenu;
    }

    private JPopupMenu _getMenuForMultipleSelection(int n) {
        ConstraintBuilderCustomizer constraintBuilderCustomizer;
        JPopupMenu jPopupMenu = this.getMenuForMultipleSelection(n);
        if (jPopupMenu != null && (constraintBuilderCustomizer = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            constraintBuilderCustomizer.customizeMenuForMultipleSelection(jPopupMenu, locale, n);
            if (jPopupMenu.getComponentCount() == 0) {
                jPopupMenu = null;
            }
        }
        return jPopupMenu;
    }

    private JPopupMenu _getMenuForConstraintBuilder() {
        ConstraintBuilderCustomizer constraintBuilderCustomizer;
        JPopupMenu jPopupMenu = this.getMenuForConstraintBuilder();
        if (jPopupMenu != null && (constraintBuilderCustomizer = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            constraintBuilderCustomizer.customizeMenuForConstraintBuilder(jPopupMenu, locale);
            if (jPopupMenu.getComponentCount() == 0) {
                jPopupMenu = null;
            }
        }
        return jPopupMenu;
    }

    private void _setSelection(int n, int n2) {
        ConstraintBuilderComp constraintBuilderComp;
        int n3;
        int n4;
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        this._orderedSelectionDirty = true;
        int n5 = this._selection.size();
        int n6 = 0;
        while (n6 < n5) {
            constraintBuilderComp = (ConstraintBuilderComp)this._selection.elementAt(n6);
            int n7 = constraintBuilderComp.getIndex();
            if (n7 < n4 || n7 > n3) {
                constraintBuilderComp.setSelected(false);
            }
            ++n6;
        }
        this._selection.removeAllElements();
        int n8 = n4;
        while (n8 <= n3) {
            constraintBuilderComp = this._getComponent(n8);
            constraintBuilderComp.setSelected(true);
            this._selection.addElement(constraintBuilderComp);
            ++n8;
        }
        int n9 = this._selection.size();
        this._fireSelectionEvent(n5, n9);
    }

    private void _fireSelectionEvent(int n, int n2) {
        this._fireIntegerEvent(PROPERTY_SELECTION_COUNT, n, n2);
    }

    private void _fireIntegerEvent(String string, int n, int n2) {
        if (n != n2) {
            Integer n3 = IntegerUtils.getInteger((int)n);
            Integer n4 = IntegerUtils.getInteger((int)n2);
            ((Component)((Object)this)).firePropertyChange(string, n3, n4);
        }
    }

    private ConstraintBuilderComp _getComponent(int n) {
        return this._getComponent(this._parent, n);
    }

    private ConstraintBuilderComp _getComponent(ConstraintBuilderComp constraintBuilderComp, int n) {
        if (constraintBuilderComp.getIndex() == n) {
            return constraintBuilderComp;
        }
        if (constraintBuilderComp instanceof ParentComponent) {
            ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
            int n2 = parentComponent.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                constraintBuilderComp = this._getComponent(parentComponent.getChild(n3), n);
                if (constraintBuilderComp != null) {
                    return constraintBuilderComp;
                }
                ++n3;
            }
        }
        return null;
    }

    private void _orderSelection() {
        int n = this._selection.size();
        this._orderedSelection = new ConstraintBuilderComp[n];
        this._selection.copyInto(this._orderedSelection);
        Sort.qSort((Object[])this._orderedSelection, (int)n, (Comparator)CBCompComparator.getComparator());
        this._orderedSelectionDirty = false;
    }

    private void _updateIndicies() {
        int n = this._updateIndex(this._parent, 0);
        this._anchorIndex = -1;
    }

    private int _updateIndex(ConstraintBuilderComp constraintBuilderComp, int n) {
        constraintBuilderComp.setIndex(n);
        if (constraintBuilderComp instanceof ParentComponent) {
            ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
            int n2 = parentComponent.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                n = this._updateIndex(parentComponent.getChild(n3), n + 1);
                ++n3;
            }
        }
        return n;
    }

    private void _updateSelection() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this._x2 == -1) {
            return;
        }
        if (this._x2 < this._x1) {
            n4 = this._x2;
            n3 = this._x1;
        } else {
            n4 = this._x1;
            n3 = this._x2;
        }
        if (this._y2 < this._y1) {
            n2 = this._y2;
            n = this._y1;
        } else {
            n2 = this._y1;
            n = this._y2;
        }
        int n5 = n3 - n4 + 1;
        int n6 = n - n2 + 1;
        this.freezeRepaints();
        this._parent.updateSelection(n4, n2, n5, n6);
        this.unfreezeRepaints();
        this.paintImmediateInterior();
    }

    private void _paintSelection(Graphics graphics) {
        if (this._x1 == -1 || this._x2 == -1) {
            return;
        }
        graphics.setColor(((Component)((Object)this)).getForeground());
        graphics.setXORMode(((Component)((Object)this)).getBackground());
        graphics.drawLine(this._x1, this._y1, this._x1, this._y2);
        graphics.drawLine(this._x1, this._y2, this._x2, this._y2);
        graphics.drawLine(this._x2, this._y2, this._x2, this._y1);
        graphics.drawLine(this._x2, this._y1, this._x1, this._y1);
        graphics.setPaintMode();
    }

    private void _createConstraintGroup(ConstraintBuilderComp constraintBuilderComp, boolean bl) {
        ParentComponent parentComponent = constraintBuilderComp.getParentComponent();
        if (parentComponent == null) {
            throw new IllegalArgumentException("parent not found.");
        }
        Component component = SwingUtilities.findFocusOwner((Component)((Object)this));
        DragComponent dragComponent = this.createNewComponent();
        int n = parentComponent.getIndex(constraintBuilderComp);
        parentComponent.removeChild(constraintBuilderComp);
        AndOrComponent andOrComponent = this.createAndOrComponent(bl);
        andOrComponent.setConstraintBuilder(this);
        andOrComponent.addChild(constraintBuilderComp);
        andOrComponent.addChild(dragComponent);
        parentComponent.addChild(andOrComponent, n);
        this.setSelection(andOrComponent);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        ((Container)((Object)this)).validate();
        ((JComponent)((Object)parentComponent)).scrollRectToVisible(((Component)((Object)andOrComponent)).getBounds());
        this.fireDataConstraintChanged();
        if (component != null) {
            component.requestFocus();
        }
    }

    private void _addConstraintBuilderComp(ConstraintBuilderComp constraintBuilderComp, ParentComponent parentComponent) {
        parentComponent.addChild(constraintBuilderComp);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        ((Container)((Object)this)).validate();
        ((JComponent)((Object)parentComponent)).scrollRectToVisible(((Component)((Object)constraintBuilderComp)).getBounds());
    }

    private void _simplifyParent(ParentComponent parentComponent) {
        ConstraintBuilderComp constraintBuilderComp;
        if (parentComponent == null) {
            return;
        }
        this.freezeRepaints();
        int n = parentComponent.getChildCount();
        ConstraintBuilderComp[] constraintBuilderCompArray = parentComponent.getChildren();
        int n2 = 0;
        while (n2 < n) {
            constraintBuilderComp = constraintBuilderCompArray[n2];
            if (constraintBuilderComp instanceof ParentComponent) {
                this._simplifyParent((ParentComponent)constraintBuilderComp);
            }
            ++n2;
        }
        if (!(parentComponent instanceof RootComponent) && parentComponent instanceof AndOrComponent) {
            AndOrComponent andOrComponent = (AndOrComponent)parentComponent;
            int n3 = andOrComponent.getChildCount();
            ParentComponent parentComponent2 = andOrComponent.getParentComponent();
            switch (n3) {
                case 0: {
                    parentComponent2.removeChild(andOrComponent);
                    break;
                }
                case 1: {
                    int n4 = parentComponent2.getIndex(andOrComponent);
                    parentComponent2.removeChild(andOrComponent);
                    constraintBuilderComp = andOrComponent.getChild(0);
                    andOrComponent.removeChild(constraintBuilderComp);
                    parentComponent2.addChild(constraintBuilderComp);
                    break;
                }
                default: {
                    constraintBuilderCompArray = andOrComponent.getChildren();
                    int n5 = 0;
                    while (n5 < constraintBuilderCompArray.length) {
                        constraintBuilderComp = constraintBuilderCompArray[n5];
                        if (constraintBuilderComp instanceof AndOrComponent) {
                            AndOrComponent andOrComponent2 = (AndOrComponent)constraintBuilderComp;
                            if (andOrComponent.isAnd() == andOrComponent2.isAnd() && andOrComponent.isNot() == andOrComponent2.isNot()) {
                                ConstraintBuilderComp[] constraintBuilderCompArray2 = andOrComponent2.getChildren();
                                int n6 = andOrComponent.getIndex(andOrComponent2);
                                andOrComponent2.removeAll();
                                andOrComponent.removeChild(andOrComponent2);
                                boolean bl = this.isSelected(andOrComponent2);
                                int n7 = this._selection.size();
                                if (bl) {
                                    this.removeFromSelection(andOrComponent2, false);
                                }
                                int n8 = 0;
                                while (n8 < constraintBuilderCompArray2.length) {
                                    andOrComponent.addChild(constraintBuilderCompArray2[n8], n6 + n8);
                                    if (bl) {
                                        this.addToSelection(constraintBuilderCompArray2[n8], false);
                                    }
                                    ++n8;
                                }
                                if (bl) {
                                    this._fireSelectionEvent(n7, this._selection.size());
                                }
                            }
                        }
                        ++n5;
                    }
                    break block0;
                }
            }
        }
        this.unfreezeRepaints();
    }

    private JPopupMenu _getEmptyMenu() {
        if (this._menuListener == null) {
            this._menuListener = new Menus();
        }
        this._menu = new JPopupMenu();
        return this._menu;
    }

    private JPopupMenu _getMenuForComponent(ConstraintBuilderComp constraintBuilderComp) {
        boolean bl;
        JPopupMenu jPopupMenu = null;
        int n = this._selection.size();
        boolean bl2 = bl = n > 1;
        if (bl) {
            jPopupMenu = this._getMenuForMultipleSelection(n);
        } else if (constraintBuilderComp instanceof ParentComponent) {
            ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
            if (parentComponent instanceof AndOrComponent) {
                AndOrComponent andOrComponent = (AndOrComponent)constraintBuilderComp;
                ParentComponent parentComponent2 = andOrComponent.getParentComponent();
                boolean bl3 = parentComponent2 == this._parent;
                boolean bl4 = andOrComponent.isNot();
                jPopupMenu = this._getMenuForAndOrComponent(andOrComponent.isAnd(), andOrComponent.getChildCount(), bl3, bl4, andOrComponent.isExpanded());
            } else if (parentComponent instanceof RootComponent) {
                jPopupMenu = this._getMenuForConstraintBuilder();
            }
        } else if (constraintBuilderComp instanceof DragComponent) {
            DragComponent dragComponent = (DragComponent)constraintBuilderComp;
            boolean bl5 = dragComponent.getParentComponent() instanceof AndOrComponent ? ((AndOrComponent)dragComponent.getParentComponent()).isNot() : false;
            jPopupMenu = this._getMenuForSingleComponent(dragComponent.getConstraintComponent(), bl5);
        }
        return jPopupMenu;
    }

    private Point _getOffset(Component component) {
        Component component2 = component;
        int n = 0;
        int n2 = 0;
        while (component2 != null && component2 != this) {
            Point point = component2.getLocation();
            n += point.x;
            n2 += point.y;
            component2 = component2.getParent();
        }
        return new Point(n, n2);
    }

    private void _performAndOrOnSelection(ConstraintBuilderComp constraintBuilderComp, boolean bl) {
        int n = this._selection.size();
        if (constraintBuilderComp == null || n == 0) {
            return;
        }
        Component component = SwingUtilities.findFocusOwner((Component)((Object)this));
        ParentComponent parentComponent = constraintBuilderComp.getParentComponent();
        Object[] objectArray = new ConstraintBuilderComp[n];
        this._selection.copyInto(objectArray);
        this.freezeRepaints();
        int n2 = 0;
        while (n2 < n) {
            ParentComponent parentComponent2;
            if (objectArray[n2] != constraintBuilderComp && (parentComponent2 = ((ConstraintBuilderComp)objectArray[n2]).getParentComponent()) != null) {
                parentComponent2.removeChild((ConstraintBuilderComp)objectArray[n2]);
            }
            ++n2;
        }
        int n3 = parentComponent.getIndex(constraintBuilderComp);
        parentComponent.removeChild(constraintBuilderComp);
        AndOrComponent andOrComponent = this.createAndOrComponent(bl);
        andOrComponent.setConstraintBuilder(this);
        int n4 = 0;
        while (n4 < n) {
            andOrComponent.addChild((ConstraintBuilderComp)objectArray[n4]);
            ++n4;
        }
        parentComponent.addChild(andOrComponent, n3);
        this.setSelection(andOrComponent);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        ((Container)((Object)this)).validate();
        ((JComponent)((Object)parentComponent)).scrollRectToVisible(((Component)((Object)andOrComponent)).getBounds());
        this.fireDataConstraintChanged();
        if (component != null) {
            component.requestFocus();
        }
    }

    private void _layoutConstraintBuilder() {
        ((JComponent)((Object)this._parent)).revalidate();
        this._scrollBox.revalidate();
    }

    void tryInvalidateLeafLocation() {
        int n = this._parent.getGroupDepth();
        if (this._groupDepth != n) {
            int n2 = this._groupDepth;
            this._groupDepth = n;
            this._fireIntegerEvent(PROPERTY_GROUP_DEPTH, n2, this._groupDepth);
        }
        this._parent.setLeafLocationValid(false);
    }

    private void _setExpanded(ParentComponent parentComponent, boolean bl) {
        parentComponent.setExpanded(bl);
        int n = parentComponent.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ConstraintBuilderComp constraintBuilderComp = parentComponent.getChild(n2);
            if (constraintBuilderComp instanceof ParentComponent) {
                this._setExpanded((ParentComponent)constraintBuilderComp, bl);
            }
            ++n2;
        }
    }

    private class AccessibleConstraintBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleConstraintBuilder() {
            super((JComponent)((Object)ConstraintBuilder.this));
            ConstraintBuilder.this._parent.getAccessibleContext().setAccessibleParent(ConstraintBuilder.this);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ConstraintBuilder.this._parent;
        }
    }

    protected class Key
    implements ActionListener {
        protected Key() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("DELETE".equals(string)) {
                ConstraintBuilder.this.deleteSelectedComponents();
            } else if (ConstraintBuilder._INSERT_COMMAND.equals(string)) {
                ConstraintComponent constraintComponent = ConstraintBuilder.this.createConstraintComponent((DataConstraint)null);
                ConstraintBuilder.this.addConstraintComponent(constraintComponent);
            }
        }
    }

    private class Listen
    implements PropertyChangeListener {
        private Listen() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ConstraintBuilder.this.fireDataConstraintChanged();
            ConstraintBuilder.this.leafChanged((ConstraintComponent)propertyChangeEvent.getSource());
            ((Component)((Object)ConstraintBuilder.this)).repaint();
        }
    }

    private class Menus
    implements ActionListener {
        private Menus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("CHANGE_TO_AND".equals(string)) {
                ConstraintBuilder.this.performAndOr(true);
            } else if ("CHANGE_TO_OR".equals(string)) {
                ConstraintBuilder.this.performAndOr(false);
            } else if ("CREATE_AND".equals(string)) {
                ConstraintBuilder.this.performCreateAndOr(true, true);
            } else if ("CREATE_OR".equals(string)) {
                ConstraintBuilder.this.performCreateAndOr(false, true);
            } else if ("CREATE_NOT".equals(string)) {
                ConstraintBuilder.this.createNotOnSelection();
            } else if ("DELETE".equals(string)) {
                ConstraintBuilder.this.deleteSelectedComponents();
            } else if (ConstraintBuilder._ADD_COMMAND.equals(string)) {
                ConstraintBuilder.this.performAdd();
            } else if ("SIMPLIFY".equals(string)) {
                ConstraintBuilder.this.performSimplify();
            } else if ("EXPAND".equals(string)) {
                ConstraintBuilder.this.performExpand(true);
            } else if ("COLLAPSE".equals(string)) {
                ConstraintBuilder.this.performExpand(false);
            } else if ("REMOVE_AND".equals(string)) {
                ConstraintBuilder.this.performRemoveParent();
            } else if ("REMOVE_OR".equals(string)) {
                ConstraintBuilder.this.performRemoveParent();
            } else if (ConstraintBuilder._REMOVE_NOT_COMMAND.equals(string)) {
                ConstraintBuilder.this.performRemoveParent();
            }
        }
    }
}

