/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;

public class DragComponent
extends ConstraintBuilderComp
implements DragSourceListener,
DropTargetListener {
    static final ImmInsets _FOCUS_INSETS = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null).getInsets(null);
    protected static final int GRAB_WIDTH = 10;
    protected static final int GRAB_HEIGHT = 10;
    private ConstraintComponent _constraintComponent;
    private ParentComponent _parentComponent;
    private boolean _dropping;
    private boolean _replacing;
    private boolean _isDragging;
    private DragGestureRecognizer _childDragGestureRecognizer;

    private DragComponent() {
    }

    public DragComponent(ConstraintComponent constraintComponent) {
        this._constraintComponent = constraintComponent;
        ((Container)((Object)this)).setLayout(null);
        Component component = constraintComponent.getComponent();
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this), 2, (DragGestureListener)new StartDrag(false));
        this._setChild(component);
        this._addDropTarget(this);
        ((Component)((Object)this)).enableEvents(60L);
    }

    public DragComponent(ParentComponent parentComponent, LWComponent lWComponent) {
        this._parentComponent = parentComponent;
        ((Container)((Object)this)).setLayout(null);
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this), 2, (DragGestureListener)new StartDrag(false));
        this._setChild((Component)lWComponent);
        ((Component)((Object)this)).enableEvents(48L);
    }

    public void performNot() {
        ConstraintComponent constraintComponent = this.getConstraintComponent();
        if (constraintComponent != null) {
            DCUnaryExpression dCUnaryExpression = new DCUnaryExpression(constraintComponent.getDataConstraint(), 1);
            constraintComponent.initState(constraintComponent.getDataDescriptor(), dCUnaryExpression);
        }
    }

    public ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    public ParentComponent getWrappedParentComponent() {
        return this._parentComponent;
    }

    public DataConstraint getDataConstraint() {
        if (this.getConstraintComponent() != null) {
            return this.getConstraintComponent().getDataConstraint();
        }
        return this.getWrappedParentComponent().getDataConstraint();
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        ((Component)((Object)this)).repaint();
    }

    public void setDropping(boolean bl) {
        if (this._dropping != bl) {
            this._dropping = bl;
            Color color = this._dropping ? this.getConstraintBuilder().DROP_FEEDBACK_COLOR : this.getUIDefaults().getColor("control");
            this.getChild().setBackground(color);
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean isDropping() {
        return this._dropping;
    }

    public void setReplacing(boolean bl) {
        if (this._replacing != bl) {
            this._replacing = bl;
            Color color = this._replacing ? this.getConstraintBuilder().DROP_REPLACE_FEEDBACK_COLOR : this.getUIDefaults().getColor("control");
            this.getChild().setBackground(color);
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean isReplacing() {
        return this._replacing;
    }

    public boolean isFocusTraversable() {
        return this.getWrappedParentComponent() == null;
    }

    public Component getFocusComponent() {
        return this;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component component = this.getChild();
        component.setEnabled(bl);
        UIDefaults uIDefaults = this.getUIDefaults();
        if (!((Component)((Object)this)).isEnabled()) {
            component.setBackground(uIDefaults.getColor("lightIntensity"));
        } else {
            component.setBackground(uIDefaults.getColor("control"));
        }
    }

    public void paintComponent(Graphics graphics) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        int n = DragComponent._FOCUS_INSETS.left;
        int n2 = DragComponent._FOCUS_INSETS.top;
        Dimension dimension = ((Component)((Object)this)).getSize();
        PaintContext paintContext = this.getPaintContext();
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        borderPainter.paint(paintContext, graphics, n, n2, dimension.width - (DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right), dimension.height - (DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom));
        ImmInsets immInsets = borderPainter.getInsets(paintContext);
        n += immInsets.left;
        n2 += immInsets.top;
        dimension.width -= immInsets.left + immInsets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        dimension.height -= immInsets.top + immInsets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        Color color = graphics.getColor();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        if (!((Component)((Object)this)).isEnabled()) {
            graphics.setColor(uIDefaults.getColor("lightIntensity"));
        } else if (this.isReplacing()) {
            graphics.setColor(constraintBuilder.DROP_REPLACE_FEEDBACK_COLOR);
        } else if (this.isDropping()) {
            graphics.setColor(constraintBuilder.DROP_FEEDBACK_COLOR);
        } else if (this.isSelected()) {
            graphics.setColor(this.getSelectionColor());
        } else {
            graphics.setColor(uIDefaults.getColor("control"));
        }
        graphics.fillRect(n, n2, 10, dimension.height);
        int n3 = n + 5;
        int n4 = n2 + dimension.height / 2;
        Color color2 = Color.white;
        graphics.setColor(color2);
        graphics.drawLine(n3, n4 - 2, n3, n4 - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(n3 + 1, n4 - 2, n3 + 1, n4 - 2);
        graphics.drawLine(n3, n4 - 1, n3 + 1, n4 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n3, n4 + 2, n3, n4 + 2);
        graphics.setColor(Color.black);
        graphics.drawLine(n3, n4 + 3, n3 + 1, n4 + 3);
        graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
        if (((Component)((Object)this)).hasFocus()) {
            Dimension dimension2 = ((Component)((Object)this)).getSize();
            BorderPainter borderPainter2 = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            borderPainter2.paint(paintContext, graphics, 0, 0, dimension2.width, dimension2.height - 1);
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    public Dimension getMinimumSize() {
        Component component = this.getChild();
        Dimension dimension = new Dimension(10, 10);
        Dimension dimension2 = component.getMinimumSize();
        dimension.width += dimension2.width;
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets immInsets = borderPainter.getInsets(this.getPaintContext());
        dimension.width += immInsets.left + immInsets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        dimension.height += immInsets.top + immInsets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Component component = this.getChild();
        Dimension dimension = new Dimension(10, 10);
        Dimension dimension2 = component.getPreferredSize();
        if (this.getConstraintComponent() != null) {
            int n = this.getLeafWidth();
            dimension2.width = Math.max(n, dimension2.width);
        }
        dimension.width += dimension2.width;
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets immInsets = borderPainter.getInsets(this.getPaintContext());
        dimension.width += immInsets.left + immInsets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        dimension.height += immInsets.top + immInsets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        return dimension;
    }

    public static int getGroupWidth(PaintContext paintContext) {
        Font font = paintContext.getPaintFont();
        if (font == null) {
            return -1;
        }
        FontMetrics fontMetrics = paintContext.getFontMetrics(font);
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets immInsets = borderPainter.getInsets(paintContext);
        return 10 + immInsets.left + immInsets.right + 2 + 25 + fontMetrics.stringWidth("NOT AND");
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Component component = this.getChild();
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets immInsets = borderPainter.getInsets(this.getPaintContext());
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n = immInsets.left + 10 + DragComponent._FOCUS_INSETS.left;
        int n2 = immInsets.top + DragComponent._FOCUS_INSETS.top;
        int n3 = dimension.width - (immInsets.left + immInsets.right + 10 + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right);
        int n4 = dimension.height - (immInsets.top + immInsets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom);
        component.setBounds(n, n2, n3, n4);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        ((Component)((Object)this)).repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || constraintBuilder != null && !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 121 && (keyEvent.getModifiers() & 1) != 0) {
            this._showMenu(0, 0);
            keyEvent.consume();
        } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9 && ((Component)((Object)this)).hasFocus()) {
            if (keyEvent.isShiftDown()) {
                ParentComponent parentComponent = this.getParentComponent();
                if (parentComponent.getIndex(this) == 0) {
                    parentComponent.requestFocus();
                    keyEvent.consume();
                }
            } else {
                ParentComponent parentComponent = this.getWrappedParentComponent();
                if (parentComponent != null) {
                    parentComponent.getFocusComponent().requestFocus();
                } else {
                    this.getChild().requestFocus();
                }
                keyEvent.consume();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || constraintBuilder != null && !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        int n2 = mouseEvent.getX();
        if (!((JComponent)((Object)this)).contains(n2, n = mouseEvent.getY())) {
            return;
        }
        boolean bl = false;
        int n3 = mouseEvent.getID();
        if (mouseEvent.isPopupTrigger()) {
            this._showMenu(n2, n);
            bl = true;
        } else if (n3 == 501) {
            this.trySelection(mouseEvent);
            bl = true;
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    protected Color getSelectionColor() {
        return this.getConstraintBuilder().SELECTION_COLOR;
    }

    protected Component getChild() {
        Component component = null;
        if (((Container)((Object)this)).getComponentCount() != 0) {
            component = ((Container)((Object)this)).getComponent(0);
        }
        return component;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this._isDragging = false;
        this.getConstraintBuilder().setDragging(this, false);
    }

    public boolean isDragging() {
        return this._isDragging;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this._acceptDrag(dropTargetDragEvent)) {
            this.setReplacing(true);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setReplacing(false);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        ConstraintBuilderComp[] constraintBuilderCompArray;
        this.setReplacing(false);
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        if (!this._acceptDrop(dropTargetDropEvent)) {
            dropTargetContext.dropComplete(false);
            return;
        }
        dropTargetDropEvent.acceptDrop(2);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = null;
        if (transferable.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            try {
                object = transferable.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException iOException) {
                object = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            if (object instanceof DataDescriptor && (constraintBuilderCompArray = (DataDescriptor)object) != null) {
                dropTargetContext.dropComplete(true);
                ConstraintComponent constraintComponent = this.getConstraintBuilder().createConstraintComponent((DataDescriptor)constraintBuilderCompArray);
                this.getConstraintBuilder().replaceConstraintBuilderComp(constraintComponent, (ConstraintBuilderComp)this);
            }
        }
        if (object == null && transferable.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            try {
                object = transferable.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException iOException) {
                object = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            if (object instanceof ConstraintComponent && (constraintBuilderCompArray = (ConstraintComponent)object) != null) {
                dropTargetContext.dropComplete(true);
                this.getConstraintBuilder().replaceConstraintBuilderComp((ConstraintComponent)constraintBuilderCompArray, (ConstraintBuilderComp)this);
            }
        }
        if (object == null && transferable.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            try {
                object = transferable.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException iOException) {
                object = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            if (object instanceof CBCompArray && (constraintBuilderCompArray = ((CBCompArray)object).getData()) != null) {
                dropTargetContext.dropComplete(true);
                int n = 0;
                while (n < constraintBuilderCompArray.length) {
                    if (constraintBuilderCompArray[n] == this) {
                        return;
                    }
                    ++n;
                }
                this.getConstraintBuilder().replaceConstraintBuilderComp(constraintBuilderCompArray, (ConstraintBuilderComp)this);
            }
        }
    }

    protected int getAccessActionCount() {
        return 5;
    }

    protected String getAccessActionDescription(int n) {
        switch (n) {
            case 0: {
                return this.getTranslatedAccessibleString("TOGGLE_SELECT");
            }
            case 1: {
                return this.getTranslatedAccessibleString("PERFORM_NOT");
            }
            case 2: {
                return this.getTranslatedAccessibleString("CREATE_AND");
            }
            case 3: {
                return this.getTranslatedAccessibleString("CREATE_OR");
            }
            case 4: {
                return this.getTranslatedAccessibleString("DELETE");
            }
        }
        return null;
    }

    protected boolean doAccessAction(int n) {
        switch (n) {
            case 0: {
                boolean bl;
                boolean bl2 = bl = !this.isSelected();
                if (bl) {
                    this.getConstraintBuilder().addToSelection(this, false);
                } else {
                    this.getConstraintBuilder().removeFromSelection(this, false);
                }
                return true;
            }
            case 1: {
                this.performNot();
                return true;
            }
            case 2: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(true, false);
                return true;
            }
            case 3: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(false, false);
                return true;
            }
            case 4: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().deleteSelectedComponents();
                return true;
            }
        }
        return false;
    }

    void tryDrag(DragGestureEvent dragGestureEvent, boolean bl) {
        ConstraintBuilderComp constraintBuilderComp = this._getCBComponent();
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        if (constraintBuilder.canDrag(constraintBuilderComp) && !this._isDragging) {
            if (!constraintBuilderComp.isSelected()) {
                constraintBuilder.setSelection(constraintBuilderComp);
                constraintBuilder.paintImmediateInterior();
            }
            Point point = dragGestureEvent.getDragOrigin();
            point.x = 5;
            point.y = -point.y;
            if (constraintBuilderComp instanceof ParentComponent) {
                point.y -= ((Component)((Object)this)).getLocation().y;
                if (bl) {
                    point.y -= this.getChild().getLocation().y;
                }
            }
            this._isDragging = true;
            dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, constraintBuilder.getDragImage(), point, constraintBuilder.getDragTransferable(), (DragSourceListener)this);
            constraintBuilder.setDragging(this, this._isDragging);
        }
    }

    void trySelection(MouseEvent mouseEvent) {
        ConstraintBuilderComp constraintBuilderComp = this._getCBComponent();
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        if (mouseEvent.isShiftDown()) {
            constraintBuilder.addToSelection(constraintBuilderComp);
        } else if (mouseEvent.isControlDown()) {
            constraintBuilder.toggleSelection(constraintBuilderComp);
        } else if (!constraintBuilder.isSelected(constraintBuilderComp)) {
            constraintBuilder.setSelection(constraintBuilderComp);
        }
        constraintBuilderComp.requestDBUIFocus(false);
    }

    void childMouseEvent(MouseEvent mouseEvent) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        if (mouseEvent.isConsumed() || !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Component component = this.getChild();
        if (!component.contains(n, n2)) {
            return;
        }
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            Point point = component.getLocation();
            this._showMenu(n += point.x, n2 += point.y);
            bl = true;
        } else if (mouseEvent.getID() == 501) {
            this.trySelection(mouseEvent);
            bl = true;
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    int getBorderWidth() {
        int n = 10;
        BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets immInsets = borderPainter.getInsets(this.getPaintContext());
        return n += immInsets.left + immInsets.right;
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!((Component)((Object)this)).isEnabled()) {
            return false;
        }
        ParentComponent parentComponent = this.getParentComponent();
        while (parentComponent != null) {
            if (parentComponent.isDragging()) {
                return false;
            }
            parentComponent = parentComponent.getParentComponent();
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
                return true;
            }
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
                return true;
            }
            if (CBCompArray.CB_COMP_ARRAY_FLAVOR.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean _acceptDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (!((Component)((Object)this)).isEnabled()) {
            return false;
        }
        ParentComponent parentComponent = this.getParentComponent();
        while (parentComponent != null) {
            if (parentComponent.isDragging()) {
                return false;
            }
            parentComponent = parentComponent.getParentComponent();
        }
        return true;
    }

    private void _showMenu(int n, int n2) {
        ConstraintBuilderComp constraintBuilderComp = this._getCBComponent();
        if (constraintBuilderComp instanceof ParentComponent) {
            Point point = ((Component)((Object)this)).getLocation();
            n += point.x;
            n2 += point.y;
        }
        this.getConstraintBuilder().showMenu(constraintBuilderComp, n, n2);
    }

    private void _setChild(Component component) {
        ((Container)((Object)this)).add(component);
        this._childDragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 2, (DragGestureListener)new StartDrag(true));
        component.addMouseListener(new Mouser());
        if (this.getWrappedParentComponent() == null) {
            ChildSelect childSelect = new ChildSelect();
            if (component instanceof Container) {
                this._addMouseListener((Container)component, childSelect);
            }
        }
    }

    private ConstraintBuilderComp _getCBComponent() {
        if (this.getConstraintComponent() != null) {
            return this;
        }
        return this.getWrappedParentComponent();
    }

    private void _addMouseListener(Container container, MouseListener mouseListener) {
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            component.addMouseListener(mouseListener);
            if (component instanceof Container) {
                this._addMouseListener((Container)component, mouseListener);
            }
            ++n;
        }
    }

    private void _addDropTarget(LWComponent lWComponent) {
        if (JFCSupport.getEWTDropTarget((JComponent)lWComponent) != null) {
            return;
        }
        DropTarget dropTarget = new DropTarget((Component)lWComponent, (DropTargetListener)this);
        int n = lWComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = lWComponent.getComponent(n2);
            if (component instanceof LWComponent) {
                this._addDropTarget((LWComponent)component);
            }
            ++n2;
        }
    }

    private class StartDrag
    implements DragGestureListener {
        private boolean _isChild;

        public StartDrag(boolean bl) {
            this._isChild = bl;
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            DragComponent.this.tryDrag(dragGestureEvent, this._isChild);
        }
    }

    private class ChildSelect
    extends MouseAdapter {
        private ChildSelect() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ConstraintBuilder constraintBuilder = DragComponent.this.getConstraintBuilder();
            if (!mouseEvent.isConsumed() && ((Component)((Object)constraintBuilder)).isEnabled()) {
                constraintBuilder.setSelection(DragComponent.this);
            }
        }
    }

    private class Mouser
    extends MouseAdapter {
        private Mouser() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DragComponent.this.childMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DragComponent.this.childMouseEvent(mouseEvent);
        }
    }
}

