/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseLayoutManager;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.util.LocaleUtils;

public class BaseConstraintComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static final int _BASE_CONDITION = 1;
    public static final int CONDITION_EQUAL_TO = 1;
    public static final int CONDITION_NOT_EQUAL_TO = 2;
    public static final int CONDITION_IS_NULL = 3;
    public static final int CONDITION_IS_NOT_NULL = 4;
    public static final int CONDITION_BETWEEN = 5;
    public static final int CONDITION_NOT_BETWEEN = 6;
    protected static final int RESERVED_ID_MAX = 100;
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private static final String _BETWEEN_KEY = "BETWEEN";
    private static final String _NOT_BETWEEN_KEY = "NOT_BETWEEN";
    private static final String _NULL_KEY = "IS_NULL";
    private static final String _NOT_NULL_KEY = "IS_NOT_NULL";
    private static final String _AND_KEY = "AND";
    private static final int _EQUAL_INDEX = 0;
    private static final int _NOT_EQUAL_INDEX = 1;
    private static final int _NULL_INDEX = 2;
    private static final int _NOT_NULL_INDEX = 3;
    private static final int _BETWEEN_INDEX = 4;
    private static final int _NOT_BETWEEN_INDEX = 5;
    private static final int _DEFAULT_COUNT = 2;
    private static final int _NULL_COUNT = 2;
    private JComboBox _choice = new Choice();
    private Component _value = this.createValueComponent();
    private int _choiceWidth;
    private int _valueWidth;
    private LWComponent _between;
    private JLabel _label;
    private Component _betweenValue;
    private boolean _allowBetween;
    private DataDescriptor _descriptor;
    private DataConstraint _oldValue;

    public BaseConstraintComponent() {
        ((Container)((Object)this)).setLayout(new BaseLayoutManager());
        ((Container)((Object)this)).add("condition", this._choice);
        ((Container)((Object)this)).add("value", this._value);
        this._value.validate();
    }

    public void setBetweenAllowed(boolean bl) {
        if (bl != this._allowBetween) {
            this._allowBetween = bl;
            if (bl && this._between == null) {
                this._between = new LWComponent();
                this._between.setLayout(new BorderLayout(2, 0));
                this._label = new JLabel(this.getBetweenLabel());
                this._betweenValue = this.createValueComponent();
                this._between.add("Center", this._label);
                this._between.add("East", this._betweenValue);
                ((Container)((Object)this)).add("between", (Component)this._between);
                this._between.setVisible(this.isBetween(this.getTestCondition()));
                this._betweenValue.validate();
                ((Container)((Object)this)).invalidate();
            } else if (!bl && this._between != null) {
                this._between.setVisible(false);
                ((Container)((Object)this)).invalidate();
            }
            this.updateChoiceValues(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        }
    }

    public boolean isBetweenAllowed() {
        return this._allowBetween;
    }

    public void setTestCondition(int n) {
        if (!this.isConditionValid(n)) {
            throw new IllegalArgumentException("condition " + n + " is invalid.");
        }
        int n2 = this.convertConditionToSelection(n);
        this._choice.setSelectedIndex(n2);
        this.testConditionChanged(n);
    }

    public int getTestCondition() {
        int n = this._choice.getSelectedIndex();
        return this.convertSelectionToCondition(n);
    }

    public Component getComponent() {
        return this;
    }

    public DataConstraint getDataConstraint() {
        return this.getDataConstraint(this.getDataDescriptor(), this.getTestCondition());
    }

    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    public void initState(DataDescriptor dataDescriptor, DataConstraint dataConstraint) {
        boolean bl = false;
        if (dataConstraint != null && dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            bl = true;
        }
        this._descriptor = dataDescriptor;
        this._oldValue = dataConstraint;
        this.updateChoiceValues(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        this.parseConstraint(dataConstraint);
        if (bl) {
            this.setTestCondition(this.getNotCondition(this.getTestCondition()));
        }
        this.updateLayout();
    }

    public void requestFocus() {
        this._choice.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._choice.setEnabled(bl);
        this.getValueComponent().setEnabled(bl);
        if (this.isBetween(this.getTestCondition())) {
            this.getBetweenValueComponent().setEnabled(bl);
        }
    }

    public int getConditionPreferredWidth() {
        return this._choice.getPreferredSize().width;
    }

    public void setConditionWidth(int n) {
        if (this._choiceWidth != n) {
            this._choiceWidth = n;
            ((Container)((Object)this)).invalidate();
        }
    }

    public int getConditionWidth() {
        if (this._choiceWidth == 0) {
            this._choiceWidth = this.getConditionPreferredWidth();
        }
        return this._choiceWidth;
    }

    public int getValuePreferredWidth() {
        Component component = this.getValueComponent();
        int n = 0;
        if (component.isVisible()) {
            n = this.getValueComponent().getPreferredSize().width;
            if (this.isBetween(this.getTestCondition())) {
                n += this._between.getPreferredSize().width;
            }
        }
        return n;
    }

    public void setValueWidth(int n) {
        if (this._valueWidth != n) {
            this._valueWidth = n;
            ((Container)((Object)this)).invalidate();
        }
    }

    public int getValueWidth() {
        if (this._valueWidth == 0) {
            this._valueWidth = this.getValuePreferredWidth();
        }
        return this._valueWidth;
    }

    public JComboBox getConditionComponent() {
        return this._choice;
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    protected void fireDataConstraintChanged(Object object, Object object2) {
        ((Component)((Object)this)).firePropertyChange("dataConstraint", object, object2);
    }

    protected Component createValueComponent() {
        JTextField jTextField = new JTextField(10);
        jTextField.getDocument().addDocumentListener(new Dirty());
        return jTextField;
    }

    protected boolean isBetween(int n) {
        return n == 5 || n == 6;
    }

    protected boolean isNull(int n) {
        return n == 3 || n == 4;
    }

    protected boolean isNullAllowed() {
        DataDescriptor dataDescriptor = this.getDataDescriptor();
        return dataDescriptor == null ? false : dataDescriptor.isNullAllowed();
    }

    protected boolean isConditionValid(int n) {
        if (n == 1 || n == 2) {
            return true;
        }
        if (this.isNullAllowed() && (n == 3 || n == 4)) {
            return true;
        }
        return this.isBetweenAllowed() && (n == 5 || n == 6);
    }

    protected int convertConditionToSelection(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = this.getBaseNullIndex();
                break;
            }
            case 4: {
                n2 = this.getBaseNullIndex() + 1;
                break;
            }
            case 5: {
                n2 = this.getBaseBetweenIndex();
                break;
            }
            case 6: {
                n2 = this.getBaseBetweenIndex() + 1;
                break;
            }
        }
        return n2;
    }

    protected int convertSelectionToCondition(int n) {
        int n2 = -1;
        if (n == -1) {
            return n2;
        }
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
            }
        }
        int n3 = this.getBaseNullIndex();
        int n4 = this.getBaseBetweenIndex();
        if (n2 == -1) {
            if (this.isNullAllowed()) {
                if (n == n3) {
                    n2 = 3;
                } else if (n == n3 + 1) {
                    n2 = 4;
                } else if (n == n4) {
                    n2 = 5;
                } else if (n == n4 + 1) {
                    n2 = 6;
                }
            } else if (n == n4) {
                n2 = 5;
            } else if (n == n4 + 1) {
                n2 = 6;
            }
        }
        return n2;
    }

    protected int getBaseBetweenIndex() {
        if (this.isNullAllowed()) {
            return 4;
        }
        return 2;
    }

    protected int getBaseNullIndex() {
        return 2;
    }

    protected int getItemCount() {
        int n = 2;
        boolean bl = this.isNullAllowed();
        boolean bl2 = this.isBetweenAllowed();
        if (bl) {
            n += 2;
        }
        if (bl2) {
            n += 2;
        }
        return n;
    }

    protected String[] getChoiceValues(Locale locale) {
        int n;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        int n2 = this.getItemCount();
        boolean bl = this.isNullAllowed();
        boolean bl2 = this.isBetweenAllowed();
        String[] stringArray = new String[n2];
        stringArray[0] = resourceBundle.getString(_EQUAL_KEY);
        stringArray[1] = resourceBundle.getString(_NOT_EQUAL_KEY);
        if (bl) {
            n = this.getBaseNullIndex();
            stringArray[n] = resourceBundle.getString(_NULL_KEY);
            stringArray[n + 1] = resourceBundle.getString(_NOT_NULL_KEY);
        }
        if (bl2) {
            n = this.getBaseBetweenIndex();
            stringArray[n] = resourceBundle.getString(_BETWEEN_KEY);
            stringArray[n + 1] = resourceBundle.getString(_NOT_BETWEEN_KEY);
        }
        return stringArray;
    }

    protected DataConstraint getDataConstraint(DataDescriptor dataDescriptor, int n) {
        if (dataDescriptor == null) {
            return null;
        }
        DCExpression dCExpression = null;
        DataConstraint dataConstraint = this.getValueDataConstraint(this.getValueComponent(), dataDescriptor, n);
        DataConstraint dataConstraint2 = this.getItemDataConstraint(dataDescriptor, n);
        switch (n) {
            case 1: 
            case 3: {
                int n2 = 3;
                dCExpression = new DCComparisonExpression(dataConstraint2, dataConstraint, n2);
                break;
            }
            case 2: 
            case 4: {
                int n3 = 4;
                dCExpression = new DCComparisonExpression(dataConstraint2, dataConstraint, n3);
                break;
            }
            case 5: 
            case 6: {
                DataConstraint dataConstraint3 = this.getBetweenValueDataConstraint(this.getBetweenValueComponent(), dataDescriptor, n);
                int n4 = n == 5 ? 1 : 2;
                dCExpression = new DCBetweenExpression(dataConstraint2, dataConstraint, dataConstraint3, n4);
                break;
            }
        }
        return dCExpression;
    }

    protected Component getValueComponent() {
        return this._value;
    }

    protected Component getBetweenValueComponent() {
        return this._betweenValue;
    }

    protected DataConstraint getBetweenValueDataConstraint(Component component, DataDescriptor dataDescriptor, int n) {
        return this.getValueDataConstraint(component, dataDescriptor, n);
    }

    protected DataConstraint getValueDataConstraint(Component component, DataDescriptor dataDescriptor, int n) {
        if (this.isNull(n)) {
            return DCConstant.getNullConstant();
        }
        if (component instanceof JTextField) {
            return new DCConstant(((JTextField)component).getText());
        }
        return null;
    }

    protected DataConstraint getItemDataConstraint(DataDescriptor dataDescriptor, int n) {
        return dataDescriptor == null ? null : new DCVariable(dataDescriptor);
    }

    protected void parseConstraint(DataConstraint dataConstraint) {
        if (dataConstraint == null) {
            this.setTestCondition(1);
            this.initValueComponent(this.getValueComponent(), null);
            return;
        }
        if (dataConstraint instanceof DCComparisonExpression) {
            DCComparisonExpression dCComparisonExpression = (DCComparisonExpression)dataConstraint;
            int n = dCComparisonExpression.getOperand();
            DCConstant dCConstant = this._getValue(dCComparisonExpression);
            Object object = dCConstant == null ? null : dCConstant.getValue();
            this.initValueComponent(this.getValueComponent(), object);
            boolean bl = dCConstant == DCConstant.getNullConstant();
            int n2 = this._convertOperandToCondition(n, bl);
            this.setTestCondition(n2);
        } else if (dataConstraint instanceof DCBetweenExpression) {
            if (!this.isBetweenAllowed()) {
                throw new IllegalStateException("between is not allowed");
            }
            DCBetweenExpression dCBetweenExpression = (DCBetweenExpression)dataConstraint;
            int n = dCBetweenExpression.getOperand();
            DataConstraint dataConstraint2 = dCBetweenExpression.getFirstConstraint();
            DCConstant dCConstant = dataConstraint2 instanceof DCConstant ? (DCConstant)dataConstraint2 : null;
            Object object = dCConstant == null ? null : dCConstant.getValue();
            this.initValueComponent(this.getValueComponent(), object);
            dataConstraint2 = dCBetweenExpression.getSecondConstraint();
            dCConstant = dataConstraint2 instanceof DCConstant ? (DCConstant)dataConstraint2 : null;
            object = dCConstant == null ? null : dCConstant.getValue();
            this.initBetweenValueComponent(this.getBetweenValueComponent(), object);
            int n3 = n == 1 ? 5 : 6;
            this.setTestCondition(n3);
        } else {
            throw new IllegalArgumentException("Illegal DataConstraint " + dataConstraint);
        }
    }

    protected int getNotCondition(int n) {
        switch (n) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
        }
        return n;
    }

    protected void initValueComponent(Component component, Object object) {
        if (component instanceof JTextField) {
            String string = object == null ? null : object.toString();
            ((JTextField)component).setText(string);
        }
    }

    protected void initBetweenValueComponent(Component component, Object object) {
        this.initValueComponent(component, object);
    }

    protected String getBetweenLabel() {
        return this._getBetweenLabel(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    protected void updateChoiceValues(Locale locale) {
        int n = this._choice.getSelectedIndex();
        this._choice.removeAllItems();
        String[] stringArray = this.getChoiceValues(locale);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this._choice.addItem(stringArray[n2]);
            ++n2;
        }
        if (n != -1 && n < stringArray.length) {
            int n3 = this.convertSelectionToCondition(n);
            this.testConditionChanged(n3);
        }
    }

    protected void testConditionChanged(int n) {
        this._valueWidth = 0;
        ((Container)((Object)this)).invalidate();
    }

    protected void dataConstraintChanged() {
        DataConstraint dataConstraint = this.getDataConstraint();
        DataConstraint dataConstraint2 = this._oldValue;
        this.fireDataConstraintChanged(dataConstraint2, dataConstraint);
        this._oldValue = dataConstraint;
    }

    void updateLayout() {
        int n = this.getTestCondition();
        boolean bl = this.isBetween(n);
        boolean bl2 = false;
        if (this._between != null && this._between.isVisible() != bl) {
            this._between.setVisible(bl);
            this._valueWidth = 0;
            bl2 = true;
        }
        boolean bl3 = !this.isNull(n);
        Component component = this.getValueComponent();
        if (component.isVisible() != bl3) {
            component.setVisible(bl3);
            this._valueWidth = 0;
        }
        if (bl2) {
            ((Container)((Object)this)).invalidate();
        }
    }

    private String _getBetweenLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        return resourceBundle.getString(_AND_KEY);
    }

    private int _convertOperandToCondition(int n, boolean bl) {
        int n2 = -1;
        n2 = bl ? (n == 3 ? 3 : 4) : (n == 3 ? 1 : 2);
        return n2;
    }

    private DCConstant _getValue(DCComparisonExpression dCComparisonExpression) {
        DataConstraint dataConstraint = dCComparisonExpression.getConstraint(0);
        DataConstraint dataConstraint2 = dCComparisonExpression.getConstraint(1);
        if (dataConstraint instanceof DCConstant) {
            return (DCConstant)dataConstraint;
        }
        if (dataConstraint2 instanceof DCConstant) {
            return (DCConstant)dataConstraint2;
        }
        return null;
    }

    private class Dirty
    implements DocumentListener {
        private Dirty() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }
    }

    private class Choice
    extends JComboBox
    implements ItemListener {
        public Choice() {
            this.setEditable(false);
            this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                BaseConstraintComponent.this.updateLayout();
                BaseConstraintComponent.this.dataConstraintChanged();
                int n = this.getSelectedIndex();
                BaseConstraintComponent.this.testConditionChanged(BaseConstraintComponent.this.convertSelectionToCondition(n));
            }
        }
    }
}

