/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;

public abstract class ComparisonConstraintComp
extends BaseConstraintComponent {
    public static final int CONDITION_GREATER_THAN = 100;
    public static final int CONDITION_LESS_THAN = 101;
    public static final int CONDITION_GREATER_THAN_OR_EQUAL_TO = 102;
    public static final int CONDITION_LESS_THAN_OR_EQUAL_TO = 103;
    private static final String _GREATER_KEY = "GREATER";
    private static final String _LESS_KEY = "LESS";
    private static final String _GREATER_OR_EQUAL_KEY = "GREATER_OR_EQUAL";
    private static final String _LESS_OR_EQUAL_KEY = "LESS_OR_EQUAL";
    private static final int _GREATER_INDEX = 2;
    private static final int _LESS_INDEX = 3;
    private static final int _GREATER_OR_EQUAL_INDEX = 4;
    private static final int _LESS_OR_EQUAL_INDEX = 5;
    private static final int _STRING_COUNT = 4;

    public ComparisonConstraintComp() {
        this.setBetweenAllowed(true);
    }

    protected boolean isConditionValid(int n) {
        if (n == 100 || n == 101 || n == 102 || n == 103) {
            return true;
        }
        return super.isConditionValid(n);
    }

    protected int convertConditionToSelection(int n) {
        int n2 = -1;
        switch (n) {
            case 100: {
                n2 = 2;
                break;
            }
            case 101: {
                n2 = 3;
                break;
            }
            case 102: {
                n2 = 4;
                break;
            }
            case 103: {
                n2 = 5;
                break;
            }
            default: {
                n2 = super.convertConditionToSelection(n);
            }
        }
        return n2;
    }

    protected int convertSelectionToCondition(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 100;
                break;
            }
            case 3: {
                n2 = 101;
                break;
            }
            case 4: {
                n2 = 102;
                break;
            }
            case 5: {
                n2 = 103;
                break;
            }
            default: {
                n2 = super.convertSelectionToCondition(n);
            }
        }
        return n2;
    }

    protected int getBaseBetweenIndex() {
        return super.getBaseBetweenIndex() + 4;
    }

    protected int getBaseNullIndex() {
        return super.getBaseNullIndex() + 4;
    }

    protected int getItemCount() {
        return super.getItemCount() + 4;
    }

    protected String[] getChoiceValues(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String[] stringArray = super.getChoiceValues(locale);
        stringArray[2] = resourceBundle.getString(_GREATER_KEY);
        stringArray[3] = resourceBundle.getString(_LESS_KEY);
        stringArray[4] = resourceBundle.getString(_GREATER_OR_EQUAL_KEY);
        stringArray[5] = resourceBundle.getString(_LESS_OR_EQUAL_KEY);
        return stringArray;
    }

    protected DataConstraint getDataConstraint(DataDescriptor dataDescriptor, int n) {
        DataConstraint dataConstraint = null;
        DataConstraint dataConstraint2 = this.getValueDataConstraint(this.getValueComponent(), dataDescriptor, n);
        DataConstraint dataConstraint3 = this.getItemDataConstraint(dataDescriptor, n);
        switch (n) {
            case 100: {
                int n2 = 1;
                dataConstraint = new DCComparisonExpression(dataConstraint2, dataConstraint3, n2);
                break;
            }
            case 101: {
                int n3 = 2;
                dataConstraint = new DCComparisonExpression(dataConstraint2, dataConstraint3, n3);
                break;
            }
            case 102: {
                int n4 = 5;
                dataConstraint = new DCComparisonExpression(dataConstraint2, dataConstraint3, n4);
                break;
            }
            case 103: {
                int n5 = 6;
                dataConstraint = new DCComparisonExpression(dataConstraint2, dataConstraint3, n5);
                break;
            }
            default: {
                dataConstraint = super.getDataConstraint(dataDescriptor, n);
            }
        }
        return dataConstraint;
    }

    protected void parseConstraint(DataConstraint dataConstraint) {
        if (dataConstraint == null || !(dataConstraint instanceof DCComparisonExpression)) {
            super.parseConstraint(dataConstraint);
        } else {
            DCComparisonExpression dCComparisonExpression = (DCComparisonExpression)dataConstraint;
            int n = dCComparisonExpression.getOperand();
            if (n == 3 || n == 4) {
                super.parseConstraint(dataConstraint);
            } else {
                DCComparisonExpression dCComparisonExpression2 = (DCComparisonExpression)dataConstraint;
                int n2 = -1;
                switch (dCComparisonExpression2.getOperand()) {
                    case 1: {
                        n2 = 100;
                        break;
                    }
                    case 2: {
                        n2 = 101;
                        break;
                    }
                    case 5: {
                        n2 = 102;
                        break;
                    }
                    case 6: {
                        n2 = 103;
                    }
                }
                this.setTestCondition(n2);
                DCConstant dCConstant = this._getConstant(dCComparisonExpression2.getConstraint(0), dCComparisonExpression2.getConstraint(1));
                Object object = dCConstant == null ? null : dCConstant.getValue();
                this.initValueComponent(this.getValueComponent(), object);
            }
        }
    }

    protected int getNotCondition(int n) {
        switch (n) {
            case 100: {
                n = 103;
                break;
            }
            case 101: {
                n = 102;
                break;
            }
            case 102: {
                n = 101;
                break;
            }
            case 103: {
                n = 100;
                break;
            }
            default: {
                n = super.getNotCondition(n);
            }
        }
        return n;
    }

    private DCConstant _getConstant(DataConstraint dataConstraint, DataConstraint dataConstraint2) {
        if (dataConstraint instanceof DCConstant) {
            return (DCConstant)dataConstraint;
        }
        if (dataConstraint2 instanceof DCConstant) {
            return (DCConstant)dataConstraint2;
        }
        return null;
    }
}

