/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;

class JTextDropTarget {
    private static JTextDropTarget _sInstance;

    public static JTextDropTarget getJTextDropTarget() {
        if (_sInstance == null) {
            _sInstance = new JTextDropTarget();
        }
        return _sInstance;
    }

    public void addDropTarget(JTextComponent jTextComponent) {
        DropTarget dropTarget = new DropTarget((Component)jTextComponent, (DropTargetListener)new A(jTextComponent));
    }

    private JTextDropTarget() {
    }

    private class A
    implements DropTargetListener {
        private JTextComponent _text;

        public A(JTextComponent jTextComponent) {
            this._text = jTextComponent;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!this._acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this._text.setBackground(Color.lightGray);
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this._acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._text.setBackground(UIManager.getColor(LookAndFeel.TEXT));
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this._text.setBackground(UIManager.getColor(LookAndFeel.TEXT));
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            dropTargetDropEvent.acceptDrop(2);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = null;
            try {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (IOException iOException) {
                object = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            if (object != null) {
                String string = object.toString();
                this._text.replaceSelection(string);
            }
            dropTargetContext.dropComplete(object != null);
        }

        private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            if (dataFlavorArray == null) {
                return true;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (DataFlavor.stringFlavor.equals(dataFlavorArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

