/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.constraintComponent.MultiLayoutManager;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.datatransfer.TransferUtils;

public class MultiDescriptorComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    public static final String PROPERTY_DATA_DESCRIPTOR = "dataDescriptor";
    protected static final DataDescriptor EMPTY_DESCRIPTOR = new DataDescriptor(){
        static /* synthetic */ Class class$java$lang$Object;

        public String getName() {
            return MultiDescriptorComponent._sDEFAULT_VALUE;
        }

        public Class getDataType() {
            return class$java$lang$Object == null ? (class$java$lang$Object = 1.class$("java.lang.Object")) : class$java$lang$Object;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    };
    private static BorderPainter _sBorderPainter;
    private static final String _sDEFAULT_VALUE = "";
    private static final int _sNOT_QUALIFIED = 0;
    private static final int _sTABLE_QUALIFIED = 1;
    private static final int _sSCHEMA_QUALIFIED = 2;
    boolean _defaulted;
    private Color _background;
    private Color _foreground;
    JComboBox _item;
    private int _itemWidth;
    private PropertyChangeListener _propListen;
    private DataDescriptor _originalDescriptor;
    private DataDescriptor _selectedDescriptorAfterChange;
    private DataDescriptor _selectedDescriptor;
    private DataDescriptorProvider _provider;
    private ConstraintComponent _constraintComponent;
    private DataConstraint _oldValue;
    private boolean _ignoreSelectionChanges = false;
    private DataDescriptor _oldDescriptorValue;
    private int _qualificationLevel = 0;
    private boolean _isDescriptorListChanged;

    public MultiDescriptorComponent() {
        this(null);
    }

    public MultiDescriptorComponent(DataDescriptorProvider dataDescriptorProvider) {
        Item item = new Item();
        this._item = this.createDescriptorSelector();
        this._item.addItemListener(item);
        B b = new B();
        DropTarget dropTarget = new DropTarget((Component)this._item, (DropTargetListener)b);
        dropTarget = new DropTarget(this._item.getEditor().getEditorComponent(), (DropTargetListener)b);
        ((Container)((Object)this)).setLayout(new MultiLayoutManager());
        ((Container)((Object)this)).add("item", this._item);
        this._propListen = new Update();
        this._constraintComponent = this.getConstraintComponent(EMPTY_DESCRIPTOR);
        this._constraintComponent.addPropertyChangeListener(this._propListen);
        ((Container)((Object)this)).addPropertyChangeListener(new UpdateOnSelection());
        ((Container)((Object)this)).add("component", this._constraintComponent.getComponent());
        ((JComponent)((Object)this)).setBackground(UIManager.getColor("control"));
        this.setDataDescriptorProvider(dataDescriptorProvider);
    }

    public void setDataDescriptorProvider(DataDescriptorProvider dataDescriptorProvider) {
        if (this._provider != dataDescriptorProvider) {
            if (this._provider != null) {
                this._provider.removePropertyChangeListener(this._propListen);
            }
            this._provider = dataDescriptorProvider;
            if (this._provider != null) {
                this._provider.addPropertyChangeListener(this._propListen);
            }
            this.setItemWidth(0);
            this.setChoiceItems(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        }
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public void fireDataConstraintChange() {
        DataConstraint dataConstraint = this.getDataConstraint();
        ((Component)((Object)this)).firePropertyChange("dataConstraint", this._oldValue, dataConstraint);
        this._oldValue = dataConstraint;
    }

    public Component getComponent() {
        return this;
    }

    public DataConstraint getDataConstraint() {
        return this.getConstraintComponent().getDataConstraint();
    }

    public DataDescriptor getDataDescriptor() {
        return this._selectedDescriptor;
    }

    public void initState(DataDescriptor dataDescriptor, DataConstraint dataConstraint) {
        this._oldValue = dataConstraint;
        this._originalDescriptor = dataDescriptor;
        this._selectedDescriptor = dataDescriptor;
        this._initState(dataConstraint, LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setSelectedDescriptor(DataDescriptor dataDescriptor) {
        this._selectedDescriptor = dataDescriptor;
        this.selectedItemChanged();
    }

    public Dimension getMinimumSize() {
        return this._item.getMinimumSize();
    }

    public void requestFocus() {
        this._item.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._item.setEnabled(bl);
        this.getConstraintComponent().getComponent().setEnabled(bl);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        PaintContext paintContext = this.getPaintContext();
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new FixedBorderPainter(1, 0, 1, 1);
        }
        return _sBorderPainter;
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    protected ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    protected ConstraintComponent getConstraintComponent(DataDescriptor dataDescriptor) {
        return ConstraintCompFactory.getConstraintCompFactory().createConstraintComponent(null, dataDescriptor, null);
    }

    protected int getItemPreferredWidth() {
        return this._item.getPreferredSize().width;
    }

    protected void setItemWidth(int n) {
        if (this._itemWidth != n) {
            this._itemWidth = n;
            ((Container)((Object)this)).invalidate();
        }
    }

    protected int getItemWidth() {
        if (this._itemWidth == 0) {
            this._itemWidth = this.getItemPreferredWidth();
        }
        return this._itemWidth;
    }

    protected void selectedItemChanged() {
        if (this._ignoreSelectionChanges) {
            return;
        }
        DataDescriptor dataDescriptor = this._selectedDescriptor;
        DataDescriptor dataDescriptor2 = null;
        int n = this._item.getSelectedIndex();
        if (this._defaulted) {
            if (n == 0) {
                return;
            }
            --n;
        }
        if (this._provider != null && n >= 0) {
            int n2 = this._provider.getDescriptorCount();
            if (n < n2) {
                dataDescriptor2 = this._provider.getDescriptor(n);
            } else if (n == n2) {
                dataDescriptor2 = this._selectedDescriptorAfterChange != null ? this._selectedDescriptorAfterChange : this._originalDescriptor;
            } else if (n == n2 + 1) {
                dataDescriptor2 = this._originalDescriptor;
            }
        }
        if (dataDescriptor2 == null) {
            dataDescriptor2 = this._selectedDescriptor;
        }
        this._selectedDescriptor = dataDescriptor2;
        if (this._selectedDescriptor != null && this._defaulted) {
            if (!this._item.isEditable()) {
                this._item.removeItem(_sDEFAULT_VALUE);
            }
            this._defaulted = false;
        }
        this.selectedDescriptorChanged(dataDescriptor != this._selectedDescriptor);
        this.fireDataDescriptorChange();
    }

    protected void selectedDescriptorChanged(boolean bl) {
        ConstraintComponent constraintComponent;
        if (bl && (constraintComponent = this.getConstraintComponent(this._selectedDescriptor)) != this._constraintComponent) {
            this._constraintComponent.removePropertyChangeListener(this._propListen);
            ((Container)((Object)this)).remove(this._constraintComponent.getComponent());
            this._constraintComponent = constraintComponent;
            this._constraintComponent.addPropertyChangeListener(this._propListen);
            ((Container)((Object)this)).add("component", this._constraintComponent.getComponent());
            ((Container)((Object)this)).invalidate();
        }
    }

    protected void setChoiceItems(Locale locale) {
        Object object;
        this._ignoreSelectionChanges = true;
        DataDescriptor dataDescriptor = this._selectedDescriptor;
        Vector<String> vector = new Vector<String>(this._provider != null ? this._provider.getDescriptorCount() + 7 : 37);
        this._defaulted = false;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HashSet<String> hashSet = new HashSet<String>();
        String string = _sDEFAULT_VALUE;
        int n = 0;
        String string2 = this._selectedDescriptorAfterChange == null ? _sDEFAULT_VALUE : this._getQualifiedName(this._selectedDescriptorAfterChange, locale, 2);
        String string3 = this._originalDescriptor == null ? _sDEFAULT_VALUE : this._getQualifiedName(this._originalDescriptor, locale, 2);
        block0: do {
            String string4;
            hashSet.clear();
            vector.clear();
            bl4 = false;
            if (this._provider != null) {
                int n2 = 0;
                while (n2 < this._provider.getDescriptorCount()) {
                    object = this._provider.getDescriptor(n2);
                    string4 = this._getQualifiedName((DataDescriptor)object, locale, n);
                    if (n < 2) {
                        boolean bl5 = bl4 = !hashSet.add(string4);
                        if (bl4) {
                            ++n;
                            continue block0;
                        }
                    }
                    vector.addElement(string4);
                    String string5 = this._getQualifiedName((DataDescriptor)object, locale, 2);
                    if (string5.equals(string2)) {
                        bl = true;
                    }
                    if (string5.equals(string3)) {
                        bl2 = true;
                    }
                    ++n2;
                }
            }
            if (!bl && this._selectedDescriptorAfterChange != null) {
                string4 = this._getQualifiedName(this._selectedDescriptorAfterChange, locale, n);
                if (n < 2) {
                    boolean bl6 = bl4 = !hashSet.add(string4);
                    if (bl4) {
                        ++n;
                        continue;
                    }
                }
                vector.addElement(string4);
                bl3 = true;
            } else if (!bl2 && this._originalDescriptor != null) {
                string4 = this._getQualifiedName(this._originalDescriptor, locale, n);
                if (n < 2) {
                    boolean bl7 = bl4 = !hashSet.add(string4);
                    if (bl4) {
                        ++n;
                        continue;
                    }
                }
                vector.addElement(string4);
                bl3 = true;
            }
            if (this._selectedDescriptor == null) {
                this._selectedDescriptor = this._selectedDescriptorAfterChange;
            }
            if (this._selectedDescriptor != null) {
                string = string4 = this._getQualifiedName(this._selectedDescriptor, locale, n);
                continue;
            }
            if (this._item.isEditable()) continue;
            vector.insertElementAt(_sDEFAULT_VALUE, 0);
            this._defaulted = true;
        } while (bl4);
        this._qualificationLevel = n;
        this._isDescriptorListChanged = bl3;
        object = this.createComboBoxModel(vector);
        this._item.setModel(object);
        this._item.setSelectedItem(string);
        this.selectedDescriptorChanged(dataDescriptor != this._selectedDescriptor);
        this._ignoreSelectionChanges = false;
    }

    protected JComboBox createDescriptorSelector() {
        return new DescriptorCombo();
    }

    protected JComboBox getDescriptorSelector() {
        return this._item;
    }

    protected void fireDataDescriptorChange() {
        DataDescriptor dataDescriptor = this.getDataDescriptor();
        ((Component)((Object)this)).firePropertyChange(PROPERTY_DATA_DESCRIPTOR, this._oldDescriptorValue, dataDescriptor);
        this._oldDescriptorValue = dataDescriptor;
    }

    protected ComboBoxModel createComboBoxModel(Vector vector) {
        return new DefaultComboBoxModel(vector);
    }

    boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return true;
        }
        return TransferUtils.supportsDataFlavor((DataFlavor[])dataFlavorArray, (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
    }

    void dragEnter(Component component) {
        this._background = component.getBackground();
        this._foreground = component.getForeground();
        component.setBackground(this._foreground);
        component.setForeground(this._background);
    }

    void dragExit(Component component) {
        component.setForeground(this._foreground);
        component.setBackground(this._background);
    }

    void drop(Component component, DataDescriptor dataDescriptor) {
        String string = this._getQualifiedName(dataDescriptor, LocaleUtils.getDefaultableLocale((Component)((Object)this)), this._qualificationLevel);
        this._item.setSelectedItem(string);
        this.selectedItemChanged();
        this.fireDataConstraintChange();
    }

    void updateItems() {
        this._selectedDescriptorAfterChange = this._selectedDescriptor;
        this.setChoiceItems(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        this.setItemWidth(0);
    }

    private void _initState(DataConstraint dataConstraint, Locale locale) {
        if (dataConstraint == null) {
            this.selectedDescriptorChanged(true);
            this.setChoiceItems(locale);
            this._initConstraintComponent(dataConstraint);
            return;
        }
        DCVariable dCVariable = null;
        if (dataConstraint instanceof DCExpression) {
            DCExpression dCExpression = (DCExpression)dataConstraint;
            int n = dCExpression.getConstraintCount();
            int n2 = 0;
            while (n2 < n) {
                DataConstraint dataConstraint2 = dCExpression.getConstraint(n2);
                if (dataConstraint2 instanceof DCVariable) {
                    dCVariable = (DCVariable)dataConstraint2;
                    break;
                }
                ++n2;
            }
        }
        if (this._selectedDescriptor == null && dCVariable != null) {
            this._selectedDescriptor = this._findDescriptor(dCVariable.getVariable());
        }
        this.selectedDescriptorChanged(true);
        this.setChoiceItems(locale);
        this._initConstraintComponent(dataConstraint);
    }

    private void _initConstraintComponent(DataConstraint dataConstraint) {
        this._constraintComponent.initState(this._selectedDescriptor, dataConstraint);
    }

    private DataDescriptor _findDescriptor(Object object) {
        String string;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        String string2 = object instanceof Column ? this._getQualifiedName((Column)object, locale, 2) : (string = object instanceof String ? (String)object : null);
        if (this._originalDescriptor != null && this._getQualifiedName(this._originalDescriptor, locale, 2).equals(string)) {
            return this._originalDescriptor;
        }
        if (this._selectedDescriptorAfterChange != null && this._getQualifiedName(this._selectedDescriptorAfterChange, locale, 2).equals(string)) {
            return this._selectedDescriptorAfterChange;
        }
        if (this._provider != null) {
            int n = 0;
            while (n < this._provider.getDescriptorCount()) {
                DataDescriptor dataDescriptor = this._provider.getDescriptor(n);
                if (this._getQualifiedName(dataDescriptor, locale, 2).equals(string)) {
                    return dataDescriptor;
                }
                ++n;
            }
        }
        return null;
    }

    private String _getQualifiedName(DataDescriptor dataDescriptor, Locale locale, int n) {
        Column column;
        Column column2 = column = dataDescriptor instanceof Column ? (Column)dataDescriptor : null;
        if (column == null || n == 0) {
            return dataDescriptor.getDisplayName(locale);
        }
        switch (n) {
            case 1: {
                return column.getTable().getDisplayName(locale) + "." + column.getDisplayName(locale);
            }
            case 2: {
                return column.getTable().getSchema().getDisplayName(locale) + "." + column.getTable().getDisplayName(locale) + "." + column.getDisplayName(locale);
            }
        }
        return dataDescriptor.getDisplayName(locale);
    }

    private class UpdateOnSelection
    implements PropertyChangeListener {
        private UpdateOnSelection() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (MultiDescriptorComponent.PROPERTY_DATA_DESCRIPTOR.equals(propertyChangeEvent.getPropertyName()) && MultiDescriptorComponent.this._isDescriptorListChanged) {
                MultiDescriptorComponent.this.updateItems();
            }
        }
    }

    private class Update
    implements PropertyChangeListener {
        private Update() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("dataConstraint".equals(string)) {
                MultiDescriptorComponent.this.fireDataConstraintChange();
            } else if ("descriptorCount".equals(string) || "descriptorChanged".equals(string)) {
                MultiDescriptorComponent.this.updateItems();
            }
        }
    }

    private class B
    implements DropTargetListener {
        private B() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (MultiDescriptorComponent.this.acceptDrag(dropTargetDragEvent)) {
                MultiDescriptorComponent.this.dragEnter(dropTargetDragEvent.getDropTargetContext().getComponent());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!MultiDescriptorComponent.this.acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            MultiDescriptorComponent.this.dragExit(dropTargetEvent.getDropTargetContext().getComponent());
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            MultiDescriptorComponent.this.dragExit(component);
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            dropTargetDropEvent.acceptDrop(2);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                Object object = transferable.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
                if (object instanceof DataDescriptor) {
                    dropTargetContext.dropComplete(true);
                    MultiDescriptorComponent.this.drop(component, (DataDescriptor)object);
                } else {
                    dropTargetContext.dropComplete(false);
                }
            }
            catch (Exception exception) {
                dropTargetContext.dropComplete(false);
            }
        }
    }

    private class Item
    implements ItemListener {
        private Item() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == MultiDescriptorComponent.this._item) {
                MultiDescriptorComponent.this.selectedItemChanged();
            }
            if (!MultiDescriptorComponent.this._ignoreSelectionChanges) {
                MultiDescriptorComponent.this.fireDataConstraintChange();
            }
        }
    }

    public class DescriptorCombo
    extends JComboBox {
        public DescriptorCombo() {
            this.setEditable(false);
        }

        public void setPopupVisible(boolean bl) {
            if (MultiDescriptorComponent.this._defaulted && bl) {
                if (!MultiDescriptorComponent.this._item.isEditable()) {
                    this.removeItem(MultiDescriptorComponent._sDEFAULT_VALUE);
                }
                MultiDescriptorComponent.this._defaulted = false;
            }
            super.setPopupVisible(bl);
        }
    }
}

