/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.event.DynamicTableListener;
import oracle.bali.share.event.ListenerManager;

public abstract class DynamicTable
extends Table {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    private PropertyChangeSupport _support;
    private ListenerManager _listener;

    public abstract void setName(String var1);

    public abstract void addColumn(Column var1, int var2);

    public abstract void removeColumn(Column var1);

    public abstract void addForeignKey(Relationship var1, int var2);

    public abstract void removeForeignKey(Relationship var1);

    public abstract void addUniqueKey(Column var1, int var2);

    public abstract void removeUniqueKey(Column var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addTableListener(DynamicTableListener dynamicTableListener) {
        if (this._listener == null) {
            this._listener = new ListenerManager();
        }
        this._listener.addListener((EventListener)dynamicTableListener);
    }

    public void removeTableListener(DynamicTableListener dynamicTableListener) {
        if (this._listener != null) {
            this._listener.removeListener((EventListener)dynamicTableListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    protected void fireTableEvent(int n, Column column, int n2) {
        DynamicTableEvent dynamicTableEvent = new DynamicTableEvent(this, n, column, n2);
        this.processTableEvent(dynamicTableEvent);
    }

    protected void fireTableEvent(int n, Relationship relationship, int n2) {
        DynamicTableEvent dynamicTableEvent = new DynamicTableEvent(this, n, relationship, n2);
        this.processTableEvent(dynamicTableEvent);
    }

    protected void processTableEvent(DynamicTableEvent dynamicTableEvent) {
        if (this._listener == null) {
            return;
        }
        Enumeration enumeration = this._listener.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (dynamicTableEvent.getID()) {
            case 100: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).columnAdded(dynamicTableEvent);
                }
                break;
            }
            case 101: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).columnRemoved(dynamicTableEvent);
                }
                break;
            }
            case 102: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).primaryKeyAdded(dynamicTableEvent);
                }
                break;
            }
            case 103: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).primaryKeyRemoved(dynamicTableEvent);
                }
                break;
            }
            case 104: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).foreignKeyAdded(dynamicTableEvent);
                }
                break;
            }
            case 105: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).foreignKeyRemoved(dynamicTableEvent);
                }
                break;
            }
            case 106: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).uniqueKeyAdded(dynamicTableEvent);
                }
                break;
            }
            case 107: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicTableListener)enumeration.nextElement()).uniqueKeyRemoved(dynamicTableEvent);
                }
                break;
            }
        }
    }
}

