/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db.impl;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;

public final class RelationshipImpl
extends Relationship {
    private Column[] _children;
    private Column[] _referenced;
    private String _name;
    private int _type;

    public RelationshipImpl(Column column, Column column2, String string) {
        this(column, column2, string, 0);
    }

    public RelationshipImpl(Column column, Column column2, String string, int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        this._children = new Column[1];
        this._children[0] = column;
        this._referenced = new Column[1];
        this._referenced[0] = column2;
        this._name = string;
        this._type = n;
    }

    public RelationshipImpl(Column[] columnArray, Column[] columnArray2, String string) {
        this(columnArray, columnArray2, string, 0);
    }

    public RelationshipImpl(Column[] columnArray, Column[] columnArray2, String string, int n) {
        if (columnArray == null || columnArray.length == 0) {
            throw new IllegalArgumentException("children is empty");
        }
        if (columnArray2 == null || columnArray2.length == 0) {
            throw new IllegalArgumentException("referenced is empty");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        this._children = new Column[columnArray.length];
        System.arraycopy(columnArray, 0, this._children, 0, columnArray.length);
        this._referenced = new Column[columnArray2.length];
        System.arraycopy(columnArray2, 0, this._referenced, 0, columnArray2.length);
        this._name = string;
        this._type = n;
    }

    public int getColumnCount() {
        return this._children.length;
    }

    public Column getColumn(int n) {
        return this._children[n];
    }

    public Column getReferencedColumn(int n) {
        return this._referenced[n];
    }

    public String getName() {
        return this._name;
    }

    public int getRelationshipType() {
        return this._type;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String toString() {
        return "Relationship: " + this.getName();
    }
}

