/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import oracle.bali.dbUI.graph.Data;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeDataSource;
import oracle.bali.dbUI.graph.Port;

final class ChildNodeDataSource
extends Data {
    private Node _node;
    private int _portCount;
    private int[] _indicies;
    private boolean _expanded = true;
    private NodeDataSource _parent;
    private Data[] _children;
    private Data[] _sortedChildren;

    public ChildNodeDataSource(NodeDataSource nodeDataSource, Node node, int n) {
        super(node, nodeDataSource.getLocale(), n);
        this._parent = nodeDataSource;
        this.setNode(node);
    }

    public void dispose() {
        super.dispose();
        if (this._node == null) {
            return;
        }
        this._node = null;
        this._indicies = null;
        this._parent = null;
        this._children = null;
        this._sortedChildren = null;
    }

    public Node getNode() {
        return this._node;
    }

    public Port getPort(int n) {
        if (this._indicies != null) {
            n = this._indicies[n];
        }
        return this.getNode().getPort(n);
    }

    public void setNode(Node node) {
        this._node = node;
        this._portCount = NodeDataSource.getPortCount(node);
        this._calculateIndicies();
    }

    public void setSortedChildren(Data[] dataArray) {
        if (this.isExpanded()) {
            this._sortedChildren = dataArray;
        } else {
            this._children = dataArray;
        }
    }

    public Data[] getSortedChildren() {
        return this._sortedChildren;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean bl, Data[] dataArray) {
        this._expanded = bl;
        this._children = dataArray;
    }

    public Data[] getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this.getPortCount() > 0;
    }

    public int getPortCount() {
        return this._portCount;
    }

    public void updatePortCount(int n) {
        this._portCount += n;
    }

    private void _calculateIndicies() {
        this._indicies = this._parent.__calculateSortedIndicies(this.getNode());
    }
}

