/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Cursor;
import java.util.Vector;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.EdgeImpl;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.Port;

public class DefaultEdgeFactory
implements EdgeFactory {
    private static EdgeFactory _sEdgeFactory;

    public static EdgeFactory getEdgeFactory() {
        if (_sEdgeFactory == null) {
            _sEdgeFactory = new DefaultEdgeFactory();
        }
        return _sEdgeFactory;
    }

    public boolean isEdgeValid(Port port, Port port2) {
        if (port == null || port2 == null) {
            return false;
        }
        return port.isSourceable() && port2.isTargetable();
    }

    public Edge createEdge(Port port, Port port2) {
        if (port == null || port2 == null) {
            return null;
        }
        return new EdgeImpl(port, port2);
    }

    public Cursor getCursor(Port port, Port port2) {
        return this.isEdgeValid(port, port2) ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
    }

    public Port[] getTargetablePorts(Port port, Node node) {
        Vector<Port> vector = new Vector<Port>();
        int n = node.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            Port port2 = node.getPort(n2);
            if (this.isEdgeValid(port, port2)) {
                vector.addElement(port2);
            }
            ++n2;
        }
        int n3 = vector.size();
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray = new Port[n3];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected DefaultEdgeFactory() {
    }
}

