/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.dbUI.graph.ClassComparator;
import oracle.bali.dbUI.graph.Graph;
import oracle.bali.dbUI.graph.GridFocusPainter;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeAutoScroller;
import oracle.bali.dbUI.graph.NodeDataSource;
import oracle.bali.dbUI.graph.NodeToolTipClient;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.PortAppearanceProvider;
import oracle.bali.dbUI.graph.PortComparator;
import oracle.bali.dbUI.graph.SortInputHandler;
import oracle.bali.dbUI.graph.scrolling.ScrollArea;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.grid.AbstractAppearanceManager;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.BooleanComparator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;

public class NodeComponent
extends LWComponent
implements Accessible {
    public static final String PROPERTY_PORT_LOCATION = "portLocation";
    public static final String PROPERTY_PORT_SELECTION_COUNT = "portSelectionCount";
    public static final String PROPERTY_NODE_EXPANDED = "nodeExpanded";
    public static final String PROPERTY_SORTED_COLUMN = "sortedColumn";
    public static final String COMMAND_PORT_DOUBLE_CLICK = "NodeComponent.portDoubleClick";
    public static final String COMMAND_PORT_SINGLE_CLICK = "NodeComponent.portSingleClick";
    public static final int COLUMN_TARGETABLE = 1;
    public static final int COLUMN_KEY = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_DATATYPE = 4;
    public static final int COLUMN_SOURCEABLE = 5;
    public static final int DEFAULT_COLUMN_COUNT = 6;
    private static Image _sIMAGE_KEY = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/key.gif");
    private static Image _sIMAGE_SOURCEABLE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/port_sourceable.gif");
    private static Image _sIMAGE_TARGETABLE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/port_targetable.gif");
    private static Image _sIMAGE_SOURCED = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/port_sourced.gif");
    private static Image _sIMAGE_TARGETED = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/port_targeted.gif");
    private static Image _sIMAGE_NUMBER;
    private static Image _sIMAGE_DATE;
    private static Image _sIMAGE_STRING;
    private static Image _sIMAGE_NODE_SOURCEABLE;
    private static Image _sIMAGE_NODE_TARGETABLE;
    private static Image _sIMAGE_NODE_SOURCED;
    private static Image _sIMAGE_NODE_TARGETED;
    private static Icon _sIMAGE_EXPANDED;
    private static Icon _sIMAGE_COLLAPSED;
    private static final String _GRAPH_BUNDLE = "oracle.bali.dbUI.resource.GraphBundle";
    private static final String _KEY_KEY = "NODECOMPONENT.KEY";
    private static final String _KEY_TARGETABLE = "NODECOMPONENT.TARGETABLE";
    private static final String _KEY_SOURCEABLE = "NODECOMPONENT.SOURCEABLE";
    private static final String _KEY_DATATYPE = "NODECOMPONENT.DATATYPE";
    private static final String _KEY_COLUMN_NAME = "NODECOMPONENT.COLUMN_NAME";
    private static final String _KEY_KEY_DESC = "NODECOMPONENT.KEY_DESC";
    private static final String _KEY_TARGETABLE_DESC = "NODECOMPONENT.TARGETABLE_DESC";
    private static final String _KEY_SOURCEABLE_DESC = "NODECOMPONENT.SOURCEABLE_DESC";
    private static final String _KEY_DATATYPE_DESC = "NODECOMPONENT.DATATYPE_DESC";
    private static final String _KEY_COLUMN_NAME_DESC = "NODECOMPONENT.COLUMN_NAME_DESC";
    private static final String _KEY_S_P = "NODECOMPONENT.S_P";
    private static final String _KEY_S = "NODECOMPONENT.S";
    private static final String _KEY_P = "NODECOMPONENT.P";
    private static final String _KEY_NONE = "NODECOMPONENT.NONE";
    private static final int _DEFAULT_NAME_WIDTH = 150;
    private static final int _IMAGE_WIDTH = 18;
    private static final int _SOURCEABLE_IMAGE_WIDTH = 20;
    static final int _HIDDEN_COLUMN = 0;
    private SpreadTable _spreadTable;
    private ScrollArea _scrollBox;
    private Node _node;
    private Cell _focusCell;
    private Listener _listener = new Listener();
    private PortAppearanceProvider _portAppearanceProvider;
    private Port _targetPort;
    private Graph _graph;
    private SortInputHandler _sorter;
    private ListenerManager _actionListeners;
    private boolean _createMode = false;
    private Hashtable _expansionCache;
    static /* synthetic */ Class class$oracle$bali$dbUI$graph$NodeComponent;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;

    public NodeComponent() {
        this(null);
    }

    public NodeComponent(Node node) {
        this(node, null);
    }

    public NodeComponent(Node node, Graph graph) {
        DBUILookAndFeel dBUILookAndFeel = DBUILookAndFeel.getLookAndFeel();
        NodeDataSource nodeDataSource = new NodeDataSource(this);
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(6);
        this._spreadTable = new _Table((TwoDModel)nodeDataSource, (OneDModel)arrayOneDModel, null);
        this._spreadTable.setColumnHeaderHeight(10);
        Header header = this._spreadTable.getColumnHeader();
        header.setCanMoveItems(false);
        header.setCanResizeItems(false);
        SortInputHandler sortInputHandler = new SortInputHandler(nodeDataSource);
        header.setHeaderKeyHandler((HeaderKeyHandler)sortInputHandler);
        header.setItemInputHandler((HeaderItemInputHandler)sortInputHandler);
        this._sorter = sortInputHandler;
        Grid grid = this._spreadTable.getGrid();
        grid.setAppearanceManager((AppearanceManager)new AM());
        grid.setVerticalSeparatorsVisible(false);
        GridSelectionManager gridSelectionManager = GeneralGridSelectionManager.createSingleRowSelectionManager();
        grid.setGridSelectionManager(gridSelectionManager);
        grid.addPropertyChangeListener(this._listener);
        grid.setFill(dBUILookAndFeel.getBackgroundPainter((JComponent)((Object)this)));
        grid.setDefaultInputHandler((CellInputHandler)new Handler(null));
        grid.setToolTipManager((GridToolTipManager)new NodeToolTipClient());
        this._spreadTable.setColumnVisible(0, false);
        this._spreadTable.setBorder(null);
        FixedAlignmentPainter fixedAlignmentPainter = new FixedAlignmentPainter((Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(1, 18);
        grid.setColumnPainter(1, (Painter)fixedAlignmentPainter);
        this._spreadTable.setColumnWidth(2, 18);
        grid.setColumnPainter(2, (Painter)fixedAlignmentPainter);
        this._spreadTable.setColumnWidth(3, 150);
        this._spreadTable.setColumnWidth(4, 18);
        grid.setColumnPainter(4, (Painter)fixedAlignmentPainter);
        this._spreadTable.setColumnWidth(5, 20);
        grid.setColumnPainter(5, (Painter)fixedAlignmentPainter);
        this._scrollBox = new ScrollArea(this._spreadTable);
        this._scrollBox.addVAdjustmentListener(this._listener);
        ((Container)((Object)this)).setLayout((LayoutManager)new MaximumBorderLayout());
        ((Container)((Object)this)).add("Center", (Component)((Object)this._scrollBox));
        this.setNode(node);
        this.setGraph(graph);
        this.updateUI(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent);
        this.getSpreadTable().setBorder(null);
        this.getSpreadTable().getGrid().setBorder(null);
        this.getSpreadTable().getGrid().setOverlayBorderVisible(false);
        this.getSpreadTable().getColumnHeader().setFirstEdge(false);
        this.getSpreadTable().getColumnHeader().setBorder(null);
    }

    public void setCreateMode(boolean bl) {
        if (this._createMode != bl) {
            this._createMode = bl;
            NodeDataSource nodeDataSource = this._getDataSource();
            if (bl) {
                nodeDataSource.setNode(null);
            } else {
                nodeDataSource.setNode(this.getNode());
                if (this._expansionCache != null) {
                    Enumeration enumeration = this._expansionCache.keys();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            Node node = (Node)enumeration.nextElement();
                            Object v = this._expansionCache.get(node);
                            boolean bl2 = Boolean.TRUE.equals(v);
                            nodeDataSource.setNodeExpanded(node, bl2);
                        }
                    }
                    this._expansionCache.clear();
                }
                this._expansionCache = null;
                this.__invalidate();
                this.__updateUI();
                this.locationChanged();
            }
        }
    }

    public boolean isCreateMode() {
        return this._createMode;
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        Node node2 = this._node;
        if (node != node2) {
            this._node = node;
            if (!this.isCreateMode()) {
                this._getDataSource().setNode(this._node);
                this.__updateUI();
            }
        }
    }

    public Graph getGraph() {
        return this._graph;
    }

    public void setGraph(Graph graph) {
        Graph graph2 = this._graph;
        if (graph != graph2) {
            if (graph2 != null) {
                graph2.removePropertyChangeListener(this._listener);
            }
            this._graph = graph;
            if (this._graph != null) {
                this._graph.addPropertyChangeListener(this._listener);
            }
            this.__updateUI();
        }
    }

    public void setDropTargetPort(Port port) {
        if (this._targetPort != port) {
            Grid grid = this._getGrid();
            Port port2 = this._targetPort;
            this._targetPort = null;
            if (port2 != null) {
                grid.paintRow(this.getPortIndex(port2));
            }
            if (port != null) {
                int n = this.getPortIndex(port);
                if (port.isTargetable()) {
                    this._targetPort = port;
                    if (this._targetPort != null) {
                        grid.paintRow(n);
                    }
                }
            }
            this.autoScroll(port);
        } else if (this._targetPort != null) {
            this.autoScroll(this._targetPort);
        }
    }

    public Port getDropTargetPort() {
        return this._targetPort;
    }

    public void autoScroll(Port port) {
        this._checkScroller(this.getPortIndex(port));
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)actionListener);
        }
    }

    public int getPortLocation(Port port) {
        Node node;
        int n = this._getPortIndex(port);
        if (n == -1) {
            node = port.getParent();
            while (node != this.getNode() && node != null) {
                if (!this.isNodeExpanded(node) && (n = this._getPortIndex(node)) != -1) break;
                node = node.getParent();
            }
            if (n == -1) {
                return -1;
            }
        }
        node = this._getGrid();
        int n2 = node.getRowPosition(n) + this._getGridOffset();
        Point point = node.getCanvasOrigin();
        Dimension dimension = ((Component)((Object)this)).getSize();
        if ((n2 += point.y) < 0) {
            n2 = 0;
        } else if (dimension.height < 0) {
            n2 = 0;
        } else if (n2 >= dimension.height) {
            n2 = dimension.height;
        } else if ((n2 += node.getRowHeight(n) / 2) > dimension.height) {
            n2 = dimension.height;
        }
        return n2;
    }

    public Port getPortAt(int n) {
        Grid grid = this._getGrid();
        int n2 = this._getGridOffset();
        if (n < n2) {
            return null;
        }
        int n3 = grid.getCanvasOriginY();
        n -= n3 + n2;
        n3 = -n3;
        int n4 = grid.getInnerHeight();
        if (n < n3 || n > n3 + n4) {
            return null;
        }
        int n5 = grid.getRowAt(n);
        if (n5 == -1) {
            return null;
        }
        return this.getPort(n5);
    }

    public Port getPort(int n) {
        TwoDModel twoDModel = this._getGrid().getModel();
        if (n < 0 || n >= twoDModel.getRowCount()) {
            return null;
        }
        return (Port)twoDModel.getData(0, n);
    }

    public int getPortIndex(Port port) {
        if (port == null) {
            return -1;
        }
        return this._getPortIndex(port);
    }

    public SpreadTable getSpreadTable() {
        return this._spreadTable;
    }

    public PortAppearanceProvider getPortAppearanceProvider() {
        return this._portAppearanceProvider;
    }

    public void setPortAppearanceProvider(PortAppearanceProvider portAppearanceProvider) {
        if (this._portAppearanceProvider != portAppearanceProvider) {
            this._portAppearanceProvider = portAppearanceProvider;
            ((Component)((Object)this)).repaint();
        }
    }

    public int getSelectedPortCount() {
        OneDSelection oneDSelection = this._getGrid().getSelection().getRowSelection();
        return oneDSelection.getSelectedItemCount();
    }

    public Port getSelectedPort(int n) {
        OneDSelection oneDSelection = this._getGrid().getSelection().getRowSelection();
        int n2 = oneDSelection.getSelectedItemAtIndex(n);
        if (n2 < 0 || n2 >= oneDSelection.getSelectedItemCount()) {
            return null;
        }
        return this.getPort(n2);
    }

    public Port[] getSelectedPorts() {
        OneDSelection oneDSelection = this._getGrid().getSelection().getRowSelection();
        int n = oneDSelection.getSelectedItemCount();
        Port[] portArray = null;
        if (n != 0) {
            portArray = new Port[n];
            int n2 = 0;
            while (n2 < n) {
                portArray[n2] = this.getPort(oneDSelection.getSelectedItemAtIndex(n2));
                ++n2;
            }
        }
        return portArray;
    }

    public boolean isPortSelected(Port port) {
        int n = this.getPortIndex(port);
        return n == -1 ? false : this._getGrid().getSelection().containsRow(n);
    }

    public void setPortSelected(Port port, boolean bl) {
        int n = this.getPortIndex(port);
        if (n != -1) {
            TwoDSelection twoDSelection = this._getGrid().getSelection();
            twoDSelection = bl ? (twoDSelection.isEmpty() ? new TwoDSelection(n, true) : twoDSelection.addRows(n, 1)) : twoDSelection.removeRows(n, 1);
            try {
                this._getGrid().setSelection(twoDSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean isNodeExpanded(Node node) {
        if (node == null) {
            return false;
        }
        if (this.isCreateMode()) {
            if (this._expansionCache == null) {
                return false;
            }
            Object v = this._expansionCache.get(node);
            if (v == null) {
                return true;
            }
            return Boolean.TRUE.equals(v);
        }
        NodeDataSource nodeDataSource = this._getDataSource();
        return nodeDataSource.isNodeExpanded(node);
    }

    public void setNodeExpanded(Node node, boolean bl) {
        if (node != null) {
            if (this.isCreateMode()) {
                if (this._expansionCache == null) {
                    this._expansionCache = new Hashtable();
                }
                this._expansionCache.put(node, new Boolean(bl));
            } else {
                NodeDataSource nodeDataSource = this._getDataSource();
                nodeDataSource.setNodeExpanded(node, bl);
            }
        }
    }

    public int getSortedColumn() {
        return this._sorter.getLastColumn();
    }

    public boolean isSortAscending() {
        int n = this.getSortedColumn();
        return n == -1 ? false : !this._sorter.getColumnAscending(n);
    }

    public void setSortedColumn(int n, boolean bl) {
        this._sorter.sort(n, bl);
    }

    public Dimension getMaximumSize() {
        return ((JComponent)((Object)this)).getPreferredSize();
    }

    public void requestFocus() {
        this._getGrid().requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        bl = ((Component)((Object)this)).isEnabled();
        this._scrollBox.setEnabled(bl);
        this._spreadTable.setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new Access();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        int n = actionEvent.getID();
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumeration = this._actionListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 1001: {
                while (enumeration.hasMoreElements()) {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
                }
                break;
            }
        }
    }

    protected void updateUI(Class clazz) {
        if (clazz == (class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent)) {
            this.updateUI();
        }
    }

    static Comparator __getComparator(int n, boolean bl, Locale locale) {
        Comparator comparator = null;
        switch (n) {
            case 1: 
            case 2: 
            case 5: {
                comparator = BooleanComparator.getComparator();
                break;
            }
            case 3: {
                comparator = new StringComparator(Collator.getInstance(locale));
                break;
            }
            case 4: {
                comparator = new ClassComparator();
            }
        }
        return new PortComparator(comparator, n, bl, locale);
    }

    void locationChanged() {
        this.__firePropertyChanged(PROPERTY_PORT_LOCATION, Boolean.FALSE, Boolean.TRUE);
    }

    void __firePortSelection(int n, boolean bl) {
        Port port = this.getPort(n);
        if (port != null) {
            Port port2;
            Port port3;
            if (bl) {
                port3 = null;
                port2 = port;
            } else {
                port2 = null;
                port3 = port;
            }
            this.__firePropertyChanged(PROPERTY_PORT_SELECTION_COUNT, port3, port2);
        }
    }

    void __fireActionEvent(Object object, String string, int n) {
        this.processEvent(new ActionEvent(object, 1001, string, n));
    }

    void __portRemoved(Port port) {
        int n = this.getPortIndex(port);
        if (n != -1 && this._getGrid().getSelection().containsRow(n)) {
            TwoDSelection twoDSelection = this._getGrid().getSelection();
            twoDSelection.removeRows(n, 1);
            try {
                this._getGrid().setSelection(twoDSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.__firePropertyChanged(PROPERTY_PORT_SELECTION_COUNT, port, null);
        }
    }

    void __fireExpansionChanged(Node node, boolean bl) {
        Node node2;
        Node node3;
        this.__invalidate();
        if (bl) {
            node3 = null;
            node2 = node;
        } else {
            node2 = null;
            node3 = node;
        }
        this.__firePropertyChanged(PROPERTY_NODE_EXPANDED, node3, node2);
    }

    void __firePropertyChanged(String string, Object object, Object object2) {
        ((Component)((Object)this)).firePropertyChange(string, object, object2);
    }

    void __invalidate() {
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this._scrollBox)).invalidate();
    }

    NodeDataSource _getDataSource() {
        return (NodeDataSource)this._getGrid().getModel();
    }

    void __updateUI() {
        this.freezeRepaints();
        try {
            Grid grid = this.getSpreadTable().getGrid();
            if (this._getDataSource().isHGrid()) {
                HGridHandler hGridHandler = new HGridHandler();
                hGridHandler.setExpandedIcon(_sIMAGE_EXPANDED);
                hGridHandler.setCollapsedIcon(_sIMAGE_COLLAPSED);
                hGridHandler.setIndentWidth(9);
                grid.setColumnPainter(3, (Painter)hGridHandler);
                grid.setColumnCellInputHandler(3, (CellInputHandler)new Handler((CellInputHandler)hGridHandler));
            } else {
                HGridHandler hGridHandler = new HGridHandler();
                hGridHandler.setExpandedIcon(null);
                hGridHandler.setCollapsedIcon(null);
                hGridHandler.setIndentWidth(0);
                grid.setColumnPainter(3, (Painter)hGridHandler);
                grid.setColumnCellInputHandler(3, (CellInputHandler)new Handler(null));
            }
            this.__invalidate();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    private void _checkScroller(int n) {
        Grid grid = this._getGrid();
        int n2 = grid.getFirstRowOnScreen();
        int n3 = n2 + grid.getOnScreenRowCount() - 1;
        if (n == n2) {
            NodeAutoScroller.getAutoScroller().schedule(this, true);
        } else if (n == n3) {
            NodeAutoScroller.getAutoScroller().schedule(this, false);
        } else {
            NodeAutoScroller.getAutoScroller().cancel(this);
        }
    }

    private int _getGridOffset() {
        Container container = this._getGrid().getParent();
        int n = 0;
        while (container != this) {
            n += container.getLocation().y;
            container = container.getParent();
        }
        return n;
    }

    private Grid _getGrid() {
        return this.getSpreadTable().getGrid();
    }

    private int _getPortIndex(Port port) {
        if (port == null) {
            return -1;
        }
        return this._getDataSource().getPortIndex(port);
    }

    private int _getNameColumnPrefSize() {
        int n = 0;
        Grid grid = this.getSpreadTable().getGrid();
        Painter painter = grid.getColumnPainter(3);
        AppearanceManager appearanceManager = grid.getAppearanceManager();
        int n2 = 0;
        while (n2 < grid.getRowCount()) {
            ImmInsets immInsets;
            int n3 = 0;
            PaintContext paintContext = grid.getCellPaintContext(3, n2);
            Dimension dimension = painter.getPreferredSize(paintContext);
            Appearance appearance = appearanceManager.getCellPaintingAppearance(3, n2);
            BorderPainter borderPainter = appearance.getBorderPainter();
            if (borderPainter != null) {
                immInsets = borderPainter.getInsets(paintContext);
                n3 += immInsets.left + immInsets.right;
            }
            immInsets = appearance.getInsets();
            dimension.width += (n3 += immInsets.left + immInsets.right);
            if (dimension.width > n) {
                n = dimension.width;
            }
            ++n2;
        }
        return n;
    }

    private void _recalculateNameColumn(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this._getNameColumnPrefSize();
        Grid grid = this.getSpreadTable().getGrid();
        if (grid.isColumnVisible(1)) {
            n -= 18;
        }
        if (grid.isColumnVisible(5)) {
            n -= 20;
        }
        if (grid.isColumnVisible(2)) {
            n -= 18;
        }
        if (grid.isColumnVisible(4)) {
            n -= 18;
        }
        if (n2 > n && n > 0) {
            n2 = n;
        } else if (n2 < n) {
            n2 = n;
        }
        this.getSpreadTable().setColumnWidth(3, n2);
    }

    private void _showMenu(Grid grid, int n, int n2, int n3, int n4) {
        if (this.getGraph() != null) {
            Point point = this._translatePoint(grid, n, n2, n3, n4);
            this.getGraph().showMenuForPort(this.getPort(n2), this, point.x, point.y);
        }
    }

    private Point _translatePoint(Grid grid, int n, int n2, int n3, int n4) {
        Point point = grid.getCanvasOrigin();
        n3 += grid.getColumnPosition(n);
        n4 += grid.getRowPosition(n2);
        Object object = grid;
        while (object != this) {
            Point point2 = object.getLocation();
            n3 += point2.x;
            n4 += point2.y;
            object = object.getParent();
        }
        return new Point(n3, n4);
    }

    private static boolean _isPopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return true;
        }
        return (mouseEvent.getModifiers() & 0x10) == 0;
    }

    protected Image getSourceableImage(Port port) {
        return port instanceof Node ? _sIMAGE_NODE_SOURCEABLE : _sIMAGE_SOURCEABLE;
    }

    protected Image getTargetableImage(Port port) {
        return port instanceof Node ? _sIMAGE_NODE_TARGETABLE : _sIMAGE_TARGETABLE;
    }

    protected Image getSourcedImage(Port port) {
        return _sIMAGE_SOURCED;
    }

    protected Image getTargetedImage(Port port) {
        return _sIMAGE_TARGETED;
    }

    protected Image getKeyImage(Port port) {
        return _sIMAGE_KEY;
    }

    protected Image getDataTypeImage(Port port, Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NodeComponent.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NodeComponent.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE || clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NodeComponent.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = NodeComponent.class$("java.math.BigInteger")) : class$java$math$BigInteger) || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NodeComponent.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NodeComponent.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NodeComponent.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE || clazz == (class$java$lang$Number == null ? (class$java$lang$Number = NodeComponent.class$("java.lang.Number")) : class$java$lang$Number) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NodeComponent.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
            return _sIMAGE_NUMBER;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NodeComponent.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = NodeComponent.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = NodeComponent.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Character.TYPE) {
            return _sIMAGE_STRING;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = NodeComponent.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            return _sIMAGE_DATE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sIMAGE_NODE_SOURCEABLE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/group_source.gif");
        _sIMAGE_NODE_TARGETABLE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/group_target.gif");
        _sIMAGE_STRING = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/data_string.gif");
        _sIMAGE_NUMBER = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/data_number.gif");
        _sIMAGE_DATE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/data_date.gif");
        _sIMAGE_EXPANDED = new ImageIcon(ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/group_collapse.gif"));
        _sIMAGE_COLLAPSED = new ImageIcon(ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$NodeComponent == null ? (class$oracle$bali$dbUI$graph$NodeComponent = NodeComponent.class$("oracle.bali.dbUI.graph.NodeComponent")) : class$oracle$bali$dbUI$graph$NodeComponent), (String)"/oracle/bali/dbUI/graph/images/group_expand.gif"));
    }

    private class Listener
    implements AdjustmentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            NodeComponent.this.locationChanged();
        }

        public void rowScrolled(GridEvent gridEvent) {
            NodeComponent.this.locationChanged();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("edgeCount".equals(string)) {
                ((Component)((Object)NodeComponent.this)).repaint();
            } else if ("selection".equals(string)) {
                int n;
                TwoDSelection twoDSelection = (TwoDSelection)object;
                TwoDSelection twoDSelection2 = (TwoDSelection)object2;
                int n2 = twoDSelection.getSingleRow();
                if (n2 != -1) {
                    NodeComponent.this.__firePortSelection(n2, false);
                }
                if ((n = twoDSelection2.getSingleRow()) != -1) {
                    NodeComponent.this.__firePortSelection(n, true);
                }
            }
        }
    }

    private class Handler
    extends ProxyInputHandler {
        public Handler(CellInputHandler cellInputHandler) {
            if (cellInputHandler == null) {
                cellInputHandler = NullInputHandler.getCellInputHandler();
            }
            this.setDefaultCellInputHandler(cellInputHandler);
        }

        public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (grid.isEnabled() && NodeComponent._isPopupTrigger(mouseEvent)) {
                TwoDSelection twoDSelection = new TwoDSelection(n2, true);
                try {
                    grid.setSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                grid.requestFocus(n, n2, (AWTEvent)mouseEvent);
                mouseEvent.consume();
            }
            super.mousePressed(mouseEvent, grid, n, n2);
        }

        public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (grid.isEnabled() && NodeComponent._isPopupTrigger(mouseEvent)) {
                NodeComponent.this._showMenu(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
            super.mouseReleased(mouseEvent, grid, n, n2);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            super.keyPressed(keyEvent, grid, n, n2);
            if (!keyEvent.isConsumed() && grid.isEnabled() && keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
                NodeComponent.this._showMenu(grid, n, n2, grid.getSize().width / 2, grid.getRowHeight(n2) * 2 / 3);
                keyEvent.consume();
            }
        }
    }

    private class _Table
    extends SpreadTable {
        _Table(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
            super(twoDModel, oneDModel, oneDModel2);
        }

        protected Grid createGrid(TwoDModel twoDModel) {
            return new _Grid(twoDModel);
        }

        protected Header createColumnHeader(OneDModel oneDModel) {
            return new _Header(oneDModel);
        }

        private class _Header
        extends Header {
            public _Header(OneDModel oneDModel) {
                super(oneDModel);
            }

            protected int getPaintState() {
                return super.getPaintState() | 4;
            }

            protected Header.AccessibleHeader createAccessibleHeader() {
                return new AHeader();
            }

            private class AHeader
            extends Header.AccessibleHeader {
                public AHeader() {
                    super((Header)_Header.this);
                }

                public String getAccessibleName(int n) {
                    String string = null;
                    String string2 = null;
                    switch (n) {
                        case 2: {
                            string = NodeComponent._KEY_KEY;
                            break;
                        }
                        case 3: {
                            string = NodeComponent._KEY_COLUMN_NAME;
                            break;
                        }
                        case 1: {
                            string = NodeComponent._KEY_TARGETABLE;
                            break;
                        }
                        case 4: {
                            string = NodeComponent._KEY_DATATYPE;
                            break;
                        }
                        case 5: {
                            string = NodeComponent._KEY_SOURCEABLE;
                            break;
                        }
                        default: {
                            string2 = super.getAccessibleName(n);
                        }
                    }
                    if (string != null) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                        string2 = resourceBundle.getString(string);
                    }
                    return string2;
                }

                public String getAccessibleDescription(int n) {
                    String string = null;
                    String string2 = null;
                    switch (n) {
                        case 2: {
                            string2 = NodeComponent._KEY_KEY_DESC;
                            break;
                        }
                        case 3: {
                            string2 = NodeComponent._KEY_COLUMN_NAME_DESC;
                            break;
                        }
                        case 1: {
                            string2 = NodeComponent._KEY_TARGETABLE_DESC;
                            break;
                        }
                        case 4: {
                            string2 = NodeComponent._KEY_DATATYPE_DESC;
                            break;
                        }
                        case 5: {
                            string2 = NodeComponent._KEY_SOURCEABLE_DESC;
                            break;
                        }
                        default: {
                            string = super.getAccessibleDescription(n);
                        }
                    }
                    if (string2 != null) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                        string = resourceBundle.getString(string2);
                    }
                    return string;
                }
            }
        }

        private class _Grid
        extends Grid {
            public _Grid(TwoDModel twoDModel) {
                super(twoDModel);
            }

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            protected Grid.AccessibleGrid createAccessibleGrid() {
                return new AGrid();
            }

            protected void processFocusEvent(FocusEvent focusEvent) {
                if (focusEvent.getID() == 1004 && this.getFocusCell() != null && this.getFocusCell().column != -1 && this.getFocusCell().column != 3 && this.getFocusCell().row >= this.getRowCount()) {
                    super.requestFocus(3, 0, null);
                }
                super.processFocusEvent(focusEvent);
            }

            public boolean requestFocus(int n, int n2, AWTEvent aWTEvent) {
                return super.requestFocus(3, n2, aWTEvent);
            }

            protected void paintFocusCell(PaintContext paintContext, Graphics graphics) {
                Cell cell = this.getFocusCell();
                if (this.getDrawFocusCellHighlite() && cell != null && this.isColumnOnScreen(cell.column) && this.isRowOnScreen(cell.row) && ((Component)((Object)this)).hasFocus()) {
                    int n = this.getColumnPosition(cell.column) + 1;
                    int n2 = this.getRowPosition(cell.row) + 1;
                    int n3 = this.getColumnWidth(cell.column) - 2;
                    int n4 = this.getRowHeight(cell.row) - 2;
                    paintContext = this.getCellPaintContext(cell.column, cell.row);
                    Painter painter = GridFocusPainter.getPainter();
                    painter.paint(paintContext, graphics, n, n2, n3, n4);
                }
            }

            public void reshape(int n, int n2, int n3, int n4) {
                int n5 = ((JComponent)((Object)this)).getHeight();
                super.reshape(n, n2, n3, n4);
                if (!NodeComponent.this.isCreateMode()) {
                    if (n5 == 0 || n4 != n5) {
                        NodeComponent.this.locationChanged();
                    }
                    NodeComponent.this._recalculateNameColumn(this.getInnerWidth());
                }
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                if (((Component)((Object)this)).isEnabled() && mouseEvent.getID() == 500 && !NodeComponent._isPopupTrigger(mouseEvent)) {
                    Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
                    int n = this.getRowAt(point.y);
                    Port port = NodeComponent.this.getPort(n);
                    if (port != null) {
                        if (mouseEvent.getClickCount() == 1) {
                            NodeComponent.this.__fireActionEvent(port, NodeComponent.COMMAND_PORT_SINGLE_CLICK, mouseEvent.getModifiers());
                        } else if (mouseEvent.getClickCount() % 2 == 0) {
                            NodeComponent.this.__fireActionEvent(port, NodeComponent.COMMAND_PORT_DOUBLE_CLICK, mouseEvent.getModifiers());
                        }
                    }
                }
            }

            public Dimension getPreferredSize() {
                int n = 0;
                int n2 = this.getRowCount() * this.getDefaultRowHeight();
                if (this.getHorizontalSeparatorsVisible()) {
                    Painter painter = this.getHorizontalSeparatorPainter();
                    int n3 = painter.getMinimumSize((PaintContext)this.getPaintContext()).height;
                    n2 += (this.getRowCount() - 1) * n3;
                }
                if (this.isColumnVisible(1)) {
                    n += 18;
                }
                if (this.isColumnVisible(5)) {
                    n += 20;
                }
                if (this.isColumnVisible(2)) {
                    n += 18;
                }
                if (this.isColumnVisible(4)) {
                    n += 18;
                }
                return new Dimension(n += NodeComponent.this._getNameColumnPrefSize(), n2);
            }

            private class AGrid
            extends Grid.AccessibleGrid {
                public AGrid() {
                    super((Grid)_Grid.this);
                }

                protected String getAccessibleName(int n, int n2, Object object) {
                    Class clazz;
                    String string;
                    int n3;
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(NodeComponent._GRAPH_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                    Port port = NodeComponent.this.getPort(n2);
                    boolean bl = false;
                    TwoDModel twoDModel = _Table.this.getGrid().getModel();
                    boolean bl2 = twoDModel.getData(2, n2) != null;
                    Object object2 = twoDModel.getData(3, n2);
                    if (object2 instanceof HDataObject) {
                        object2 = ((HDataObject)object2).getData();
                    }
                    if ((n3 = (string = (clazz = port.getDataType()) == null ? " null " : clazz.toString()).lastIndexOf(".")) != -1) {
                        string = string.substring(n3 + 1);
                    }
                    String string2 = object2 + "";
                    String string3 = this._getKey(bl, bl2);
                    String string4 = resourceBundle.getString(string3);
                    MessageFormat messageFormat = new MessageFormat(string4);
                    Object[] objectArray = new Object[]{object2, string};
                    string2 = messageFormat.format(objectArray);
                    return string2;
                }

                private String _getKey(boolean bl, boolean bl2) {
                    String string = null;
                    string = bl ? (bl2 ? NodeComponent._KEY_S_P : NodeComponent._KEY_S) : (bl2 ? NodeComponent._KEY_P : NodeComponent._KEY_NONE);
                    return string;
                }
            }
        }
    }

    private class AM
    extends AbstractAppearanceManager {
        private Appearance _imageDropAppearance;
        private Appearance _dropAppearance;
        private Appearance _appearance = (Appearance)UIManager.get("Grid.DefaultAppearance");
        private Appearance _imageAppearance;

        public Appearance getCellPaintingAppearance(int n, int n2) {
            Port port = NodeComponent.this.getPort(n2);
            if (port == NodeComponent.this.getDropTargetPort()) {
                return this._getDropAppearance(n);
            }
            if (NodeComponent.this.getPortAppearanceProvider() == null) {
                return this._getAppearance(n);
            }
            Appearance appearance = NodeComponent.this.getPortAppearanceProvider().getPortAppearance(port, this._appearance);
            return appearance == null || appearance == this._appearance ? this._getAppearance(n) : appearance;
        }

        private Appearance _getAppearance(int n) {
            Appearance appearance = this._appearance;
            if (n != 3) {
                if (this._imageAppearance == null) {
                    this._imageAppearance = this._appearance.copy();
                    this._imageAppearance.setInsets(ImmInsets.getEmptyInsets());
                }
                appearance = this._imageAppearance;
            }
            return appearance;
        }

        private void _createDropAppearance() {
            this._dropAppearance = this._appearance.copy();
            Color color = NodeComponent.this.getSpreadTable().getGrid().getUIDefaults().getColor("controlDkShadow");
            this._dropAppearance.setBackground(color);
            this._dropAppearance.setSelectBackground(color);
            this._dropAppearance.setForeground(Color.white);
            this._dropAppearance.setSelectForeground(Color.white);
        }

        private Appearance _getDropAppearance(int n) {
            if (this._dropAppearance == null) {
                this._createDropAppearance();
            }
            Appearance appearance = this._dropAppearance;
            if (n != 3) {
                if (this._imageDropAppearance == null) {
                    this._imageDropAppearance = this._dropAppearance.copy();
                    this._imageDropAppearance.setInsets(ImmInsets.getEmptyInsets());
                }
                appearance = this._imageDropAppearance;
            }
            return appearance;
        }
    }

    private class HGridHandler
    extends HCellHandler {
        private HGridHandler() {
        }

        protected boolean isBackgroundUsed() {
            return false;
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super((JComponent)((Object)NodeComponent.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

