/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import oracle.bali.dbUI.graph.ChildNodeDataSource;
import oracle.bali.dbUI.graph.Data;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.hGrid.HTwoDModel;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

class NodeDataSource
extends AbstractTwoDModel
implements HTwoDModel,
Sortable {
    private Node _node;
    private Data[] _hdata;
    private int _rowCount;
    private int _sortedColumn = -1;
    private boolean _ascending = false;
    private NodeComponent _component;
    private Listener _listener;
    private boolean _subNodesFound;
    static /* synthetic */ Class class$oracle$bali$dbUI$graph$ChildNodeDataSource;

    public static final int getPortCount(Node node) {
        if (node == null) {
            return 0;
        }
        int n = 0;
        int n2 = node.getPortCount();
        int n3 = 0;
        while (n3 < n2) {
            ++n;
            Port port = node.getPort(n3);
            if (port instanceof Node) {
                n += NodeDataSource.getPortCount((Node)port);
            }
            ++n3;
        }
        return n;
    }

    public NodeDataSource(NodeComponent nodeComponent) {
        this._component = nodeComponent;
        this._listener = new Listener();
    }

    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)((Object)this.getComponent()));
    }

    public void dispose() {
        if (this._node != null) {
            this._removePortListeners(this._node);
        }
        this._node = null;
        int n = this._hdata == null ? 0 : this._hdata.length;
        int n2 = 0;
        while (n2 < n) {
            this._hdata[n2].dispose();
            this._hdata[n2] = null;
            ++n2;
        }
        this._hdata = null;
    }

    public NodeComponent getComponent() {
        return this._component;
    }

    public boolean isHGrid() {
        return this._subNodesFound;
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isNodeExpanded(Node node) {
        int n = this.getPortIndex(node);
        if (n == -1) {
            return false;
        }
        ChildNodeDataSource childNodeDataSource = (ChildNodeDataSource)this._hdata[n];
        return childNodeDataSource.isExpanded();
    }

    public void setNodeExpanded(Node node, boolean bl) {
        int n = this.getPortIndex(node);
        if (n != -1) {
            if (bl) {
                this.expandRow(3, n);
            } else {
                this.collapseRow(3, n);
            }
        }
    }

    public int getPortIndex(Port port) {
        return NodeDataSource._getPortIndex(port, this._hdata, 0);
    }

    public void setNode(Node node) {
        if (this._node == node) {
            return;
        }
        int n = this.getRowCount();
        if (n != 0) {
            this.fireModelEvent(2005, 0, n);
        }
        this.dispose();
        this._node = node;
        if (this._node != null) {
            this._addPortListeners(this._node);
        }
        int n2 = NodeDataSource.getPortCount(this._node);
        this._hdata = new Data[n2];
        Object var5_4 = null;
        int n3 = node == null ? 0 : node.getPortCount();
        boolean bl = false;
        int n4 = 0;
        Locale locale = this.getLocale();
        int[] nArray = this.__calculateSortedIndicies(this.getNode());
        if (nArray == null) {
            int n5 = 0;
            while (n5 < n3) {
                Port port = node.getPort(n5);
                if (port instanceof Node) {
                    Node node2 = (Node)port;
                    n4 = this._addNode(node2, this._hdata, n4, 1, locale);
                    bl = true;
                } else {
                    this._hdata[n4] = new Data(port, locale, 0);
                    ++n4;
                }
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n6];
                Port port = node.getPort(n7);
                if (port instanceof Node) {
                    Node node3 = (Node)port;
                    n4 = this._addNode(node3, this._hdata, n4, 1, locale);
                    bl = true;
                } else {
                    this._hdata[n4] = new Data(port, locale, 0);
                    ++n4;
                }
                ++n6;
            }
        }
        this._subNodesFound = bl;
        this._rowCount = n2;
        if (n2 != 0) {
            this.fireModelEvent(2004, 0, n2);
        }
    }

    public void sort(int n, boolean bl) {
        this._sortedColumn = n;
        this._ascending = bl;
        this._hdata = this._sortNode(this.getNode(), this._hdata);
        if (this._rowCount != 0) {
            this.fireModelEvent(2006, 0, this._rowCount);
        }
        this.getComponent().locationChanged();
        this.getComponent().__firePropertyChanged("sortedColumn", IntegerUtils.getInteger((int)-1), IntegerUtils.getInteger((int)n));
    }

    public void expandRow(int n, int n2) {
        Data[] dataArray = this._hdata;
        Data data = dataArray[n2];
        if (data.getClass() != (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? (class$oracle$bali$dbUI$graph$ChildNodeDataSource = NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource")) : class$oracle$bali$dbUI$graph$ChildNodeDataSource)) {
            return;
        }
        ChildNodeDataSource childNodeDataSource = (ChildNodeDataSource)data;
        if (childNodeDataSource.isExpanded()) {
            return;
        }
        int n3 = dataArray.length;
        Data[] dataArray2 = childNodeDataSource.getChildren();
        int n4 = dataArray2.length;
        int n5 = n3 + n4;
        Data[] dataArray3 = new Data[n5];
        childNodeDataSource.setExpanded(true, null);
        System.arraycopy(dataArray, 0, dataArray3, 0, n2 + 1);
        System.arraycopy(dataArray2, 0, dataArray3, n2 + 1, n4);
        int n6 = n3 - (n2 + 1);
        System.arraycopy(dataArray, n2 + 1, dataArray3, n2 + 1 + n4, n6);
        this._hdata = dataArray3;
        this._rowCount = this._hdata.length;
        Grid grid = this.getComponent().getSpreadTable().getGrid();
        this.fireModelEvent(2004, n2 + 1, n4);
        grid.requestFocus(3, n2, null);
        this.getComponent().__fireExpansionChanged(childNodeDataSource.getNode(), true);
        this.getComponent().locationChanged();
    }

    public void collapseRow(int n, int n2) {
        Data[] dataArray = this._hdata;
        Data data = dataArray[n2];
        if (data.getClass() != (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? (class$oracle$bali$dbUI$graph$ChildNodeDataSource = NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource")) : class$oracle$bali$dbUI$graph$ChildNodeDataSource)) {
            return;
        }
        ChildNodeDataSource childNodeDataSource = (ChildNodeDataSource)data;
        if (!childNodeDataSource.isExpanded()) {
            return;
        }
        int n3 = n2 + 1;
        int n4 = this._getChildCount(childNodeDataSource, this._hdata, n3);
        Data[] dataArray2 = new Data[n4];
        System.arraycopy(this._hdata, n3, dataArray2, 0, n4);
        childNodeDataSource.setExpanded(false, dataArray2);
        int n5 = dataArray.length;
        int n6 = n5 - n4;
        Data[] dataArray3 = new Data[n6];
        System.arraycopy(dataArray, 0, dataArray3, 0, n2 + 1);
        int n7 = n5 - n3 - n4;
        System.arraycopy(dataArray, n3 + n4, dataArray3, n2 + 1, n7);
        this._hdata = dataArray3;
        this._rowCount = this._hdata.length;
        Grid grid = this.getComponent().getSpreadTable().getGrid();
        this.fireModelEvent(2005, n2 + 1, n4);
        grid.requestFocus(3, n2, null);
        this.getComponent().__fireExpansionChanged(childNodeDataSource.getNode(), false);
        this.getComponent().locationChanged();
    }

    public int getColumnCount() {
        return 6;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void setData(int n, int n2, Object object) {
    }

    public Object getData(int n, int n2) {
        if (this._node == null) {
            return null;
        }
        if (n2 >= this._rowCount) {
            return null;
        }
        Data data = this._hdata[n2];
        Port port = data.getPort();
        switch (n) {
            case 0: {
                return port;
            }
            case 1: {
                return port.isTargetable() ? (this._isTargeted(port) ? this.getComponent().getTargetedImage(port) : this.getComponent().getTargetableImage(port)) : null;
            }
            case 2: {
                return port.isKey() ? this.getComponent().getKeyImage(port) : null;
            }
            case 3: {
                return data;
            }
            case 4: {
                return this.getComponent().getDataTypeImage(port, port.getDataType());
            }
            case 5: {
                return port.isSourceable() ? (this._isSourced(port) ? this.getComponent().getSourcedImage(port) : this.getComponent().getSourceableImage(port)) : null;
            }
        }
        return null;
    }

    void repaintRows(int n, int n2) {
        if (n2 != 0) {
            this.fireModelEvent(2006, n, n2);
        }
    }

    int[] __calculateSortedIndicies(Node node) {
        if (this._sortedColumn == -1 || node == null) {
            return null;
        }
        int n = node.getPortCount();
        Object[] objectArray = new Port[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = node.getPort(n2);
            ++n2;
        }
        Comparator comparator = NodeComponent.__getComparator(this._sortedColumn, this._ascending, this.getLocale());
        return Sort.indirectQSort((Object[])objectArray, (int)n, (Comparator)comparator);
    }

    int[] __calculateSortedIndicies(Data[] dataArray) {
        if (this._sortedColumn == -1) {
            int[] nArray = new int[dataArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            return nArray;
        }
        int n = dataArray.length;
        Object[] objectArray = new Port[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = dataArray[n2].getPort();
            ++n2;
        }
        Comparator comparator = NodeComponent.__getComparator(this._sortedColumn, this._ascending, this.getLocale());
        return Sort.indirectQSort((Object[])objectArray, (int)n, (Comparator)comparator);
    }

    private static int _getPortIndex(Port port, Data[] dataArray, int n) {
        int n2 = n;
        while (n2 < dataArray.length) {
            if (dataArray[n2].getPort().equals(port)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void _updateBaseNode(int n, Port port) {
        int n2 = this._hdata.length;
        this._hdata = this._getUpdatedArray(n, port, this._hdata, 0);
        int n3 = this._hdata.length;
        this._subNodesFound = this._findSubNode();
        this._rowCount += n3 - n2;
        if (n3 > n2) {
            int n4 = n3 - n2;
            this.fireModelEvent(2004, n4, n4);
        } else {
            this.fireModelEvent(2005, 0, n2 - n3);
        }
        this.getComponent().__updateUI();
    }

    private void _updateNode(Node node, int n, Port port) {
        if (node == this.getNode()) {
            this._updateBaseNode(n, port);
            return;
        }
        int n2 = this.getPortIndex(node);
        if (n2 != -1) {
            ChildNodeDataSource childNodeDataSource = (ChildNodeDataSource)this._hdata[n2];
            childNodeDataSource.updatePortCount(n);
            if (childNodeDataSource.isExpanded()) {
                int n3 = n2 + 1;
                int n4 = this._getChildCount(childNodeDataSource, this._hdata, n3);
                Data[] dataArray = new Data[n4];
                System.arraycopy(this._hdata, n3, dataArray, 0, n4);
                Data[] dataArray2 = this._getUpdatedArray(n, port, dataArray, childNodeDataSource.getDepth() + 1);
                int n5 = dataArray2.length;
                int n6 = this._hdata.length;
                int n7 = n5 - n4;
                Data[] dataArray3 = new Data[n6 + n7];
                System.arraycopy(this._hdata, 0, dataArray3, 0, n3);
                System.arraycopy(dataArray2, 0, dataArray3, n3, n5);
                System.arraycopy(this._hdata, n3 + n4, dataArray3, n3 + n5, n6 - (n3 + n4));
                this._hdata = dataArray3;
                this._rowCount += n7;
                if (n7 > 0) {
                    this.fireModelEvent(2004, n2 + n4, n7);
                } else if (n7 < 0) {
                    this.fireModelEvent(2005, n2 + n4, -n7);
                }
            } else {
                Data[] dataArray = childNodeDataSource.getChildren();
                Data[] dataArray4 = this._getUpdatedArray(n, port, dataArray, childNodeDataSource.getDepth() + 1);
                childNodeDataSource.setExpanded(false, dataArray4);
            }
        }
    }

    private Data[] _getUpdatedArray(int n, Port port, Data[] dataArray, int n2) {
        Data[] dataArray2 = null;
        if (n < 0) {
            int n3;
            int n4;
            int n5 = NodeDataSource._getPortIndex(port, dataArray, 0);
            if (n5 == -1) {
                return dataArray;
            }
            Data data = dataArray[n5];
            if (data.getClass() == (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? (class$oracle$bali$dbUI$graph$ChildNodeDataSource = NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource")) : class$oracle$bali$dbUI$graph$ChildNodeDataSource)) {
                ChildNodeDataSource childNodeDataSource = (ChildNodeDataSource)data;
                n4 = this._getChildCount(childNodeDataSource, dataArray, n5 + 1) + 1;
            } else {
                n4 = 1;
            }
            data.dispose();
            int n6 = dataArray.length;
            dataArray2 = new Data[n6 - n4];
            if (n5 != 0) {
                System.arraycopy(dataArray, 0, dataArray2, 0, n5);
            }
            if ((n3 = n5 + n4) != n6) {
                System.arraycopy(dataArray, n3, dataArray2, n5, n6 - n3);
            }
        } else if (n > 0) {
            if (port instanceof Node) {
                Node node = (Node)port;
                int n7 = NodeDataSource.getPortCount(node) + 1;
                Data[] dataArray3 = new Data[n7];
                int n8 = this._addNode(node, dataArray3, 0, n2, this.getLocale());
                int n9 = dataArray.length;
                dataArray2 = new Data[n9 + n7];
                System.arraycopy(dataArray, 0, dataArray2, 0, n9);
                System.arraycopy(dataArray3, 0, dataArray2, n9, n7);
            } else {
                Data data = new Data(port, this.getLocale(), n2);
                int n10 = dataArray.length;
                dataArray2 = new Data[n10 + 1];
                System.arraycopy(dataArray, 0, dataArray2, 0, n10);
                dataArray2[n10] = data;
            }
        }
        return dataArray2;
    }

    private boolean _findSubNode() {
        int n = 0;
        while (n < this._hdata.length) {
            if (this._hdata[n].getClass() == (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource") : class$oracle$bali$dbUI$graph$ChildNodeDataSource)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int _addNode(Node node, Data[] dataArray, int n, int n2, Locale locale) {
        ChildNodeDataSource childNodeDataSource = new ChildNodeDataSource(this, node, n2);
        dataArray[n] = childNodeDataSource;
        ++n;
        int n3 = node.getPortCount();
        int n4 = 0;
        while (n4 < n3) {
            Port port = childNodeDataSource.getPort(n4);
            if (port instanceof Node) {
                n = this._addNode((Node)port, dataArray, n, n2 + 1, locale);
            } else {
                dataArray[n] = new Data(port, locale, n2 + 1);
                ++n;
            }
            ++n4;
        }
        return n;
    }

    private Data[] _sortNode(Node node, Data[] dataArray) {
        int n;
        Object object;
        int n2 = node == null ? 0 : node.getPortCount();
        Data[] dataArray2 = new Data[n2];
        int n3 = dataArray == null ? 0 : dataArray.length;
        Data[] dataArray3 = new Data[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            dataArray2[n4++] = dataArray[n5];
            if (dataArray[n5].getClass() == (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource") : class$oracle$bali$dbUI$graph$ChildNodeDataSource)) {
                object = (ChildNodeDataSource)dataArray[n5];
                if (((ChildNodeDataSource)object).isExpanded()) {
                    n = this._getChildCount((ChildNodeDataSource)object, dataArray, n5 + 1);
                    Data[] dataArray4 = new Data[n];
                    System.arraycopy(dataArray, n5 + 1, dataArray4, 0, n);
                    ((ChildNodeDataSource)object).setSortedChildren(this._sortNode(((ChildNodeDataSource)object).getNode(), dataArray4));
                    n5 += n;
                } else {
                    ((ChildNodeDataSource)object).setSortedChildren(this._sortNode(((ChildNodeDataSource)object).getNode(), ((ChildNodeDataSource)object).getChildren()));
                }
            }
            ++n5;
        }
        object = this.__calculateSortedIndicies(dataArray2);
        n = 0;
        int n6 = 0;
        while (n6 < n2) {
            ChildNodeDataSource childNodeDataSource;
            int n7 = object[n6];
            Data data = dataArray2[n7];
            dataArray3[n++] = data;
            if (data.getClass() == (class$oracle$bali$dbUI$graph$ChildNodeDataSource == null ? NodeDataSource.class$("oracle.bali.dbUI.graph.ChildNodeDataSource") : class$oracle$bali$dbUI$graph$ChildNodeDataSource) && (childNodeDataSource = (ChildNodeDataSource)data).isExpanded()) {
                Data[] dataArray5 = childNodeDataSource.getSortedChildren();
                int n8 = 0;
                while (n8 < dataArray5.length) {
                    dataArray3[n++] = dataArray5[n8];
                    ++n8;
                }
                childNodeDataSource.setSortedChildren(null);
            }
            ++n6;
        }
        return dataArray3;
    }

    private int _getChildCount(ChildNodeDataSource childNodeDataSource, Data[] dataArray, int n) {
        int n2 = 0;
        Node node = childNodeDataSource.getNode();
        int n3 = n;
        while (n3 < dataArray.length) {
            if (!this._isAncestor(node, dataArray[n3].getPort())) break;
            ++n2;
            ++n3;
        }
        return n2;
    }

    private boolean _isAncestor(Node node, Port port) {
        if (port == null) {
            return false;
        }
        if (port == node) {
            return true;
        }
        return this._isAncestor(node, port.getParent());
    }

    private void _addPortListeners(Port port) {
        port.addPropertyChangeListener(this._listener);
        if (port instanceof Node) {
            Node node = (Node)port;
            int n = node.getPortCount();
            int n2 = 0;
            while (n2 < n) {
                this._addPortListeners(node.getPort(n2));
                ++n2;
            }
        }
    }

    private void _removePortListeners(Port port) {
        port.removePropertyChangeListener(this._listener);
        if (port instanceof Node) {
            Node node = (Node)port;
            int n = node.getPortCount();
            int n2 = 0;
            while (n2 < n) {
                this._removePortListeners(node.getPort(n2));
                ++n2;
            }
        }
    }

    private boolean _isSourced(Port port) {
        return this.getComponent().getGraph() == null ? false : this.getComponent().getGraph().isSource(port);
    }

    private boolean _isTargeted(Port port) {
        return this.getComponent().getGraph() == null ? false : this.getComponent().getGraph().isTarget(port);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Port port;
            if (NodeDataSource.this._component.isCreateMode()) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("portCount".equals(string)) {
                Port port2;
                int n;
                if (object == null) {
                    NodeDataSource.this._addPortListeners((Port)object2);
                } else if (object2 == null) {
                    NodeDataSource.this._removePortListeners((Port)object);
                }
                if (object == null) {
                    n = 1;
                    port2 = (Port)object2;
                } else {
                    n = -1;
                    port2 = (Port)object;
                }
                if (n < 0) {
                    NodeDataSource.this.getComponent().__portRemoved(port2);
                }
                Node node = (Node)propertyChangeEvent.getSource();
                NodeDataSource.this._updateNode(node, n, port2);
                NodeDataSource.this.getComponent().__invalidate();
            } else if (("targetable".equals(string) || "sourceable".equals(string) || "key".equals(string) || "dataType".equals(string) || "displayName".equals(string)) && (port = (Port)propertyChangeEvent.getSource()) != NodeDataSource.this._node) {
                int n = NodeDataSource.this.getPortIndex(port);
                if ("displayName".equals(string)) {
                    Data data = NodeDataSource.this._hdata[n];
                    data.updateData(NodeDataSource.this.getLocale());
                }
                NodeDataSource.this.repaintRows(n, 1);
            }
        }
    }
}

