/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.Sortable;

class SortInputHandler
extends StandardHeaderKeyHandler
implements HeaderItemInputHandler {
    private Sortable _ds;
    private int _item = -1;
    private boolean _inside;
    private boolean[] _order;
    private int _lastColumn = -1;

    public SortInputHandler(Sortable sortable) {
        this._ds = sortable;
        this._order = new boolean[6];
    }

    public void handleKeyEvent(Header header, KeyEvent keyEvent) {
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
            this.sort(header.getFocusItem());
        }
        super.handleKeyEvent(header, keyEvent);
    }

    public void sort(int n) {
        this.sort(n, this._order[n]);
    }

    public void sort(int n, boolean bl) {
        this._lastColumn = n;
        this._ds.sort(n, bl);
        this._order[n] = !bl;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public boolean getColumnAscending(int n) {
        return this._order[n];
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        this._inside = true;
        this._item = n;
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        if (this._item == -1) {
            return;
        }
        if (this._inside && this._item == n) {
            this.sort(n);
        }
        this._item = -1;
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        this._inside = n == this._item;
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        this._inside = n != this._item;
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
    }
}

