/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.NodeGlassPane;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.item.AccessibleLayoutItem;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.jle.tool.SelectionTool;

class EdgeLinkItem
extends LinkItem
implements PropertyChangeListener {
    private static final String _KEY_NAME = "EDGE.NAMED_LINK";
    private static final String _KEY_NONAME = "EDGE.UNNAMED_LINK";
    private PortLinkPort _source;
    private PortLinkPort _target;
    private Edge _edge;

    public EdgeLinkItem(PortLinkPort portLinkPort, PortLinkPort portLinkPort2, Edge edge) {
        this.enableJLEEvents(16L);
        this._source = portLinkPort;
        this._target = portLinkPort2;
        this._edge = edge;
        this.putProperty(NodeGlassPane.TOOLTIP_KEY, edge.getToolTipText());
        this._edge.addPropertyChangeListener(this);
    }

    public void setItemParent(LayoutItem layoutItem) {
        super.setItemParent(layoutItem);
        LinkPortListener[] linkPortListenerArray = this._source.getLinkPortListeners();
        if (linkPortListenerArray == null || linkPortListenerArray.length == 0) {
            this._source.addLinkPortListener((LinkPortListener)this);
            this._target.addLinkPortListener((LinkPortListener)this);
        }
    }

    public Edge getEdge() {
        return this._edge;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setPorts(LinkPort[] linkPortArray) {
        throw new IllegalArgumentException("ports must be set in constructor");
    }

    public LinkPort[] getPorts() {
        LinkPort[] linkPortArray = new LinkPort[]{this._source, this._target};
        return linkPortArray;
    }

    public int getPortCount() {
        return 2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("toolTipText".equals(propertyChangeEvent.getPropertyName())) {
            this.putProperty(NodeGlassPane.TOOLTIP_KEY, propertyChangeEvent.getNewValue());
        }
    }

    protected LinkPort[] updatePorts(LinkPort linkPort) {
        this.updateBounds();
        return this.getPorts();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLink();
    }

    protected void processMouseEvent(JLEEvent jLEEvent) {
        if ((jLEEvent.getID() == 501 || jLEEvent.getID() == 502) && GraphCanvas.__isPopupTrigger(jLEEvent)) {
            if (this.hitTest(jLEEvent.getX(), jLEEvent.getY())) {
                JLECanvas jLECanvas;
                if (jLEEvent.getID() == 502 && (jLECanvas = this.getCanvas()) instanceof GraphCanvas) {
                    ((GraphCanvas)jLECanvas).__showMenuForEdge(this.getEdge(), (LayoutItem)this, jLEEvent.getX(), jLEEvent.getY());
                }
                jLEEvent.consume();
            } else {
                JLECanvas jLECanvas = this.getCanvas();
                if (jLECanvas instanceof GraphCanvas) {
                    ((GraphCanvas)jLECanvas).__redispatchMouseEvent(jLEEvent, (LayoutItem)this);
                }
            }
        }
        super.processMouseEvent(jLEEvent);
    }

    private class AccessibleLink
    extends AccessibleLayoutItem {
        public AccessibleLink() {
            super((LayoutItem)EdgeLinkItem.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (SelectionTool.isSelected((LayoutItem)EdgeLinkItem.this)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
                if (EdgeLinkItem.this.getCanvas() != null && EdgeLinkItem.this.getCanvas().getGlassComponent().hasFocus()) {
                    accessibleStateSet.add(AccessibleState.FOCUSED);
                }
            }
            if (EdgeLinkItem.this.getCanvas() != null) {
                if (EdgeLinkItem.this.getCanvas().isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
                if (EdgeLinkItem.this.getCanvas().isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                }
            }
            return accessibleStateSet;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null || "".equals(string)) {
                string = this._getAccessibleName(EdgeLinkItem.this.getEdge());
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null || "".equals(string)) {
                string = this._getAccessibleDescription(EdgeLinkItem.this.getEdge());
            }
            return string;
        }

        private String _getAccessibleName(Edge edge) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", this.getLocale());
            String string = edge.getToolTipText();
            String string2 = string != null && !"".equals(string) ? EdgeLinkItem._KEY_NAME : EdgeLinkItem._KEY_NONAME;
            String string3 = resourceBundle.getString(string2);
            MessageFormat messageFormat = new MessageFormat(string3);
            String string4 = this._getName(edge.getSourcePort(0));
            String string5 = this._getName(edge.getTargetPort(0));
            if (string2 == EdgeLinkItem._KEY_NAME) {
                Object[] objectArray = new Object[]{string, string4, string5};
                return messageFormat.format(objectArray);
            }
            Object[] objectArray = new Object[]{string4, string5};
            return messageFormat.format(objectArray);
        }

        private String _getName(Port port) {
            String string = port.getDisplayName(this.getLocale());
            Node node = port.getParent();
            while (node != null) {
                string = node.getDisplayName(this.getLocale()) + "." + string;
                node = node.getParent();
            }
            return string;
        }

        private String _getAccessibleDescription(Edge edge) {
            return this._getAccessibleName(edge);
        }
    }
}

