/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.dbUI.graph.jle.AccessibleJLEWindow;
import oracle.bali.dbUI.graph.jle.Content;
import oracle.bali.dbUI.graph.jle.JLEComponentBorder;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.dbUI.graph.jle.TitleBar;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.SynthesizingImageSet;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.tool.BoundsTool;

public class JLEWindow
extends ComponentItem {
    private boolean _selected;
    private boolean _minimized;
    private boolean _resizable;
    private TitleBar _titleBar;
    private Component _content;
    private JLEContainer _middle;
    private PropertyChangeSupport _support;
    private VetoableChangeSupport _vetoSupport;
    private ImageSet _minimizedSet;
    private Rectangle2D _savedBounds;
    private Border _border;
    private MinComp _minimizedComponent;
    private boolean _defaultSize = true;
    private boolean _added = false;

    public JLEWindow() {
        super((Component)((Object)new Content()), 60L);
        Content content = (Content)((Object)this.getComponent());
        content.setWindow(this);
        ((Container)((Object)content)).setLayout((LayoutManager)new MaximumBorderLayout());
        ((JComponent)((Object)content)).setBackground(UIManager.getDefaults().getColor(LookAndFeel.CONTROL));
        this._middle = new JLEContainer();
        this._middle.setBackground(UIManager.getDefaults().getColor(LookAndFeel.WINDOW));
        this._middle.setLayout((LayoutManager)new MaximumBorderLayout());
        this._middle.setBorder((Border)new BorderAdapter((BorderPainter)new BP()));
        this._titleBar = new TitleBar(this);
        ((Container)((Object)content)).add("North", this._titleBar);
        ((Container)((Object)content)).add("Center", this._middle);
        this.setBorder((Border)new BorderAdapter((BorderPainter)new JLEComponentBorder(this._middle, this._titleBar)));
        this._resizable = true;
        this.setForcedMouseConsumption(false);
    }

    public void setToolTipText(String string) {
        this._titleBar.setToolTipText(string);
        if (this._minimizedComponent != null) {
            this._minimizedComponent.setToolTipText(string);
        }
    }

    public String getToolTipText() {
        return this._titleBar.getToolTipText();
    }

    void setAutoDisplayToolTips(boolean bl) {
        if (this.getAutoDisplayToolTips() != bl) {
            this._titleBar.setAutoDisplay(bl);
            if (bl) {
                if (this._titleBar.isToolTipDefaulted() && this._minimizedComponent != null) {
                    this._minimizedComponent.setToolTipText(this.getTitle());
                }
            } else if (this._titleBar.isToolTipDefaulted() && this._minimizedComponent != null) {
                this._minimizedComponent.setToolTipText(null);
            }
        }
    }

    boolean getAutoDisplayToolTips() {
        return this._titleBar.getAutoDisplay();
    }

    public void setBorder(Border border) {
        Content content = (Content)((Object)this.getComponent());
        ((JComponent)((Object)content)).setBorder(border);
        this._border = border;
    }

    public Border getBorder() {
        return this._border;
    }

    public void setContent(Component component) {
        if (this._content != component) {
            if (this._content != null) {
                this._middle.remove(this._content);
            }
            this._content = component;
            if (this._content != null) {
                Accessible accessible;
                this._middle.add(this._content, "Center");
                if (this._content instanceof Accessible && (accessible = (Accessible)((Object)this._content)).getAccessibleContext() != null) {
                    accessible.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
                }
            }
            this._invalidateAndRepaint();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component getContent() {
        return this._content;
    }

    public ImageSet getMinimizedImageSet() {
        return this._minimizedSet;
    }

    public final void setMinimizedImage(Image image) {
        this.setMinimizedImageSet((ImageSet)new SynthesizingImageSet(image));
    }

    public void setMinimizedImageSet(ImageSet imageSet) {
        if (this._minimizedSet != imageSet) {
            this._minimizedSet = imageSet;
            this._invalidateAndRepaint();
        }
    }

    public boolean isEnabled() {
        return this._titleBar.isEnabled();
    }

    public void setEnabled(boolean bl) {
        Component component;
        this.getComponent().setEnabled(bl);
        this._titleBar.setEnabled(bl);
        if (this._minimizedComponent != null) {
            ((JComponent)((Object)this._minimizedComponent)).setEnabled(bl);
        }
        if ((component = this.getContent()) != null) {
            component.setEnabled(bl);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean bl) {
        if (this._selected != bl) {
            this._selected = bl;
            this._titleBar.setSelected(bl);
            this.firePropertyChange("selected", new Boolean(!this._selected), new Boolean(this._selected));
        }
    }

    public Image getImage() {
        return this._titleBar.getImage();
    }

    public void setImage(Image image) {
        this._titleBar.setImage(image);
    }

    public boolean isClosable() {
        return this._titleBar.isClosable();
    }

    public void setClosable(boolean bl) {
        this._titleBar.setClosable(bl);
    }

    public boolean isMinimized() {
        return !this._middle.isVisible();
    }

    public void setMinimized(boolean bl) {
        if (this.isMinimized() != bl) {
            if (this.fireVetoableChange("minimized", new Boolean(!bl), new Boolean(bl))) {
                return;
            }
            if (this.getMinimizedImageSet() == null) {
                Dimension dimension = this.getComponent().getPreferredSize();
                this._middle.setVisible(!bl);
                this._titleBar.__updateButtons();
                this._invalidateAndRepaint();
                Dimension dimension2 = this.getComponent().getPreferredSize();
                int n = bl ? dimension.width : dimension2.width;
                this.setItemSize(n, dimension2.height);
            } else {
                this._updateBoundsTool(bl);
                Content content = (Content)((Object)this.getComponent());
                if (bl) {
                    this._savedBounds = this.getItemBounds();
                    this._middle.setVisible(false);
                    this._titleBar.setVisible(false);
                    if (this._minimizedComponent == null) {
                        this._minimizedComponent = new MinComp();
                        this._minimizedComponent.setToolTipText(this.getToolTipText());
                        ((Container)((Object)content)).add("South", (Component)((Object)this._minimizedComponent));
                    }
                    ((JComponent)((Object)this._minimizedComponent)).setVisible(true);
                    ((JComponent)((Object)content)).setBorder(null);
                    Dimension dimension = this.getComponent().getPreferredSize();
                    double d = this._savedBounds.getWidth() - (double)dimension.width;
                    this.setItemBounds(this._savedBounds.getX() + d, this._savedBounds.getY(), dimension.width, dimension.height);
                    this._savedBounds.setRect(d, 0.0, this._savedBounds.getWidth(), this._savedBounds.getHeight());
                    Window window = SwingUtilities.windowForComponent(this.getComponent());
                    Component component = SwingUtilities.findFocusOwner(window);
                    if (component != null && ((Container)this.getComponent()).isAncestorOf(component)) {
                        this.getComponent().requestFocus();
                    }
                } else {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    ((JComponent)((Object)this._minimizedComponent)).setVisible(false);
                    this._titleBar.setVisible(true);
                    this._middle.setVisible(true);
                    ((JComponent)((Object)content)).setBorder(this.getBorder());
                    this._titleBar.__updateButtons();
                    Rectangle2D rectangle2D = this.getItemBounds();
                    this.setItemBounds(rectangle2D.getX() - this._savedBounds.getX(), rectangle2D.getY(), this._savedBounds.getWidth(), this._savedBounds.getHeight());
                }
                this._invalidateAndRepaint();
            }
            this.firePropertyChange("minimized", new Boolean(!bl), new Boolean(bl));
            if (this.getCanvas() != null) {
                this.getCanvas().repaint();
            }
        }
    }

    public String getTitle() {
        return this._titleBar.getTitle();
    }

    public void setTitle(String string) {
        if (this.getTitle() != string) {
            this._titleBar.setTitle(string);
        }
    }

    public void setTitleBarPainter(Painter painter) {
        this._titleBar.setPainter(painter);
    }

    public Painter getTitleBarPainter() {
        return this._titleBar.getPainter();
    }

    public void setTitleBarBackground(Color color) {
        this._titleBar.setTitleBackground(color);
    }

    public Color getTitleBarBackground() {
        return this._titleBar.getBackground();
    }

    public void setTitleBarForeground(Color color) {
        this._titleBar.setTitleForeground(color);
    }

    public Color getTitleBarForeground() {
        return this._titleBar.getForeground();
    }

    public boolean isVisible() {
        return this.getComponent().isVisible();
    }

    public void setVisible(boolean bl) {
        this.getComponent().setVisible(bl);
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean bl) {
        if (this._resizable != bl) {
            this._resizable = bl;
            BoundsTool.setResizable((LayoutItem)this, (boolean)bl);
        }
    }

    public boolean close() {
        if (this.fireVetoableChange("closed", Boolean.FALSE, Boolean.TRUE)) {
            return false;
        }
        this.firePropertyChange("closed", Boolean.FALSE, Boolean.TRUE);
        return true;
    }

    void __setItemSize(double d, double d2) {
        boolean bl = this._defaultSize;
        this.setItemSize(d, d2);
        if (!this._added) {
            this._defaultSize = bl;
        }
    }

    public void setItemSize(double d, double d2) {
        if (d != 0.0 && d2 != 0.0) {
            this._defaultSize = false;
        }
        Rectangle rectangle = this.getItemBounds().getBounds();
        Dimension dimension = this.getComponent().getMinimumSize();
        if (d < (double)dimension.width) {
            d = dimension.width;
        }
        if (d2 < (double)dimension.height) {
            d2 = dimension.height;
        }
        Dimension dimension2 = this.getComponent().getPreferredSize();
        if (dimension2.width > 0 && d > (double)dimension2.width) {
            d = dimension2.width;
        }
        if (dimension2.height > 0 && d2 > (double)dimension2.height) {
            d2 = dimension2.height;
        }
        super.setItemSize(d, d2);
        Rectangle rectangle2 = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", rectangle, rectangle2);
    }

    public void setItemBounds(double d, double d2, double d3, double d4) {
        if (d3 != 0.0 && d4 != 0.0) {
            this._defaultSize = false;
        }
        Rectangle rectangle = this.getItemBounds().getBounds();
        Dimension dimension = this.getComponent().getMinimumSize();
        if (d3 < (double)dimension.width) {
            d3 = dimension.width;
        }
        if (d4 < (double)dimension.height) {
            d4 = dimension.height;
        }
        Dimension dimension2 = this.getComponent().getPreferredSize();
        if (dimension2.width > 0 && d3 > (double)dimension2.width) {
            d3 = dimension2.width;
        }
        if (dimension2.height > 0 && d4 > (double)dimension2.height) {
            d4 = dimension2.height;
        }
        super.setItemBounds(d, d2, d3, d4);
        Rectangle rectangle2 = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", rectangle, rectangle2);
    }

    public void setItemLocation(double d, double d2) {
        Rectangle rectangle = this.getItemBounds().getBounds();
        super.setItemLocation(d, d2);
        Rectangle rectangle2 = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", rectangle, rectangle2);
    }

    public void setItemTransform(AffineTransform affineTransform) throws TransformException {
        Rectangle2D rectangle2D = this.getItemBounds();
        Rectangle rectangle = rectangle2D.getBounds();
        super.setItemTransform(affineTransform);
        Rectangle rectangle2 = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", rectangle, rectangle2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport((Object)this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport((Object)this);
        }
        this._vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean isActive() {
        return this.isSelected();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleJLEWindow(this);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    protected boolean fireVetoableChange(String string, Object object, Object object2) {
        boolean bl = false;
        try {
            if (this._vetoSupport != null) {
                this._vetoSupport.fireVetoableChange(string, object, object2);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            bl = true;
        }
        return bl;
    }

    Rectangle __getTitleBarBounds() {
        return this._titleBar.getBounds();
    }

    Component __getTitleBar() {
        return this._titleBar;
    }

    Component __getMinimizedComponent() {
        return this._minimizedComponent;
    }

    Point __getContentLocation() {
        int n = 0;
        int n2 = 0;
        Component component = this.getContent();
        while (component != null && component != this.getComponent()) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    Insets __getBorderInsets() {
        Component component = this.getComponent();
        Border border = ((JComponent)component).getBorder();
        Insets insets = border == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(component);
        border = this._middle.getBorder();
        Insets insets2 = border == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(this._middle);
        return new Insets(insets.top, insets.left + insets2.left, insets.bottom, insets.right + insets2.right);
    }

    private void _updateBoundsTool(boolean bl) {
        LayoutTool layoutTool;
        if (bl) {
            BoundsTool.setResizable((LayoutItem)this, (boolean)false);
        } else {
            BoundsTool.setResizable((LayoutItem)this, (boolean)this._resizable);
        }
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null && (layoutTool = jLECanvas.getTool()) instanceof NodeTool) {
            NodeTool nodeTool = (NodeTool)layoutTool;
            nodeTool.getBoundsTool().updateControlPoints((LayoutItem)this);
        }
    }

    private void _invalidateAndRepaint() {
        Component component = this.getComponent();
        component.invalidate();
        component.repaint();
    }

    private class BP
    extends AbstractBorderPainter {
        private ImmInsets _INSETS = new ImmInsets(5, 3, 3, 3);

        private BP() {
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return this._INSETS;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = n + n3 + 1;
            int n6 = n2 + n4 + 1;
            int n7 = paintContext.getPaintState();
            UIDefaults uIDefaults = UIManager.getDefaults();
            if (JLEWindow.this.isSelected()) {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.WINDOW));
            } else {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL));
            }
            graphics.drawLine(n, n2 + 1, n5, n2 + 1);
            graphics.drawLine(n, n2 + 2, n5, n2 + 2);
            graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
            graphics.drawLine(n + 2, n2 + 4, n + 2, n2 + 4);
            graphics.drawLine(n, n2 + 3, n, n6);
            graphics.drawLine(n + 1, n2 + 3, n + 1, n6);
            graphics.drawLine(n5 - 2, n2 + 3, n5 - 2, n6);
            graphics.drawLine(n5 - 3, n2 + 3, n5 - 3, n6);
            graphics.drawLine(n5 - 4, n2 + 3, n5 - 4, n2 + 3);
            graphics.drawLine(n5 - 5, n2 + 3, n5 - 5, n2 + 3);
            graphics.drawLine(n5 - 4, n2 + 4, n5 - 4, n2 + 4);
            graphics.drawLine(n, n6 - 2, n5, n6 - 2);
            graphics.drawLine(n, n6 - 3, n5, n6 - 3);
            graphics.drawLine(n + 2, n6 - 4, n + 2, n6 - 4);
            graphics.drawLine(n + 3, n6 - 4, n + 3, n6 - 4);
            graphics.drawLine(n + 2, n6 - 5, n + 2, n6 - 5);
            graphics.drawLine(n5 - 4, n6 - 4, n5 - 4, n6 - 4);
            graphics.drawLine(n5 - 5, n6 - 4, n5 - 5, n6 - 4);
            graphics.drawLine(n5 - 4, n6 - 5, n5 - 4, n6 - 5);
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2, n5, n2);
            graphics.drawLine((n += 2) + 2, n2 += 3, (n5 -= 4) - 2, n2);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
            graphics.drawLine(n, n2 + 2, n, (n6 -= 4) - 2);
            graphics.drawLine(n5, n2 + 2, n5, n6 - 2);
            graphics.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
            graphics.drawLine(n + 2, n6, n5 - 2, n6);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }
    }

    private class MinComp
    extends PainterComponent {
        public MinComp() {
            this.setPainter((Painter)new PainterJoiner((Painter)new ImageSetPainter(), (Painter)new MinTextPainter(), 5));
            ((Component)((Object)this)).enableEvents(16L);
        }

        public void setToolTipText(String string) {
            super.setToolTipText(string);
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        }

        public void doLayout() {
            super.doLayout();
            if (JLEWindow.this._titleBar.isToolTipDefaulted() && JLEWindow.this.getTitle() != null && JLEWindow.this.getTitle().length() > 10) {
                this.setToolTipText(JLEWindow.this.getTitle());
            }
        }

        public Object getPaintData(Object object) {
            if (PaintContext.IMAGESET_KEY.equals(object)) {
                return JLEWindow.this.getMinimizedImageSet();
            }
            if (PaintContext.LABEL_KEY.equals(object)) {
                return JLEWindow.this.getTitle();
            }
            return super.getPaintData(object);
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (JLEWindow.this.isSelected()) {
                n |= 0x20;
            }
            return n;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (((Component)((Object)this)).isEnabled() && mouseEvent.getID() == 500 && mouseEvent.getClickCount() % 2 == 0) {
                JLEWindow.this.setMinimized(false);
            }
        }
    }

    private class MinTextPainter
    extends TruncatingTextPainter {
        private MinTextPainter() {
        }

        public Dimension getPreferredSize(PaintContext paintContext) {
            Font font;
            String string = this.getStringData(paintContext);
            Dimension dimension = super.getPreferredSize(paintContext);
            if (string != null && string.length() > 10 + TruncatingTextPainter.getEllipsis((PaintContext)paintContext).length() && (font = paintContext.getPaintFont()) != null) {
                FontMetrics fontMetrics = paintContext.getFontMetrics(font);
                dimension.width = fontMetrics.stringWidth(string.substring(0, 10)) + fontMetrics.stringWidth(TruncatingTextPainter.getEllipsis((PaintContext)paintContext));
            }
            return dimension;
        }
    }

    private class JLEContainer
    extends JPanel {
        private JLEContainer() {
        }

        public void addNotify() {
            super.addNotify();
            JLEWindow.this._added = true;
            if (JLEWindow.this._defaultSize) {
                Dimension dimension = JLEWindow.this.getComponent().getPreferredSize();
                Dimension dimension2 = this.getPreferredSize();
                int n = Math.min(dimension.width, dimension2.width + dimension2.width / 2);
                JLEWindow.this.setItemSize(n, dimension.height);
                JLEWindow.this._defaultSize = false;
            }
        }
    }
}

