/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Graphics;
import java.util.EventObject;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.ControlPointSet;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.AlignmentUtils;
import oracle.bali.jle.util.ItemUtils;

class NodeBoundsTool
extends BoundsTool {
    private static final int _CONTROL_POINT_SIZE = 4;
    private boolean _workaroundComplete = false;
    private boolean _ignoreEvents;
    private boolean _passOnRelease = true;

    public NodeBoundsTool() {
        this.setBoundsPainter((BoundsPainter)new NoControlPointPainter());
        this.setMultipleSelectAllowed(false);
        this.setDeleteAllowed(true);
        this.setMode(32);
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        if (!this._workaroundComplete) {
            BaseItem baseItem = new BaseItem();
            BoundsTool.setResizable((LayoutItem)baseItem, (boolean)false);
            this.processSelect((LayoutItem)baseItem, null);
            this.processDeselect((LayoutItem)baseItem);
            this._workaroundComplete = true;
        }
    }

    public void updateControlPoints(LayoutItem layoutItem) {
        this.clearControlPointSet(layoutItem);
        this.refreshSelection(layoutItem);
    }

    public boolean processDelete(LayoutItem layoutItem, EventObject eventObject) {
        boolean bl;
        GraphCanvas graphCanvas;
        String string = null;
        Object object = null;
        if (layoutItem instanceof JLENodeWindow) {
            string = "nodeCount";
            object = ((JLENodeWindow)layoutItem).getNode();
        } else if (layoutItem instanceof EdgeLinkItem) {
            string = "edgeCount";
            object = ((EdgeLinkItem)layoutItem).getEdge();
        }
        GraphCanvas graphCanvas2 = graphCanvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        if (graphCanvas != null && string != null) {
            graphCanvas.__removeItem(layoutItem);
            if (graphCanvas.__fireVetoableChange(string, object, null)) {
                return false;
            }
        }
        if ((bl = super.processDelete(layoutItem, eventObject)) && graphCanvas != null && string != null) {
            graphCanvas.firePropertyChange(string, object, null);
        }
        return bl;
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        super.processKeyPressed(jLEEvent);
        if (jLEEvent.getKeyCode() == 121 && jLEEvent.isShiftDown()) {
            JLECanvas jLECanvas;
            int n;
            LayoutItem[] layoutItemArray = this.getSelectedItems();
            int n2 = n = layoutItemArray == null ? 0 : layoutItemArray.length;
            if (n == 1 && layoutItemArray[0] instanceof EdgeLinkItem && (jLECanvas = this.getCanvas()) instanceof GraphCanvas) {
                EdgeLinkItem edgeLinkItem = (EdgeLinkItem)layoutItemArray[0];
                ((GraphCanvas)jLECanvas).__showMenuForEdge(edgeLinkItem.getEdge(), (LayoutItem)edgeLinkItem, 0.0, 0.0);
            }
        }
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        LayoutItem layoutItem = this.getCanvas().getContentItem().getItemAt(jLEEvent.getX(), jLEEvent.getY());
        if (jLEEvent.isConsumed()) {
            if (layoutItem != null && !SelectionTool.isSelected((LayoutItem)layoutItem)) {
                jLEEvent = new JLEEvent(jLEEvent.getSource(), jLEEvent.getID(), jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getX(), jLEEvent.getY(), jLEEvent.getClickCount());
            }
            this._passOnRelease = false;
        } else {
            this._passOnRelease = true;
        }
        super.processMousePressed(jLEEvent);
        if (this.isEnabled() && !this.isPrimaryMouseEvent(jLEEvent)) {
            layoutItem = this.getCanvas().getContentItem().getHitItem(jLEEvent.getX(), jLEEvent.getY());
            this._processDeselectAll(layoutItem, (EventObject)jLEEvent);
            if (layoutItem != this.getCanvas().getContentItem() && layoutItem != null && !SelectionTool.isSelected((LayoutItem)layoutItem)) {
                this.processSelect(layoutItem);
            }
        }
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        if (this._passOnRelease) {
            super.processMouseReleased(jLEEvent);
        }
        this._passOnRelease = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _processDeselectAll(LayoutItem layoutItem, EventObject eventObject) {
        JLECanvas jLECanvas = this.getCanvas();
        LayoutItem[] layoutItemArray = this.getSelectedItems();
        if (jLECanvas != null) {
            jLECanvas.freezeRepaints();
        }
        try {
            int n = 0;
            while (n < layoutItemArray.length) {
                if (layoutItemArray[n] != layoutItem) {
                    this.processDeselect(layoutItemArray[n], eventObject);
                }
                ++n;
            }
            Object var7_6 = null;
            if (jLECanvas == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (jLECanvas == null) throw throwable;
            jLECanvas.unfreezeRepaints();
            throw throwable;
        }
        jLECanvas.unfreezeRepaints();
    }

    public boolean processSelect(LayoutItem layoutItem, EventObject eventObject) {
        if (this._ignoreEvents) {
            return false;
        }
        GraphCanvas graphCanvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Node node = null;
        Edge edge = null;
        if (layoutItem instanceof JLENodeWindow) {
            node = ((JLENodeWindow)layoutItem).getNode();
        } else if (layoutItem instanceof EdgeLinkItem) {
            edge = ((EdgeLinkItem)layoutItem).getEdge();
        }
        if (graphCanvas != null && (node != null ? graphCanvas.__fireVetoableChange("nodeSelectionCount", null, node) : edge != null && graphCanvas.__fireVetoableChange("edgeSelectionCount", null, edge))) {
            return false;
        }
        this._ignoreEvents = true;
        AlignmentUtils.moveToFront((LayoutItem)layoutItem);
        this._ignoreEvents = false;
        boolean bl = super.processSelect(layoutItem, eventObject);
        if (bl) {
            if (layoutItem instanceof JLEWindow) {
                this.getCanvas().setFocusedItem(layoutItem);
                ((JLEWindow)layoutItem).setSelected(true);
                if (layoutItem instanceof JLENodeWindow) {
                    JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                    if (jLENodeWindow.isMinimized()) {
                        jLENodeWindow.getComponent().requestFocus();
                    } else {
                        jLENodeWindow.getNodeComponent().requestFocus();
                    }
                }
            } else if (layoutItem instanceof EdgeLinkItem) {
                this.getCanvas().requestFocus();
            }
            if (graphCanvas != null) {
                if (node != null) {
                    graphCanvas.firePropertyChange("nodeSelectionCount", null, node);
                } else if (edge != null) {
                    graphCanvas.firePropertyChange("edgeSelectionCount", null, edge);
                }
            }
        }
        return bl;
    }

    public boolean processDeselect(LayoutItem layoutItem, EventObject eventObject) {
        if (this._ignoreEvents) {
            return false;
        }
        GraphCanvas graphCanvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Node node = null;
        Edge edge = null;
        if (layoutItem instanceof JLENodeWindow) {
            node = ((JLENodeWindow)layoutItem).getNode();
        } else if (layoutItem instanceof EdgeLinkItem) {
            edge = ((EdgeLinkItem)layoutItem).getEdge();
        }
        if (graphCanvas != null && (node != null ? graphCanvas.__fireVetoableChange("nodeSelectionCount", node, null) : edge != null && graphCanvas.__fireVetoableChange("edgeSelectionCount", edge, null))) {
            return false;
        }
        boolean bl = super.processDeselect(layoutItem, eventObject);
        if (bl) {
            if (layoutItem instanceof JLEWindow) {
                ((JLEWindow)layoutItem).setSelected(false);
            }
            if (graphCanvas != null) {
                if (node != null) {
                    graphCanvas.firePropertyChange("nodeSelectionCount", node, null);
                } else if (edge != null) {
                    graphCanvas.firePropertyChange("edgeSelectionCount", edge, null);
                }
            }
        }
        return bl;
    }

    protected ControlPointSet fetchControlPointSet(LayoutItem layoutItem) {
        if (!BoundsTool.isResizable((LayoutItem)layoutItem)) {
            return null;
        }
        Rectangle2D rectangle2D = ItemUtils.parentToContent((LayoutItem)layoutItem, (Rectangle2D)layoutItem.getItemBounds());
        double d = rectangle2D.getX() + 3.0;
        double d2 = rectangle2D.getY() + 3.0;
        double d3 = d + rectangle2D.getWidth() - 7.0;
        double d4 = d2 + rectangle2D.getHeight() - 7.0;
        double d5 = rectangle2D.getWidth() - 10.0;
        double d6 = rectangle2D.getHeight() - 10.0;
        int n = 4;
        int n2 = (int)(d5 / 4.0 - 2.0);
        if (n2 < 0) {
            n2 = 0;
        }
        n += 2 * n2;
        int n3 = (int)(d6 / 4.0 - 2.0);
        if (n3 < 0) {
            n3 = 0;
        }
        ControlPoint[] controlPointArray = new ControlPoint[n += 2 * n3];
        controlPointArray[0] = new ControlPoint(0, d, d2, layoutItem);
        controlPointArray[1] = new ControlPoint(2, d3, d2, layoutItem);
        controlPointArray[2] = new ControlPoint(8, d, d4, layoutItem);
        controlPointArray[3] = new ControlPoint(10, d3, d4, layoutItem);
        double d7 = d5 / (double)n2;
        double d8 = d6 / (double)n3;
        int n4 = 4;
        int n5 = 0;
        while (n5 < n2) {
            controlPointArray[n5 + n4] = new ControlPoint(1, d + (double)(n5 + 1) * d7, d2, layoutItem);
            ++n5;
        }
        n4 += n2;
        int n6 = 0;
        while (n6 < n2) {
            controlPointArray[n6 + n4] = new ControlPoint(9, d + (double)(n6 + 1) * d7, d4, layoutItem);
            ++n6;
        }
        n4 += n2;
        int n7 = 0;
        while (n7 < n3) {
            controlPointArray[n7 + n4] = new ControlPoint(4, d, d2 + (double)(n7 + 1) * d8, layoutItem);
            ++n7;
        }
        n4 += n3;
        int n8 = 0;
        while (n8 < n3) {
            controlPointArray[n8 + n4] = new ControlPoint(6, d3, d2 + (double)(n8 + 1) * d8, layoutItem);
            ++n8;
        }
        return new ControlPointSet(controlPointArray);
    }

    protected boolean fireBoundsToolEvent(int n, LayoutItem layoutItem, double d, double d2) {
        boolean bl = super.fireBoundsToolEvent(n, layoutItem, d, d2);
        if (n == 3) {
            bl &= BoundsTool.isResizable((LayoutItem)layoutItem);
        } else if (n == 2) {
            this.getCanvas().repaint();
        }
        return bl;
    }

    private static class NoControlPointPainter
    extends DefaultBoundsPainter {
        private NoControlPointPainter() {
        }

        public void drawControlPoint(Graphics graphics, ControlPoint controlPoint, int n, int n2) {
        }

        public void drawMove(Graphics graphics, LayoutItem layoutItem, int n, int n2, int n3, int n4) {
            if (BoundsTool.isMovable((LayoutItem)layoutItem)) {
                super.drawMove(graphics, layoutItem, n, n2, n3, n4);
            }
        }

        public int getControlPointWidth() {
            return 6;
        }

        public int getControlPointHeight() {
            return 6;
        }
    }
}

