/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.tool.LinkTool;

class NodeLinkTool
extends LinkTool {
    private JLENodeWindow _lastWindow;
    private Port _lastPort;
    private MouseMotionListener _listener;
    private JLENodeWindow _sourceItem;

    protected void processMouseReleased(JLEEvent jLEEvent) {
        super.processMouseReleased(jLEEvent);
        if (this._lastWindow != null) {
            this._lastWindow.getNodeComponent().setDropTargetPort(null);
        }
        this.getCanvas().getGlassComponent().setCursor(Cursor.getDefaultCursor());
        this._lastWindow = null;
        this._lastPort = null;
        if (this._sourceItem != null) {
            this._sourceItem.getNodeComponent().getSpreadTable().getGrid().removeMouseMotionListener(this._listener);
        }
        this._sourceItem = null;
    }

    protected boolean fireLinkToolEvent(int n, LinkItem linkItem, LayoutItem layoutItem, Point2D point2D, LayoutItem layoutItem2, Point2D point2D2) {
        EdgeFactory edgeFactory;
        Port port;
        boolean bl = super.fireLinkToolEvent(n, linkItem, layoutItem, point2D, layoutItem2, point2D2);
        if (layoutItem2 == null) {
            if (this._lastWindow != null && this._lastPort != null) {
                this.addImmediateRect(this._lastWindow.getItemBounds());
                this._lastWindow.getNodeComponent().setDropTargetPort(null);
            }
            this.getCanvas().getGlassComponent().setCursor(Cursor.getDefaultCursor());
            this._lastWindow = null;
            this._lastPort = null;
        }
        if (n != 3 || !(layoutItem instanceof JLENodeWindow) || !(layoutItem2 instanceof JLENodeWindow)) {
            return bl;
        }
        JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem2;
        JLENodeWindow jLENodeWindow2 = (JLENodeWindow)layoutItem;
        if (n == 3 && this._sourceItem == null) {
            if (this._listener == null) {
                this._listener = new Consumer();
            }
            this._sourceItem = jLENodeWindow2;
            port = this._sourceItem.getNodeComponent().getSpreadTable().getGrid();
            ((Component)((Object)port)).addMouseMotionListener(this._listener);
        }
        if (layoutItem == layoutItem2) {
            return bl;
        }
        port = jLENodeWindow.getPort(point2D2.getX(), point2D2.getY());
        Port port2 = jLENodeWindow2.getPort(point2D.getX(), point2D.getY());
        if ((jLENodeWindow != this._lastWindow || port != this._lastPort) && this._lastWindow != null && this._lastPort != null) {
            this._lastWindow.getNodeComponent().setDropTargetPort(null);
            this.addImmediateRect(this._lastWindow.getItemBounds());
        }
        this._lastWindow = jLENodeWindow;
        this._lastPort = port;
        Cursor cursor = Cursor.getDefaultCursor();
        JLECanvas jLECanvas = this.getCanvas();
        boolean bl2 = false;
        if (jLECanvas instanceof GraphCanvas && (bl2 = (edgeFactory = ((GraphCanvas)jLECanvas).getEdgeFactory()).isEdgeValid(port2, port))) {
            cursor = edgeFactory.getCursor(port2, port);
        }
        jLECanvas.getGlassComponent().setCursor(cursor);
        if (jLENodeWindow != null && port != null && bl2) {
            jLENodeWindow.getNodeComponent().setDropTargetPort(port);
            this.addImmediateRect(jLENodeWindow.getItemBounds());
        } else if (!bl2 && jLENodeWindow != null) {
            jLENodeWindow.getNodeComponent().autoScroll(port);
        }
        return bl;
    }

    protected boolean isValidLinkSource(LayoutItem layoutItem, Point2D point2D) {
        if (!(layoutItem instanceof JLENodeWindow)) {
            return false;
        }
        JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
        Port port = jLENodeWindow.getPort(point2D.getX(), point2D.getY());
        return port != null && port.isSourceable();
    }

    protected boolean isValidLinkDestination(LayoutItem layoutItem, Point2D point2D, LayoutItem layoutItem2, Point2D point2D2) {
        if (!(layoutItem2 instanceof JLENodeWindow) || !(layoutItem instanceof JLENodeWindow)) {
            return false;
        }
        JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem2;
        JLENodeWindow jLENodeWindow2 = (JLENodeWindow)layoutItem;
        Port port = jLENodeWindow.getPort(point2D2.getX(), point2D2.getY());
        Port port2 = jLENodeWindow2.getPort(point2D.getX(), point2D.getY());
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas instanceof GraphCanvas) {
            GraphCanvas graphCanvas = (GraphCanvas)jLECanvas;
            EdgeFactory edgeFactory = graphCanvas.getEdgeFactory();
            if (!edgeFactory.isEdgeValid(port, port2)) {
                return false;
            }
            if (graphCanvas.doesEdgeExist(port, port2)) {
                return false;
            }
        }
        return port2 != null && port2.isTargetable();
    }

    public LinkItem processLink(LayoutItem layoutItem, LayoutItem layoutItem2, Point2D point2D, Point2D point2D2) {
        Object object;
        if (!(layoutItem instanceof JLENodeWindow) || !(layoutItem2 instanceof JLENodeWindow)) {
            return null;
        }
        JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
        JLENodeWindow jLENodeWindow2 = (JLENodeWindow)layoutItem2;
        Port port = jLENodeWindow.getPort(point2D.getX(), point2D.getY());
        Port port2 = jLENodeWindow2.getPort(point2D2.getX(), point2D2.getY());
        GraphCanvas graphCanvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Edge edge = null;
        if (graphCanvas != null) {
            object = graphCanvas.getEdgeFactory();
            edge = object.createEdge(port, port2);
        }
        if (edge == null) {
            return null;
        }
        if (graphCanvas != null && graphCanvas.__fireVetoableChange("edgeCount", null, edge)) {
            return null;
        }
        object = null;
        if (graphCanvas != null) {
            object = graphCanvas.__addEdge(edge, port, jLENodeWindow, port2, jLENodeWindow2);
        } else {
            PortLinkPort portLinkPort = new PortLinkPort(port, jLENodeWindow, false);
            PortLinkPort portLinkPort2 = new PortLinkPort(port2, jLENodeWindow2, true);
            object = new EdgeLinkItem(portLinkPort, portLinkPort2, edge);
            this.getCanvas().getContentItem().addItem((LayoutItem)object, 0);
        }
        return object;
    }

    private class Consumer
    extends MouseMotionAdapter {
        private Consumer() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }
    }
}

