/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.share.event.ListenerManager;

class PortLinkPort
implements LinkPort,
PropertyChangeListener {
    private Port _port;
    private JLENodeWindow _window;
    private boolean _target;
    private boolean _dead;
    private ListenerManager _listeners;
    private double _x;
    private double _y;

    public PortLinkPort(Port port, JLENodeWindow jLENodeWindow, boolean bl) {
        this._port = port;
        this._window = jLENodeWindow;
        this._target = bl;
        ((Container)((Object)this._window.getNodeComponent())).addPropertyChangeListener(this);
        PropertyManager propertyManager = this._window.getPropertyManager();
        propertyManager.addPropertyChangeListener((PropertyChangeListener)this);
        this._recalculateLocation();
    }

    public LayoutItem getItem() {
        return this._window;
    }

    public void die() {
        if (this.isDead()) {
            return;
        }
        PropertyManager propertyManager = this._window.getPropertyManager();
        propertyManager.removePropertyChangeListener((PropertyChangeListener)this);
        ((Component)((Object)this._window.getNodeComponent())).removePropertyChangeListener(this);
        this._fireLinkPortEvent(2);
        this._port = null;
        this._window = null;
        this._dead = true;
        this._listeners = null;
        this._y = Double.NaN;
        this._x = Double.NaN;
    }

    public boolean isDead() {
        return this._dead;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void addLinkPortListener(LinkPortListener linkPortListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)linkPortListener);
    }

    public void removeLinkPortListener(LinkPortListener linkPortListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)linkPortListener);
        }
    }

    public LinkPortListener[] getLinkPortListeners() {
        LinkPortListener linkPortListener;
        if (this._listeners == null) {
            return new LinkPortListener[0];
        }
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration == null) {
            return new LinkPortListener[0];
        }
        Vector<LinkPortListener> vector = new Vector<LinkPortListener>();
        while (enumeration.hasMoreElements()) {
            linkPortListener = (LinkPortListener)enumeration.nextElement();
            vector.addElement(linkPortListener);
        }
        linkPortListener = new LinkPortListener[vector.size()];
        vector.copyInto((Object[])linkPortListener);
        return linkPortListener;
    }

    public boolean isUpper() {
        return false;
    }

    public boolean isLower() {
        return false;
    }

    public boolean isLeft() {
        return this._target;
    }

    public boolean isRight() {
        return !this._target;
    }

    public boolean isCenter() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(string) || LayoutItem.BOUNDS_KEY.equals(string) || "portLocation".equals(string)) {
            this._recalculateLocation();
        }
    }

    private void _fireLinkPortEvent(int n) {
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        LinkPortEvent linkPortEvent = new LinkPortEvent((LinkPort)this, n);
        while (enumeration.hasMoreElements()) {
            LinkPortListener linkPortListener = (LinkPortListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    linkPortListener.portMoved(linkPortEvent);
                    break;
                }
                case 2: {
                    linkPortListener.portDead(linkPortEvent);
                }
            }
        }
    }

    private void _recalculateLocation() {
        if (this.getNodeWindow().getNodeComponent().isCreateMode()) {
            return;
        }
        Point point = this.getNodeWindow().__getContentLocation();
        this._x = this._target ? 0.0 : this.getNodeWindow().getItemSize().getWidth();
        this._y = this.getNodeWindow().isMinimized() ? this.getNodeWindow().getItemSize().getHeight() / 2.0 : (double)(this.getNodeWindow().getNodeComponent().getPortLocation(this.getPort()) + point.y);
        this._fireLinkPortEvent(1);
    }

    public Port getPort() {
        return this._port;
    }

    public JLENodeWindow getNodeWindow() {
        return this._window;
    }
}

