/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.scrolling;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.dbUI.graph.scrolling.MiddleLayout;
import oracle.bali.dbUI.graph.scrolling.ScrollAreaLayout;
import oracle.bali.dbUI.graph.scrolling.ScrollToolbar;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.share.util.IntegerUtils;

public class ScrollArea
extends LWComponent
implements Accessible {
    private static Image _sTOP = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollArea.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_top.gif");
    private static Image _sTOP_HALF = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollArea.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_tophalf.gif");
    private static Image _sMIDDLE = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollArea.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_middle.gif");
    private static Image _sBOTTOM_HALF = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollArea.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_bottomhalf.gif");
    private static Image _sBOTTOM = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollArea.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_bottom.gif");
    private static final String _TOOLTIP_KEY = "SCROLLAREA.TOOLTIP";
    private static final String _KEY_TOP = "top";
    private static final String _KEY_BOTTOM = "bottom";
    private JViewport _viewPort;
    private SpreadTable _table;
    private ScrollToolbar _topScroll;
    private ScrollToolbar _bottomScroll;
    private Indicator _topIndicator;
    private Indicator _bottomIndicator;
    private JPanel _middle;
    static /* synthetic */ Class class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar;

    public ScrollArea(SpreadTable spreadTable) {
        ((Container)((Object)this)).setLayout((LayoutManager)new MaximumBorderLayout(0, 1));
        this._viewPort = new JViewport();
        this._bottomScroll = new ScrollToolbar(this._viewPort, (Scrollable)spreadTable);
        this._bottomIndicator = new Indicator(this._bottomScroll);
        Container container = this._createScrollButtonArea(this._bottomScroll, (Component)((Object)this._bottomIndicator));
        ((Container)((Object)this)).add("South", container);
        this._topScroll = new ScrollToolbar(this._viewPort, (Scrollable)spreadTable);
        this._topIndicator = new Indicator(this._topScroll);
        Container container2 = this._createScrollButtonArea(this._topScroll, (Component)((Object)this._topIndicator));
        ((Container)((Object)this)).add("North", container2);
        this._middle = new JPanel(new MiddleLayout());
        this._middle.setBorder(new BP());
        this._middle.add("center", this._viewPort);
        ((Container)((Object)this)).add("Center", this._middle);
        this._table = spreadTable;
        Listener listener = new Listener();
        this._topScroll.addAdjustmentListener(listener);
        this._bottomScroll.addAdjustmentListener(listener);
        this._viewPort.addChangeListener(listener);
        this._middle.add("north", (Component)this._table.getColumnHeader());
        this._viewPort.setView((Component)this._table.getGrid());
    }

    public void addVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._topScroll.addAdjustmentListener(adjustmentListener);
        this._bottomScroll.addAdjustmentListener(adjustmentListener);
    }

    public void removeVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._topScroll.removeAdjustmentListener(adjustmentListener);
        this._bottomScroll.removeAdjustmentListener(adjustmentListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._topScroll.setEnabled(bl);
        this._bottomScroll.setEnabled(bl);
        ((JComponent)((Object)this._bottomIndicator)).setEnabled(bl);
        ((JComponent)((Object)this._topIndicator)).setEnabled(bl);
        this._table.setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new Access();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void addNotify() {
        super.addNotify();
        this._middle.add("north", (Component)this._table.getColumnHeader());
        this._viewPort.setView((Component)this._table.getGrid());
    }

    private void _syncScrollBarsWithViewport() {
        JViewport jViewport = this._viewPort;
        ScrollToolbar scrollToolbar = this._topScroll;
        ScrollToolbar scrollToolbar2 = this._bottomScroll;
        Dimension dimension = jViewport.getExtentSize();
        Dimension dimension2 = jViewport.getViewSize();
        Point point = jViewport.getViewPosition();
        int n = dimension.height;
        int n2 = dimension2.height;
        int n3 = Math.max(0, Math.min(point.y, n2 - n));
        scrollToolbar.setValues(n3, n, 0, n2);
        scrollToolbar2.setValues(n3, n, 0, n2);
    }

    private Container _createScrollButtonArea(Component component, Component component2) {
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new ScrollAreaLayout());
        lWComponent.setOpaque(true);
        lWComponent.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        lWComponent.add("center", component);
        lWComponent.add("east", component2);
        return lWComponent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BP
    implements Border {
        private BP() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2, n5, n2);
            graphics.drawLine(n, n6, n5, n6);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 0, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class IPainter
    extends ImagePainter {
        private Adjustable _adjustable;

        public IPainter(Adjustable adjustable) {
            super(0);
            this._adjustable = adjustable;
        }

        protected Image getImageData(PaintContext paintContext) {
            int n = this._adjustable.getValue();
            int n2 = this._adjustable.getMinimum();
            int n3 = this._adjustable.getMaximum();
            int n4 = this._adjustable.getVisibleAmount();
            int n5 = n3 - n4 - n;
            if (n <= n2) {
                return _sTOP;
            }
            if (n5 <= n2) {
                return _sBOTTOM;
            }
            return _sMIDDLE;
        }
    }

    private class Indicator
    extends PainterComponent
    implements AdjustmentListener {
        private Painter _painter;
        private ScrollToolbar _bar;

        public Indicator(ScrollToolbar scrollToolbar) {
            this._painter = new FixedBorderPainter((Painter)new IPainter(scrollToolbar), 0, 3, 0, 3);
            this._bar = scrollToolbar;
            this._bar.addAdjustmentListener(this);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        }

        public String getToolTipText() {
            float f = this._bar.getUnitIncrement();
            int n = Math.round((float)this._bar.getValue() / f);
            int n2 = Math.round((float)this._bar.getVisibleAmount() / f);
            int n3 = Math.round((float)this._bar.getMaximum() / f);
            Object[] objectArray = new Number[]{IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)(n + n2)), IntegerUtils.getInteger((int)n3)};
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", ((Component)((Object)this)).getLocale());
            String string = resourceBundle.getString(ScrollArea._TOOLTIP_KEY);
            return MessageFormat.format(string, objectArray);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ((Component)((Object)ScrollArea.this)).repaint();
        }

        public Painter getPainter() {
            return this._painter;
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        public Access() {
            super((JComponent)((Object)ScrollArea.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    private class Listener
    implements ChangeListener,
    AdjustmentListener {
        private Listener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            JViewport jViewport = ScrollArea.this._viewPort;
            Point point = jViewport.getViewPosition();
            point.y = adjustmentEvent.getValue();
            jViewport.setViewPosition(point);
            if (adjustmentEvent.getSource() == ScrollArea.this._topScroll) {
                ScrollArea.this._bottomScroll.setValue(adjustmentEvent.getValue());
            } else {
                ScrollArea.this._topScroll.setValue(adjustmentEvent.getValue());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ScrollArea.this._syncScrollBarsWithViewport();
        }
    }
}

