/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.scrolling;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import oracle.bali.dbUI.graph.scrolling.ContinuousToolBarButton;
import oracle.bali.dbUI.graph.scrolling.NonFocusableButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

class ScrollToolbar
extends JToolBar
implements Adjustable,
ActionListener {
    private Scrollable _scrollable;
    private JViewport _viewport;
    private int _value;
    private int _maximum;
    private int _minimum;
    private int _orientation;
    private int _unitIncrement = 1;
    private int _blockIncrement = 10;
    private int _visible;
    private ListenerManager _listeners;
    private JButton _topButton;
    private JButton _upButton;
    private JButton _downButton;
    private JButton _bottomButton;
    private static final String _IS_ROLLOVER = "JToolBar.isRollover";
    static /* synthetic */ Class class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar;

    public ScrollToolbar(JViewport jViewport, Scrollable scrollable) {
        this._scrollable = scrollable;
        this._viewport = jViewport;
        Image image = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/top.gif");
        Image image2 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/top_disabled.gif");
        Image image3 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/bottom.gif");
        Image image4 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/bottom_disabled.gif");
        Image image5 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/up.gif");
        Image image6 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/up_disabled.gif");
        Image image7 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/down.gif");
        Image image8 = ImageUtils.getImageResource((Class)(class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar == null ? (class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar = ScrollToolbar.class$("oracle.bali.dbUI.graph.scrolling.ScrollToolbar")) : class$oracle$bali$dbUI$graph$scrolling$ScrollToolbar), (String)"/oracle/bali/dbUI/graph/scrolling/images/down_disabled.gif");
        this._topButton = new NonFocusableButton(image);
        this._topButton.setDisabledIcon(new ImageIcon(image2));
        this._bottomButton = new NonFocusableButton(image3);
        this._bottomButton.setDisabledIcon(new ImageIcon(image4));
        this._upButton = new ContinuousToolBarButton(image5);
        this._upButton.setDisabledIcon(new ImageIcon(image6));
        this._downButton = new ContinuousToolBarButton(image7);
        this._downButton.setDisabledIcon(new ImageIcon(image8));
        this.add(this._topButton);
        this.add(this._upButton);
        this.add(this._downButton);
        this.add(this._bottomButton);
        this._topButton.addActionListener(this);
        this._upButton.addActionListener(this);
        this._downButton.addActionListener(this);
        this._bottomButton.addActionListener(this);
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this._updateButtons();
        this.setOpaque(false);
        this.setBackground(null);
        this.putClientProperty(_IS_ROLLOVER, Boolean.TRUE);
    }

    public int getOrientation() {
        return 0;
    }

    public int getValue() {
        return this._value;
    }

    public final void setValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            n5 = n;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getMinimum() {
        return this._minimum;
    }

    public final void setMinimum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = n;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getMaximum() {
        return this._maximum;
    }

    public final void setMaximum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = n;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getVisibleAmount() {
        return this._visible;
    }

    public void setVisibleAmount(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            n5 = this._value;
            n4 = n;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public synchronized void setUnitIncrement(int n) {
        this._unitIncrement = n;
    }

    public int getUnitIncrement() {
        Rectangle rectangle = this._viewport.getViewRect();
        return this._scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
    }

    public synchronized void setBlockIncrement(int n) {
        this._blockIncrement = n;
    }

    public int getBlockIncrement() {
        Rectangle rectangle = this._viewport.getViewRect();
        return this._scrollable.getScrollableBlockIncrement(rectangle, 1, 1);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        int n5 = this._value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            if (n == this._value && n2 == this._visible && n3 == this._minimum && n4 == this._maximum) {
                return;
            }
            this._setValuesInternal(n, n2, n3, n4);
        }
        if (n5 != n) {
            this._fireAccessValue(n5, n);
        }
        this._updateButtons();
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._listeners.removeListener((EventListener)adjustmentListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._topButton.setEnabled(bl);
        this._upButton.setEnabled(bl);
        this._downButton.setEnabled(bl);
        this._bottomButton.setEnabled(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        int n2 = 5;
        int n3 = n = this.getValue();
        if (this._topButton == object) {
            n3 = 0;
        } else if (this._bottomButton == object) {
            n3 = this.getMaximum() - this.getVisibleAmount();
        } else if (this._upButton == object) {
            n3 = n - this.getUnitIncrement();
            n2 = 1;
        } else if (this._downButton == object) {
            n3 = n + this.getUnitIncrement();
            n2 = 2;
        }
        this.setValue(n3);
        if (n != this.getValue()) {
            this.fireAdjustmentEvent(n2);
        }
    }

    protected void fireAdjustmentEvent(int n) {
        this.processEvent(new AdjustmentEvent(this, 601, n, this.getValue()));
    }

    private synchronized void _setValuesInternal(int n, int n2, int n3, int n4) {
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this._value = n;
        this._visible = n2;
        this._minimum = n3;
        this._maximum = n4;
    }

    private void _updateButtons() {
        int n = this.getValue();
        int n2 = this.getMaximum() - this.getVisibleAmount() - n;
        this._topButton.setEnabled(n > 0);
        this._upButton.setEnabled(n > 0);
        this._bottomButton.setEnabled(n2 > 0);
        this._downButton.setEnabled(n2 > 0);
    }

    private void _fireAccessValue(int n, int n2) {
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleValue", IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public Access() {
            super(ScrollToolbar.this);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.VERTICAL);
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            ScrollToolbar.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getMaximum());
        }
    }
}

