/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;

class CBWindow
extends JInternalFrame
implements PropertyChangeListener {
    private static final String _ACTIVATE_KEY = "ACTIVATE";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _FILTER_KEY = "FILTER";
    private boolean _between = false;
    private boolean _isNull = false;
    private JCheckBox _checkBox;
    private PushButton _ok;
    private PushButton _cancel;
    private ConstraintComponent _constraintComponent;
    private String _title;

    public CBWindow(ActionListener actionListener, ActionListener actionListener2) {
        this.setClosable(false);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setResizable(false);
        this._checkBox = new JCheckBox();
        this._ok = new PushButton("");
        this._ok.setDefaultCapable(true);
        this._ok.addActionListener(actionListener);
        this._cancel = new PushButton("");
        this._cancel.addActionListener(actionListener2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(actionListener, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(actionListener2, keyStroke, 2);
    }

    public boolean isConstraintActive() {
        return this._checkBox.isSelected();
    }

    public void setConstraintActive(boolean bl) {
        this._checkBox.setSelected(bl);
    }

    public DataConstraint getDataConstraint() {
        ConstraintComponent constraintComponent = this.getConstraintComponent();
        if (constraintComponent == null) {
            return null;
        }
        return constraintComponent.getDataConstraint();
    }

    public void setConstraintComponent(ConstraintComponent constraintComponent) {
        if (this._constraintComponent != null) {
            this._constraintComponent.removePropertyChangeListener(this);
        }
        this._constraintComponent = constraintComponent;
        if (this._constraintComponent != null) {
            this._constraintComponent.addPropertyChangeListener(this);
            this._setLayout();
        }
    }

    public ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    public void setWindowTitle(String string) {
        this._title = string;
    }

    public void requestFocus() {
        this.getConstraintComponent().getComponent().requestFocus();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._setText(this.getLocale());
    }

    private void _setText(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        this._checkBox.setText(resourceBundle.getString(_ACTIVATE_KEY));
        this._ok.setLabel(resourceBundle.getString(_OK_KEY));
        this._cancel.setLabel(resourceBundle.getString(_CANCEL_KEY));
        if (this._title != null) {
            String string = resourceBundle.getString(_FILTER_KEY) + this._title;
            this.setTitle(string);
        }
    }

    private void _setLayout() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(3, 3));
        Component component = this._constraintComponent.getComponent();
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.add("West", component);
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
        jPanel2.add("West", this._checkBox);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this._ok, DialogButtonBar.CONSTRAINT_YES);
        dialogButtonBar.add((Component)this._cancel, DialogButtonBar.CONSTRAINT_CANCEL);
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout(3, 3));
        jPanel4.add("East", (Component)dialogButtonBar);
        container.add("North", jPanel3);
        container.add("South", jPanel4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("dataConstraint".equals(string)) {
            Serializable serializable;
            DataConstraint dataConstraint = (DataConstraint)propertyChangeEvent.getNewValue();
            boolean bl = dataConstraint instanceof DCBetweenExpression;
            boolean bl2 = false;
            if (dataConstraint instanceof DCComparisonExpression) {
                serializable = (DCComparisonExpression)dataConstraint;
                boolean bl3 = bl2 = ((DCBinaryExpression)serializable).getConstraint(1) == DCConstant.getNullConstant();
            }
            if (bl != this._between || bl2 != this._isNull) {
                this._between = bl;
                this._isNull = bl2;
                serializable = this.getConstraintComponent().getComponent();
                ((Component)serializable).validate();
                this.pack();
            }
        }
    }
}

