/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.header.CBHeaderInputHandler;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderMoveAdapter;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.painter.Painter;

public class ConstraintSortHandler
extends CBHeaderInputHandler {
    private static final String _SORT_ASCEND = "ascending";
    private static final String _SORT_DESCEND = "descending";
    private static final String _KEY_ASCEND = "HEADER.ASCEND";
    private static final String _KEY_DESCEND = "HEADER.DESCEND";
    private static final String _KEY_SORT = "HEADER.SORT";
    private Listener _listener;
    private Sortable _sortable;
    private boolean[] _decending;
    private boolean _armed;
    private int _item;
    private int _lastItemSorted;

    public ConstraintSortHandler(Header header, Constrainable constrainable, ConstraintCompFactory constraintCompFactory, DataDescriptorProvider dataDescriptorProvider, Sortable sortable) {
        super(header, constrainable, constraintCompFactory, dataDescriptorProvider);
        this._sortable = sortable;
        this._lastItemSorted = -1;
        this._item = -1;
        this._listener = new Listener();
    }

    public Sortable getSortable() {
        return this._sortable;
    }

    public void setSortable(Sortable sortable) {
        this._sortable = sortable;
        this._decending = null;
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        header.addMoveListener((HeaderMoveListener)this._listener);
        super.mousePressed(mouseEvent, header, n);
        if (!mouseEvent.isConsumed()) {
            if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
                return;
            }
            this._armed = true;
            this._item = n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        header.removeMoveListener((HeaderMoveListener)this._listener);
        super.mouseReleased(mouseEvent, header, n);
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._checkArmed(mouseEvent, header, n);
        if (this._item == n && this._armed) {
            this.sort(n);
            mouseEvent.consume();
        }
        this._item = -1;
        this._armed = false;
    }

    HeaderKeyHandler createHeaderKeyHandler() {
        return new KeySort();
    }

    JPopupMenu createPopupMenu(int n) {
        JPopupMenu jPopupMenu = super.createPopupMenu(n);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        Header header = this.getHeader();
        Locale locale = header.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString(_KEY_ASCEND));
        jMenuItem.setActionCommand(_SORT_ASCEND);
        jMenuItem.addActionListener(this._listener);
        JMenuItem jMenuItem2 = new JMenuItem(resourceBundle.getString(_KEY_DESCEND));
        jMenuItem2.setActionCommand(_SORT_DESCEND);
        jMenuItem2.addActionListener(this._listener);
        JMenu jMenu = new JMenu(resourceBundle.getString(_KEY_SORT));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jPopupMenu.add(jMenu);
        return jPopupMenu;
    }

    void cancelSort() {
        this._item = -1;
    }

    void sort(int n) {
        if (this._sortable != null) {
            if (this._decending == null) {
                this._decending = new boolean[this.getHeader().getItemCount()];
            }
            if (this._lastItemSorted == n) {
                this._decending[n] = !this._decending[n];
            }
            this._sortable.sort(n, !this._decending[n]);
            this._lastItemSorted = n;
        }
    }

    void sort(int n, boolean bl) {
        if (this._sortable != null) {
            if (this._decending == null) {
                this._decending = new boolean[this.getHeader().getItemCount()];
            }
            this._decending[n] = bl;
            this._sortable.sort(n, bl);
            this._lastItemSorted = n;
        }
    }

    private void _checkArmed(MouseEvent mouseEvent, Header header, int n) {
        Painter painter;
        if (this._item == n && (painter = header.getPainter(n)) instanceof CBHeaderItemPainter) {
            CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
            boolean bl = this._pointInItem(cBHeaderItemPainter, header, n, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private boolean _pointInItem(CBHeaderItemPainter cBHeaderItemPainter, Header header, int n, int n2, int n3) {
        boolean bl = cBHeaderItemPainter.pointInActiveArea(header.getItemSize(n), header.getSize().height, n2, n3);
        if (bl) {
            return false;
        }
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        return n2 <= header.getItemSize(n) && n3 <= header.getSize().height;
    }

    private class KeySort
    extends CBHeaderInputHandler.MenuKeyHandler {
        private KeySort() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 32 && keyEvent.getID() == 401) {
                int n = header.getFocusItem();
                if (n != -1) {
                    ConstraintSortHandler.this.sort(n);
                }
                keyEvent.consume();
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class Listener
    extends HeaderMoveAdapter
    implements ActionListener {
        private Listener() {
        }

        public void itemMoving(HeaderEvent headerEvent) {
            ConstraintSortHandler.this.cancelSort();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ConstraintSortHandler.this._menuItem != -1) {
                if (ConstraintSortHandler._SORT_ASCEND.equals(string)) {
                    ConstraintSortHandler.this.sort(ConstraintSortHandler.this._menuItem, false);
                } else if (ConstraintSortHandler._SORT_DESCEND.equals(string)) {
                    ConstraintSortHandler.this.sort(ConstraintSortHandler.this._menuItem, true);
                }
            }
        }
    }
}

