/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.laf.DisabledBGPainter;
import oracle.bali.dbUI.laf.FocusPainter;
import oracle.bali.dbUI.laf.RaisedBorderPainter;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class DBUILookAndFeel {
    public static final String RESOURCE_BUNDLE = "oracle.bali.dbUI.resource.DBUIBundle";
    private static DBUILookAndFeel _sLookAndFeel;
    private static TaskScheduler _sScheduler;
    private static Painter _sPainter;
    private static Painter _sDisabledBackgroundPainter;

    public static DBUILookAndFeel getLookAndFeel() {
        if (_sLookAndFeel == null) {
            _sLookAndFeel = new DBUILookAndFeel();
        }
        return _sLookAndFeel;
    }

    public static TaskScheduler getTaskScheduler() {
        if (_sScheduler == null) {
            _sScheduler = new TaskScheduler();
        }
        return _sScheduler;
    }

    public void popupMenu(Component component, JPopupMenu jPopupMenu, int n, int n2) {
        Menu menu = new Menu(component, jPopupMenu, n, n2);
        DBUILookAndFeel.getTaskScheduler().schedule((Task)menu, 0);
    }

    public BorderPainter getFocusPainter(JComponent jComponent) {
        return FocusPainter.getPainter();
    }

    public BorderPainter getRaisedBorderPainter(JComponent jComponent) {
        return RaisedBorderPainter.getPainter();
    }

    public Painter getCheckPainter(JComponent jComponent) {
        if (_sPainter == null) {
            _sPainter = new PainterStacker((Painter)new PainterStacker((Painter)new Fill(FilledRectPainter.getPainter()), CheckPainter.getPainter()), (Painter)new Wrap(CheckPainter.getPainter()));
        }
        return _sPainter;
    }

    public static Image createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public Painter getBackgroundPainter(JComponent jComponent) {
        if (_sDisabledBackgroundPainter == null) {
            _sDisabledBackgroundPainter = new DisabledBGPainter(FilledRectPainter.getPainter());
        }
        return _sDisabledBackgroundPainter;
    }

    public void setCursor(Component component, boolean bl) {
        Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        Window window = WindowUtils.getWindow((Component)component);
        if (window != null) {
            this._setCursor(cursor, window);
        }
    }

    private void _setCursor(Cursor cursor, Component component) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this._setCursor(cursor, componentArray[n]);
                ++n;
            }
        }
    }

    private DBUILookAndFeel() {
    }

    class Menu
    implements Task {
        private Component _component;
        private JPopupMenu _menu;
        private int _x;
        private int _y;

        public Menu(Component component, JPopupMenu jPopupMenu, int n, int n2) {
            this._component = component;
            this._menu = jPopupMenu;
            this._x = n;
            this._y = n2;
        }

        public void runTask(TaskEvent taskEvent) {
            MenuUtils.showPopupMenu((JPopupMenu)this._menu, (Component)this._component, (int)this._x, (int)this._y);
        }
    }

    class Fill
    extends ColorChange {
        public Fill(Painter painter) {
            super(painter);
        }

        protected Color getColor(PaintContext paintContext) {
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            return uIDefaults.getColor("control");
        }
    }

    class Wrap
    extends AbstractWrappingPainter {
        public Wrap(Painter painter) {
            super(painter);
        }

        public boolean isTransparent(PaintContext paintContext) {
            return true;
        }
    }
}

