/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.event.MouseEvent;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderMoveAdapter;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.model.Sortable;

class SortHandler
extends NullInputHandler {
    private HeaderMoveAdapter _moveListener;
    private PropertyTable _parent;
    private Sortable _sortable;
    private boolean[] _decending;
    private boolean _armed;
    private int _item;
    private int _lastItemSorted;

    public SortHandler(PropertyTable propertyTable, Sortable sortable) {
        this._parent = propertyTable;
        this._sortable = sortable;
        this._lastItemSorted = -1;
        this._item = -1;
        this._moveListener = new ML();
    }

    public void sort(int n) {
        if (this._decending == null) {
            this._decending = new boolean[this._parent.getColumnHeader().getItemCount()];
        }
        if (this._lastItemSorted == n) {
            this._decending[n] = !this._decending[n];
        }
        this._sortable.sort(n, !this._decending[n]);
        this._lastItemSorted = n;
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        header.addMoveListener((HeaderMoveListener)this._moveListener);
        this._armed = true;
        this._item = n;
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        header.removeMoveListener((HeaderMoveListener)this._moveListener);
        if (!mouseEvent.isPopupTrigger() && this._item == n && this._armed && this._pointInItem(header, n, mouseEvent.getX(), mouseEvent.getY()) && !this._parent.fireCancelablePropertyTableEvent(n)) {
            this._parent.getGrid().commitCellEdit();
            this.sort(n);
            mouseEvent.consume();
            this._parent.firePropertyTableEvent(n);
        }
        this._item = -1;
        this._armed = false;
    }

    void cancelSort() {
        this._item = -1;
    }

    private boolean _pointInItem(Header header, int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        return n2 <= header.getItemSize(n) && n3 <= header.getSize().height;
    }

    private class ML
    extends HeaderMoveAdapter {
        private ML() {
        }

        public void itemMoving(HeaderEvent headerEvent) {
            SortHandler.this.cancelSort();
        }
    }
}

