/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.queryBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.dbUI.columnPropertyEditor.ColumnPropertyEditor;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumn;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumnFactory;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsTable;
import oracle.bali.dbUI.schemaViewer.SchemaViewer;
import oracle.bali.dbUI.schemaViewer.SchemaViewerEvent;
import oracle.bali.dbUI.schemaViewer.SchemaViewerListener;
import oracle.bali.dbUI.util.sql.SQLGenerator;
import oracle.bali.dbUI.viewBuilder.VBOuterJoinListener;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class QueryBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COMPONENT = "selectedComponent";
    private static final int _INDEX_VIEW_BUILDER = 0;
    private static final int _INDEX_CONSTRAINT_BUILDER = 1;
    private static final int _INDEX_COLUMN_PROPERTY_EDITOR = 2;
    private static final int _INDEX_SQL = 3;
    private static final int _INDEX_RESULTS = 4;
    private static final String _KEY_VIEWBUILDER = "VIEWBUILDER";
    private static final String _KEY_CONSTRAINTBUILDER = "CONSTRAINTBUILDER";
    private static final String _KEY_COLUMNCOMPONENT = "COLUMNCOMPONENT";
    private static final String _KEY_SQL = "SQL";
    private static final String _KEY_RESULTS = "RESULTS";
    private static final String _KEY_SCHEMA_VIEWER_NAME = "SCHEMA_VIEWER_NAME";
    private static final String _KEY_TABLE_ALIAS = "QUERYBUILDER.TABLE_ALIAS";
    private ViewBuilder _viewBuilder;
    private boolean _viewBuilderDirty;
    private ConstraintBuilder _constraintBuilder;
    private boolean _constraintBuilderDirty;
    private DDProvider _dataDescriptorProvider;
    private ColumnPropertyEditor _columnComponent;
    private boolean _columnComponentDirty;
    private boolean _needToUpdateColumnComponent;
    private boolean _needToUpdateColumnComponentValues;
    private JScrollPane _sqlScrollBox;
    private JTextArea _codeEditor;
    private SQLGenerator _generator;
    private boolean _sqlDirty;
    private String _lastSQL;
    private ResultsTable _results;
    private boolean _resultsDirty;
    private boolean _needToUpdateResults;
    private JTabbedPane _tabPanel;
    private int _lastIndex = -1;
    private SchemaViewer _schemaViewer;
    private JSplitPane _splitter;

    public QueryBuilder() {
        this(null);
    }

    public QueryBuilder(Database database) {
        this(database, null);
    }

    public QueryBuilder(Database database, ModelFactory modelFactory) {
        UIListener uIListener = new UIListener();
        this._schemaViewer = this.createSchemaViewer();
        this._schemaViewer.addSchemaViewerListener(uIListener);
        this._viewBuilder = this.createViewBuilder();
        ((Container)((Object)this._viewBuilder)).addPropertyChangeListener(uIListener);
        this._viewBuilder.addOuterJoinListener(uIListener);
        this._viewBuilder.addRelationshipListener(uIListener);
        this._viewBuilder.setTableAliasAllowed(true);
        this._constraintBuilder = this.createConstraintBuilder();
        ((Container)((Object)this._constraintBuilder)).addPropertyChangeListener(uIListener);
        this._dataDescriptorProvider = new DDProvider();
        this._columnComponent = this.createColumnPropertyEditor();
        this._columnComponent.setColumnFactory(VisualColumnFactory.getVisualColumnFactory());
        ((Container)((Object)this._columnComponent)).addPropertyChangeListener(uIListener);
        this._columnComponent.getPropertyTable().addEditListener(uIListener);
        this._columnComponent.getPropertyTable().addMoveListener(uIListener);
        this._results = this.createResultsTable();
        this._results.getSpreadTable().addResizeListener((TableResizeListener)uIListener);
        this._results.getSpreadTable().addMoveListener((TableMoveListener)uIListener);
        this._codeEditor = new JTextArea();
        this._codeEditor.getDocument().addDocumentListener(uIListener);
        this._codeEditor.setEditable(false);
        this._codeEditor.setLineWrap(true);
        this._codeEditor.setWrapStyleWord(true);
        this._sqlScrollBox = new JScrollPane(this._codeEditor);
        this._tabPanel = new JTabbedPane();
        this._tabPanel.addChangeListener(uIListener);
        this._tabPanel.add((Component)((Object)this._viewBuilder));
        this._tabPanel.add((Component)((Object)this._constraintBuilder));
        this._tabPanel.add((Component)((Object)this._columnComponent));
        this._tabPanel.add(this._sqlScrollBox);
        this._tabPanel.add((Component)((Object)this._results));
        this._splitter = new JSplitPane();
        this._splitter.setLeftComponent((Component)((Object)this._schemaViewer));
        this._splitter.setRightComponent(this._tabPanel);
        this._splitter.setContinuousLayout(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", this._splitter);
        this.setDatabase(database);
        this.setModelFactory(modelFactory);
    }

    public void setDatabase(Database database) {
        this._schemaViewer.setDatabase(database);
        this._viewBuilder.setTables(null);
        this._constraintBuilder.setDataConstraint(null);
        this._needToUpdateColumnComponent = true;
        this._needToUpdateResults = true;
    }

    public Database getDatabase() {
        return this._schemaViewer.getDatabase();
    }

    public ViewBuilder getViewBuilder() {
        return this._viewBuilder;
    }

    public ConstraintBuilder getConstraintBuilder() {
        return this._constraintBuilder;
    }

    public ColumnPropertyEditor getColumnPropertyEditor() {
        this._updateColumnComponent();
        return this._columnComponent;
    }

    public ResultsTable getResultsTable() {
        this._updateResultsTable();
        return this._results;
    }

    public SchemaViewer getSchemaViewer() {
        return this._schemaViewer;
    }

    public final void setModelFactory(ModelFactory modelFactory) {
        this.getResultsTable().setModelFactory(modelFactory);
        this._tabPanel.setEnabledAt(4, modelFactory != null);
    }

    public Component getSelectedComponent() {
        return this._tabPanel.getSelectedComponent();
    }

    public void setSelectedComponent(Component component) {
        if (component == this._viewBuilder) {
            this._tabPanel.setSelectedIndex(0);
        } else if (component == this._constraintBuilder) {
            this._tabPanel.setSelectedIndex(1);
        } else if (component == this._columnComponent) {
            this._tabPanel.setSelectedIndex(2);
        } else if (component == this._sqlScrollBox) {
            this._tabPanel.setSelectedIndex(3);
        } else if (component == this._results && this._tabPanel.isEnabledAt(4)) {
            this._tabPanel.setSelectedIndex(4);
        }
    }

    public void setSQLGenerator(SQLGenerator sQLGenerator) {
        if (sQLGenerator != this._generator) {
            this._generator = sQLGenerator;
            if (this.getSelectedComponent() == this._sqlScrollBox) {
                this._updateSQLComponent();
            }
        }
    }

    public SQLGenerator getSQLGenerator() {
        if (this._generator == null) {
            this._generator = SQLGenerator.getSQLGenerator();
        }
        return this._generator;
    }

    public String getSQLString() {
        Object object;
        Column[] columnArray = null;
        if (!this._viewBuilderDirty) {
            object = this.getColumnPropertyEditor().getColumnWrappers();
            columnArray = this._getColumns((ColumnWrapper[])object);
        }
        if (columnArray == null) {
            columnArray = this.getViewBuilder().getSelectedColumns();
        }
        object = this.getConstraintBuilder().getDataConstraint();
        Relationship[] relationshipArray = this.getViewBuilder().getIncludedRelationships();
        OuterJoin[] outerJoinArray = this.getViewBuilder().getOuterJoins();
        DataConstraint dataConstraint = this._results.getFilterDataConstraint();
        if (object == null) {
            object = dataConstraint;
        } else if (dataConstraint != null) {
            DataConstraint[] dataConstraintArray = new DataConstraint[]{object, dataConstraint};
            object = new DCBooleanExpression(dataConstraintArray, 1);
        }
        return this.getSQLGenerator().getSQLString(columnArray, (DataConstraint)object, relationshipArray, outerJoinArray);
    }

    public void setSQLString(String string) throws ParseException {
        throw new ParseException(string, 0);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._viewBuilder.setEnabled(bl);
        this._constraintBuilder.setEnabled(bl);
        this._columnComponent.setEnabled(bl);
        this._codeEditor.setEnabled(bl);
        this._sqlScrollBox.setEnabled(bl);
        this._results.setEnabled(bl);
        this._tabPanel.setEnabled(bl);
        this._splitter.setEnabled(bl);
        this._schemaViewer.setEnabled(bl);
    }

    protected ViewBuilder createViewBuilder() {
        return new ViewBuilder();
    }

    protected ConstraintBuilder createConstraintBuilder() {
        return new ConstraintBuilder();
    }

    protected ColumnPropertyEditor createColumnPropertyEditor() {
        return new ColumnPropertyEditor();
    }

    protected ResultsTable createResultsTable() {
        return new ResultsTable();
    }

    public SchemaViewer createSchemaViewer() {
        return new SchemaViewer();
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new AccessibleQueryBuilder();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    boolean updatePage(int n) {
        int n2 = this._lastIndex;
        this._lastIndex = n;
        if (n2 == 0) {
            if (this._viewBuilderDirty) {
                this._needToUpdateColumnComponent = true;
                this._needToUpdateResults = true;
                this._viewBuilderDirty = false;
            }
        } else if (n2 == 1) {
            if (this._constraintBuilderDirty) {
                this._needToUpdateResults = true;
                this._constraintBuilderDirty = false;
            }
        } else if (n2 == 2) {
            if (this._columnComponentDirty) {
                this._needToUpdateResults = true;
                this._columnComponentDirty = false;
            }
        } else if (n2 == 3) {
            if (this._sqlDirty) {
                String string = this._codeEditor.getText();
                if (this._lastSQL == null || !this._lastSQL.equals(string)) {
                    try {
                        this.setSQLString(string);
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                this._sqlDirty = false;
            }
        } else if (n2 == 4 && this._resultsDirty) {
            this._needToUpdateColumnComponentValues = true;
            this._resultsDirty = false;
        }
        if (n == 0) {
            this._updateViewBuilder();
        } else if (n == 1) {
            this._updateConstraintBuilder();
        } else if (n == 2) {
            this._updateColumnComponent();
        } else if (n == 3) {
            this._updateSQLComponent();
        } else if (n == 4) {
            this._updateResultsTable();
        }
        return true;
    }

    void tableSelected(Table table) {
        int n = this._tabPanel.getSelectedIndex();
        if (n == 0) {
            this.getViewBuilder().addTable(table, true);
        }
    }

    void columnSelected(Column column) {
        int n = this._tabPanel.getSelectedIndex();
        if (n == 0) {
            this.getViewBuilder().addTable(column.getTable(), true);
            this.getViewBuilder().setColumnSelected(column, true);
        } else if (n == 1) {
            this.getConstraintBuilder().addConstraintComponent(this.getConstraintBuilder().getConstraintCompFactory().createConstraintComponent(this._dataDescriptorProvider, column, null));
        }
    }

    private void _updateLabels(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String string = resourceBundle.getString(_KEY_VIEWBUILDER);
        this._tabPanel.setTitleAt(0, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_CONSTRAINTBUILDER);
        this._tabPanel.setTitleAt(1, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_COLUMNCOMPONENT);
        this._tabPanel.setTitleAt(2, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_SQL);
        this._tabPanel.setTitleAt(3, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_RESULTS);
        this._tabPanel.setTitleAt(4, StringUtils.stripMnemonic((String)string));
    }

    private void _updateViewBuilder() {
    }

    private void _updateConstraintBuilder() {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        DataDescriptor[] dataDescriptorArray = this.getViewBuilder().getSelectedColumns();
        int n = dataDescriptorArray == null ? 0 : dataDescriptorArray.length;
        this._dataDescriptorProvider.setDescriptors(dataDescriptorArray);
        constraintBuilder.setDataDescriptorProvider(this._dataDescriptorProvider);
        if (n != 0 && constraintBuilder.getLeafCount() == 0) {
            constraintBuilder.addConstraintComponent(constraintBuilder.getConstraintCompFactory().createConstraintComponent(this._dataDescriptorProvider, null, null));
        }
    }

    private void _updateColumnComponent() {
        Object[] objectArray;
        if (this._needToUpdateColumnComponent) {
            this._needToUpdateColumnComponent = false;
            objectArray = this.getViewBuilder().getSelectedColumns();
            ColumnPropertyEditor columnPropertyEditor = this.getColumnPropertyEditor();
            columnPropertyEditor.setColumns((Column[])objectArray);
        }
        if (this._needToUpdateColumnComponentValues) {
            this._needToUpdateColumnComponentValues = false;
            objectArray = this.getResultsTable().getColumnWrappers();
            System.out.println("todo: updated the contents of the column property editor");
        }
    }

    private void _updateSQLComponent() {
        String string = this.getSQLString();
        JTextArea jTextArea = this._codeEditor.getSize().width <= 0 ? this._viewBuilder.getCanvas().getComponent() : this._codeEditor;
        string = WrappedText.wrapText((String)string, (Component)jTextArea);
        this._codeEditor.setText(string);
        this._lastSQL = string;
    }

    private void _updateResultsTable() {
        if (this._needToUpdateResults) {
            this._needToUpdateResults = false;
            ColumnPropertyEditor columnPropertyEditor = this.getColumnPropertyEditor();
            ColumnWrapper[] columnWrapperArray = columnPropertyEditor.getColumnWrappers();
            ViewBuilder viewBuilder = this.getViewBuilder();
            Relationship[] relationshipArray = viewBuilder.getIncludedRelationships();
            DataConstraint dataConstraint = this.getConstraintBuilder().getDataConstraint();
            OuterJoin[] outerJoinArray = viewBuilder.getOuterJoins();
            if (columnWrapperArray == null) {
                Column[] columnArray = viewBuilder.getSelectedColumns();
                columnWrapperArray = ColumnWrapper.getColumnWrappers(columnArray);
            }
            this.getResultsTable().setColumnWrappers(columnWrapperArray);
            this.getResultsTable().setRelationships(relationshipArray);
            this.getResultsTable().setDataConstraint(dataConstraint);
            this.getResultsTable().setOuterJoins(outerJoinArray);
            this.getResultsTable().updateResults();
        }
    }

    private Column[] _getColumns(ColumnWrapper[] columnWrapperArray) {
        if (columnWrapperArray == null || columnWrapperArray.length == 0) {
            return null;
        }
        int n = columnWrapperArray.length;
        Column[] columnArray = new Column[n];
        int n2 = 0;
        while (n2 < n) {
            String string;
            Column column = columnWrapperArray[n2].getColumn();
            if (columnWrapperArray[n2] instanceof VisualColumn) {
                VisualColumn visualColumn = (VisualColumn)columnWrapperArray[n2];
                string = visualColumn.getDisplayName();
            } else {
                Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
                string = column.getDisplayName(locale);
            }
            columnArray[n2] = new ColumnImpl(column.getName(), string, column.getDataType(), column.getTable());
            ++n2;
        }
        return columnArray;
    }

    private class AccessibleQueryBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleQueryBuilder() {
            super((JComponent)((Object)QueryBuilder.this));
            AccessibleContext accessibleContext = QueryBuilder.this._schemaViewer.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", LocaleUtils.getDefaultableLocale((Component)((Object)QueryBuilder.this)));
            String string = resourceBundle.getString(QueryBuilder._KEY_SCHEMA_VIEWER_NAME);
            accessibleContext.setAccessibleName(string);
            accessibleContext = QueryBuilder.this._viewBuilder.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            accessibleContext = QueryBuilder.this._constraintBuilder.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            accessibleContext.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(1));
            accessibleContext = QueryBuilder.this._columnComponent.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            accessibleContext.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(2));
            accessibleContext = QueryBuilder.this._codeEditor.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            accessibleContext.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(3));
            accessibleContext = QueryBuilder.this._results.getAccessibleContext();
            accessibleContext.setAccessibleParent(QueryBuilder.this);
            accessibleContext.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(4));
        }
    }

    private class DDProvider
    implements DataDescriptorProvider {
        private DataDescriptor[] _descriptors;
        private PropertyChangeSupport _support;

        private DDProvider() {
        }

        public int getDescriptorCount() {
            return this._descriptors == null ? 0 : this._descriptors.length;
        }

        public void setDescriptors(DataDescriptor[] dataDescriptorArray) {
            int n = this._descriptors == null ? 0 : this._descriptors.length;
            int n2 = dataDescriptorArray == null ? 0 : dataDescriptorArray.length;
            boolean bl = false;
            bl = n == n2 && dataDescriptorArray != null && this._descriptors != null ? !Arrays.equals(dataDescriptorArray, this._descriptors) : true;
            this._descriptors = null;
            if (n2 != 0) {
                this._descriptors = new DataDescriptor[n2];
                System.arraycopy(dataDescriptorArray, 0, this._descriptors, 0, n2);
            }
            this._fireEvent(n, n2);
            this._fireEvent(bl);
        }

        public DataDescriptor getDescriptor(int n) {
            return this._descriptors[n];
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this._support == null) {
                this._support = new PropertyChangeSupport(this);
            }
            this._support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this._support != null) {
                this._support.removePropertyChangeListener(propertyChangeListener);
            }
        }

        private void _fireEvent(int n, int n2) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorCount", IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
            }
        }

        private void _fireEvent(boolean bl) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorChanged", false, bl);
            }
        }
    }

    private class UIListener
    implements ChangeListener,
    PropertyChangeListener,
    TableEditListener,
    TableMoveListener,
    TableResizeListener,
    SchemaViewerListener,
    VBRelationshipListener,
    VBOuterJoinListener,
    DocumentListener {
        private UIListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)QueryBuilder.this), true);
            int n = QueryBuilder.this._tabPanel.getSelectedIndex();
            if (!QueryBuilder.this.updatePage(n)) {
                // empty if block
            }
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)QueryBuilder.this), false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("dataConstraint".equals(string)) {
                QueryBuilder.this._constraintBuilderDirty = true;
            } else if ("_VISUAL_ORDER_CHANGED".equals(string)) {
                QueryBuilder.this._columnComponentDirty = true;
            } else if ("selectedColumns".equals(string)) {
                QueryBuilder.this._viewBuilderDirty = true;
            } else if ("includedRelationships".equals(string)) {
                QueryBuilder.this._viewBuilderDirty = true;
            } else if ("relationshipType".equals(string)) {
                QueryBuilder.this._viewBuilderDirty = true;
            }
            if (QueryBuilder.this._constraintBuilderDirty || QueryBuilder.this._columnComponentDirty || QueryBuilder.this._viewBuilderDirty) {
                QueryBuilder.this._results.cleanupResults();
            }
        }

        public void cellEditing(TableEvent tableEvent) {
        }

        public void cellEdited(TableEvent tableEvent) {
            QueryBuilder.this._columnComponentDirty = true;
        }

        public void columnResizing(TableEvent tableEvent) {
        }

        public void columnResized(TableEvent tableEvent) {
            if (tableEvent.getSource() == QueryBuilder.this._results.getSpreadTable()) {
                QueryBuilder.this._resultsDirty = true;
            }
        }

        public void rowResizing(TableEvent tableEvent) {
        }

        public void rowResized(TableEvent tableEvent) {
        }

        public void columnMoving(TableEvent tableEvent) {
        }

        public void columnMoved(TableEvent tableEvent) {
            if (tableEvent.getSource() == QueryBuilder.this._results.getSpreadTable()) {
                QueryBuilder.this._resultsDirty = true;
            }
        }

        public void rowMoving(TableEvent tableEvent) {
        }

        public void rowMoved(TableEvent tableEvent) {
            if (tableEvent.getSource() == QueryBuilder.this._columnComponent.getPropertyTable()) {
                QueryBuilder.this._columnComponentDirty = true;
            }
        }

        public void tableActivated(SchemaViewerEvent schemaViewerEvent) {
            QueryBuilder.this.tableSelected(schemaViewerEvent.getTable());
        }

        public void columnActivated(SchemaViewerEvent schemaViewerEvent) {
            QueryBuilder.this.columnSelected(schemaViewerEvent.getColumn());
        }

        public void relationshipAdding(ViewBuilderEvent viewBuilderEvent) {
        }

        public void relationshipAdded(ViewBuilderEvent viewBuilderEvent) {
            if (viewBuilderEvent.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dynamicRelationship = (DynamicRelationship)viewBuilderEvent.getRelationship();
                dynamicRelationship.addPropertyChangeListener(this);
            }
        }

        public void relationshipRemoving(ViewBuilderEvent viewBuilderEvent) {
        }

        public void relationshipRemoved(ViewBuilderEvent viewBuilderEvent) {
            if (viewBuilderEvent.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dynamicRelationship = (DynamicRelationship)viewBuilderEvent.getRelationship();
                dynamicRelationship.removePropertyChangeListener(this);
            }
        }

        public void outerJoinAdded(ViewBuilderEvent viewBuilderEvent) {
            QueryBuilder.this._viewBuilderDirty = true;
        }

        public void outerJoinRemoved(ViewBuilderEvent viewBuilderEvent) {
            QueryBuilder.this._viewBuilderDirty = true;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            QueryBuilder.this._sqlDirty = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            QueryBuilder.this._sqlDirty = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

