/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.schemaViewer;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.DynamicColumn;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.event.DynamicTableListener;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.schemaViewer.SchemaViewerEvent;
import oracle.bali.dbUI.schemaViewer.SchemaViewerListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeButtonDecoration;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDragSupport;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeLineDecoration;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeStackingDecoration;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.event.ListenerManager;

public class SchemaViewer
extends LWComponent
implements Accessible {
    private static final String _KEY_DATABASE = "SCHEMAVIEWER.DATABASE";
    private static final String _KEY_SCHEMA = "SCHEMAVIEWER.SCHEMA";
    private static final String _KEY_TABLE = "SCHEMAVIEWER.TABLE";
    private static final String _KEY_COLUMN = "SCHEMAVIEWER.COLUMN";
    private static final String _ACCESS_BUNDLE = "oracle.bali.dbUI.resource.AccessibleBundle";
    private DTree _tree = new DTree();
    private JScrollPane _scrollBox;
    private Database _database;
    private ListenerManager _listeners;

    public SchemaViewer() {
        this(null);
    }

    public SchemaViewer(Database database) {
        DTreeButtonDecoration dTreeButtonDecoration = new DTreeButtonDecoration();
        DTreeLineDecoration dTreeLineDecoration = new DTreeLineDecoration();
        DTreeStackingDecoration dTreeStackingDecoration = new DTreeStackingDecoration((DTreeDecoration)dTreeLineDecoration, (DTreeDecoration)dTreeButtonDecoration);
        this._tree.setDecoration((DTreeDecoration)dTreeStackingDecoration);
        DTreeDragSupport dTreeDragSupport = new DTreeDragSupport(this._tree);
        JScrollPane jScrollPane = new JScrollPane((Component)this._tree);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", jScrollPane);
        this._scrollBox = jScrollPane;
        this.setDatabase(database);
    }

    public void setDatabase(Database database) {
        this._database = database;
        Object[] objectArray = new String[]{"Schemas"};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        DTreeItemFactory dTreeItemFactory = new DTreeItemFactory(){

            public DTreeItem createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
                return new SchemaRoot(SchemaViewer.this.getDatabase());
            }
        };
        DTreeDeferringRoot dTreeDeferringRoot = new DTreeDeferringRoot(null, null, (OneDModel)arrayOneDModel, dTreeItemFactory);
        this._tree.setRoot((DTreeRootItem)dTreeDeferringRoot);
    }

    public Database getDatabase() {
        return this._database;
    }

    public void addSchemaViewerListener(SchemaViewerListener schemaViewerListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)schemaViewerListener);
    }

    public void removeSchemaViewerListener(SchemaViewerListener schemaViewerListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)schemaViewerListener);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
        this._tree.setEnabled(bl);
    }

    public Locale getLocale() {
        if (((Component)((Object)this)).isDisplayable()) {
            return super.getLocale();
        }
        return Locale.getDefault();
    }

    protected void fireTableActivateEvent(Table table) {
        int n = 2000;
        SchemaViewerEvent schemaViewerEvent = new SchemaViewerEvent(this, n, table);
        this.processEvent(schemaViewerEvent);
    }

    protected void fireColumnActivateEvent(Column column) {
        int n = 2001;
        SchemaViewerEvent schemaViewerEvent = new SchemaViewerEvent(this, n, column);
        this.processEvent(schemaViewerEvent);
    }

    protected Icon getIcon(Schema schema) {
        return null;
    }

    protected Icon getIcon(Table table) {
        return null;
    }

    protected Icon getIcon(Column column) {
        return null;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SchemaViewerEvent) {
            this.processSchemaViewerEvent((SchemaViewerEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processSchemaViewerEvent(SchemaViewerEvent schemaViewerEvent) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        int n = schemaViewerEvent.getID();
        switch (n) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((SchemaViewerListener)enumeration.nextElement()).columnActivated(schemaViewerEvent);
                }
                break;
            }
            case 2000: {
                while (enumeration.hasMoreElements()) {
                    ((SchemaViewerListener)enumeration.nextElement()).tableActivated(schemaViewerEvent);
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new AccessibleSchemaViewer();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    private class ColumnItem
    extends DTreeDeferredChild
    implements DTreeDragSource,
    PropertyChangeListener {
        private Transferable _transfer;
        private Column _column;
        private Icon _icon;

        public ColumnItem(Column column) {
            this._column = column;
            if (this._column instanceof DynamicColumn) {
                ((DynamicColumn)column).addPropertyChangeListener(this);
            }
            this._icon = SchemaViewer.this.getIcon(this._column);
        }

        public String getAccessibleType() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return resourceBundle.getString(SchemaViewer._KEY_COLUMN);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("name".equals(string)) {
                ((Component)((Object)SchemaViewer.this)).repaint();
            } else if ("dataType".equals(string)) {
                this._icon = SchemaViewer.this.getIcon(this._column);
                ((Component)((Object)SchemaViewer.this)).repaint();
            }
        }

        public Icon getIcon() {
            return this._icon;
        }

        public String getLabel() {
            return this._column.getDisplayName(SchemaViewer.this.getLocale());
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem dTreeItem) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem dTreeItem) {
            if (this._transfer == null) {
                this._transfer = ObjectTransferable.createTransferable((Object)this._column);
            }
            return this._transfer;
        }

        public void dragDropEnd(DTreeItem dTreeItem, int n) {
        }

        public void activate() {
            super.activate();
            SchemaViewer.this.fireColumnActivateEvent(this._column);
        }

        protected void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                SchemaViewer.this.fireColumnActivateEvent(this._column);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        protected void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                SchemaViewer.this.fireColumnActivateEvent(this._column);
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }

    private class TableItem
    extends BaseParent
    implements DTreeDragSource,
    DTreeItemFactory,
    PropertyChangeListener,
    DynamicTableListener {
        private Transferable _transfer;
        private Table _table;
        private Icon _icon;

        public TableItem(Table table) {
            super(null);
            this._table = table;
            this._icon = SchemaViewer.this.getIcon(this._table);
            if (this._table instanceof DynamicTable) {
                DynamicTable dynamicTable = (DynamicTable)this._table;
                dynamicTable.addPropertyChangeListener(this);
                dynamicTable.addTableListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("name".equals(string) || "displayName".equals(string)) {
                ((Component)((Object)SchemaViewer.this)).repaint();
            }
        }

        public String getAccessibleType() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return resourceBundle.getString(SchemaViewer._KEY_TABLE);
        }

        public void columnAdded(DynamicTableEvent dynamicTableEvent) {
            System.out.println("todo: SchemaViewer.update table " + dynamicTableEvent.getTable().getName() + " and add column " + dynamicTableEvent.getColumn().getName());
        }

        public void columnRemoved(DynamicTableEvent dynamicTableEvent) {
            System.out.println("todo: SchemaViewer.update table " + dynamicTableEvent.getTable().getName() + " and remove column " + dynamicTableEvent.getColumn().getName());
        }

        public void primaryKeyAdded(DynamicTableEvent dynamicTableEvent) {
        }

        public void primaryKeyRemoved(DynamicTableEvent dynamicTableEvent) {
        }

        public void foreignKeyAdded(DynamicTableEvent dynamicTableEvent) {
        }

        public void foreignKeyRemoved(DynamicTableEvent dynamicTableEvent) {
        }

        public void uniqueKeyAdded(DynamicTableEvent dynamicTableEvent) {
        }

        public void uniqueKeyRemoved(DynamicTableEvent dynamicTableEvent) {
        }

        public Icon getIcon() {
            return this._icon;
        }

        public Object getChildData(int n) {
            return this._table.getColumnDisplayName(n, SchemaViewer.this.getLocale());
        }

        protected void initChilderen() {
            this._table.getColumnCount();
        }

        public int getChildCount() {
            return this._table.getColumnCount();
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public DTreeItem createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            return new ColumnItem(this._table.getColumn(n));
        }

        public String getLabel() {
            return this._table.getDisplayName(SchemaViewer.this.getLocale());
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem dTreeItem) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem dTreeItem) {
            if (this._transfer == null) {
                this._transfer = ObjectTransferable.createTransferable((Object)this._table);
            }
            return this._transfer;
        }

        public void dragDropEnd(DTreeItem dTreeItem, int n) {
        }

        protected void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                mouseEvent.consume();
                SchemaViewer.this.fireTableActivateEvent(this._table);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        protected void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
                SchemaViewer.this.fireTableActivateEvent(this._table);
            } else {
                super.keyPressed(keyEvent);
            }
        }

        public void activate() {
            super.activate();
            SchemaViewer.this.fireTableActivateEvent(this._table);
        }
    }

    private class SchemaItem
    extends BaseParent
    implements DTreeItemFactory {
        private Icon _icon;
        private Schema _schema;

        public SchemaItem(Schema schema) {
            super(null);
            this._icon = SchemaViewer.this.getIcon(schema);
            this._schema = schema;
        }

        public Object getChildData(int n) {
            return this._schema.getTableDisplayName(n, SchemaViewer.this.getLocale());
        }

        public String getAccessibleType() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return resourceBundle.getString(SchemaViewer._KEY_SCHEMA);
        }

        protected void initChilderen() {
            this._schema.getTableCount();
        }

        public int getChildCount() {
            return this._schema.getTableCount();
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public DTreeItem createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            return new TableItem(this._schema.getTable(n));
        }

        public Icon getIcon() {
            return this._icon;
        }

        public String getLabel() {
            return this._schema.getDisplayName(SchemaViewer.this.getLocale());
        }
    }

    private class SchemaRoot
    extends BaseParent
    implements DTreeItemFactory {
        private Database _database;

        public SchemaRoot(Database database) {
            super(null);
            this._database = database;
        }

        public String getAccessibleType() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return resourceBundle.getString(SchemaViewer._KEY_DATABASE);
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public Object getChildData(int n) {
            return this._database == null ? null : this._database.getSchemaDisplayName(n, SchemaViewer.this.getLocale());
        }

        protected void initChilderen() {
            if (this._database != null) {
                this._database.getSchemaCount();
            }
        }

        protected int getChildCount() {
            return this._database == null ? 0 : this._database.getSchemaCount();
        }

        public DTreeItem createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            return new SchemaItem(this._database.getSchema(n));
        }

        public Icon getIcon() {
            return null;
        }

        public String getLabel() {
            return this._database == null ? null : this._database.getDisplayName(SchemaViewer.this.getLocale());
        }
    }

    private abstract class BaseParent
    extends DTreeDeferredParent {
        private boolean _childerenInited;

        public BaseParent(OneDModel oneDModel) {
            super(oneDModel);
        }

        public boolean isExpandable() {
            if (!this._childerenInited) {
                return true;
            }
            return super.isExpandable();
        }

        public int getItemCount() {
            if (!this._childerenInited) {
                DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)SchemaViewer.this), true);
                this.initChilderen();
                DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)SchemaViewer.this), false);
                this._childerenInited = true;
            }
            return this.getChildCount();
        }

        protected void initChilderen() {
        }

        protected abstract int getChildCount();
    }

    private class AccessibleSchemaViewer
    extends JComponent.AccessibleJComponent {
        public AccessibleSchemaViewer() {
            super((JComponent)((Object)SchemaViewer.this));
            SchemaViewer.this._tree.getAccessibleContext().setAccessibleParent(SchemaViewer.this);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return SchemaViewer.this._tree;
        }
    }
}

