/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.tableComponent;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.tableComponent.ColumnSelectInputHandler;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class TableComponent
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTION_CHANGED = "selectedColumns";
    public static final String PROPERTY_COLUMN_LOCATION = "columnLocation";
    public static final String PROPERTY_TABLE = "table";
    public static final int CHECK_COLUMN = 1;
    public static final int PRIMARY_KEY_COLUMN = 2;
    public static final int UNIQUE_KEY_COLUMN = 3;
    public static final int COLUMN_NAME_COLUMN = 4;
    public static final int DEFAULT_COLUMN_COUNT = 5;
    private static final String _ACCESS_BUNDLE = "oracle.bali.dbUI.resource.AccessibleBundle";
    private static final String _KEY_ALL_SELECTED = "TABLECOMPONENT.ALL_COLUMNS";
    private static final String _KEY_NOT_ALL_SELECTED = "TABLECOMPONENT.NOT_ALL_COLUMNS";
    private static final String _KEY_PRIMARY_KEY = "TABLECOMPONENT.PRIMARY_KEY";
    private static final String _KEY_UNIQUE_KEY = "TABLECOMPONENT.UNIQUE_KEY";
    private static final String _KEY_COLUMN_NAME = "TABLECOMPONENT.COLUMN_NAME";
    private static final String _KEY_ALL_SELECTED_DESC = "TABLECOMPONENT.ALL_COLUMNS_DESC";
    private static final String _KEY_NOT_ALL_SELECTED_DESC = "TABLECOMPONENT.NOT_ALL_COLUMNS_DESC";
    private static final String _KEY_PRIMARY_KEY_DESC = "TABLECOMPONENT.PRIMARY_KEY_DESC";
    private static final String _KEY_UNIQUE_KEY_DESC = "TABLECOMPONENT.UNIQUE_KEY_DESC";
    private static final String _KEY_COLUMN_NAME_DESC = "TABLECOMPONENT.COLUMN_NAME_DESC";
    private static final String _KEY_S_P_U = "TABLECOMPONENT.S_P_U";
    private static final String _KEY_S_P = "TABLECOMPONENT.S_P";
    private static final String _KEY_S = "TABLECOMPONENT.S";
    private static final String _KEY_S_U = "TABLECOMPONENT.S_U";
    private static final String _KEY_P_U = "TABLECOMPONENT.P_U";
    private static final String _KEY_P = "TABLECOMPONENT.P";
    private static final String _KEY_U = "TABLECOMPONENT.U";
    private static final String _KEY_NONE = "TABLECOMPONENT.NONE";
    private static final int _DEFAULT_NAME_WIDTH = 150;
    private static final int _HIDDEN_COLUMN = 0;
    private ArrayOneDModel _sortOrder;
    private GridSelectionManager _selection;
    GridSelectionManager _highlight;
    private SpreadTable _spreadTable;
    private JScrollPane _scrollBox;
    private Table _table;
    private int _lastItemSorted;
    private Listener _listener = new Listener();

    public TableComponent() {
        this(null);
    }

    public TableComponent(Table table) {
        DBUILookAndFeel dBUILookAndFeel = DBUILookAndFeel.getLookAndFeel();
        Painter painter = dBUILookAndFeel.getCheckPainter((JComponent)((Object)this));
        SortableTwoDModel sortableTwoDModel = new SortableTwoDModel(5, 0);
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(5);
        this._spreadTable = new _Table((TwoDModel)sortableTwoDModel, (OneDModel)arrayOneDModel, null);
        Header header = this._spreadTable.getColumnHeader();
        header.setPainter(1, painter);
        header.setItemInputHandler((HeaderItemInputHandler)new Sort());
        header.setCanMoveItems(false);
        header.setCanResizeItems(false);
        header.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        Grid grid = this._spreadTable.getGrid();
        grid.setHorizontalSeparatorsVisible(false);
        grid.setVerticalSeparatorsVisible(false);
        this._selection = GeneralGridSelectionManager.createSingleRowSelectionManager();
        this._highlight = GeneralGridSelectionManager.createMultipleRowSelectionManager();
        grid.setGridSelectionManager(this._selection);
        grid.setAppearanceManager((AppearanceManager)new Appear());
        grid.setFill(dBUILookAndFeel.getBackgroundPainter((JComponent)((Object)this)));
        this._spreadTable.setColumnVisible(0, false);
        this._spreadTable.setColumnWidth(1, 20);
        grid.setColumnCellInputHandler(1, (CellInputHandler)new ColumnSelectInputHandler(this));
        this._spreadTable.setBorder(null);
        grid.setColumnPainter(1, painter);
        this._spreadTable.setColumnWidth(2, 20);
        grid.setColumnPainter(2, (Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(2, 20);
        grid.setColumnPainter(3, (Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(3, 20);
        this._spreadTable.setColumnWidth(4, 150);
        grid.addEditListener((GridEditListener)this._listener);
        grid.addFocusListener(this._listener);
        this._scrollBox = new JScrollPane((Component)this._spreadTable);
        this._scrollBox.getViewport().addChangeListener(this._listener);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", this._scrollBox);
        this._sortOrder = new ArrayOneDModel(5);
        this._lastItemSorted = -1;
        this.setTable(table);
        this.updateUI();
    }

    public int getSelectedColumnCount() {
        int n = 0;
        TwoDModel twoDModel = this._getGrid().getModel();
        int n2 = twoDModel.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            if (Boolean.TRUE.equals(twoDModel.getData(1, n3))) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public Column[] getSelectedColumns() {
        int n = 0;
        TwoDModel twoDModel = this._getGrid().getModel();
        int n2 = twoDModel.getRowCount();
        Column[] columnArray = new Column[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (twoDModel.getData(1, n3) == Boolean.TRUE) {
                columnArray[n] = this.getColumn(n3);
                ++n;
            }
            ++n3;
        }
        Column[] columnArray2 = new Column[n];
        System.arraycopy(columnArray, 0, columnArray2, 0, n);
        return columnArray2;
    }

    public boolean isColumnSelected(Column column) {
        int n = this._getColumnIndex(column);
        TwoDModel twoDModel = this._getGrid().getModel();
        return twoDModel.getData(1, n) == Boolean.TRUE;
    }

    public void setColumnSelected(Column column, boolean bl) {
        this._setColumnSelected(column, bl, true);
    }

    public void setAllColumnsSelected(boolean bl) {
        TwoDModel twoDModel = this._getGrid().getModel();
        int n = twoDModel.getRowCount();
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        ArrayList<Column> arrayList = new ArrayList<Column>(2);
        int n2 = 0;
        while (n2 < n) {
            if (!bl2.equals(twoDModel.getData(1, n2))) {
                twoDModel.setData(1, n2, (Object)bl2);
                arrayList.add((Column)twoDModel.getData(0, n2));
            }
            ++n2;
        }
        this._columnSelectionChanged(arrayList.toArray(new Column[0]), bl);
        this._updateHeaderImage(bl);
    }

    public Table getTable() {
        return this._table;
    }

    public void setTable(Table table) {
        Table table2 = this.getTable();
        if (table != table2) {
            Column[] columnArray;
            if (table2 != null && table2 instanceof DynamicTable) {
                ((DynamicTable)table2).removeTableListener(this._listener);
            }
            if ((columnArray = this.getSelectedColumns()) != null && columnArray.length > 0) {
                this._columnSelectionChanged(columnArray, false);
            }
            this._table = table;
            if (this._table != null && this._table instanceof DynamicTable) {
                ((DynamicTable)this._table).addTableListener(this._listener);
            }
            ((Component)((Object)this)).firePropertyChange(PROPERTY_TABLE, table2, this._table);
            this.updateUI(this._table);
        }
    }

    public void setCellInputHandler(CellInputHandler cellInputHandler) {
        this._getGrid().setDefaultInputHandler(cellInputHandler);
    }

    public CellInputHandler getCellInputHandler() {
        return this._getGrid().getDefaultInputHandler();
    }

    public int getColumnLocation(Column column) {
        int n = this._getColumnIndex(column);
        if (n == -1) {
            return -1;
        }
        Grid grid = this._getGrid();
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n2 = SwingUtilities.convertPoint((Component)grid, (int)0, (int)grid.getRowPosition((int)n), (Component)((Object)this)).y;
        if (n2 < 0) {
            n2 = 0;
        } else if (dimension.height < 0) {
            n2 = 0;
        } else if (n2 >= dimension.height) {
            n2 = dimension.height;
        }
        return n2;
    }

    public Column getColumnAt(int n) {
        Grid grid = this._getGrid();
        int n2 = grid.getRowAt(n = SwingUtilities.convertPoint((Component)((Object)this), (int)0, (int)n, (Component)grid).y);
        if (n2 == -1) {
            return null;
        }
        return this.getColumn(n2);
    }

    public void setColumnHighlighted(Column column, boolean bl) {
        if (this.isColumnHighlighted(column) != bl) {
            int n = this._getColumnIndex(column);
            if (n == -1) {
                return;
            }
            TwoDSelection twoDSelection = new TwoDSelection(n, true);
            try {
                if (bl) {
                    this._highlight.addSelection(twoDSelection);
                    this._selection.addSelection(twoDSelection);
                } else {
                    this._highlight.removeSelection(twoDSelection);
                    this._selection.removeSelection(twoDSelection);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean isColumnHighlighted(Column column) {
        int n = this._getColumnIndex(column);
        if (n == -1) {
            return false;
        }
        return this._highlight.getSelection().containsRow(n);
    }

    public void setAllColumnsHighlighted(boolean bl) {
        OneDSelection oneDSelection = new OneDSelection(0, this._getGridModel().getRowCount() - 1);
        TwoDSelection twoDSelection = new TwoDSelection(null, oneDSelection);
        try {
            if (bl) {
                this._highlight.addSelection(twoDSelection);
                this._selection.addSelection(twoDSelection);
            } else {
                this._highlight.removeSelection(twoDSelection);
                this._selection.removeSelection(twoDSelection);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public Column getColumn(int n) {
        TwoDModel twoDModel = this._getGrid().getModel();
        return (Column)twoDModel.getData(0, n);
    }

    public int getColumnIndex(Column column) {
        return this._getColumnIndex(column);
    }

    public SpreadTable getSpreadTable() {
        return this._spreadTable;
    }

    public void addColumns(int n) {
        SortableTwoDModel sortableTwoDModel = this._getGridModel();
        int n2 = sortableTwoDModel.getColumnCount();
        sortableTwoDModel.addColumns(n2, n);
        ArrayOneDModel arrayOneDModel = this._getColumnModel();
        arrayOneDModel.addItems(n2, n);
        this._sortOrder.addItems(n2, n);
    }

    public void removeColumns(int n) {
        SortableTwoDModel sortableTwoDModel = this._getGridModel();
        int n2 = sortableTwoDModel.getColumnCount();
        int n3 = n2 - n;
        if (n3 < 5) {
            n3 = 5;
            n = n2 - n;
        }
        if (n <= 0) {
            return;
        }
        sortableTwoDModel.removeColumns(n3, n);
        ArrayOneDModel arrayOneDModel = this._getColumnModel();
        arrayOneDModel.removeItems(n3, n);
        this._sortOrder.removeItems(n3, n);
    }

    public final boolean areAllColumnsSelected() {
        TwoDModel twoDModel = this._getGrid().getModel();
        int n = twoDModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            if (twoDModel.getData(1, n2) == Boolean.FALSE) {
                return false;
            }
            ++n2;
        }
        return n > 0;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSpreadTable().getPreferredSize();
        Insets insets = this._scrollBox.getInsets();
        dimension.width += insets.left + insets.right + 1;
        dimension.height += insets.top + insets.bottom + 1;
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void requestFocus() {
        this.getSpreadTable().getGrid().requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        bl = ((Component)((Object)this)).isEnabled();
        this._scrollBox.setEnabled(bl);
        this._spreadTable.setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void updateUI() {
        super.updateUI();
        this.getSpreadTable().setColumnHeaderHeight(this._getHeaderHeight());
    }

    void sortColumn(int n) {
        boolean bl;
        SortableTwoDModel sortableTwoDModel = this._getGridModel();
        Object object = this._sortOrder.getData(n);
        boolean bl2 = bl = object == null;
        if (this._lastItemSorted == n) {
            if (object == null) {
                bl = false;
                this._sortOrder.setData(n, (Object)Boolean.TRUE);
            } else {
                bl = true;
                this._sortOrder.setData(n, null);
            }
        }
        sortableTwoDModel.sort(n, bl);
        this._lastItemSorted = n;
        this.locationChanged();
    }

    void focusLost(FocusEvent focusEvent) {
        Column column;
        Cell cell = this._getGrid().getFocusCell();
        if (cell != null && !this.isColumnHighlighted(column = this.getColumn(cell.row))) {
            TwoDSelection twoDSelection = new TwoDSelection(cell.row, true);
            try {
                this._selection.removeSelection(twoDSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    void focusGained(FocusEvent focusEvent) {
        int n = -1;
        Cell cell = this._getGrid().getFocusCell();
        if (cell == null) {
            if (this._getGrid().getRowCount() > 0) {
                n = 0;
            }
        } else {
            this._getGrid().requestFocus(cell.column, cell.row, (AWTEvent)focusEvent);
            n = cell.row;
        }
        if (n != -1) {
            TwoDSelection twoDSelection = new TwoDSelection(n, true);
            try {
                this._selection.addSelection(twoDSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    void selectRow(int n, AWTEvent aWTEvent) {
        try {
            this._selection.addSelection(new TwoDSelection(n, true));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        Grid grid = this._getGrid();
        grid.requestFocus(1, n, aWTEvent);
        grid.scrollCellIntoView(1, n);
    }

    private void _columnSelectionChanged(Column[] columnArray, boolean bl) {
        ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTION_CHANGED, bl ? null : columnArray, bl ? columnArray : null);
    }

    void locationChanged() {
        ((Component)((Object)this)).firePropertyChange(PROPERTY_COLUMN_LOCATION, null, null);
    }

    void updateUI(Table table) {
        SortableTwoDModel sortableTwoDModel;
        int n;
        int n2 = 0;
        if (table != null) {
            n2 = table.getColumnCount();
        }
        if ((n = (sortableTwoDModel = this._getGridModel()).getRowCount()) != n2) {
            TwoDModelEvent twoDModelEvent;
            sortableTwoDModel.removeRows(0, n);
            sortableTwoDModel.addRows(0, n2);
            int n3 = n2 - n;
            if (n3 > 0) {
                twoDModelEvent = new TwoDModelEvent((Object)this, 2004, n, n3);
                this._highlight.getTwoDModelListener().rowsAdded(twoDModelEvent);
            } else {
                n3 = -n3;
                twoDModelEvent = new TwoDModelEvent((Object)this, 2005, n - n3, n3);
                this._highlight.getTwoDModelListener().rowsRemoved(twoDModelEvent);
            }
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        int n4 = 0;
        while (n4 < n2) {
            sortableTwoDModel.setData(0, n4, (Object)table.getColumn(n4));
            sortableTwoDModel.setData(1, n4, (Object)Boolean.FALSE);
            sortableTwoDModel.setData(2, n4, null);
            sortableTwoDModel.setData(3, n4, null);
            sortableTwoDModel.setData(4, n4, (Object)table.getColumn(n4).getDisplayName(locale));
            ++n4;
        }
        this.updatePrimaryKeys();
        this.updateUniqueKeys();
        if (n2 != 0) {
            this._getGrid().requestFocus(1, 0, null);
        }
        this._lastItemSorted = -1;
        ((Container)((Object)this)).invalidate();
        this.locationChanged();
        ((Component)((Object)this)).repaint();
    }

    void restoreSelectedColumns(Column[] columnArray) {
        if (columnArray != null) {
            int n = columnArray.length;
            ArrayList<Column> arrayList = new ArrayList<Column>(2);
            int n2 = 0;
            while (n2 < n) {
                if (this._getColumnIndex(columnArray[n2]) == -1) {
                    arrayList.add(columnArray[n2]);
                } else {
                    this._setColumnSelected(columnArray[n2], true, false);
                }
                ++n2;
            }
            this._columnSelectionChanged(arrayList.toArray(new Column[0]), false);
        }
    }

    private void _setColumnSelected(Column column, boolean bl, boolean bl2) {
        if (this.isColumnSelected(column) != bl) {
            int n = this._getColumnIndex(column);
            TwoDModel twoDModel = this._getGrid().getModel();
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            twoDModel.setData(1, n, (Object)bl3);
            boolean bl4 = !bl ? false : this.areAllColumnsSelected();
            this._updateHeaderImage(bl4);
            if (bl2) {
                this._columnSelectionChanged(new Column[]{column}, bl);
            }
        }
    }

    void updatePrimaryKeys() {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        int n = table.getColumnCount();
        int n2 = table.getPrimaryKeyCount();
        TwoDModel twoDModel = this.getSpreadTable().getGrid().getModel();
        Image image = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/tableComponent/images/key.gif");
        int n3 = 0;
        while (n3 < n) {
            twoDModel.setData(2, n3, null);
            ++n3;
        }
        if (n2 != 0) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n) {
                    if (table.getPrimaryKey(n4).getName().equals(table.getColumn(n5).getName())) {
                        twoDModel.setData(2, n5, (Object)image);
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }

    void updateUniqueKeys() {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        int n = table.getColumnCount();
        int n2 = table.getUniqueKeyCount();
        TwoDModel twoDModel = this.getSpreadTable().getGrid().getModel();
        Image image = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/tableComponent/images/uniquekey.gif");
        int n3 = 0;
        while (n3 < n) {
            twoDModel.setData(3, n3, null);
            ++n3;
        }
        if (n2 != 0) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n) {
                    if (table.getUniqueKey(n4).getName().equals(table.getColumn(n5).getName())) {
                        twoDModel.setData(3, n5, (Object)image);
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }

    private int _getHeaderHeight() {
        DBUILookAndFeel dBUILookAndFeel = DBUILookAndFeel.getLookAndFeel();
        Painter painter = dBUILookAndFeel.getCheckPainter((JComponent)((Object)this));
        Header header = this.getSpreadTable().getColumnHeader();
        Dimension dimension = painter.getPreferredSize(header.getPaintContext());
        ImmInsets immInsets = header.getAppearance().getInsets();
        ImmInsets immInsets2 = header.getBorderInsets();
        return dimension.height + immInsets.top + immInsets.bottom + immInsets2.top + immInsets2.bottom + 4;
    }

    private Grid _getGrid() {
        return this.getSpreadTable().getGrid();
    }

    private void _updateHeaderImage(boolean bl) {
        Boolean bl2;
        ArrayOneDModel arrayOneDModel = this._getColumnModel();
        Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (bl2 != arrayOneDModel.getData(1)) {
            arrayOneDModel.setData(1, (Object)bl2);
        }
    }

    private int _getColumnIndex(Column column) {
        String string = column.getName();
        int n = this._getGrid().getRowCount();
        int n2 = 0;
        while (n2 < n) {
            Column column2 = this.getColumn(n2);
            if (string.equals(column2.getName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private ArrayOneDModel _getColumnModel() {
        ArrayOneDModel arrayOneDModel = (ArrayOneDModel)this.getSpreadTable().getColumnHeader().getModel();
        return arrayOneDModel;
    }

    SortableTwoDModel _getGridModel() {
        SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)this._getGrid().getModel();
        return sortableTwoDModel;
    }

    private class Listener
    extends DynamicTableAdapter
    implements FocusListener,
    GridEditListener,
    ChangeListener {
        private Listener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                FocusEvent focusEvent2 = new FocusEvent(focusEvent.getComponent(), focusEvent.getID(), focusEvent.isTemporary());
                SwingUtilities.invokeLater(new Runnable(this, focusEvent2){
                    private final /* synthetic */ FocusEvent val$copyEvent;
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = listener;
                        this.val$copyEvent = focusEvent;
                    }

                    public void run() {
                        Listener.access$800(this.this$1).focusGained(this.val$copyEvent);
                    }
                });
            } else {
                TableComponent.this.focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            TableComponent.this.focusLost(focusEvent);
        }

        public void cellEditing(GridEvent gridEvent) {
        }

        public void cellEdited(GridEvent gridEvent) {
            if (gridEvent.getColumn() == 1) {
                Column column = TableComponent.this.getColumn(gridEvent.getRow());
                TableComponent.this._columnSelectionChanged(new Column[]{column}, TableComponent.this.isColumnSelected(column));
                TableComponent.this._updateHeaderImage(TableComponent.this.areAllColumnsSelected());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            TableComponent.this.locationChanged();
        }

        public void columnAdded(DynamicTableEvent dynamicTableEvent) {
            Column[] columnArray = TableComponent.this.getSelectedColumns();
            TableComponent.this.updateUI(dynamicTableEvent.getTable());
            TableComponent.this.restoreSelectedColumns(columnArray);
        }

        public void columnRemoved(DynamicTableEvent dynamicTableEvent) {
            Column[] columnArray = TableComponent.this.getSelectedColumns();
            TableComponent.this.updateUI(dynamicTableEvent.getTable());
            TableComponent.this.restoreSelectedColumns(columnArray);
        }

        public void primaryKeyAdded(DynamicTableEvent dynamicTableEvent) {
            TableComponent.this.updatePrimaryKeys();
        }

        public void primaryKeyRemoved(DynamicTableEvent dynamicTableEvent) {
            TableComponent.this.updatePrimaryKeys();
        }

        public void uniqueKeyAdded(DynamicTableEvent dynamicTableEvent) {
            TableComponent.this.updateUniqueKeys();
        }

        public void uniqueKeyRemoved(DynamicTableEvent dynamicTableEvent) {
            TableComponent.this.updateUniqueKeys();
        }

        static /* synthetic */ TableComponent access$800(Listener listener) {
            return listener.TableComponent.this;
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                int n = header.getFocusItem();
                if (n == 1) {
                    TableComponent.this.setAllColumnsSelected(!TableComponent.this.areAllColumnsSelected());
                } else {
                    TableComponent.this.sortColumn(n);
                }
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class Sort
    extends NullInputHandler {
        private Sort() {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            boolean bl;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0x10) != 0;
            if (n2 >= 0 && n3 >= 0 && n2 <= header.getItemSize(n) && n3 <= header.getSize().height && bl) {
                if (n == 1) {
                    TableComponent.this.setAllColumnsSelected(!TableComponent.this.areAllColumnsSelected());
                } else {
                    TableComponent.this.sortColumn(n);
                }
            }
        }
    }

    private class _Table
    extends SpreadTable {
        _Table(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
            super(twoDModel, oneDModel, oneDModel2);
        }

        protected Grid createGrid(TwoDModel twoDModel) {
            return new _Grid(twoDModel);
        }

        protected Header createColumnHeader(OneDModel oneDModel) {
            return new _Header(oneDModel);
        }

        Column __getColumn(int n) {
            return TableComponent.this.getColumn(n);
        }

        private class _Header
        extends Header {
            public _Header(OneDModel oneDModel) {
                super(oneDModel);
            }

            protected Header.AccessibleHeader createAccessibleHeader() {
                return new AHeader();
            }

            private class AHeader
            extends Header.AccessibleHeader {
                private AHeader() {
                    super((Header)_Header.this);
                }

                public String getAccessibleName(int n) {
                    String string = null;
                    String string2 = null;
                    switch (n) {
                        case 1: {
                            if (TableComponent.this.areAllColumnsSelected()) {
                                string = TableComponent._KEY_ALL_SELECTED;
                                break;
                            }
                            string = TableComponent._KEY_NOT_ALL_SELECTED;
                            break;
                        }
                        case 2: {
                            string = TableComponent._KEY_PRIMARY_KEY;
                            break;
                        }
                        case 3: {
                            string = TableComponent._KEY_UNIQUE_KEY;
                            break;
                        }
                        case 4: {
                            string = TableComponent._KEY_COLUMN_NAME;
                            break;
                        }
                        default: {
                            string2 = super.getAccessibleName(n);
                        }
                    }
                    if (string != null) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                        string2 = resourceBundle.getString(string);
                    }
                    return string2;
                }

                public String getAccessibleDescription(int n) {
                    String string = null;
                    String string2 = null;
                    switch (n) {
                        case 1: {
                            if (TableComponent.this.areAllColumnsSelected()) {
                                string2 = TableComponent._KEY_ALL_SELECTED_DESC;
                                break;
                            }
                            string2 = TableComponent._KEY_NOT_ALL_SELECTED_DESC;
                            break;
                        }
                        case 2: {
                            string2 = TableComponent._KEY_PRIMARY_KEY_DESC;
                            break;
                        }
                        case 3: {
                            string2 = TableComponent._KEY_UNIQUE_KEY_DESC;
                            break;
                        }
                        case 4: {
                            string2 = TableComponent._KEY_COLUMN_NAME_DESC;
                            break;
                        }
                        default: {
                            string = super.getAccessibleDescription(n);
                        }
                    }
                    if (string2 != null) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                        string = resourceBundle.getString(string2);
                    }
                    return string;
                }
            }
        }

        private class _Grid
        extends Grid {
            public _Grid(TwoDModel twoDModel) {
                super(twoDModel);
            }

            public boolean requestFocus(int n, int n2, AWTEvent aWTEvent) {
                if (n < 5) {
                    n = 1;
                } else {
                    CellInputHandler cellInputHandler = this.getColumnCellInputHandler(n);
                    if (cellInputHandler == this.getDefaultInputHandler()) {
                        n = 1;
                    }
                }
                return super.requestFocus(n, n2, aWTEvent);
            }

            Column __getColumn(int n) {
                return _Table.this.__getColumn(n);
            }

            protected Grid.AccessibleGrid createAccessibleGrid() {
                return new AGrid();
            }

            private class AGrid
            extends Grid.AccessibleGrid {
                private AGrid() {
                    super((Grid)_Grid.this);
                }

                protected String getAccessibleName(int n, int n2, Object object) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, ((Component.AccessibleAWTComponent)((Object)this)).getLocale());
                    Column column = _Grid.this.__getColumn(n2);
                    boolean bl = TableComponent.this.isColumnSelected(column);
                    TwoDModel twoDModel = _Grid.this.getModel();
                    boolean bl2 = twoDModel.getData(3, n2) != null;
                    boolean bl3 = twoDModel.getData(2, n2) != null;
                    Object object2 = twoDModel.getData(4, n2);
                    Class clazz = column.getDataType();
                    String string = clazz.toString();
                    int n3 = string.lastIndexOf(".");
                    if (n3 != -1) {
                        string = string.substring(n3 + 1);
                    }
                    String string2 = object2 + "";
                    String string3 = this._getKey(bl, bl3, bl2);
                    String string4 = resourceBundle.getString(string3);
                    MessageFormat messageFormat = new MessageFormat(string4);
                    Object[] objectArray = new Object[]{object2, string};
                    string2 = messageFormat.format(objectArray);
                    return string2;
                }

                private String _getKey(boolean bl, boolean bl2, boolean bl3) {
                    String string = null;
                    string = bl ? (bl2 ? (bl3 ? TableComponent._KEY_S_P_U : TableComponent._KEY_S_P) : (bl3 ? TableComponent._KEY_S_U : TableComponent._KEY_S)) : (bl2 ? (bl3 ? TableComponent._KEY_P_U : TableComponent._KEY_P) : (bl3 ? TableComponent._KEY_U : TableComponent._KEY_NONE));
                    return string;
                }
            }
        }
    }

    private class Appear
    extends RowGroupingAppearance {
        private Appearance _checkAppearance;

        public Appear() {
            Color color = UIManager.getColor("normalIntensity");
            if (color != null) {
                color = ColorUtils.lighterShadeColor((Color)color);
                this.setColor(color);
            }
            this.setRows(1);
        }

        public Appearance getCellPaintingAppearance(int n, int n2) {
            Appearance appearance = super.getCellPaintingAppearance(n, n2);
            if (n == 1) {
                if (this._checkAppearance == null) {
                    this._checkAppearance = appearance.copy();
                    this._checkAppearance.setBackground(UIManager.getColor("control"));
                }
                appearance = this._checkAppearance;
            }
            return appearance;
        }
    }
}

