/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.util.jdbc.JDBCSchema;

public class JDBCDatabase
extends Database {
    private static final int _SCHEMA_NAME = 1;
    private Connection _connection;
    private String _name;
    private Schema[] _schemas;
    private String[] _schemaNames;

    public JDBCDatabase(Connection connection) {
        this._connection = connection;
        try {
            this._name = this._connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public int getSchemaCount() {
        if (this._schemaNames == null) {
            this._schemaNames = this.createSchemaNames();
        }
        return this._schemaNames == null ? 0 : this._schemaNames.length;
    }

    public Schema getSchema(int n) {
        if (this._schemas == null) {
            this._schemas = new Schema[this.getSchemaCount()];
        }
        if (this._schemas[n] == null) {
            this._schemas[n] = this.createSchema(n);
        }
        return this._schemas[n];
    }

    public String getSchemaName(int n) {
        if (this._schemaNames == null) {
            this._schemaNames = this.createSchemaNames();
        }
        return this._schemaNames == null ? null : this._schemaNames[n];
    }

    public String getSchemaDisplayName(int n, Locale locale) {
        return this.getSchemaName(n);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    protected Schema createSchema(int n) {
        return new JDBCSchema(this._connection, this, this.getSchemaName(n));
    }

    protected String[] createSchemaNames() {
        Object[] objectArray = null;
        try {
            ResultSet resultSet = this._connection.getMetaData().getSchemas();
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                vector.addElement(string);
            }
            objectArray = new String[vector.size()];
            if (vector.size() != 0) {
                vector.copyInto(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
        return objectArray;
    }
}

