/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.util.jdbc.JDBCTable;

public class JDBCSchema
extends Schema {
    private static final int _TABLE_NAME = 3;
    private Connection _connection;
    private String _schemaName;
    private Database _database;
    private Table[] _tables;
    private String[] _tableNames;

    public JDBCSchema(Connection connection, Database database, String string) {
        this._schemaName = string;
        this._connection = connection;
        this._database = database;
    }

    public Database getDatabase() {
        return this._database;
    }

    public String getName() {
        return this._schemaName;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public int getTableCount() {
        if (this._tableNames == null) {
            this._tableNames = this.createTableNames();
        }
        return this._tableNames == null ? 0 : this._tableNames.length;
    }

    public Table getTable(int n) {
        if (this._tables == null) {
            this._tables = new Table[this.getTableCount()];
        }
        if (this._tables[n] == null) {
            this._tables[n] = this.createTable(n);
        }
        return this._tables[n];
    }

    public String getTableName(int n) {
        if (this._tableNames == null) {
            this._tableNames = this.createTableNames();
        }
        return this._tableNames == null ? null : this._tableNames[n];
    }

    public String getTableDisplayName(int n, Locale locale) {
        return this.getTableName(n);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    protected Table createTable(int n) {
        String string = this.getTableName(n);
        return new JDBCTable(this._connection, this, string);
    }

    protected String[] createTableNames() {
        Object[] objectArray = null;
        try {
            ResultSet resultSet = this._connection.getMetaData().getTables(null, this.getName(), null, null);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                String string = resultSet.getString(3);
                vector.addElement(string);
            }
            objectArray = new String[vector.size()];
            if (vector.size() != 0) {
                vector.copyInto(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
        return objectArray;
    }
}

