/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;

class JoinMaker
extends ProxyInputHandler {
    private boolean _creatingJoin;
    private TableViewBuilderComponent _component;
    private ViewBuilder _builder;
    private CellInputHandler _handler;

    public JoinMaker(ViewBuilder viewBuilder, TableViewBuilderComponent tableViewBuilderComponent) {
        this._component = tableViewBuilderComponent;
        this._builder = viewBuilder;
        TableComponent tableComponent = tableViewBuilderComponent.getTableComponent();
        Grid grid = tableComponent.getSpreadTable().getGrid();
        this._handler = grid.getColumnCellInputHandler(1);
        grid.setColumnCellInputHandler(1, (CellInputHandler)this);
    }

    public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
        if (n == 1) {
            return this._handler;
        }
        return NullInputHandler.getCellInputHandler();
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isPopupTrigger()) {
            this._showMenu(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            return;
        }
        super.mousePressed(mouseEvent, grid, n, n2);
        if (n == 1) {
            return;
        }
        TableComponent tableComponent = this._component.getTableComponent();
        int n3 = mouseEvent.getClickCount();
        if (n3 == 1 && this._builder.isLinkCreationAllowed()) {
            this._creatingJoin = true;
            ViewBuilderLinkPort viewBuilderLinkPort = this._component.getLinkPort(n2);
            Point point = this._translatePoint(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
            this._builder.startLinkCreation(viewBuilderLinkPort, point.x, point.y);
        } else if (n3 == 2) {
            mouseEvent.consume();
            Column column = tableComponent.getColumn(n2);
            boolean bl = !this._builder.isColumnSelected(column);
            this._builder.setColumnSelected(column, bl);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mouseDragged(mouseEvent, grid, n, n2);
        if (this._creatingJoin) {
            mouseEvent.consume();
            Point point = this._translatePoint(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
            this._builder.continueLinkCreation(point.x, point.y);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isPopupTrigger()) {
            this._showMenu(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
        super.mouseReleased(mouseEvent, grid, n, n2);
        if (this._creatingJoin) {
            mouseEvent.consume();
            Point point = this._translatePoint(grid, n, n2, mouseEvent.getX(), mouseEvent.getY());
            this._builder.finishLinkCreation(point.x, point.y);
        }
        this._creatingJoin = false;
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyPressed(keyEvent, grid, n, n2);
        if (!keyEvent.isConsumed() && grid.isEnabled() && keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
            this._showMenu(grid, n, n2, grid.getSize().width / 2, grid.getRowHeight(n2) * 2 / 3);
        }
    }

    public void keyReleased(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
            keyEvent.consume();
        }
        super.keyReleased(keyEvent, grid, n, n2);
    }

    private void _showMenu(Grid grid, int n, int n2, int n3, int n4) {
        Point point = this._translatePoint(grid, n, n2, n3, n4);
        TableComponent tableComponent = this._component.getTableComponent();
        this._builder.displayPopupForColumn(tableComponent.getColumn(n2), point.x, point.y);
    }

    private Point _translatePoint(Grid grid, int n, int n2, int n3, int n4) {
        n3 += grid.getColumnPosition(n);
        n4 += grid.getRowPosition(n2);
        Object object = grid;
        while (object != null && object != this._builder) {
            Point point = object.getLocation();
            n3 += point.x;
            n4 += point.y;
            object = object.getParent();
        }
        return new Point(n3, n4);
    }
}

