/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.ColumnLinkPort;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.util.FocusUtils;

public class JInternalFrameTableComponent
extends JInternalFrame
implements TableViewBuilderComponent {
    private ColumnLinkPort[] _ports;
    private Listener _listener = new Listener();
    private static final boolean _sJDK1_3;
    private Component _lastFocused;

    public JInternalFrameTableComponent() {
        this.setMaximizable(false);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setResizable(true);
    }

    public int getLinkPortCount() {
        TableComponent tableComponent = this.getTableComponent();
        return tableComponent == null ? 0 : tableComponent.getSpreadTable().getGrid().getRowCount();
    }

    public ViewBuilderLinkPort getLinkPort(int n) {
        int n2 = this.getLinkPortCount();
        if (n < 0 || n >= n2) {
            return null;
        }
        if (this._ports == null) {
            this._ports = new ColumnLinkPort[n2];
        }
        if (this._ports[n] == null) {
            TableComponent tableComponent = this.getTableComponent();
            this._ports[n] = new ColumnLinkPort(this, tableComponent, tableComponent.getColumn(n));
        }
        return this._ports[n];
    }

    public ViewBuilderLinkPort getLinkPortAt(int n, int n2) {
        if (this.isIcon()) {
            return null;
        }
        Grid grid = this.getTableComponent().getSpreadTable().getGrid();
        Point point = SwingUtilities.convertPoint(this, n, n2, (Component)grid);
        Point point2 = grid.getCanvasOrigin();
        point.x += point2.x;
        point.y += point2.y;
        if (point.x < 0 || point.x > grid.getInnerWidth() || point.y < 0 || point.y > grid.getInnerHeight()) {
            return null;
        }
        int n3 = this.getLinkPortCount();
        Rectangle rectangle = null;
        int n4 = 0;
        while (n4 < n3) {
            ViewBuilderLinkPort viewBuilderLinkPort = this.getLinkPort(n4);
            rectangle = viewBuilderLinkPort.getBounds();
            if (rectangle.contains(n, n2)) {
                return viewBuilderLinkPort;
            }
            ++n4;
        }
        return null;
    }

    public ColumnLinkPort getColumnLinkPort(Column column) {
        TableComponent tableComponent = this.getTableComponent();
        if (tableComponent == null) {
            return null;
        }
        int n = tableComponent.getColumnIndex(column);
        return n == -1 ? null : (ColumnLinkPort)this.getLinkPort(n);
    }

    public Rectangle getComponentBounds() {
        if (this.isIcon()) {
            return this.desktopIcon.getBounds();
        }
        return this.getBounds();
    }

    public void setComponentBounds(Rectangle rectangle) {
        this.setBounds(rectangle);
    }

    public TableComponent getTableComponent() {
        Container container = this.getContentPane();
        if (container != null && container.getComponentCount() != 0) {
            return (TableComponent)((Object)container.getComponent(0));
        }
        return null;
    }

    public boolean close() {
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }

    public Point getTableComponentLocation() {
        Point point = new Point(0, 0);
        Container container = this.getContentPane();
        while (container != null) {
            Point point2 = container.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            if ((container = container.getParent()) == this) break;
        }
        return point;
    }

    public void setTableComponent(TableComponent tableComponent) {
        TableComponent tableComponent2 = this.getTableComponent();
        if (tableComponent != tableComponent2) {
            Table table;
            if (tableComponent2 != null) {
                this.getContentPane().remove((Component)((Object)tableComponent2));
            }
            this._clearPorts();
            if (tableComponent2 != null) {
                ((Component)((Object)tableComponent2)).removePropertyChangeListener(this._listener);
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    tableComponent2.getSpreadTable().getColumnHeader().removeFocusListener(this._listener);
                    tableComponent2.getSpreadTable().getGrid().removeFocusListener(this._listener);
                }
                if ((table = tableComponent2.getTable()) instanceof DynamicTable) {
                    ((DynamicTable)table).removeTableListener(this._listener);
                }
            }
            if (tableComponent != null) {
                ((Container)((Object)tableComponent)).addPropertyChangeListener(this._listener);
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    tableComponent.getSpreadTable().getColumnHeader().addFocusListener(this._listener);
                    tableComponent.getSpreadTable().getGrid().addFocusListener(this._listener);
                }
                if ((table = tableComponent.getTable()) instanceof DynamicTable) {
                    ((DynamicTable)table).addTableListener(this._listener);
                }
                this.getContentPane().add((Component)((Object)tableComponent));
            }
        }
    }

    public void setImage(Image image) {
        this.setFrameIcon(new ImageIcon(image));
    }

    public Image getImage() {
        Icon icon = this.getFrameIcon();
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        super.reshape(n, n2, n3, n4);
        Rectangle rectangle2 = this.getBounds();
        this.firePropertyChange("bounds", rectangle, rectangle2);
    }

    public Dimension getPreferredSize() {
        JMenuBar jMenuBar;
        JRootPane jRootPane = this.getRootPane();
        if (_sJDK1_3) {
            jRootPane.setPreferredSize(new Dimension(jRootPane.getPreferredSize()));
        }
        Dimension dimension = super.getPreferredSize();
        if (_sJDK1_3) {
            jRootPane.setPreferredSize(null);
        }
        if ((jMenuBar = this.getMenuBar()) != null) {
            Dimension dimension2 = jMenuBar.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height + 2;
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        super.setIcon(bl);
        int n = this._ports == null ? 0 : this._ports.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._ports[n2] != null) {
                this._ports[n2].invalidate();
            }
            ++n2;
        }
    }

    public boolean isComponentSelected() {
        return this.isSelected();
    }

    public void setComponentSelected(boolean bl) {
        try {
            this.setSelected(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.isSelected();
        super.setSelected(bl);
        boolean bl3 = this.isSelected();
        this.firePropertyChange("componentSelected", bl2, bl3);
    }

    public Component getFocusOwner() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            return this._lastFocused;
        }
        return super.getFocusOwner();
    }

    private void _clearPorts() {
        int n = this._ports == null ? 0 : this._ports.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._ports[n2] != null) {
                this._ports[n2].cleanup();
            }
            ++n2;
        }
        this._ports = null;
    }

    private void _reorderPorts() {
        if (this._ports != null) {
            TableComponent tableComponent = this.getTableComponent();
            Vector<ColumnLinkPort> vector = new Vector<ColumnLinkPort>();
            vector.setSize(this.getLinkPortCount());
            int n = 0;
            while (n < this._ports.length) {
                if (this._ports[n] != null) {
                    vector.setElementAt(this._ports[n], tableComponent.getColumnIndex(this._ports[n].getColumn()));
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                this._ports[n2] = (ColumnLinkPort)vector.get(n2);
                ++n2;
            }
        }
    }

    static {
        String string = System.getProperty("java.version");
        _sJDK1_3 = string == null ? false : string.startsWith("1.3");
    }

    private class Listener
    extends DynamicTableAdapter
    implements PropertyChangeListener,
    FocusListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("table".equals(string)) {
                Table table = (Table)propertyChangeEvent.getOldValue();
                if (table instanceof DynamicTable) {
                    ((DynamicTable)table).removeTableListener(this);
                }
                JInternalFrameTableComponent.this._clearPorts();
                Table table2 = (Table)propertyChangeEvent.getNewValue();
                if (table2 instanceof DynamicTable) {
                    ((DynamicTable)table2).addTableListener(this);
                }
            } else if ("columnLocation".equals(string)) {
                JInternalFrameTableComponent.this._reorderPorts();
            }
        }

        public void columnAdded(DynamicTableEvent dynamicTableEvent) {
            JInternalFrameTableComponent.this._clearPorts();
        }

        public void columnRemoved(DynamicTableEvent dynamicTableEvent) {
            JInternalFrameTableComponent.this._clearPorts();
        }

        public void focusGained(FocusEvent focusEvent) {
            JInternalFrameTableComponent.this._lastFocused = (Component)focusEvent.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

