/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.dnd.DBUIDnDSupport;
import oracle.bali.dbUI.dnd.DBUITransferableProvider;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameViewBuilderCanvas;
import oracle.bali.share.datatransfer.TransferUtils;

class VBJDKDropSupport
implements DropTargetListener {
    private JInternalFrameViewBuilderCanvas _canvas;

    public VBJDKDropSupport(JInternalFrameViewBuilderCanvas jInternalFrameViewBuilderCanvas) {
        this._canvas = jInternalFrameViewBuilderCanvas;
    }

    public void addDropTarget(JComponent jComponent) {
        if (jComponent.getDropTarget() == null) {
            DropTarget dropTarget = new DropTarget(jComponent, this);
        }
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = jComponent.getComponent(n2);
            if (component instanceof JComponent) {
                this.addDropTarget((JComponent)component);
            }
            ++n2;
        }
    }

    public void removeDropTarget(JComponent jComponent) {
        DropTarget dropTarget = jComponent.getDropTarget();
        if (dropTarget != null) {
            try {
                dropTarget.removeDropTargetListener(this);
                jComponent.setDropTarget(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = jComponent.getComponent(n2);
            if (component instanceof JComponent) {
                this.removeDropTarget((JComponent)component);
            }
            ++n2;
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this._dragProcessing(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this._dragProcessing(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this._dragProcessing(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        if (!this._canvas.isEnabled()) {
            dropTargetDropEvent.rejectDrop();
            dropTargetContext.dropComplete(false);
            return;
        }
        dropTargetDropEvent.acceptDrop(2);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Table table = null;
        Column column = null;
        if (transferable.isDataFlavorSupported(DBUIDataFlavors.COLUMN_FLAVOR)) {
            try {
                object2 = transferable.getTransferData(DBUIDataFlavors.COLUMN_FLAVOR);
                if (object2 instanceof Column) {
                    table = column.getTable();
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        if (table == null && transferable.isDataFlavorSupported(DBUIDataFlavors.TABLE_FLAVOR)) {
            try {
                object2 = transferable.getTransferData(DBUIDataFlavors.TABLE_FLAVOR);
                if (object2 instanceof Table) {
                    table = (Table)object2;
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        if (table == null && (object2 = DBUIDnDSupport.getDBUITransferableProviders()) != null) {
            int n = 0;
            while (table == null && n < ((DBUITransferableProvider[])object2).length) {
                object = object2[n].getDBUITransferData(transferable, DBUIDataFlavors.COLUMN_FLAVOR);
                if (object instanceof Column) {
                    column = (Column)object;
                    table = column.getTable();
                } else {
                    object = object2[n].getDBUITransferData(transferable, DBUIDataFlavors.TABLE_FLAVOR);
                    if (object instanceof Table) {
                        table = (Table)object;
                    }
                }
                ++n;
            }
        }
        object2 = this._canvas.getViewBuilder();
        if (table != null) {
            Point point = dropTargetDropEvent.getLocation();
            object = dropTargetContext.getComponent();
            while (object != object2 && object != null) {
                point.x += ((Component)object).getX();
                point.y += ((Component)object).getY();
                object = ((Component)object).getParent();
            }
            DBUILookAndFeel.getLookAndFeel().setCursor(this._canvas, true);
            ((ViewBuilder)object2).addTable(table, point.x, point.y, true);
            DBUILookAndFeel.getLookAndFeel().setCursor(this._canvas, false);
            if (column != null) {
                ((ViewBuilder)object2).setColumnSelected(column, true);
            }
            ((Component)object2).repaint();
        }
        dropTargetContext.dropComplete(table != null);
    }

    private void _dragProcessing(DropTargetDragEvent dropTargetDragEvent) {
        if (this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray;
        if (this._canvas.isEnabled() && (dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors()) != null) {
            DBUITransferableProvider[] dBUITransferableProviderArray = DBUIDnDSupport.getDBUITransferableProviders();
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.TABLE_FLAVOR) || TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.COLUMN_FLAVOR)) {
                    return true;
                }
                if (dBUITransferableProviderArray != null) {
                    int n2 = 0;
                    while (n2 < dBUITransferableProviderArray.length) {
                        if (dBUITransferableProviderArray[n2].isDBUIDataFlavorSupported(dataFlavorArray[n], DBUIDataFlavors.TABLE_FLAVOR) || dBUITransferableProviderArray[n2].isDBUIDataFlavorSupported(dataFlavorArray[n], DBUIDataFlavors.COLUMN_FLAVOR)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return false;
    }
}

