/*
 * Decompiled with CFR 0.152.
 */
package ice.debug;

import ice.util.Defs;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;

public class Debug
extends RuntimeException {
    private static final int PRINT_TO_STDOUT = 0;
    private static final int PRINT_TO_FILE = 1;
    private static final int PRINT_TO_SOCKET = 2;
    private static int printDestination;
    private static String EOL;
    private static PrintStream ps;
    private static String dumpFileName;
    private static OutputStream socketOutput;
    public static final boolean all;
    public static final boolean trace;
    public static final boolean ex;
    public static final boolean chk;
    public static final boolean extra;
    public static final boolean check = true;

    static {
        all = Debug.debugProperty("ice.debug.debug");
        trace = all || Debug.debugProperty("ice.debug.trace");
        ex = all || Debug.debugProperty("ice.debug.exception");
        chk = all || Debug.debugProperty("ice.debug.check");
        extra = all || Debug.debugProperty("ice.debug.extra");
        Debug.doInit();
    }

    private static void doInit() {
        EOL = Debug.sysProperty("line.separator");
        if (EOL == null) {
            EOL = "\n";
        }
        String file_str = Debug.sysProperty("ice.debug.file");
        String socket_str = Debug.sysProperty("ice.debug.socket");
        if (file_str != null) {
            printDestination = 1;
            dumpFileName = file_str;
        } else if (socket_str != null) {
            printDestination = 2;
            int colon = socket_str.indexOf(58);
            if (colon >= 0) {
                int port = -1;
                try {
                    port = Integer.parseInt(socket_str.substring(colon + 1));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (1 <= port && port <= 65535) {
                    String address_str = socket_str.substring(0, colon);
                    try {
                        InetAddress address = InetAddress.getByName(address_str);
                        Socket socket = new Socket(address, port);
                        try {
                            socketOutput = socket.getOutputStream();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.out);
                            socket.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
            }
            if (socketOutput == null) {
                System.out.println("ERROR: Failed to connect to socket " + socket_str);
            }
        } else {
            printDestination = 0;
            boolean likePosix = "/".equals(Debug.sysProperty("file.separator"));
            ps = likePosix ? System.err : System.out;
        }
        if (trace) {
            char[] stars = new char[79];
            int i = stars.length;
            while (i != 0) {
                stars[--i] = 42;
            }
            StringBuffer sb = new StringBuffer(300);
            sb.append(stars);
            sb.append(EOL);
            sb.append(new Date().toString());
            sb.append(EOL);
            sb.append("JVM: ");
            sb.append(Debug.sysProperty("java.version"));
            sb.append(", ");
            sb.append(Debug.sysProperty("java.vendor"));
            sb.append(", ");
            sb.append(Debug.sysProperty("os.name"));
            sb.append(", ");
            sb.append(Debug.sysProperty("os.version"));
            sb.append(EOL);
            sb.append(stars);
            Debug.doOutput(sb.toString());
        }
    }

    private static String sysProperty(String name) {
        try {
            String string = Defs.sysProperty(name);
            return string;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static boolean debugProperty(String name) {
        String value = Debug.sysProperty(name);
        if (value != null) {
            return value.equals("yes") || value.equals("true");
        }
        return false;
    }

    private Debug(String s) {
        super(s);
    }

    private static char[] getStackPrintout(Throwable ex) {
        CharArrayWriter buffer = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buffer);
        ex.printStackTrace(writer);
        writer.flush();
        return buffer.toCharArray();
    }

    public static String getStackPrintoutAsString(Throwable ex) {
        CharArrayWriter buffer = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buffer);
        ex.printStackTrace(writer);
        writer.flush();
        return buffer.toString();
    }

    private static boolean getMethodAndSourcePositions(char[] data, int start, int end, int[] result) {
        while (start != end) {
            if (data[end - 1] > ' ') break;
            --end;
        }
        if (start != end && data[end - 1] == ')') {
            char c;
            int source_end;
            int source_start = source_end = end - 1;
            block1: while (start != source_start && (c = data[--source_start]) != ')') {
                if (c != '(') continue;
                int method_end = source_start++;
                while (method_end != start && data[method_end - 1] <= ' ') {
                    --method_end;
                }
                int method_start = method_end;
                while (start != method_start) {
                    char c2;
                    if ((c2 = data[--method_start]) > ' ') {
                        if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == '<' || c2 == '>') continue;
                        break block1;
                    }
                    if (++method_start == method_end) break block1;
                    result[0] = method_start;
                    result[1] = method_end;
                    result[2] = source_start;
                    result[3] = source_end;
                    return true;
                }
                break block1;
            }
        }
        return false;
    }

    private static String getStackMethod(RuntimeException ex, int depth) {
        char[] data = Debug.getStackPrintout(ex);
        int cursor = 0;
        int end = data.length;
        int[] positions = new int[4];
        do {
            int line_start = cursor;
            int line_end = end;
            while (cursor != end) {
                char c = data[cursor];
                ++cursor;
                if (c != '\n' && c != '\r') continue;
                line_end = cursor;
                break;
            }
            if (!Debug.getMethodAndSourcePositions(data, line_start, line_end, positions)) continue;
            if (depth == 0) {
                int method_start = positions[0];
                int method_end = positions[1];
                return new String(data, method_start, method_end - method_start);
            }
            --depth;
        } while (cursor != end);
        return null;
    }

    public static void p(String str) {
        Debug.doOutput(str);
    }

    public static void s() {
        Debug.s("STACK TRACE");
    }

    public static void s(String message) {
        Debug x = new Debug(message);
        x.fillInStackTrace();
        Debug.doOutput(Debug.getStackPrintoutAsString(x));
    }

    public static void trace(String s) {
        if (trace) {
            RuntimeException ex = new RuntimeException();
            ex.fillInStackTrace();
            String methodName = Debug.getStackMethod(ex, 1);
            Debug.doOutput('[' + methodName + ']' + EOL + "    " + s);
        }
    }

    public static void traceAsIs(String s) {
        if (trace) {
            Debug.doOutput(s);
        }
    }

    public static void traceStack(String title) {
        if (trace) {
            Debug x = new Debug(title);
            x.fillInStackTrace();
            Debug.doOutput(Debug.getStackPrintoutAsString(x));
        }
    }

    public static void ex(Throwable exception) {
        if (ex) {
            Debug.doOutput("EXCEPTION: " + exception + EOL + Debug.getStackPrintoutAsString(exception));
        }
    }

    private static void doOutput(String str) {
        if (printDestination == 1) {
            Debug.doOutput_file(str);
        } else if (printDestination == 2) {
            OutputStream output = socketOutput;
            if (output != null) {
                try {
                    output.write(str.getBytes());
                    output.write(10);
                    output.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                    try {
                        output.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace(System.out);
                    }
                    socketOutput = null;
                }
            }
        } else if (!str.endsWith(EOL)) {
            ps.println(str);
        } else {
            ps.print(str);
            ps.flush();
        }
    }

    private static final void doOutput_file(String str) {
        byte[] data;
        try {
            data = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            data = str.getBytes();
        }
        try {
            FileOutputStream fos = new FileOutputStream(dumpFileName, true);
            try {
                fos.write(data);
                if (!str.endsWith(EOL)) {
                    int i = 0;
                    int N = EOL.length();
                    while (i != N) {
                        fos.write(EOL.charAt(i));
                        ++i;
                    }
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static void bug() {
        throw new RuntimeException("***BUG***: SEE SOURCE FOR DETAILS");
    }

    public static void checkOrderLE(int a, int b, int c) {
        if (a > b) {
            Debug.bug();
        }
        if (b > c) {
            Debug.bug();
        }
    }

    public static void checkOrderLE(int a, int b, int c, int d) {
        if (a > b) {
            Debug.bug();
        }
        if (b > c) {
            Debug.bug();
        }
        if (c > d) {
            Debug.bug();
        }
    }
}

