/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.BaseFunction;
import ice.mozilla.javascript.ClassNameHelper;
import ice.mozilla.javascript.ClassOutput;
import ice.mozilla.javascript.ClassRepository;
import ice.mozilla.javascript.ClassShutter;
import ice.mozilla.javascript.ContextListener;
import ice.mozilla.javascript.DefaultErrorReporter;
import ice.mozilla.javascript.DefiningClassLoader;
import ice.mozilla.javascript.ErrorReporter;
import ice.mozilla.javascript.EvaluatorException;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.FunctionObject;
import ice.mozilla.javascript.GeneratedClassLoader;
import ice.mozilla.javascript.IRFactory;
import ice.mozilla.javascript.Interpreter;
import ice.mozilla.javascript.JavaMembers;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.LazilyLoadedCtor;
import ice.mozilla.javascript.ListenerArray;
import ice.mozilla.javascript.NativeArray;
import ice.mozilla.javascript.NativeBoolean;
import ice.mozilla.javascript.NativeCall;
import ice.mozilla.javascript.NativeDate;
import ice.mozilla.javascript.NativeError;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.NativeMath;
import ice.mozilla.javascript.NativeNumber;
import ice.mozilla.javascript.NativeObject;
import ice.mozilla.javascript.NativeScript;
import ice.mozilla.javascript.NativeString;
import ice.mozilla.javascript.NativeWith;
import ice.mozilla.javascript.Node;
import ice.mozilla.javascript.NotAFunctionException;
import ice.mozilla.javascript.ObjToIntMap;
import ice.mozilla.javascript.Parser;
import ice.mozilla.javascript.PropertyException;
import ice.mozilla.javascript.RegExpProxy;
import ice.mozilla.javascript.Script;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.SecurityController;
import ice.mozilla.javascript.SecuritySupport;
import ice.mozilla.javascript.TokenStream;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.WrapFactory;
import ice.mozilla.javascript.WrapHandler;
import ice.mozilla.javascript.debug.DebugReader;
import ice.mozilla.javascript.debug.Debugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    static final String defaultResource = "ice.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    static final boolean printICode = false;
    private static Class codegenClass = null;
    static final boolean check = true;
    static boolean isCachingEnabled = true;
    private static Hashtable threadContexts = new Hashtable(11);
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    private static final Object contextListenersLock;
    private static Object[] contextListeners;
    NativeCall currentActivation;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    private SecurityController securityController;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private Hashtable activationNames;
    int interpreterLine;
    String interpreterSourceFile;
    int instructionCount;
    int instructionThreshold;

    public Context() {
        this.$init$();
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        Object[] array = contextListeners;
        if (array != null) {
            int i = array.length;
            while (i-- != 0) {
                ((ContextListener)array[i]).contextCreated(this);
            }
        }
    }

    public Context(SecuritySupport x) {
        this();
        this.setClassShutter(x);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context old = Context.getCurrentContext();
        if (cx == null) {
            if (old != null) {
                cx = old;
            } else {
                cx = new Context();
                Context.setThreadContext(cx);
            }
        } else if (cx.enterCount != 0) {
            if (cx != old) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (old != null) {
            cx = old;
        } else {
            Context.setThreadContext(cx);
        }
        ++cx.enterCount;
        Object[] listeners = contextListeners;
        if (listeners != null) {
            int i = listeners.length;
            while (i-- != 0) {
                ((ContextListener)listeners[i]).contextEntered(cx);
            }
        }
        return cx;
    }

    public static void exit() {
        Object[] listeners;
        boolean released = false;
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (cx.enterCount < 1) {
            Context.codeBug();
        }
        --cx.enterCount;
        if (cx.enterCount == 0) {
            released = true;
            Context.setThreadContext(null);
        }
        if ((listeners = contextListeners) != null) {
            int i = listeners.length;
            while (i-- != 0) {
                ((ContextListener)listeners[i]).contextExited(cx);
            }
            if (released) {
                int i2 = listeners.length;
                while (i2-- != 0) {
                    ((ContextListener)listeners[i2]).contextReleased(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContextListener(ContextListener listener) {
        Object object = contextListenersLock;
        synchronized (object) {
            contextListeners = ListenerArray.add(contextListeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextListener(ContextListener listener) {
        Object object = contextListenersLock;
        synchronized (object) {
            contextListeners = ListenerArray.remove(contextListeners, listener);
        }
    }

    public static Context getCurrentContext() {
        if (threadLocalCx != null) {
            try {
                Context context = (Context)threadLocalGet.invoke(threadLocalCx, null);
                return context;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    private static void setThreadContext(Context cx) {
        if (threadLocalCx != null) {
            try {
                threadLocalSet.invoke(threadLocalCx, cx);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        if (cx != null) {
            threadContexts.put(t, cx);
        } else {
            threadContexts.remove(t);
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        Object[] array = this.listeners;
        if (array != null && version != this.version) {
            this.firePropertyChangeImpl(array, languageVersionProperty, new Integer(this.version), new Integer(version));
        }
        this.version = version;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 4 2003 01 16";
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        ErrorReporter result = this.errorReporter;
        Object[] array = this.listeners;
        if (array != null && this.errorReporter != reporter) {
            this.firePropertyChangeImpl(array, errorReporterProperty, this.errorReporter, reporter);
        }
        this.errorReporter = reporter;
        return result;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale loc) {
        Locale result = this.locale;
        this.locale = loc;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.add(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.remove(this.listeners, listener);
        }
    }

    void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object[] array = this.listeners;
        if (array != null) {
            this.firePropertyChangeImpl(array, property, oldValue, newValue);
        }
    }

    private void firePropertyChangeImpl(Object[] array, String property, Object oldValue, Object newValue) {
        int i = array.length;
        while (i-- != 0) {
            Object obj = array[i];
            if (!(obj instanceof PropertyChangeListener)) continue;
            PropertyChangeListener l = (PropertyChangeListener)obj;
            l.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
        }
    }

    public static void reportWarning(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportWarning(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportWarning(message, filename, linep[0], null, 0);
    }

    public static void reportError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportError(message, filename, linep[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
            return cx.getErrorReporter().runtimeError(message, sourceName, lineno, lineSource, lineOffset);
        }
        throw new EvaluatorException(message);
    }

    static EvaluatorException reportRuntimeError0(String messageId) {
        return Context.reportRuntimeError(Context.getMessage0(messageId));
    }

    static EvaluatorException reportRuntimeError1(String messageId, Object arg1) {
        return Context.reportRuntimeError(Context.getMessage1(messageId, arg1));
    }

    static EvaluatorException reportRuntimeError2(String messageId, Object arg1, Object arg2) {
        return Context.reportRuntimeError(Context.getMessage2(messageId, arg1, arg2));
    }

    static EvaluatorException reportRuntimeError3(String messageId, Object arg1, Object arg2, Object arg3) {
        return Context.reportRuntimeError(Context.getMessage3(messageId, arg1, arg2, arg3));
    }

    public static EvaluatorException reportRuntimeError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        return Context.reportRuntimeError(message, filename, linep[0], null, 0);
    }

    public Scriptable initStandardObjects(ScriptableObject scope) {
        return this.initStandardObjects(scope, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scope, boolean sealed) {
        if (scope == null) {
            scope = new NativeObject();
        }
        BaseFunction.init(this, scope, sealed);
        NativeObject.init(this, scope, sealed);
        Scriptable objectProto = ScriptableObject.getObjectPrototype(scope);
        Scriptable functionProto = ScriptableObject.getFunctionPrototype(scope);
        functionProto.setPrototype(objectProto);
        if (scope.getPrototype() == null) {
            scope.setPrototype(objectProto);
        }
        NativeError.init(this, scope, sealed);
        NativeGlobal.init(this, scope, sealed);
        NativeArray.init(this, scope, sealed);
        NativeString.init(this, scope, sealed);
        NativeBoolean.init(this, scope, sealed);
        NativeNumber.init(this, scope, sealed);
        NativeDate.init(this, scope, sealed);
        NativeMath.init(this, scope, sealed);
        NativeWith.init(this, scope, sealed);
        NativeCall.init(this, scope, sealed);
        NativeScript.init(this, scope, sealed);
        new LazilyLoadedCtor(scope, "RegExp", "ice.mozilla.javascript.regexp.NativeRegExp", sealed);
        new LazilyLoadedCtor(scope, "Packages", "ice.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "java", "ice.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "getClass", "ice.mozilla.javascript.NativeJavaPackage", sealed);
        String adapterClass = "ice.mozilla.javascript.JavaAdapter";
        String adapterProperty = "JavaAdapter";
        try {
            adapterClass = System.getProperty(adapterClass, adapterClass);
            adapterProperty = System.getProperty("ice.mozilla.javascript.JavaAdapterClassName", adapterProperty);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        new LazilyLoadedCtor(scope, adapterProperty, adapterClass, sealed);
        return scope;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public Object evaluateString(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) throws JavaScriptException {
        try {
            StringReader in = new StringReader(source);
            Object object = this.evaluateReader(scope, in, sourceName, lineno, securityDomain);
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public Object evaluateReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException, JavaScriptException {
        Script script = this.compileReader(scope, in, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    public synchronized boolean stringIsCompilableUnit(String source) {
        StringReader in = new StringReader(source);
        TokenStream ts = new TokenStream(in, null, null, 1);
        ErrorReporter currentReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean errorseen = false;
        try {
            try {
                IRFactory irf = new IRFactory(ts, null);
                Parser p = new Parser(irf);
                p.parse(ts);
            }
            catch (IOException ioe) {
                errorseen = true;
            }
            catch (EvaluatorException ee) {
                errorseen = true;
            }
        }
        finally {
            this.setErrorReporter(currentReporter);
        }
        return !errorseen || !ts.eof();
    }

    public Script compileReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        return (Script)this.compile(scope, in, sourceName, lineno, securityDomain, false);
    }

    public Function compileFunction(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        StringReader in = new StringReader(source);
        try {
            Function function = (Function)this.compile(scope, in, sourceName, lineno, securityDomain, true);
            return function;
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public String decompileScript(Script script, Scriptable scope, int indent) {
        NativeScript ns = (NativeScript)script;
        ns.initScript(scope);
        return ns.decompile(this, indent, false);
    }

    public String decompileFunction(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, false);
        }
        return "function " + fun.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public String decompileFunctionBody(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, true);
        }
        return "[native code]\n";
    }

    public Scriptable newObject(Scriptable scope) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scope, "Object", null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scope, constructorName, null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName, Object[] args) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object ctorVal = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), constructorName);
        if (ctorVal instanceof Function) {
            Function ctor = (Function)ctorVal;
            if (args == null) {
                args = ScriptRuntime.emptyArgs;
            }
            return ctor.construct(this, scope, args);
        }
        if (ctorVal == Scriptable.NOT_FOUND) {
            String message = Context.getMessage1("msg.ctor.not.found", constructorName);
            throw new PropertyException(message);
        }
        String message = Context.getMessage1("msg.not.ctor", constructorName);
        throw new NotAFunctionException(message);
    }

    public Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(length);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Scriptable newArray(Scriptable scope, Object[] elements) {
        NativeArray result = new NativeArray(elements);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Object[] getElements(Scriptable object) {
        long longLen = NativeArray.getLengthProperty(object);
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int len = (int)longLen;
        if (len == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = new Object[len];
        int i = 0;
        while (i < len) {
            Object elem = ScriptableObject.getProperty(object, i);
            result[i] = elem == Scriptable.NOT_FOUND ? Undefined.instance : elem;
            ++i;
        }
        return result;
    }

    public static boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(value);
    }

    public static double toNumber(Object value) {
        return ScriptRuntime.toNumber(value);
    }

    public static String toString(Object value) {
        return ScriptRuntime.toString(value);
    }

    public static Scriptable toObject(Object value, Scriptable scope) {
        return ScriptRuntime.toObject(scope, value, null);
    }

    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        if (value == null && staticType != null) {
            return null;
        }
        return ScriptRuntime.toObject(scope, value, staticType);
    }

    public static Object toType(Object value, Class desiredType) throws IllegalArgumentException {
        return NativeJavaObject.coerceType(desiredType, value, false);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public void setGeneratingDebug(boolean generatingDebug) {
        this.generatingDebugChanged = true;
        if (generatingDebug && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = generatingDebug;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean generatingSource) {
        this.generatingSource = generatingSource;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        if (optimizationLevel < 0) {
            optimizationLevel = -1;
        } else if (optimizationLevel > 9) {
            optimizationLevel = 9;
        }
        if (codegenClass == null) {
            optimizationLevel = -1;
        }
        this.optimizationLevel = optimizationLevel;
    }

    public String getClassName() {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        return nameHelper != null ? nameHelper.getClassName() : null;
    }

    public void setClassName(String className) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setClassName(className);
        }
    }

    public String getTargetClassFileName() {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            return nameHelper.getTargetClassFileName();
        }
        return null;
    }

    public void setTargetClassFileName(String classFileName) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setTargetClassFileName(classFileName);
        }
    }

    public String getTargetPackage() {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        return nameHelper != null ? nameHelper.getTargetPackage() : null;
    }

    public void setTargetPackage(String targetPackage) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setTargetPackage(targetPackage);
        }
    }

    public ClassRepository getClassRepository() {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        return nameHelper != null ? nameHelper.getClassRepository() : null;
    }

    public void setClassRepository(ClassRepository classRepository) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setClassRepository(classRepository);
        }
    }

    public ClassOutput getClassOutput() {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            return nameHelper.getClassOutput();
        }
        return null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setClassOutput(classOutput);
        }
    }

    public void setSecurityController(SecurityController controller) {
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Cannot overwrite existing SecurityController object");
        }
        this.securityController = controller;
    }

    public void setSecuritySupport(SecuritySupport x) {
        this.setClassShutter(x);
    }

    public void setClassShutter(ClassShutter shutter) {
        if (shutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = shutter;
    }

    final ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public void setTargetExtends(Class extendsClass) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setTargetExtends(extendsClass);
        }
    }

    public void setTargetImplements(Class[] implementsClasses) {
        ClassNameHelper nameHelper = ClassNameHelper.get(this);
        if (nameHelper != null) {
            nameHelper.setTargetImplements(implementsClasses);
        }
    }

    public final Object getThreadLocal(Object key) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    public void putThreadLocal(Object key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public void removeThreadLocal(Object key) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(key);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public void setCompileFunctionsWithDynamicScope(boolean flag) {
        this.compileFunctionsWithDynamicScopeFlag = flag;
    }

    public static void setCachingEnabled(boolean cachingEnabled) {
        if (isCachingEnabled && !cachingEnabled) {
            JavaMembers.classTable = new Hashtable();
            ClassNameHelper.clearCache();
        }
        isCachingEnabled = cachingEnabled;
        FunctionObject.setCachingEnabled(cachingEnabled);
    }

    public void setWrapHandler(WrapHandler wrapHandler) {
        if (wrapHandler == null) {
            this.setWrapFactory(new WrapFactory());
        } else {
            this.setWrapFactory(new WrapHandlerProxy(wrapHandler));
        }
    }

    public WrapHandler getWrapHandler() {
        WrapFactory f = this.getWrapFactory();
        if (f instanceof WrapHandlerProxy) {
            return ((WrapHandlerProxy)f)._handler;
        }
        return null;
    }

    public void setWrapFactory(WrapFactory wrapFactory) {
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public void setDebugger(Debugger debugger, Object contextData) {
        this.debugger = debugger;
        this.debuggerData = contextData;
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public void setInstructionObserverThreshold(int threshold) {
        this.instructionThreshold = threshold;
    }

    protected void observeInstructionCount(int instructionCount) {
    }

    public GeneratedClassLoader createClassLoader(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx != null ? cx.getLocale() : Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(defaultResource, locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    private Object compile(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain, boolean returnFunction) throws IOException {
        Object dynamicDoamin = null;
        if (this.securityController != null) {
            dynamicDoamin = this.securityController.getDynamicSecurityDomain(securityDomain);
        }
        if (this.debugger != null && in != null) {
            in = new DebugReader(in);
        }
        TokenStream ts = new TokenStream(in, scope, sourceName, lineno);
        return this.compile(scope, ts, dynamicDoamin, in, returnFunction);
    }

    static {
        try {
            Class<?> cl = Class.forName("java.lang.ThreadLocal");
            threadLocalGet = cl.getMethod("get", null);
            threadLocalSet = cl.getMethod("set", ScriptRuntime.ObjectClass);
            threadLocalCx = cl.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        contextListenersLock = new Object();
    }

    private Interpreter getCompiler() {
        if (codegenClass != null) {
            try {
                Interpreter interpreter = (Interpreter)codegenClass.newInstance();
                return interpreter;
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException x) {
                // empty catch block
            }
        }
        return new Interpreter();
    }

    private Object compile(Scriptable scope, TokenStream ts, Object dynamicSecurityDomain, Reader in, boolean returnFunction) throws IOException {
        Interpreter compiler = this.optimizationLevel == -1 ? new Interpreter() : this.getCompiler();
        ClassNameHelper nameHelper = this.optimizationLevel == -1 ? null : ClassNameHelper.get(this);
        this.errorCount = 0;
        IRFactory irf = compiler.createIRFactory(ts, nameHelper, scope);
        Parser p = new Parser(irf);
        Node tree = (Node)p.parse(ts);
        if (tree == null) {
            return null;
        }
        tree = compiler.transform(tree, ts, scope);
        if (returnFunction) {
            Node first = tree.getFirstChild();
            if (first == null) {
                return null;
            }
            tree = (Node)first.getProp(5);
            if (tree == null) {
                return null;
            }
        }
        if (in instanceof DebugReader) {
            DebugReader dr = (DebugReader)in;
            tree.putProp(31, dr.getSaved());
        }
        Object result = compiler.compile(this, scope, tree, dynamicSecurityDomain, this.securityController, nameHelper);
        return this.errorCount == 0 ? result : null;
    }

    static String getSourcePositionFromStack(int[] linep) {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            return null;
        }
        if (cx.interpreterLine > 0 && cx.interpreterSourceFile != null) {
            linep[0] = cx.interpreterLine;
            return cx.interpreterSourceFile;
        }
        CharArrayWriter writer = new CharArrayWriter();
        RuntimeException re = new RuntimeException();
        re.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        int open = -1;
        int close = -1;
        int colon = -1;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ':') {
                colon = i;
            } else if (c == '(') {
                open = i;
            } else if (c == ')') {
                close = i;
            } else if (c == '\n' && open != -1 && close != -1 && colon != -1 && open < colon && colon < close) {
                String fileStr = s.substring(open + 1, colon);
                if (!fileStr.endsWith(".java")) {
                    String lineStr = s.substring(colon + 1, close);
                    try {
                        linep[0] = Integer.parseInt(lineStr);
                        String string = fileStr;
                        return string;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                colon = -1;
                close = -1;
                open = -1;
            }
            ++i;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> c = Class.forName("ice.mozilla.javascript.regexp.RegExpImpl");
                RegExpProxy regExpProxy = this.regExpProxy = (RegExpProxy)c.newInstance();
                return regExpProxy;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return this.regExpProxy;
    }

    private void newArrayHelper(Scriptable scope, Scriptable array) {
        array.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Array");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s = (Scriptable)ctor;
            array.setPrototype((Scriptable)s.get("prototype", s));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        return this.securityController;
    }

    public boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String name) {
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(name, name);
    }

    public boolean isActivationNeeded(String name) {
        if ("arguments".equals(name)) {
            return true;
        }
        return this.activationNames != null && this.activationNames.containsKey(name);
    }

    public void removeActivationName(String name) {
        if (this.activationNames != null) {
            this.activationNames.remove(name);
        }
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }

    private void $init$() {
        this.generatingSource = true;
    }

    private static class WrapHandlerProxy
    extends WrapFactory {
        WrapHandler _handler;

        WrapHandlerProxy(WrapHandler handler) {
            this._handler = handler;
        }

        public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
            if (obj == null) {
                return obj;
            }
            Object result = this._handler.wrap(scope, obj, staticType);
            if (result == null) {
                result = super.wrap(cx, scope, obj, staticType);
            }
            return result;
        }

        public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
            Object wrap = this._handler.wrap(scope, obj, obj.getClass());
            if (wrap instanceof Scriptable) {
                return (Scriptable)wrap;
            }
            if (wrap == null) {
                return super.wrapNewObject(cx, scope, obj);
            }
            throw new RuntimeException("Please upgrade from WrapHandler to WrapFactory");
        }
    }
}

