/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.BaseFunction;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.EcmaError;
import ice.mozilla.javascript.EvaluatorException;
import ice.mozilla.javascript.Invoker;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.WrappedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class FunctionObject
extends BaseFunction {
    static final long serialVersionUID = -4074285335521944312L;
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final String INVOKER_MASTER_CLASS = "ice.mozilla.javascript.optimizer.InvokerImpl";
    static Invoker invokerMaster = FunctionObject.newInvokerMaster();
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    transient Method method;
    transient Constructor ctor;
    transient Invoker invoker;
    private transient Class[] types;
    private int parmsLength;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;

    public FunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        String methodName;
        if (methodOrConstructor instanceof Constructor) {
            this.ctor = (Constructor)methodOrConstructor;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            methodName = this.ctor.getName();
        } else {
            this.method = (Method)methodOrConstructor;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            methodName = this.method.getName();
        }
        this.functionName = name;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != Context.class || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", methodName);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || this.types[0] != Context.class || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", methodName);
                }
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = this.types.length;
            int i = 0;
            while (i < this.parmsLength) {
                Class type = this.types[i];
                if (type != ScriptRuntime.ObjectClass && type != ScriptRuntime.StringClass && type != ScriptRuntime.BooleanClass && !ScriptRuntime.NumberClass.isAssignableFrom(type) && !Scriptable.class.isAssignableFrom(type) && type != Boolean.TYPE && type != Byte.TYPE && type != Short.TYPE && type != Integer.TYPE && type != Float.TYPE && type != Double.TYPE) {
                    throw Context.reportRuntimeError1("msg.bad.parms", methodName);
                }
                ++i;
            }
        }
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        ScriptRuntime.setFunctionProtoAndParent(scope, this);
        Context cx = Context.getCurrentContext();
        this.useDynamicScope = cx != null && cx.hasCompileFunctionsWithDynamicScope();
    }

    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    public int getLength() {
        return this.getArity();
    }

    public static Method[] findMethods(Class clazz, String name) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), name);
    }

    static Method[] findMethods(Method[] methods, String name) {
        ObjArray v = null;
        Method first = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i] != null && methods[i].getName().equals(name)) {
                if (first == null) {
                    first = methods[i];
                } else {
                    if (v == null) {
                        v = new ObjArray(5);
                        v.add(first);
                    }
                    v.add(methods[i]);
                }
            }
            ++i;
        }
        if (v == null) {
            if (first == null) {
                return null;
            }
            Method[] single = new Method[]{first};
            return single;
        }
        Object[] result = new Method[v.size()];
        v.toArray(result);
        return result;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] cached = methodsCache;
        if (cached != null && cached[0].getDeclaringClass() == clazz) {
            return cached;
        }
        Method[] methods = null;
        try {
            if (!sawSecurityException) {
                methods = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException e) {
            sawSecurityException = true;
        }
        if (methods == null) {
            methods = clazz.getMethods();
        }
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (sawSecurityException ? methods[i].getDeclaringClass() != clazz : !Modifier.isPublic(methods[i].getModifiers())) {
                methods[i] = null;
            } else {
                ++count;
            }
            ++i;
        }
        Method[] result = new Method[count];
        int j = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2] != null) {
                result[j++] = methods[i2];
            }
            ++i2;
        }
        if (result.length > 0 && Context.isCachingEnabled) {
            methodsCache = result;
        }
        return result;
    }

    public void addAsConstructor(Scriptable scope, Scriptable prototype) {
        ScriptRuntime.setFunctionProtoAndParent(scope, this);
        this.setImmunePrototypeProperty(prototype);
        prototype.setParentScope(this);
        int attr = 7;
        FunctionObject.defineProperty(prototype, "constructor", this, 7);
        String name = prototype.getClassName();
        FunctionObject.defineProperty(scope, name, this, 2);
        this.setParentScope(scope);
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, Class desired) {
        if (desired == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(arg);
        }
        if (desired == ScriptRuntime.IntegerClass || desired == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(arg));
        }
        if (desired == ScriptRuntime.BooleanClass || desired == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (desired == ScriptRuntime.DoubleClass || desired == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(arg));
        }
        if (desired == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(cx, scope, arg);
        }
        if (desired == ScriptRuntime.ObjectClass) {
            return arg;
        }
        throw Context.reportRuntimeError1("msg.cant.convert", desired.getName());
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        int i;
        Object[] invokeArgs;
        if (this.parmsLength < 0) {
            return this.callVarargs(cx, thisObj, args, false);
        }
        if (!this.isStatic) {
            Class<Object> clazz = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!clazz.isInstance(thisObj)) {
                if ((thisObj = thisObj.getPrototype()) != null && this.useDynamicScope) continue;
                throw NativeGlobal.typeError1("msg.incompat.call", this.functionName, scope);
            }
        }
        if (this.parmsLength == args.length) {
            invokeArgs = args;
            i = this.types == null ? this.parmsLength : 0;
        } else {
            invokeArgs = new Object[this.parmsLength];
            i = 0;
        }
        while (i < this.parmsLength) {
            Object arg;
            Object object = arg = i < args.length ? args[i] : Undefined.instance;
            if (this.types != null) {
                arg = FunctionObject.convertArg(cx, this, arg, this.types[i]);
            }
            invokeArgs[i] = arg;
            ++i;
        }
        try {
            Object result = this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(cx, thisObj, invokeArgs);
            Scriptable scriptable = this.hasVoidReturn ? Undefined.instance : result;
            return scriptable;
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(cx, scope, e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable parent;
            Scriptable result = this.method != null ? (Scriptable)this.callVarargs(cx, null, args, true) : (Scriptable)this.call(cx, scope, null, args);
            if (result.getPrototype() == null) {
                result.setPrototype(this.getClassPrototype());
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
            return result;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable result;
            try {
                result = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw WrappedException.wrapException(e);
            }
            catch (InstantiationException e) {
                throw WrappedException.wrapException(e);
            }
            result.setPrototype(this.getClassPrototype());
            result.setParentScope(this.getParentScope());
            Object val = this.call(cx, scope, result, args);
            if (val != null && val != Undefined.instance && val instanceof Scriptable) {
                return (Scriptable)val;
            }
            return result;
        }
        return super.construct(cx, scope, args);
    }

    private final Object doInvoke(Context cx, Object thisObj, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Invoker master = invokerMaster;
        if (master != null) {
            if (this.invoker == null) {
                this.invoker = master.createInvoker(cx, this.method, this.types);
            }
            try {
                Object object = this.invoker.invoke(thisObj, args);
                return object;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        return this.method.invoke(thisObj, args);
    }

    private Object callVarargs(Context cx, Scriptable thisObj, Object[] args, boolean inNewExpr) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] invokeArgs = new Object[]{cx, thisObj, args, this};
                Object result = this.doInvoke(cx, null, invokeArgs);
                Object object = this.hasVoidReturn ? Undefined.instance : result;
                return object;
            }
            Boolean b = inNewExpr ? Boolean.TRUE : Boolean.FALSE;
            Object[] invokeArgs = new Object[]{cx, args, this, b};
            Object object = this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(cx, null, invokeArgs);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof EvaluatorException) {
                throw (EvaluatorException)target;
            }
            if (target instanceof EcmaError) {
                throw (EcmaError)target;
            }
            Scriptable scope = thisObj == null ? this : thisObj;
            throw JavaScriptException.wrapException(cx, scope, target);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    static void setCachingEnabled(boolean enabled) {
        if (!enabled) {
            methodsCache = null;
            invokerMaster = null;
        } else if (invokerMaster == null) {
            invokerMaster = FunctionObject.newInvokerMaster();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        boolean hasConstructor = this.ctor != null;
        Member member = hasConstructor ? (Member)this.ctor : (Member)this.method;
        FunctionObject.writeMember(out, member);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Member member = FunctionObject.readMember(in);
        if (member instanceof Method) {
            this.method = (Method)member;
            this.types = this.method.getParameterTypes();
        } else {
            this.ctor = (Constructor)member;
            this.types = this.ctor.getParameterTypes();
        }
    }

    static void writeMember(ObjectOutputStream out, Member member) throws IOException {
        if (member == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        out.writeBoolean(member instanceof Method);
        out.writeObject(member.getName());
        out.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            FunctionObject.writeParameters(out, ((Method)member).getParameterTypes());
        } else {
            FunctionObject.writeParameters(out, ((Constructor)member).getParameterTypes());
        }
    }

    static Member readMember(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        boolean isMethod = in.readBoolean();
        String name = (String)in.readObject();
        Class declaring = (Class)in.readObject();
        Class[] parms = FunctionObject.readParameters(in);
        try {
            if (isMethod) {
                Method method = declaring.getMethod(name, parms);
                return method;
            }
            Constructor constructor = declaring.getConstructor(parms);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Cannot find member: " + e);
        }
    }

    static void writeParameters(ObjectOutputStream out, Class[] parms) throws IOException {
        out.writeShort(parms.length);
        int i = 0;
        while (i < parms.length) {
            block5: {
                Class parm = parms[i];
                out.writeBoolean(parm.isPrimitive());
                if (!parm.isPrimitive()) {
                    out.writeObject(parm);
                } else {
                    int j = 0;
                    while (j < primitives.length) {
                        if (parm.equals(primitives[j])) {
                            out.writeByte(j);
                            break block5;
                        }
                        ++j;
                    }
                    throw new IllegalArgumentException("Primitive " + parm + " not found");
                }
            }
            ++i;
        }
    }

    static Class[] readParameters(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class[] result = new Class[in.readShort()];
        int i = 0;
        while (i < result.length) {
            result[i] = !in.readBoolean() ? (Class)in.readObject() : primitives[in.readByte()];
            ++i;
        }
        return result;
    }

    private static Invoker newInvokerMaster() {
        return null;
    }
}

