/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeString;
import ice.mozilla.javascript.ObjToIntMap;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptable {
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int MAX_PROTOTYPE_ID = 14;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;
    private boolean prototypeFlag;
    private static final boolean check = true;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray();
        obj.prototypeFlag = true;
        obj.addAsPrototype(14, cx, scope, sealed);
    }

    private NativeArray() {
        this.$init$();
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long length) {
        this.$init$();
        int intLength = (int)length;
        if ((long)intLength == length && intLength > 0) {
            if (intLength > 10000) {
                intLength = 10000;
            }
            this.dense = new Object[intLength];
            int i = 0;
            while (i < intLength) {
                this.dense[i] = Scriptable.NOT_FOUND;
                ++i;
            }
        }
        this.length = length;
    }

    public NativeArray(Object[] array) {
        this.$init$();
        this.dense = array;
        this.length = array.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getIdDefaultAttributes(int id) {
        if (id == 1) {
            return 6;
        }
        return super.getIdDefaultAttributes(id);
    }

    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.wrap_double(this.length);
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.setLength(value);
            return;
        }
        super.setIdValue(id, value);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return NativeArray.jsConstructor(cx, scope, args, f, thisObj == null);
                }
                case 3: {
                    return NativeArray.js_toString(cx, thisObj, args);
                }
                case 4: {
                    return NativeArray.js_toLocaleString(cx, thisObj, args);
                }
                case 5: {
                    return NativeArray.js_join(cx, thisObj, args);
                }
                case 6: {
                    return NativeArray.js_reverse(cx, thisObj, args);
                }
                case 7: {
                    return NativeArray.js_sort(cx, scope, thisObj, args);
                }
                case 8: {
                    return NativeArray.js_push(cx, thisObj, args);
                }
                case 9: {
                    return NativeArray.js_pop(cx, thisObj, args);
                }
                case 10: {
                    return NativeArray.js_shift(cx, thisObj, args);
                }
                case 11: {
                    return NativeArray.js_unshift(cx, thisObj, args);
                }
                case 12: {
                    return NativeArray.js_splice(cx, scope, thisObj, args);
                }
                case 13: {
                    return NativeArray.js_concat(cx, scope, thisObj, args);
                }
                case 14: {
                    return this.js_slice(cx, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    public Object get(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start);
    }

    public boolean has(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index] != Scriptable.NOT_FOUND;
        }
        return super.has(index, start);
    }

    private static long toArrayIndex(String id) {
        long index;
        double d = ScriptRuntime.toNumber(id);
        if (d == d && (double)(index = ScriptRuntime.toUint32(d)) == d && index != 0xFFFFFFFFL && Long.toString(index).equals(id)) {
            return index;
        }
        return -1;
    }

    public void put(String id, Scriptable start, Object value) {
        long index;
        if (start == this && (index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
        }
        super.put(id, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        if (start == this) {
            if (this.length <= (long)index) {
                this.length = (long)index + 1L;
            }
            if (this.dense != null && 0 <= index && index < this.dense.length) {
                this.dense[index] = value;
                return;
            }
        }
        super.put(index, start, value);
    }

    public void delete(int index) {
        if (!this.isSealed() && this.dense != null && 0 <= index && index < this.dense.length) {
            this.dense[index] = Scriptable.NOT_FOUND;
            return;
        }
        super.delete(index);
    }

    public Object[] getIds() {
        Object[] superIds = super.getIds();
        if (this.dense == null) {
            return superIds;
        }
        int N = this.dense.length;
        long currentLength = this.length;
        if ((long)N > currentLength) {
            N = (int)currentLength;
        }
        if (N == 0) {
            return superIds;
        }
        int shift = superIds.length;
        Object[] ids = new Object[shift + N];
        System.arraycopy(this.dense, 0, ids, shift, N);
        int presentCount = 0;
        int i = 0;
        while (i != N) {
            if (ids[shift + i] != Scriptable.NOT_FOUND) {
                ids[shift + presentCount] = new Integer(i);
                ++presentCount;
            }
            ++i;
        }
        if (presentCount != N) {
            Object[] tmp = new Object[shift + presentCount];
            System.arraycopy(ids, shift, tmp, shift, presentCount);
            ids = tmp;
        }
        System.arraycopy(superIds, 0, ids, 0, shift);
        return ids;
    }

    public Object getDefaultValue(Class hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(hint);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args, IdFunction ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (!inNewExpr) {
            return ctorObj.construct(cx, scope, args);
        }
        if (args.length == 0) {
            return new NativeArray();
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args);
        }
        Object arg0 = args[0];
        if (args.length > 1 || !(arg0 instanceof Number)) {
            return new NativeArray(args);
        }
        long len = ScriptRuntime.toUint32(arg0);
        if ((double)len != ((Number)arg0).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(len);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    private void setLength(Object val) {
        double d = ScriptRuntime.toNumber(val);
        long longVal = ScriptRuntime.toUint32(d);
        if ((double)longVal != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (longVal < this.length) {
            if (this.length - longVal > 4096L) {
                Object[] e = this.getIds();
                int i = 0;
                while (i < e.length) {
                    Object id = e[i];
                    if (id instanceof String) {
                        String strId = (String)id;
                        long index = NativeArray.toArrayIndex(strId);
                        if (index >= longVal) {
                            this.delete(strId);
                        }
                    } else {
                        int index = (Integer)id;
                        if ((long)index >= longVal) {
                            this.delete(index);
                        }
                    }
                    ++i;
                }
            } else {
                long i = longVal;
                while (i < this.length) {
                    NativeArray.deleteElem(this, i);
                    ++i;
                }
            }
        }
        this.length = longVal;
    }

    static long getLengthProperty(Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).getLength();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).getLength();
        }
        if (!(obj instanceof Scriptable)) {
            return 0L;
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(obj, "length", obj));
    }

    private static void deleteElem(Scriptable target, long index) {
        int i = (int)index;
        if ((long)i == index) {
            target.delete(i);
        } else {
            target.delete(Long.toString(index));
        }
    }

    private static Object getElem(Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            return ScriptRuntime.getStrIdElem(target, id);
        }
        return ScriptRuntime.getElem(target, (int)index);
    }

    private static void setElem(Scriptable target, long index, Object value) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptRuntime.setStrIdElem(target, id, value, target);
        } else {
            ScriptRuntime.setElem(target, (int)index, value);
        }
    }

    private static String js_toString(Context cx, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return NativeArray.toStringHelper(cx, thisObj, cx.hasFeature(4), false);
    }

    private static String js_toLocaleString(Context cx, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return NativeArray.toStringHelper(cx, thisObj, false, true);
    }

    private static String toStringHelper(Context cx, Scriptable thisObj, boolean toSource, boolean toLocale) throws JavaScriptException {
        boolean iterating;
        boolean toplevel;
        String separator;
        long length = NativeArray.getLengthProperty(thisObj);
        StringBuffer result = new StringBuffer(256);
        if (toSource) {
            result.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i = 0L;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                i = 0L;
                while (i < length) {
                    Object elem;
                    if (i > 0L) {
                        result.append(separator);
                    }
                    if ((elem = NativeArray.getElem(thisObj, i)) == null || elem == Undefined.instance) {
                        haslast = false;
                    } else {
                        haslast = true;
                        if (elem instanceof String) {
                            String s = (String)elem;
                            if (toSource) {
                                result.append('\"');
                                result.append(ScriptRuntime.escapeString(s));
                                result.append('\"');
                            } else {
                                result.append(s);
                            }
                        } else {
                            if (toLocale && elem != Undefined.instance && elem != null) {
                                Scriptable obj = ScriptRuntime.toObject(cx, thisObj, elem);
                                Object tls = ScriptRuntime.getProp(obj, "toLocaleString", thisObj);
                                elem = ScriptRuntime.call(cx, tls, elem, ScriptRuntime.emptyArgs);
                            }
                            result.append(ScriptRuntime.toString(elem));
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        if (toSource) {
            if (!haslast && i > 0L) {
                result.append(", ]");
            } else {
                result.append(']');
            }
        }
        return result.toString();
    }

    private static String js_join(Context cx, Scriptable thisObj, Object[] args) {
        StringBuffer result = new StringBuffer();
        long length = NativeArray.getLengthProperty(thisObj);
        String separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        long i = 0L;
        while (i < length) {
            Object temp;
            if (i > 0L) {
                result.append(separator);
            }
            if ((temp = NativeArray.getElem(thisObj, i)) != null && temp != Undefined.instance) {
                result.append(ScriptRuntime.toString(temp));
            }
            ++i;
        }
        return result.toString();
    }

    private static Scriptable js_reverse(Context cx, Scriptable thisObj, Object[] args) {
        long len = NativeArray.getLengthProperty(thisObj);
        long half = len / (long)2;
        long i = 0L;
        while (i < half) {
            long j = len - i - 1L;
            Object temp1 = NativeArray.getElem(thisObj, i);
            Object temp2 = NativeArray.getElem(thisObj, j);
            NativeArray.setElem(thisObj, i, temp2);
            NativeArray.setElem(thisObj, j, temp1);
            ++i;
        }
        return thisObj;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object[] cmpBuf;
        Object compare;
        long length = NativeArray.getLengthProperty(thisObj);
        if (length <= 1L) {
            return thisObj;
        }
        if (args.length > 0 && Undefined.instance != args[0]) {
            compare = args[0];
            cmpBuf = new Object[2];
        } else {
            compare = null;
            cmpBuf = null;
        }
        if (length >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(cx, scope, thisObj, length, compare, cmpBuf);
        } else {
            int ilength = (int)length;
            Object[] working = new Object[ilength];
            int i = 0;
            while (i != ilength) {
                working[i] = NativeArray.getElem(thisObj, i);
                ++i;
            }
            NativeArray.heapsort(cx, scope, working, ilength, compare, cmpBuf);
            int i2 = 0;
            while (i2 != ilength) {
                NativeArray.setElem(thisObj, i2, working[i2]);
                ++i2;
            }
        }
        return thisObj;
    }

    private static boolean isBigger(Context cx, Scriptable scope, Object x, Object y, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        Scriptable undef;
        if (cmp == null) {
            if (cmpBuf != null) {
                Context.codeBug();
            }
        } else if (cmpBuf == null || cmpBuf.length != 2) {
            Context.codeBug();
        }
        if ((undef = Undefined.instance) == y) {
            return false;
        }
        if (undef == x) {
            return true;
        }
        if (cmp == null) {
            String b;
            String a = ScriptRuntime.toString(x);
            return a.compareTo(b = ScriptRuntime.toString(y)) > 0;
        }
        cmpBuf[0] = x;
        cmpBuf[1] = y;
        Object ret = ScriptRuntime.call(cx, cmp, null, cmpBuf, scope);
        double d = ScriptRuntime.toNumber(ret);
        return d > 0.0;
    }

    private static void heapsort(Context cx, Scriptable scope, Object[] array, int length, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        if (length <= 1) {
            Context.codeBug();
        }
        int i = length / 2;
        while (i != 0) {
            Object pivot = array[--i];
            NativeArray.heapify(cx, scope, pivot, array, i, length, cmp, cmpBuf);
        }
        int i2 = length;
        while (i2 != 1) {
            Object pivot = array[--i2];
            array[i2] = array[0];
            NativeArray.heapify(cx, scope, pivot, array, 0, i2, cmp, cmpBuf);
        }
    }

    private static void heapify(Context cx, Scriptable scope, Object pivot, Object[] array, int i, int end, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        int child;
        while ((child = i * 2 + 1) < end) {
            Object nextVal;
            Object childVal = array[child];
            if (child + 1 < end && NativeArray.isBigger(cx, scope, nextVal = array[child + 1], childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            array[i] = childVal;
            i = child;
        }
        array[i] = pivot;
    }

    private static void heapsort_extended(Context cx, Scriptable scope, Scriptable target, long length, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        if (length <= 1L) {
            Context.codeBug();
        }
        long i = length / (long)2;
        while (i != 0L) {
            Object pivot = NativeArray.getElem(target, --i);
            NativeArray.heapify_extended(cx, scope, pivot, target, i, length, cmp, cmpBuf);
        }
        long i2 = length;
        while (i2 != 1L) {
            Object pivot = NativeArray.getElem(target, --i2);
            NativeArray.setElem(target, i2, NativeArray.getElem(target, 0L));
            NativeArray.heapify_extended(cx, scope, pivot, target, 0L, i2, cmp, cmpBuf);
        }
    }

    private static void heapify_extended(Context cx, Scriptable scope, Object pivot, Scriptable target, long i, long end, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        long child;
        while ((child = i * (long)2 + 1L) < end) {
            Object nextVal;
            Object childVal = NativeArray.getElem(target, child);
            if (child + 1L < end && NativeArray.isBigger(cx, scope, nextVal = NativeArray.getElem(target, child + 1L), childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            NativeArray.setElem(target, i, childVal);
            i = child;
        }
        NativeArray.setElem(target, i, pivot);
    }

    private static Object js_push(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(thisObj);
        int i = 0;
        while (i < args.length) {
            NativeArray.setElem(thisObj, length + (long)i, args[i]);
            ++i;
        }
        Double lengthObj = new Double(length += (long)args.length);
        ScriptRuntime.setProp(thisObj, "length", lengthObj, thisObj);
        if (cx.getLanguageVersion() == 120) {
            return args.length == 0 ? Context.getUndefinedValue() : args[args.length - 1];
        }
        return lengthObj;
    }

    private static Object js_pop(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(thisObj);
        Object result = length > 0L ? NativeArray.getElem(thisObj, --length) : Context.getUndefinedValue();
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object js_shift(Context cx, Scriptable thisObj, Object[] args) {
        Object result;
        long length = NativeArray.getLengthProperty(thisObj);
        if (length > 0L) {
            long i = 0L;
            result = NativeArray.getElem(thisObj, i);
            if (--length > 0L) {
                i = 1L;
                while (i <= length) {
                    Object temp = NativeArray.getElem(thisObj, i);
                    NativeArray.setElem(thisObj, i - 1L, temp);
                    ++i;
                }
            }
        } else {
            result = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object js_unshift(Context cx, Scriptable thisObj, Object[] args) {
        double length = NativeArray.getLengthProperty(thisObj);
        int argc = args.length;
        if (args.length > 0) {
            if (length > 0.0) {
                long last = (long)length - 1L;
                while (last >= 0L) {
                    Object temp = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(thisObj, last + (long)argc, temp);
                    --last;
                }
            }
            int i = 0;
            while (i < args.length) {
                NativeArray.setElem(thisObj, i, args[i]);
                ++i;
            }
            ScriptRuntime.setProp(thisObj, "length", new Double(length += (double)args.length), thisObj);
        }
        return new Long((long)length);
    }

    private static Object js_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long count;
        scope = NativeArray.getTopLevelScope(scope);
        Object result = ScriptRuntime.newObject(cx, scope, "Array", null);
        int argc = args.length;
        if (argc == 0) {
            return result;
        }
        long length = NativeArray.getLengthProperty(thisObj);
        long begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
        --argc;
        if (args.length == 1) {
            count = length - begin;
        } else {
            double dcount = ScriptRuntime.toInteger(args[1]);
            count = dcount < 0.0 ? 0L : (dcount > (double)(length - begin) ? length - begin : (long)dcount);
            --argc;
        }
        long end = begin + count;
        if (count != 0L) {
            if (count == 1L && cx.getLanguageVersion() == 120) {
                result = NativeArray.getElem(thisObj, begin);
            } else {
                long last = begin;
                while (last != end) {
                    Scriptable resultArray = (Scriptable)result;
                    Object temp = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(resultArray, last - begin, temp);
                    ++last;
                }
            }
        } else if (count == 0L && cx.getLanguageVersion() == 120) {
            result = Context.getUndefinedValue();
        }
        long delta = (long)argc - count;
        if (delta > 0L) {
            long last = length - 1L;
            while (last >= end) {
                Object temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + delta, temp);
                --last;
            }
        } else if (delta < 0L) {
            long last = end;
            while (last < length) {
                Object temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + delta, temp);
                ++last;
            }
        }
        int argoffset = args.length - argc;
        int i = 0;
        while (i < argc) {
            NativeArray.setElem(thisObj, begin + (long)i, args[i + argoffset]);
            ++i;
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length + delta), thisObj);
        return result;
    }

    private static Scriptable js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        long length;
        scope = NativeArray.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, "Array");
        Scriptable result = ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        long slot = 0L;
        if (ScriptRuntime.instanceOf(scope, thisObj, ctor)) {
            length = NativeArray.getLengthProperty(thisObj);
            slot = 0L;
            while (slot < length) {
                Object temp = NativeArray.getElem(thisObj, slot);
                NativeArray.setElem(result, slot, temp);
                ++slot;
            }
        } else {
            NativeArray.setElem(result, slot++, thisObj);
        }
        int i = 0;
        while (i < args.length) {
            if (ScriptRuntime.instanceOf(scope, args[i], ctor)) {
                Scriptable arg = (Scriptable)args[i];
                length = NativeArray.getLengthProperty(arg);
                long j = 0L;
                while (j < length) {
                    Object temp = NativeArray.getElem(arg, j);
                    NativeArray.setElem(result, slot, temp);
                    ++j;
                    ++slot;
                }
            } else {
                NativeArray.setElem(result, slot++, args[i]);
            }
            ++i;
        }
        return result;
    }

    private Scriptable js_slice(Context cx, Scriptable thisObj, Object[] args) {
        long end;
        long begin;
        Scriptable scope = NativeArray.getTopLevelScope(this);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        long length = NativeArray.getLengthProperty(thisObj);
        if (args.length == 0) {
            begin = 0L;
            end = length;
        } else {
            begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
            end = args.length == 1 ? length : NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[1]), length);
        }
        long slot = begin;
        while (slot < end) {
            Object temp = NativeArray.getElem(thisObj, slot);
            NativeArray.setElem(result, slot - begin, temp);
            ++slot;
        }
        return result;
    }

    private static long toSliceIndex(double value, long length) {
        long result = value < 0.0 ? (value + (double)length < 0.0 ? 0L : (long)(value + (double)length)) : (value > (double)length ? length : (long)value);
        return result;
    }

    protected String getIdName(int id) {
        if (id == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "join";
                }
                case 6: {
                    return "reverse";
                }
                case 7: {
                    return "sort";
                }
                case 8: {
                    return "push";
                }
                case 9: {
                    return "pop";
                }
                case 10: {
                    return "shift";
                }
                case 11: {
                    return "unshift";
                }
                case 12: {
                    return "splice";
                }
                case 13: {
                    return "concat";
                }
                case 14: {
                    return "slice";
                }
            }
        }
        return null;
    }

    private void $init$() {
        this.setMaxId(1);
    }

    protected int mapNameToId(String s) {
        if (s.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeArray.toPrototypeId(s);
        }
        return 0;
    }

    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 3: {
                X = "pop";
                id = 9;
                break;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'j') {
                    X = "join";
                    id = 5;
                    break;
                }
                if (c == 'p') {
                    X = "push";
                    id = 8;
                    break;
                }
                if (c != 's') break;
                X = "sort";
                id = 7;
                break;
            }
            case 5: {
                char c = s.charAt(1);
                if (c == 'h') {
                    X = "shift";
                    id = 10;
                    break;
                }
                if (c != 'l') break;
                X = "slice";
                id = 14;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "concat";
                    id = 13;
                    break;
                }
                if (c == 'l') {
                    X = "length";
                    id = 1;
                    break;
                }
                if (c != 's') break;
                X = "splice";
                id = 12;
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'r') {
                    X = "reverse";
                    id = 6;
                    break;
                }
                if (c != 'u') break;
                X = "unshift";
                id = 11;
                break;
            }
            case 8: {
                X = "toString";
                id = 3;
                break;
            }
            case 11: {
                X = "constructor";
                id = 2;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 4;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

