/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeFunction;
import ice.mozilla.javascript.Script;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;
import java.io.IOException;
import java.io.StringReader;

public class NativeScript
extends NativeFunction
implements Script {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;
    private int prototypeIdShift;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeScript obj = new NativeScript();
        obj.scopeInit(cx, scope, sealed);
    }

    public NativeScript() {
        this.$init$();
    }

    private void scopeInit(Context cx, Scriptable scope, boolean sealed) {
        this.prototypeIdShift = this.getMaxId();
        this.addAsPrototype(this.prototypeIdShift + 4, cx, scope, sealed);
    }

    public String getClassName() {
        return "Script";
    }

    public void initScript(Scriptable scope) {
    }

    public int methodArity(int methodId) {
        if (0 <= this.prototypeIdShift) {
            switch (methodId - this.prototypeIdShift) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (0 <= this.prototypeIdShift) {
            switch (methodId - this.prototypeIdShift) {
                case 1: {
                    return NativeScript.jsConstructor(cx, scope, args);
                }
                case 2: {
                    return this.realThis(thisObj, f, true).js_toString(cx, args);
                }
                case 4: {
                    return this.realThis(thisObj, f, true).js_exec();
                }
                case 3: {
                    return this.realThis(thisObj, f, false).js_compile(cx, ScriptRuntime.toString(args, 0));
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeScript realThis(Scriptable thisObj, IdFunction f, boolean readOnly) {
        while (!(thisObj instanceof NativeScript)) {
            thisObj = this.nextInstanceCheck(thisObj, f, readOnly);
        }
        return (NativeScript)thisObj;
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        String source = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
        return NativeScript.compile(cx, scope, source);
    }

    private static Script compile(Context cx, Scriptable scope, String source) {
        StringReader reader = new StringReader(source);
        try {
            int[] linep = new int[]{0};
            String filename = Context.getSourcePositionFromStack(linep);
            if (filename == null) {
                filename = "<Script object>";
                linep[0] = 1;
            }
            Script script = cx.compileReader(scope, reader, filename, linep[0], null);
            return script;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException");
        }
    }

    private Scriptable js_compile(Context cx, String source) {
        this.script = NativeScript.compile(cx, null, source);
        return this;
    }

    private Object js_exec() throws JavaScriptException {
        throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
    }

    private Object js_toString(Context cx, Object[] args) {
        Script thisScript = this.script;
        if (thisScript == null) {
            thisScript = this;
        }
        Scriptable scope = NativeScript.getTopLevelScope(this);
        return cx.decompileScript(thisScript, scope, 0);
    }

    public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(cx, scope);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return this.exec(cx, scope);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    protected String getIdName(int id) {
        if (0 <= this.prototypeIdShift) {
            switch (id - this.prototypeIdShift) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(id);
    }

    protected int mapNameToId(String s) {
        int id;
        if (0 <= this.prototypeIdShift && (id = NativeScript.toPrototypeId(s)) != 0) {
            return this.prototypeIdShift + id;
        }
        return super.mapNameToId(s);
    }

    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 4: {
                X = "exec";
                id = 4;
                break;
            }
            case 7: {
                X = "compile";
                id = 3;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    private void $init$() {
        this.prototypeIdShift = -1;
    }
}

