/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.PreorderNodeIterator;
import ice.mozilla.javascript.UintMap;

public class Node
implements Cloneable {
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int SOURCE_PROP = 17;
    public static final int TYPE_PROP = 18;
    public static final int SPECIAL_PROP_PROP = 19;
    public static final int LABEL_PROP = 20;
    public static final int FINALLY_PROP = 21;
    public static final int LOCALCOUNT_PROP = 22;
    public static final int TARGETBLOCK_PROP = 23;
    public static final int VARIABLE_PROP = 24;
    public static final int LASTUSE_PROP = 25;
    public static final int ISNUMBER_PROP = 26;
    public static final int DIRECTCALL_PROP = 27;
    public static final int BASE_LINENO_PROP = 28;
    public static final int END_LINENO_PROP = 29;
    public static final int SPECIALCALL_PROP = 30;
    public static final int DEBUGSOURCE_PROP = 31;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int type;
    Node next;
    private Node first;
    private Node last;
    private int intDatum;
    private UintMap props;

    public Node(int nodeType) {
        this.$init$();
        this.type = nodeType;
    }

    public Node(int nodeType, Node child) {
        this.$init$();
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
    }

    public Node(int nodeType, Node left, Node right) {
        this.$init$();
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
    }

    public Node(int nodeType, Node left, Node mid, Node right) {
        this.$init$();
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
    }

    public Node(int nodeType, int value) {
        this.$init$();
        this.type = nodeType;
        this.intDatum = value;
    }

    public Node(int nodeType, Node child, int value) {
        this(nodeType, child);
        this.intDatum = value;
    }

    public Node(int nodeType, Node left, Node right, int value) {
        this(nodeType, left, right);
        this.intDatum = value;
    }

    public Node(int nodeType, Node left, Node mid, Node right, int value) {
        this(nodeType, left, mid, right);
        this.intDatum = value;
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newString(String str) {
        return new StringNode(46, str);
    }

    public static Node newString(int type, String str) {
        return new StringNode(type, str);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node child) {
        if (child == this.first) {
            return null;
        }
        Node n = this.first;
        while (n.next != child) {
            n = n.next;
            if (n != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return n;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public PreorderNodeIterator getPreorderIterator() {
        return new PreorderNodeIterator(this);
    }

    public void addChildToFront(Node child) {
        child.next = this.first;
        this.first = child;
        if (this.last == null) {
            this.last = child;
        }
    }

    public void addChildToBack(Node child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToFront(Node children) {
        Node lastSib = children.getLastSibling();
        lastSib.next = this.first;
        this.first = children;
        if (this.last == null) {
            this.last = lastSib;
        }
    }

    public void addChildrenToBack(Node children) {
        if (this.last != null) {
            this.last.next = children;
        }
        this.last = children.getLastSibling();
        if (this.first == null) {
            this.first = children;
        }
    }

    public void addChildBefore(Node newChild, Node node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node) {
            newChild.next = this.first;
            this.first = newChild;
            return;
        }
        Node prev = this.getChildBefore(node);
        this.addChildAfter(newChild, prev);
    }

    public void addChildAfter(Node newChild, Node node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        newChild.next = node.next;
        node.next = newChild;
        if (this.last == node) {
            this.last = newChild;
        }
    }

    public void removeChild(Node child) {
        Node prev = this.getChildBefore(child);
        if (prev == null) {
            this.first = this.first.next;
        } else {
            prev.next = child.next;
        }
        if (child == this.last) {
            this.last = prev;
        }
        child.next = null;
    }

    public void replaceChild(Node child, Node newChild) {
        newChild.next = child.next;
        if (child == this.first) {
            this.first = newChild;
        } else {
            Node prev = this.getChildBefore(child);
            prev.next = newChild;
        }
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    public void replaceChildAfter(Node prevChild, Node newChild) {
        Node child = prevChild.next;
        newChild.next = child.next;
        prevChild.next = newChild;
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    private static final String propToString(int propType) {
        return null;
    }

    public Object getProp(int propType) {
        if (this.props == null) {
            return null;
        }
        return this.props.getObject(propType);
    }

    public int getIntProp(int propType, int defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        return this.props.getInt(propType, defaultValue);
    }

    public int getExistingIntProp(int propType) {
        return this.props.getExistingInt(propType);
    }

    public void putProp(int propType, Object prop) {
        if (prop == null) {
            this.removeProp(propType);
        } else {
            if (this.props == null) {
                this.props = new UintMap(2);
            }
            this.props.put(propType, prop);
        }
    }

    public void putIntProp(int propType, int prop) {
        if (this.props == null) {
            this.props = new UintMap(2);
        }
        this.props.put(propType, prop);
    }

    public void removeProp(int propType) {
        if (this.props != null) {
            this.props.remove(propType);
        }
    }

    public int getOperation() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 105: 
            case 109: {
                return this.intDatum;
            }
        }
        Context.codeBug();
        return 0;
    }

    public int getLineno() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 105: 
            case 109: {
                Context.codeBug();
            }
        }
        return this.intDatum;
    }

    public double getDouble() {
        return ((NumberNode)this).number;
    }

    public String getString() {
        return ((StringNode)this).str;
    }

    public Node cloneNode() {
        Node result;
        try {
            result = (Node)super.clone();
            result.next = null;
            result.first = null;
            result.last = null;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public String toString() {
        return null;
    }

    public String toStringTree() {
        return this.toStringTreeHelper(0);
    }

    private String toStringTreeHelper(int level) {
        return "";
    }

    private void $init$() {
        this.intDatum = -1;
    }

    private static class NumberNode
    extends Node {
        double number;

        NumberNode(double number) {
            super(45);
            this.number = number;
        }
    }

    private static class StringNode
    extends Node {
        String str;

        StringNode(int type, String str) {
            super(type);
            this.str = str;
        }
    }
}

