/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;

class AttributeSelector {
    static final int MATCH_EXACT = 0;
    static final int MATCH_IN_SPACE_SEPARATED_LIST = 1;
    static final int MATCH_IN_HYPHEN_SEPARATED_LIST = 2;
    Names names;
    private int attributeNameId;
    private String value;
    private int mode;
    private boolean caseInsensitive;

    private void $init$() {
        this.caseInsensitive = false;
    }

    AttributeSelector(Names names, int attributeNameId, String value, int mode) {
        this.$init$();
        this.names = names;
        this.attributeNameId = attributeNameId;
        this.value = value;
        this.mode = mode;
        if (!DDocument.STRICT && value != null && names.getAttrNamespaceId(attributeNameId) == 3) {
            this.caseInsensitive = true;
            this.value = CharKit.toLowerCase(value);
        }
    }

    String getClassKey() {
        if (this.attributeNameId == 21) {
            return this.value;
        }
        return null;
    }

    boolean match(DElement e) {
        String s = e.getAttribute(this.attributeNameId);
        if (s != null) {
            if (this.value == null) {
                return true;
            }
            if (this.caseInsensitive) {
                s = CharKit.toLowerCase(s);
            }
            if (this.mode == 0) {
                if (s.equals(this.value)) {
                    return true;
                }
            } else if (this.mode == 1) {
                int i = s.indexOf(this.value);
                boolean okBefore = true;
                boolean okAfter = true;
                if (i > 0) {
                    char c = s.charAt(i - 1);
                    okBefore = c == ' ' || c == '\t' || c == '\n' || c == '\r';
                } else if (i >= 0 && i + this.value.length() < s.length()) {
                    char c = s.charAt(i + this.value.length());
                    boolean bl = okAfter = c == ' ' || c == '\t' || c == '\n' || c == '\r';
                }
                if (i >= 0 && okBefore && okAfter) {
                    return true;
                }
            } else if (this.mode == 2 && s.startsWith(this.value) && this.value.length() < s.length() && s.charAt(this.value.length()) == '-') {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String attrName = this.names.getAttrName(this.attributeNameId);
        if (this.value == null) {
            return "[" + attrName + "]";
        }
        if (this.mode == 0) {
            if (this.attributeNameId == 21) {
                return "." + this.value;
            }
            return "[" + attrName + "=" + this.value + "]";
        }
        if (this.mode == 1) {
            return "[" + attrName + "~=" + this.value + "]";
        }
        if (this.mode == 2) {
            return "[" + attrName + "|=" + this.value + "]";
        }
        return "";
    }
}

