/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSUtil;

class CSSDecl {
    CSSDecl next;
    int id;
    int type;
    Object value;

    CSSDecl(int id, int type, Object value) {
        this.id = id;
        this.type = type;
        this.value = value;
    }

    boolean sameId(CSSDecl x) {
        return this.id == x.id;
    }

    boolean copyDataFrom(CSSDecl x) {
        if (!this.sameId(x)) {
            Debug.bug();
        }
        boolean changes = true;
        if (this.type != x.type) {
            this.type = x.type;
            this.value = x.value;
        } else if (this.value != x.value) {
            if (this.value != null && this.value.equals(x.value)) {
                changes = false;
            } else {
                this.value = x.value;
            }
        } else {
            changes = false;
        }
        return changes;
    }

    public String toString() {
        if (this.type >= 0) {
            return CSSLookup.getPropValue(this.type);
        }
        String app = null;
        switch (this.type) {
            case -2: {
                return CSSUtil.colorToString(this.value);
            }
            case -4: {
                app = "%";
                break;
            }
            case -5: {
                app = "em";
                break;
            }
            case -6: {
                app = "ex";
                break;
            }
            case -7: {
                app = "px";
                break;
            }
            case -8: {
                app = "in";
                break;
            }
            case -9: {
                app = "cm";
                break;
            }
            case -10: {
                app = "mm";
                break;
            }
            case -11: {
                app = "pt";
                break;
            }
            case -12: {
                app = "pc";
                break;
            }
        }
        String result = this.value.toString();
        if (app != null) {
            result = result + app;
        }
        return result;
    }
}

