/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DHrefElement;
import ice.storm.DynEnv;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.w3c.dom.html.HTMLAreaElement;

public class DAreaElement
extends DHrefElement
implements HTMLAreaElement {
    int[] coords;
    private static final int Field_accessKey = 1;
    private static final int Field_alt = 2;
    private static final int Field_coords = 3;
    private static final int Field_noHref = 4;
    private static final int Field_shape = 5;
    private static final int Field_tabIndex = 6;
    private static final int Field_target = 7;

    protected DAreaElement(DDocument doc, int id) {
        super(doc, id);
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute(4, accessKey);
    }

    public String getAlt() {
        return this.getAttribute(8);
    }

    public void setAlt(String alt) {
        this.setAttribute(8, alt);
    }

    public String getCoords() {
        return this.getAttribute(32);
    }

    public void setCoords(String coords) {
        this.setAttribute(32, coords);
    }

    public boolean getNoHref() {
        return false;
    }

    public void setNoHref(boolean noHref) {
    }

    public String getShape() {
        return this.getAttribute(99);
    }

    public void setShape(String shape) {
        this.setAttribute(99, shape);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int tabIndex) {
    }

    public String getTarget() {
        return this.getAttribute(108);
    }

    public void setTarget(String target) {
        this.setAttribute(108, target);
    }

    void findBoundingBox(Rectangle r) {
        if (!this.checkCoords()) {
            return;
        }
        String s = this.getShape();
        if (s == null || s.equalsIgnoreCase("rect")) {
            int x1 = this.coords[0];
            int y1 = this.coords[1];
            int x2 = this.coords[2];
            int y2 = this.coords[3];
            if (x2 < x1) {
                int tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y2 < y1) {
                int tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            r.x = x1;
            r.y = y1;
            r.width = x2 - x1;
            r.height = y2 - y1;
        }
    }

    boolean isInside(int x, int y, int w, int h) {
        if (!this.checkCoords()) {
            return false;
        }
        String s = this.getShape();
        if (s == null || s.equalsIgnoreCase("rect")) {
            int y2;
            int x2;
            int y1;
            int x1 = this.coords[0];
            if (x1 < 0) {
                x1 = -x1 * w / 100;
            }
            if ((y1 = this.coords[1]) < 0) {
                y1 = -y1 * h / 100;
            }
            if ((x2 = this.coords[2]) < 0) {
                x2 = -x2 * w / 100;
            }
            if ((y2 = this.coords[3]) < 0) {
                y2 = -y2 * h / 100;
            }
            if (x >= x1 && x < x2 && y >= y1 && y < y2) {
                return true;
            }
        } else if (s.equalsIgnoreCase("circle")) {
            int r;
            int y1;
            int x1 = this.coords[0];
            if (x1 < 0) {
                x1 = -x1 * w / 100;
            }
            if ((y1 = this.coords[1]) < 0) {
                y1 = -y1 * h / 100;
            }
            if ((r = this.coords[2]) < 0) {
                r = w < h ? -r * w / 100 : -r * h / 100;
            }
            if ((x -= x1) * x + (y -= y1) * y < r * r) {
                return true;
            }
        } else if (s.equalsIgnoreCase("poly") || s.equalsIgnoreCase("polygon")) {
            int y0;
            int x0;
            int numEdges = 0;
            int i = 0;
            if ((x0 = this.coords[i++]) < 0) {
                x0 = -x0 * w / 100;
            }
            if ((y0 = this.coords[i++]) < 0) {
                y0 = -y0 * h / 100;
            }
            int x1 = x0 -= x;
            int y1 = y0 -= y;
            while (i < this.coords.length) {
                int y2;
                int x2;
                if ((x2 = this.coords[i++]) < 0) {
                    x2 = -x2 * w / 100;
                }
                if ((y2 = this.coords[i++]) < 0) {
                    y2 = -y2 * h / 100;
                }
                if (this.checkEdge(x1, y1, x2 -= x, y2 -= y)) {
                    ++numEdges;
                }
                x1 = x2;
                y1 = y2;
            }
            if (this.checkEdge(x1, y1, x0, y0)) {
                ++numEdges;
            }
            if ((numEdges & 1) > 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean checkEdge(int x1, int y1, int x2, int y2) {
        if (y1 <= 0 && y2 > 0 || y1 > 0 && y2 <= 0) {
            if (x1 >= 0 && x2 >= 0) {
                return true;
            }
            if ((x1 > 0 || x2 > 0) && x1 + (x2 - x1) * (0 - y1) / (y2 - y1) > 0) {
                return true;
            }
        }
        return false;
    }

    boolean checkCoords() {
        String c = this.getCoords();
        if (c == null) {
            return false;
        }
        String shape = this.getShape();
        c = c.replace(',', ' ');
        StringTokenizer st = new StringTokenizer(c);
        int n = st.countTokens();
        if ("rect".equalsIgnoreCase(shape)) {
            if (n < 4) {
                return false;
            }
            n = 4;
        } else if ("circle".equalsIgnoreCase(shape)) {
            if (n < 3) {
                return false;
            }
            n = 3;
        } else if ("poly".equalsIgnoreCase(shape) || "polygon".equalsIgnoreCase(shape)) {
            if ((n & 1) > 0) {
                n ^= 1;
            }
            if (n < 6) {
                return false;
            }
        }
        this.coords = new int[n];
        int i = 0;
        while (st.hasMoreTokens() && i < n) {
            String s = st.nextToken();
            int value = CSSUtil.parseLength(s);
            if (value == Integer.MIN_VALUE) {
                value = 0;
            }
            this.coords[i] = value;
            ++i;
        }
        return true;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DAreaElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DAreaElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAccessKey();
            }
            case 2: {
                return this.getAlt();
            }
            case 3: {
                return this.getCoords();
            }
            case 4: {
                return env.wrapBoolean(this.getNoHref());
            }
            case 5: {
                return this.getShape();
            }
            case 6: {
                return env.wrapInt(this.getTabIndex());
            }
            case 7: {
                return this.getTarget();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setAccessKey(env.toStr(value));
                return 1;
            }
            case 2: {
                this.setAlt(env.toStr(value));
                return 1;
            }
            case 3: {
                this.setCoords(env.toStr(value));
                return 1;
            }
            case 4: {
                this.setNoHref(env.toBoolean(value));
                return 1;
            }
            case 5: {
                this.setShape(env.toStr(value));
                return 1;
            }
            case 6: {
                this.setTabIndex(env.toInt(value));
                return 1;
            }
            case 7: {
                this.setTarget(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 3: {
                guess = "alt";
                id = 2;
                break;
            }
            case 5: {
                guess = "shape";
                id = 5;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "coords";
                    id = 3;
                    break;
                }
                if (c == 'n') {
                    guess = "noHref";
                    id = 4;
                    break;
                }
                if (c != 't') break;
                guess = "target";
                id = 7;
                break;
            }
            case 8: {
                guess = "tabIndex";
                id = 6;
                break;
            }
            case 9: {
                guess = "accessKey";
                id = 1;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

