/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DCSSRule;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class DRuleList
extends DynamicList
implements CSSRuleList {
    private int maxRules;
    private int numRules;
    private DCSSRule[] rules;
    private static final int Method_insertRule = -1;
    private static final int Method_deleteRule = -2;

    private void $init$() {
        this.maxRules = 16;
        this.numRules = 0;
    }

    DRuleList() {
        this.$init$();
        this.rules = new DCSSRule[this.maxRules];
    }

    public int getLength() {
        return this.numRules;
    }

    public CSSRule item(int index) {
        if (index < 0 || index >= this.numRules) {
            return null;
        }
        return this.rules[index];
    }

    protected Object script_item(int index, DynEnv env) {
        return this.item(index);
    }

    protected Object script_namedItem(String name, DynEnv env) {
        return null;
    }

    public int insertRule(String rule, int index) {
        return 0;
    }

    public void deleteRule(int index) {
        if (index < 0 || index >= this.numRules) {
            return;
        }
        int i = index;
        while (i < this.numRules - 1) {
            this.rules[i] = this.rules[i + 1];
            ++i;
        }
        this.rules[this.numRules - 1] = null;
        --this.numRules;
    }

    void addRule(DCSSRule r) {
        if (this.numRules == this.maxRules) {
            this.maxRules *= 2;
            DCSSRule[] tmp = new DCSSRule[this.maxRules];
            System.arraycopy(this.rules, 0, tmp, 0, this.numRules);
            this.rules = tmp;
        }
        this.rules[this.numRules++] = r;
    }

    String getCssText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numRules) {
            sb.append(this.rules[i].getCssText());
            ++i;
        }
        return sb.toString();
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DRuleList.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DRuleList.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DRuleList.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                String rule = env.toStr(args, 0);
                int index = env.toInt(args, 1);
                return env.wrapInt(this.insertRule(rule, index));
            }
            case -2: {
                int index = env.toInt(args, 0);
                this.deleteRule(index);
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        if (s.length() == 10) {
            char c = s.charAt(0);
            if (c == 'd') {
                guess = "deleteRule";
                id = -2;
            } else if (c == 'i') {
                guess = "insertRule";
                id = -1;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

