/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.ObjectPainter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLSelectElement;

public class DSelectElement
extends FormTypeElement
implements HTMLSelectElement,
HTMLCollection {
    private static final int Field_disabled = 1;
    private static final int Field_form = 2;
    private static final int Field_length = 3;
    private static final int Field_multiple = 4;
    private static final int Field_options = 5;
    private static final int Field_selectedIndex = 6;
    private static final int Field_size = 7;
    private static final int Field_tabIndex = 8;
    private static final int Field_type = 9;
    private static final int Field_value = 10;
    private static final int Method_add = -1;
    private static final int Method_blur = -2;
    private static final int Method_focus = -3;
    private static final int Method_item = -4;
    private static final int Method_namedItem = -5;
    private static final int Method_remove = -6;

    protected DSelectElement(DDocument d, int id) {
        super(d, id);
    }

    SelectPainter getSelectPainter() {
        return (SelectPainter)this.doc.pilot.objectPool.getNodePainter(this);
    }

    void sendDomChangeEvent() {
        this.doc.processEvent(18, this);
    }

    void updateGuiSelection() {
        SelectPainter painter = this.getSelectPainter();
        if (painter != null) {
            painter.onOptionSelectionChange();
        }
    }

    void notifySelectionObservers(boolean calledFromGui) {
        if (calledFromGui) {
            this.sendDomChangeEvent();
        } else {
            this.updateGuiSelection();
        }
    }

    void setAttributes(int[] names, String[] values, int num) {
        super.setAttributes(names, values, num);
        if (this.getMultiple() && (this.getAttribute(100) == null || this.getAttribute(100).equals("1"))) {
            this.setAttribute(100, "4");
        }
    }

    public String getType() {
        String o = this.getAttribute(62);
        if (o == null) {
            return "select-one";
        }
        return "select-multiple";
    }

    public DOptionElement getSelectedDOption() {
        DOptionElement firstOption;
        DOptionElement currentOption = firstOption = this.firstDOption();
        DOptionElement lastSelectedOption = null;
        while (currentOption != null) {
            if (currentOption.getSelected()) {
                if (this.getMultiple()) break;
                lastSelectedOption = currentOption;
            }
            currentOption = this.nextDOption(currentOption);
        }
        if (!this.getMultiple()) {
            currentOption = lastSelectedOption;
        }
        if (currentOption == null && firstOption != null) {
            firstOption.do_setSelected(true);
            currentOption = firstOption;
        }
        return currentOption;
    }

    public int getSelectedIndex() {
        DOptionElement firstOption;
        DOptionElement currentOption = firstOption = this.firstDOption();
        DOptionElement lastSelectedOption = null;
        int index = 0;
        int lastSelectedIndex = 0;
        index = 0;
        while (currentOption != null) {
            if (currentOption.getSelected()) {
                if (this.getMultiple()) break;
                lastSelectedOption = currentOption;
                lastSelectedIndex = index;
            }
            currentOption = this.nextDOption(currentOption);
            ++index;
        }
        if (!this.getMultiple()) {
            index = lastSelectedIndex;
            currentOption = lastSelectedOption;
        }
        if (currentOption == null && firstOption != null) {
            firstOption.do_setSelected(true);
            index = 0;
        }
        return index;
    }

    public final void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, false);
    }

    public final void setSelectedIndexByUser(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, true);
    }

    void setSelectedIndex(int selectedIndex, boolean calledFromGui) {
        DOptionElement opt = this.getDOption(selectedIndex);
        if (opt != null) {
            boolean changed = false;
            if (this.getMultiple()) {
                opt.do_setSelected(opt.getSelected() ^ true);
                changed = true;
            } else {
                DOptionElement x = this.firstDOption();
                x = this.firstDOption();
                while (x != null) {
                    if (x == opt) {
                        if (x.selection_state != 1) {
                            changed = true;
                            x.do_setSelected(true);
                        }
                    } else if (x.selection_state != 2) {
                        changed = true;
                        x.do_setSelected(false);
                    }
                    x = this.nextDOption(x);
                }
            }
            if (changed) {
                this.notifySelectionObservers(calledFromGui);
            }
        }
    }

    void setOptionSelection(DOptionElement opt, boolean selected) {
        DOptionElement old;
        boolean changed = false;
        if (this.getMultiple()) {
            opt.do_setSelected(selected);
            changed = true;
        } else if (selected && (old = this.getSelectedDOption()) != opt) {
            if (old != null) {
                old.do_setSelected(false);
            }
            opt.do_setSelected(true);
            changed = true;
        }
        if (changed) {
            this.notifySelectionObservers(false);
        }
    }

    public String getValue() {
        String val = null;
        DOptionElement opt = this.getSelectedDOption();
        if (opt != null) {
            val = opt.getValueOrText();
        }
        return val;
    }

    public void setValue(String value) {
        DOptionElement opt = this.getSelectedDOption();
        if (opt != null) {
            opt.setValue(value);
        }
    }

    public int getLength() {
        int count = 0;
        DOptionElement option = this.firstDOption();
        while (option != null) {
            ++count;
            option = this.nextDOption(option);
        }
        return count;
    }

    public void setLength(int n) {
        boolean changed = false;
        if (n <= 0) {
            DOptionElement option;
            while ((option = this.firstDOption()) != null) {
                this.removeDChild(option);
                changed = true;
            }
        } else {
            DOptionElement option = this.firstDOption();
            while (option != null) {
                if (--n == 0) break;
                option = this.nextDOption(option);
            }
            if (option == null) {
                if (n != 0) {
                    this.appendEmptyOptions(n);
                    changed = true;
                }
            } else {
                DOptionElement to_remove;
                while ((to_remove = this.nextDOption(option)) != null) {
                    this.removeDChild(to_remove);
                }
                changed = true;
            }
        }
    }

    public final Node item(int idx) {
        return this.getDOption(idx);
    }

    public DOptionElement getDOption(int idx) {
        DOptionElement option = this.firstDOption();
        while (option != null) {
            if (idx == 0) break;
            --idx;
            option = this.nextDOption(option);
        }
        return option;
    }

    private void appendEmptyOption() {
        DOptionElement filler = (DOptionElement)this.doc.createElement(63);
        filler.setText("");
        this.appendDChild(filler);
    }

    private void appendEmptyOptions(int count) {
        while (count-- > 0) {
            this.appendEmptyOption();
        }
    }

    public DOptionElement firstDOption() {
        return DSelectElement.optionChildOrNull(this.getFirstDChild());
    }

    public DOptionElement nextDOption(DOptionElement option) {
        if (option.next == null) {
            DNode n = option.getParentDNode();
            if (n.getNameId() == 62) {
                return DSelectElement.optionChildOrNull(n.next);
            }
            return null;
        }
        return DSelectElement.optionChildOrNull(option.next);
    }

    private static DOptionElement optionChildOrNull(DNode n) {
        while (n != null) {
            if (n instanceof DOptionElement) {
                return (DOptionElement)n;
            }
            if (n.getNameId() == 62) {
                return DSelectElement.optionChildOrNull(n.first);
            }
            n = n.next;
        }
        return null;
    }

    public int getOptionIndex(Object possible_option) {
        DOptionElement opt = this.firstDOption();
        int i = 0;
        while (opt != null) {
            if (opt == possible_option) {
                return i;
            }
            opt = this.nextDOption(opt);
            ++i;
        }
        return -1;
    }

    public Node namedItem(String name) {
        DOptionElement option = this.firstDOption();
        while (option != null) {
            String tmp = option.getAttribute(50);
            if (tmp == null) {
                tmp = option.getAttribute(63);
            }
            if (tmp != null && tmp.equals(name)) break;
            option = this.nextDOption(option);
        }
        return option;
    }

    protected void setItem(int index, DOptionElement option) {
        if (option == null) {
            this.remove(index);
        } else {
            DOptionElement current = this.getDOption(index);
            if (current != null) {
                this.replaceDChild(option, current);
            } else {
                this.appendEmptyOptions(index - this.getLength());
                this.appendDChild(option);
            }
        }
    }

    public Object getSlot(String name, DynEnv env) {
        Object result = super.getSlot(name, env);
        if (result == DynamicObject.NOT_FOUND && (result = this.namedItem(name)) == null) {
            result = DynamicObject.NOT_FOUND;
        }
        return result;
    }

    public Object getSlot(int index, DynEnv env) {
        Object result = super.getSlot(index, env);
        if (result == DynamicObject.NOT_FOUND && (result = this.getDOption(index)) == null) {
            result = DynamicObject.NOT_FOUND;
        }
        return result;
    }

    public void setSlot(int index, Object value, DynEnv env) {
        if ((value = env.toNative(value)) instanceof DOptionElement || value == null) {
            this.setItem(index, (DOptionElement)value);
        } else {
            super.setSlot(index, value, env);
        }
    }

    public HTMLCollection getOptions() {
        return this;
    }

    public boolean getDisabled() {
        return this.getAttribute(38) != null;
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute(38, disabled ? "disabled" : null);
    }

    public boolean getMultiple() {
        return this.getAttribute(62) != null;
    }

    public void setMultiple(boolean multiple) {
        this.setAttribute(62, multiple ? "multiple" : null);
    }

    public int getSize() {
        return 0;
    }

    public void setSize(int size) {
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int tabIndex) {
    }

    public void add(HTMLElement option, HTMLElement before) {
        this.insertDChildBefore((DOptionElement)option, (DOptionElement)before);
    }

    private void script_add(DOptionElement option, int index) {
        DOptionElement before;
        if (index >= 0 && (before = this.getDOption(index)) != null) {
            this.insertDChildBefore(option, before);
            return;
        }
        this.appendDChild(option);
    }

    public void remove(int index) {
        DOptionElement to_remove = this.getDOption(index);
        if (to_remove != null) {
            this.removeDChild(to_remove);
        }
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    /*
     * Unable to fully structure code
     */
    void recordData(FormSubmitData data, Object submitSource) {
        block5: {
            if (this.getDisabled()) break block5;
            _optionElement = this.firstDOption();
            if (this.getMultiple()) ** GOTO lbl11
            lastSelectedOption = this.getLastSelectedDOption();
            if (lastSelectedOption == null) break block5;
            data.appendData(this.getNameForServer(), this.fixValue(lastSelectedOption.getValueOrText()));
            break block5;
lbl-1000:
            // 1 sources

            {
                if (_optionElement.getSelected()) {
                    data.appendData(this.getNameForServer(), this.fixValue(_optionElement.getValueOrText()));
                }
                _optionElement = this.nextDOption(_optionElement);
lbl11:
                // 2 sources

                ** while (_optionElement != null)
            }
        }
    }

    private DOptionElement getLastSelectedDOption() {
        DOptionElement option = this.firstDOption();
        DOptionElement lastSelectedElement = null;
        while (option != null) {
            if (option.getSelected()) {
                lastSelectedElement = option;
            }
            option = this.nextDOption(option);
        }
        return lastSelectedElement;
    }

    void reset() {
        DOptionElement opt = this.firstDOption();
        while (opt != null) {
            opt.setSelectionAsDefault();
            opt = this.nextDOption(opt);
        }
        this.updateGuiSelection();
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DSelectElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DSelectElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DSelectElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.getDisabled());
            }
            case 2: {
                return this.getDForm();
            }
            case 3: {
                return env.wrapInt(this.getLength());
            }
            case 4: {
                return env.wrapBoolean(this.getMultiple());
            }
            case 5: {
                return this.getOptions();
            }
            case 6: {
                return env.wrapInt(this.getSelectedIndex());
            }
            case 7: {
                return env.wrapInt(this.getSize());
            }
            case 8: {
                return env.wrapInt(this.getTabIndex());
            }
            case 9: {
                return this.getType();
            }
            case 10: {
                return this.getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setDisabled(env.toBoolean(value));
                return 1;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setLength(env.toInt(value));
                return 1;
            }
            case 4: {
                this.setMultiple(env.toBoolean(value));
                return 1;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setSelectedIndex(env.toInt(value));
                return 1;
            }
            case 7: {
                this.setSize(env.toInt(value));
                return 1;
            }
            case 8: {
                this.setTabIndex(env.toInt(value));
                return 1;
            }
            case 9: {
                break;
            }
            case 10: {
                this.setValue(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                DOptionElement element = (DOptionElement)env.toNative(args, 0);
                if (args.length <= 1) {
                    this.script_add(element, -1);
                    break;
                }
                long possibleIndex = env.toPossibleInt(args[1]);
                if (possibleIndex >= 0L) {
                    this.script_add(element, (int)possibleIndex);
                    break;
                }
                DOptionElement before = (DOptionElement)env.toNative(args, 1);
                this.add(element, before);
                break;
            }
            case -2: {
                this.blur();
                break;
            }
            case -3: {
                this.focus();
                break;
            }
            case -4: {
                Object arg = args[0];
                int index = env.nativeIndexTest(arg);
                if (index >= 0) {
                    return this.item(index);
                }
                return this.namedItem(env.toStr(arg));
            }
            case -5: {
                return this.namedItem(env.toStr(args, 0));
            }
            case -6: {
                this.remove(env.toInt(args, 0));
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        block0 : switch (s.length()) {
            case 3: {
                guess = "add";
                id = -1;
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        guess = "blur";
                        id = -2;
                        break block0;
                    }
                    case 'f': {
                        guess = "form";
                        id = 2;
                        break block0;
                    }
                    case 'i': {
                        guess = "item";
                        id = -4;
                        break block0;
                    }
                    case 's': {
                        guess = "size";
                        id = 7;
                        break block0;
                    }
                    case 't': {
                        guess = "type";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'f') {
                    guess = "focus";
                    id = -3;
                    break;
                }
                if (c != 'v') break;
                guess = "value";
                id = 10;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'l') {
                    guess = "length";
                    id = 3;
                    break;
                }
                if (c != 'r') break;
                guess = "remove";
                id = -6;
                break;
            }
            case 7: {
                guess = "options";
                id = 5;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "disabled";
                    id = 1;
                    break;
                }
                if (c == 'm') {
                    guess = "multiple";
                    id = 4;
                    break;
                }
                if (c != 't') break;
                guess = "tabIndex";
                id = 8;
                break;
            }
            case 9: {
                guess = "namedItem";
                id = -5;
                break;
            }
            case 13: {
                guess = "selectedIndex";
                id = 6;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }

    public static interface SelectPainter
    extends ObjectPainter {
        public void onOptionSelectionChange();

        public void onOptionAttrChange(DOptionElement var1, DAttr var2);

        public void onOptionStructChange();
    }
}

