/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.util.Defs;
import java.text.BreakIterator;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DTextNode
extends DNode
implements Text,
CharacterData {
    private static boolean checkLanguage = Defs.booleanProperty("ice.pilots.html4.checkLocaleFromText", false);
    boolean isPre;
    private boolean isReversed;
    private BreakIterator wordIter;
    char[] text;
    int[] breakOffset;
    int numBreaks;
    private static final int Field_data = 1;
    private static final int Field_length = 2;
    private static final int Method_appendData = -1;
    private static final int Method_deleteData = -2;
    private static final int Method_insertData = -3;
    private static final int Method_replaceData = -4;
    private static final int Method_splitText = -5;
    private static final int Method_substringData = -6;

    private void $init$() {
        this.isPre = false;
        this.numBreaks = 0;
    }

    DTextNode(DDocument doc, char[] buf, int offset, int length, boolean isPre) {
        super(doc, 92);
        this.$init$();
        this.isPre = isPre;
        this.initializeText(buf, offset, length);
    }

    DTextNode(DDocument doc, String s, boolean isPre) {
        super(doc, 92);
        this.$init$();
        this.isPre = isPre;
        this.initializeText(s);
    }

    public void init() {
        if (this.isPre) {
            this.numBreaks = this.calculatePreNumbreaks(this.text);
            this.breakOffset = this.calculatePreLinebreaks(this.text, this.numBreaks);
        } else {
            this.numBreaks = this.calculateNonPreNumbreaks(this.text);
            this.breakOffset = this.calculateNonPreLinebreaks(this.text, this.numBreaks);
        }
    }

    void reverseText() {
        if (!this.isReversed) {
            this.isReversed = true;
            this.initializeText(this.text, 0, this.text.length);
        }
    }

    private void initializeText(String aString) {
        this.initializeText(aString.toCharArray(), 0, aString.length());
    }

    private void initializeText(char[] aBuf, int offset, int length) {
        this.text = new char[length];
        if (this.isReversed) {
            int idx = 0;
            while (idx < length) {
                this.text[idx] = aBuf[offset + length - 1 - idx];
                ++idx;
            }
        } else {
            System.arraycopy(aBuf, offset, this.text, 0, length);
        }
        this.init();
    }

    private int calculateNonPreNumbreaks(char[] aBuf) {
        int count = 0;
        this.wordIter = checkLanguage ? this.doc.getWordIteratorForLanguage(aBuf) : this.doc.getWordIterator();
        if (this.wordIter != null) {
            this.wordIter.setText(new String(aBuf));
            this.wordIter.first();
            while (this.wordIter.next() != -1) {
                ++count;
            }
            if (count > 0) {
                --count;
            }
        } else {
            int pos = 0;
            while (pos < aBuf.length) {
                if (aBuf[pos] == ' ' || aBuf[pos] == '\n' || aBuf[pos] == '\u200b') {
                    ++count;
                }
                ++pos;
            }
        }
        return count;
    }

    private int calculatePreNumbreaks(char[] aBuf) {
        int count = 0;
        int pos = 0;
        while (pos < aBuf.length) {
            if (aBuf[pos] == '\n') {
                ++count;
            }
            ++pos;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private int[] calculateNonPreLinebreaks(char[] aBuf, int aNumbreaks) {
        if (aNumbreaks == 0) {
            return new int[0];
        }
        count = 0;
        pos = 0;
        chrBreakOffsets = new int[aNumbreaks];
        if (this.wordIter != null) {
            this.wordIter.setText(new String(aBuf));
        }
        while (pos < aBuf.length) {
            block6: {
                if (this.wordIter == null) ** GOTO lbl15
                t = this.wordIter.next();
                if (t == -1) break;
                pos = t;
                break block6;
lbl-1000:
                // 1 sources

                {
                    ++pos;
lbl15:
                    // 2 sources

                    ** while (pos < aBuf.length && aBuf[pos] != ' ' && aBuf[pos] != '\n' && aBuf[pos] != '\u200b')
                }
            }
            if (pos >= aBuf.length) break;
            if (aBuf[pos] == '\n') {
                chrBreakOffsets[count++] = -(++pos);
                continue;
            }
            if (aBuf[pos] != '\u200b') ** GOTO lbl25
            chrBreakOffsets[count++] = ++pos;
            continue;
lbl-1000:
            // 1 sources

            {
                ++pos;
lbl25:
                // 2 sources

                ** while (pos < aBuf.length && aBuf[pos] == ' ')
            }
lbl26:
            // 1 sources

            chrBreakOffsets[count++] = pos;
        }
        this.wordIter = null;
        return chrBreakOffsets;
    }

    private int[] calculatePreLinebreaks(char[] aBuf, int aNumbreaks) {
        int[] chrBreakOffset = new int[aNumbreaks];
        int idx = 0;
        int pos = 0;
        while (pos < aBuf.length) {
            if (aBuf[pos] == '\n') {
                chrBreakOffset[idx++] = -pos - 1;
            }
            ++pos;
        }
        return chrBreakOffset;
    }

    boolean isEmpty() {
        return this.text.length == 1 && this.text[0] == ' ';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize() {
        if (this.next != null && this.next.tagId == 92) {
            DTextNode t_node = (DTextNode)this.next;
            if (this.isPre == t_node.isPre) {
                StringBuffer sb;
                StringBuffer stringBuffer = sb = new StringBuffer();
                synchronized (stringBuffer) {
                    sb.append(this.text);
                    do {
                        sb.append(t_node.text);
                        this.parent.removeDChild(t_node);
                        if (this.next == null || this.next.tagId != 92) break;
                        t_node = (DTextNode)this.next;
                    } while (this.isPre == t_node.isPre);
                    this.setData(sb.toString());
                }
            }
        }
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String nodeValue) {
        this.setData(nodeValue);
    }

    protected DNode appendDChild(DNode n) {
        return null;
    }

    protected DNode removeDChild(DNode node) {
        return null;
    }

    protected DNode getFirstDChild() {
        return null;
    }

    protected DNode getLastDChild() {
        return null;
    }

    public String getData() {
        return new String(this.text);
    }

    public void setData(String data) {
        int oldNumBreaks = this.numBreaks;
        int oldTextLength = this.text.length;
        int[] oldBreakOffset = new int[this.numBreaks];
        System.arraycopy(this.breakOffset, 0, oldBreakOffset, 0, this.breakOffset.length);
        this.initializeText(data);
        if (oldNumBreaks != this.numBreaks || oldTextLength != this.text.length) {
            this.doc.mutate();
        } else {
            int i = 0;
            while (i < oldNumBreaks) {
                if (oldBreakOffset[i] != this.breakOffset[i]) {
                    this.doc.mutate();
                    break;
                }
                ++i;
            }
        }
        DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(28);
        evt.target = this;
        this.doc.processEvent(evt);
    }

    public int getLength() {
        return this.text.length;
    }

    public String substringData(int offset, int count) {
        return new String(this.text, offset, count);
    }

    public void appendData(String arg) {
        this.setData(this.getData() + arg);
    }

    public void insertData(int offset, String arg) {
        String s = this.getData();
        s = s.substring(0, offset) + arg + s.substring(offset);
        this.setData(s);
    }

    public void deleteData(int offset, int count) {
    }

    public void replaceData(int offset, int count, String arg) {
    }

    public Text splitText(int offset) {
        return null;
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException(DNode.DOM_LEVEL_3_ERROR);
    }

    public String getWholeText() {
        throw new UnsupportedOperationException(DNode.DOM_LEVEL_3_ERROR);
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException(DNode.DOM_LEVEL_3_ERROR);
    }

    public Node cloneNode(boolean deep) {
        return new DTextNode(this.doc, this.text, 0, this.text.length, this.isPre);
    }

    public String toString() {
        return this.getData();
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DTextNode.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DTextNode.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DTextNode.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getData();
            }
            case 2: {
                return env.wrapInt(this.getLength());
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        if (key_id == 1) {
            this.setData(env.toStr(value));
            return 1;
        }
        if (key_id == 2) {
            return 1;
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.appendData(env.toStr(args, 0));
                break;
            }
            case -2: {
                int offset = env.toInt(args, 0);
                int count = env.toInt(args, 1);
                this.deleteData(offset, count);
                break;
            }
            case -3: {
                int offset = env.toInt(args, 0);
                String text = env.toStr(args, 1);
                this.insertData(offset, text);
                break;
            }
            case -4: {
                int offset = env.toInt(args, 0);
                int count = env.toInt(args, 1);
                String text = env.toStr(args, 2);
                this.replaceData(offset, count, text);
                break;
            }
            case -5: {
                int offset = env.toInt(args, 0);
                return this.splitText(offset);
            }
            case -6: {
                int offset = env.toInt(args, 0);
                int count = env.toInt(args, 1);
                return this.substringData(offset, count);
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                guess = "data";
                id = 1;
                break;
            }
            case 6: {
                guess = "length";
                id = 2;
                break;
            }
            case 9: {
                guess = "splitText";
                id = -5;
                break;
            }
            case 10: {
                char c = s.charAt(0);
                if (c == 'a') {
                    guess = "appendData";
                    id = -1;
                    break;
                }
                if (c == 'd') {
                    guess = "deleteData";
                    id = -2;
                    break;
                }
                if (c != 'i') break;
                guess = "insertData";
                id = -3;
                break;
            }
            case 11: {
                guess = "replaceData";
                id = -4;
                break;
            }
            case 13: {
                guess = "substringData";
                id = -6;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

