/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import java.awt.Rectangle;

class FloatManager {
    private CSSBox firstFloater;
    private CSSBox lastFloater;
    private CSSBox floatJustAdded;
    private Rectangle[] activeLeftFloaters;
    private Rectangle[] activeRightFloaters;
    private int numLeft;
    private int numRight;
    private int leftXAnchor;
    private int rightXAnchor;
    private int yCursor;

    FloatManager(int leftXPosition, int rightXPosition) {
        this.leftXAnchor = leftXPosition;
        this.rightXAnchor = rightXPosition;
    }

    void pushLeftFloaters(Rectangle r) {
        if (this.activeLeftFloaters == null) {
            this.activeLeftFloaters = new Rectangle[10];
        } else if (this.activeLeftFloaters.length == this.numLeft) {
            Rectangle[] tmp = new Rectangle[this.activeLeftFloaters.length * 2];
            System.arraycopy(this.activeLeftFloaters, 0, tmp, 0, this.numLeft);
            this.activeLeftFloaters = tmp;
        }
        this.activeLeftFloaters[this.numLeft++] = r;
    }

    void pushRightFloaters(Rectangle r) {
        if (this.activeRightFloaters == null) {
            this.activeRightFloaters = new Rectangle[10];
        } else if (this.activeRightFloaters.length == this.numRight) {
            Rectangle[] tmp = new Rectangle[this.activeRightFloaters.length * 2];
            System.arraycopy(this.activeRightFloaters, 0, tmp, 0, this.numRight);
            this.activeRightFloaters = tmp;
        }
        this.activeRightFloaters[this.numRight++] = r;
    }

    private void popRight() {
        this.activeRightFloaters[this.numRight - 1] = null;
        --this.numRight;
    }

    private void popLeft() {
        this.activeLeftFloaters[this.numLeft - 1] = null;
        --this.numLeft;
    }

    int getAvailableX() {
        return this.getAvailableXAtY(0);
    }

    int getAvailableWidth() {
        return this.getAvailableWidthAtY(0);
    }

    int getAvailableWidthAtY(int yDelta) {
        int[] r = this.findEdgesAtY(yDelta);
        return r[1] - r[0];
    }

    int getAvailableXAtY(int yDelta) {
        int[] r = this.findEdgesAtY(yDelta);
        return r[0] - this.leftXAnchor;
    }

    void addFloater(CSSBox b) {
        if (this.floatJustAdded == null) {
            this.floatJustAdded = b;
        }
        if (this.firstFloater != null) {
            this.lastFloater.next = b;
            b.next = null;
            this.lastFloater = b;
        } else {
            this.firstFloater = this.lastFloater = b;
            b.next = null;
        }
    }

    boolean containsNewFloaters() {
        return this.floatJustAdded != null;
    }

    boolean contains(CSSBox b) {
        CSSBox bb = this.firstFloater;
        while (bb != null) {
            if (bb == b) {
                return true;
            }
            bb = bb.next;
        }
        return false;
    }

    int clearLeft() {
        int t = this.yCursor;
        while (this.numLeft > 0) {
            Rectangle r = this.activeLeftFloaters[this.numLeft - 1];
            if (r != null && r.y + r.height > t) {
                t = r.y + r.height;
            }
            this.popLeft();
        }
        this.yCursor += (t -= this.yCursor);
        return t;
    }

    int clearRight() {
        int t = this.yCursor;
        while (this.numRight > 0) {
            Rectangle r = this.activeRightFloaters[this.numRight - 1];
            if (r != null && r.y + r.height > t) {
                t = r.y + r.height;
            }
            this.popRight();
        }
        this.yCursor += (t -= this.yCursor);
        return t;
    }

    int skipTill(int w) {
        Rectangle r;
        int t = this.yCursor;
        while (this.numLeft > 0) {
            r = this.activeLeftFloaters[this.numLeft - 1];
            if (r != null && r.y + r.height > t) {
                t = r.y + r.height;
            }
            this.popLeft();
        }
        while (this.numRight > 0) {
            r = this.activeRightFloaters[this.numRight - 1];
            if (r != null && r.y + r.height > t) {
                t = r.y + r.height;
            }
            this.popRight();
        }
        this.yCursor += (t -= this.yCursor);
        return t;
    }

    private int[] reallySkipTill(int width) {
        int t = 0;
        int[] returnVal = new int[3];
        boolean willFit = width <= this.rightXAnchor - this.leftXAnchor;
        while (true) {
            int leftX = this.leftXAnchor;
            int rightX = this.rightXAnchor;
            int[] edges = this.findEdgesAtY(t);
            leftX = edges[0];
            rightX = edges[1];
            int availableWidth = rightX - leftX;
            if (willFit && availableWidth >= width) {
                returnVal[0] = t;
                returnVal[1] = leftX;
                returnVal[2] = rightX;
                return returnVal;
            }
            int stepHeight = edges[2] != 0 && edges[3] != 0 ? Math.min(edges[2], edges[3]) : Math.max(edges[2], edges[3]);
            if (stepHeight == 0) {
                returnVal[0] = t - this.yCursor;
                returnVal[1] = this.leftXAnchor;
                returnVal[2] = this.rightXAnchor;
                return returnVal;
            }
            t += stepHeight;
        }
    }

    public boolean canPosition(int width) {
        return width <= this.rightXAnchor - this.leftXAnchor;
    }

    private int[] findEdgesAtY(int deltaY) {
        Rectangle temp;
        if (deltaY < 0) {
            throw new IllegalArgumentException("Y deflection cannot be < 0, value: " + deltaY);
        }
        int[] returnVal = new int[]{this.leftXAnchor, this.rightXAnchor, 0, 0};
        int fdx = 0;
        while (fdx < this.numLeft) {
            temp = this.activeLeftFloaters[fdx];
            if (temp.y <= this.yCursor + deltaY && temp.y + temp.height > this.yCursor + deltaY && temp.x + temp.width > returnVal[0]) {
                returnVal[0] = temp.x + temp.width;
                returnVal[2] = temp.height;
            }
            ++fdx;
        }
        int fdx2 = 0;
        while (fdx2 < this.numRight) {
            temp = this.activeRightFloaters[fdx2];
            if (temp.y <= this.yCursor + deltaY && temp.y + temp.height >= this.yCursor + deltaY && temp.x < returnVal[1]) {
                returnVal[1] = temp.x;
                returnVal[3] = temp.height;
            }
            ++fdx2;
        }
        return returnVal;
    }

    void advance(int dy) {
        Rectangle r;
        this.yCursor += dy;
        while (this.numLeft > 0) {
            r = this.activeLeftFloaters[this.numLeft - 1];
            if (r != null && r.y + r.height > this.yCursor) break;
            this.popLeft();
        }
        while (this.numRight > 0) {
            r = this.activeRightFloaters[this.numRight - 1];
            if (r != null && r.y + r.height > this.yCursor) break;
            this.popRight();
        }
        if (this.floatJustAdded != null) {
            CSSBox b = this.floatJustAdded;
            while (b != null) {
                r = new Rectangle(0, 0, b.width + b.ox * 2, b.height + b.oy * 2);
                if ((b.css.do_floats & 1) != 0) {
                    this.positionToLeft(b, r);
                    this.pushLeftFloaters(r);
                } else if ((b.css.do_floats & 2) != 0) {
                    this.positionToRight(r, b);
                    this.pushRightFloaters(r);
                }
                b = b.next;
            }
            this.floatJustAdded = null;
        }
    }

    private void positionToRight(Rectangle r, CSSBox b) {
        int[] edges = this.reallySkipTill(b.width);
        r.y = this.yCursor + edges[0];
        b.oy += r.y;
        r.x = edges[2] - b.width - b.css.margin_right - b.css.margin_left;
        b.ox += r.x;
    }

    private void positionToLeft(CSSBox b, Rectangle r) {
        int[] edges = this.reallySkipTill(b.width);
        r.y = this.yCursor + edges[0];
        b.oy += r.y;
        r.x = edges[1];
        b.ox += edges[1];
    }

    void translate(int dxLeft, int dxRight) {
        this.leftXAnchor += dxLeft;
        this.rightXAnchor += dxRight;
    }

    boolean hasActiveFloaters() {
        return this.numLeft > 0 || this.numRight > 0;
    }

    CSSBox getFirstFloater() {
        return this.firstFloater;
    }
}

